/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.rngdatatype.helpers;

import com.sun.tools.rngdatatype.DatatypeLibrary;
import com.sun.tools.rngdatatype.DatatypeLibraryFactory;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.Enumeration;
import java.util.NoSuchElementException;
import java.util.Vector;

public class DatatypeLibraryLoader
implements DatatypeLibraryFactory {
    private final Service service = new Service(DatatypeLibraryFactory.class);

    @Override
    public DatatypeLibrary createDatatypeLibrary(String uri) {
        Enumeration e = this.service.getProviders();
        while (e.hasMoreElements()) {
            DatatypeLibraryFactory factory = (DatatypeLibraryFactory)e.nextElement();
            DatatypeLibrary library = factory.createDatatypeLibrary(uri);
            if (library == null) continue;
            return library;
        }
        return null;
    }

    private static class Service {
        private final Class serviceClass;
        private final Enumeration configFiles;
        private Enumeration classNames = null;
        private final Vector providers = new Vector();
        private Loader loader;
        private static final int START = 0;
        private static final int IN_NAME = 1;
        private static final int IN_COMMENT = 2;

        public Service(Class cls) {
            try {
                this.loader = new Loader2();
            }
            catch (NoSuchMethodError e) {
                this.loader = new Loader();
            }
            this.serviceClass = cls;
            String resName = "META-INF/services/" + this.serviceClass.getName();
            this.configFiles = this.loader.getResources(resName);
        }

        public Enumeration getProviders() {
            return new ProviderEnumeration();
        }

        private synchronized boolean moreProviders() {
            while (true) {
                if (this.classNames == null) {
                    if (!this.configFiles.hasMoreElements()) {
                        return false;
                    }
                    this.classNames = Service.parseConfigFile((URL)this.configFiles.nextElement());
                    continue;
                }
                while (this.classNames.hasMoreElements()) {
                    String className = (String)this.classNames.nextElement();
                    try {
                        Class cls = this.loader.loadClass(className);
                        Object obj = cls.getConstructor(new Class[0]).newInstance(new Object[0]);
                        if (!this.serviceClass.isInstance(obj)) continue;
                        this.providers.addElement(obj);
                        return true;
                    }
                    catch (LinkageError | ReflectiveOperationException throwable) {
                    }
                }
                this.classNames = null;
            }
        }

        private static Enumeration parseConfigFile(URL url) {
            try {
                int n;
                InputStream in = url.openStream();
                Reader r = new InputStreamReader(in, StandardCharsets.UTF_8);
                r = new BufferedReader(r);
                Vector<String> tokens = new Vector<String>();
                StringBuilder tokenBuf = new StringBuilder();
                int state = 0;
                while ((n = r.read()) >= 0) {
                    char c = (char)n;
                    switch (c) {
                        case '\n': 
                        case '\r': {
                            state = 0;
                            break;
                        }
                        case '\t': 
                        case ' ': {
                            break;
                        }
                        case '#': {
                            state = 2;
                            break;
                        }
                        default: {
                            if (state == 2) break;
                            state = 1;
                            tokenBuf.append(c);
                        }
                    }
                    if (tokenBuf.length() == 0 || state == 1) continue;
                    tokens.addElement(tokenBuf.toString());
                    tokenBuf.setLength(0);
                }
                if (tokenBuf.length() != 0) {
                    tokens.addElement(tokenBuf.toString());
                }
                return tokens.elements();
            }
            catch (IOException e) {
                return null;
            }
        }

        private static class Loader2
        extends Loader {
            private ClassLoader cl = Loader2.class.getClassLoader();

            Loader2() {
                ClassLoader clt;
                for (ClassLoader tem = clt = Thread.currentThread().getContextClassLoader(); tem != null; tem = tem.getParent()) {
                    if (tem != this.cl) continue;
                    this.cl = clt;
                    break;
                }
            }

            @Override
            Enumeration getResources(String resName) {
                try {
                    return this.cl.getResources(resName);
                }
                catch (IOException e) {
                    return new Singleton(null);
                }
            }

            @Override
            Class loadClass(String name) throws ClassNotFoundException {
                return Class.forName(name, true, this.cl);
            }
        }

        private static class Loader {
            private Loader() {
            }

            Enumeration getResources(String resName) {
                ClassLoader cl = Loader.class.getClassLoader();
                URL url = cl == null ? ClassLoader.getSystemResource(resName) : cl.getResource(resName);
                return new Singleton(url);
            }

            Class loadClass(String name) throws ClassNotFoundException {
                return Class.forName(name);
            }
        }

        private static class Singleton
        implements Enumeration {
            private Object obj;

            private Singleton(Object obj) {
                this.obj = obj;
            }

            @Override
            public boolean hasMoreElements() {
                return this.obj != null;
            }

            public Object nextElement() {
                if (this.obj == null) {
                    throw new NoSuchElementException();
                }
                Object tem = this.obj;
                this.obj = null;
                return tem;
            }
        }

        private class ProviderEnumeration
        implements Enumeration {
            private int nextIndex = 0;

            private ProviderEnumeration() {
            }

            @Override
            public boolean hasMoreElements() {
                return this.nextIndex < Service.this.providers.size() || Service.this.moreProviders();
            }

            public Object nextElement() {
                try {
                    return Service.this.providers.elementAt(this.nextIndex++);
                }
                catch (ArrayIndexOutOfBoundsException e) {
                    throw new NoSuchElementException();
                }
            }
        }
    }
}

