/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.boot;

import org.hibernate.HibernateException;

public enum SchemaAutoTooling {
    CREATE("create"),
    CREATE_DROP("create-drop"),
    CREATE_ONLY("create-only"),
    DROP("drop"),
    UPDATE("update"),
    VALIDATE("validate"),
    NONE("none");

    private final String externalForm;

    private SchemaAutoTooling(String externalForm) {
        this.externalForm = externalForm;
    }

    public static SchemaAutoTooling interpret(String configurationValue) {
        if (configurationValue == null) {
            return null;
        }
        if ((configurationValue = configurationValue.trim()).isEmpty() || SchemaAutoTooling.NONE.externalForm.equals(configurationValue)) {
            return null;
        }
        for (SchemaAutoTooling sat : SchemaAutoTooling.values()) {
            if (!sat.externalForm.equals(configurationValue)) continue;
            return sat;
        }
        throw new HibernateException("Unrecognized hibernate.hbm2ddl.auto value: '" + configurationValue + "'.  Supported values include 'create', 'create-drop', 'create-only', 'drop', 'update', 'none' and 'validate'.");
    }
}

