/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.metamodel.mapping;

import org.hibernate.TransientObjectException;
import org.hibernate.engine.internal.ForeignKeys;
import org.hibernate.engine.spi.IdentifierValue;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.metamodel.mapping.ModelPart;
import org.hibernate.metamodel.mapping.ValueMapping;

public interface EntityIdentifierMapping
extends ValueMapping,
ModelPart {
    public static final String ROLE_LOCAL_NAME = "{id}";

    @Override
    default public String getPartName() {
        return ROLE_LOCAL_NAME;
    }

    public IdentifierValue getUnsavedStrategy();

    @Deprecated
    public Object getIdentifier(Object var1, SharedSessionContractImplementor var2);

    public Object getIdentifier(Object var1);

    default public Object getIdentifierIfNotUnsaved(Object entity, SharedSessionContractImplementor session) {
        if (entity == null) {
            return null;
        }
        if (session == null) {
            return this.getIdentifier(entity);
        }
        Object id = session.getContextEntityIdentifier(entity);
        if (id == null) {
            String entityName = this.findContainingEntityMapping().getEntityName();
            if (ForeignKeys.isTransient(entityName, entity, Boolean.FALSE, session)) {
                throw new TransientObjectException("object references an unsaved transient instance - save the transient instance before flushing: " + (entityName == null ? session.guessEntityName(entity) : entityName));
            }
            id = this.getIdentifier(entity);
        }
        return id;
    }

    public void setIdentifier(Object var1, Object var2, SharedSessionContractImplementor var3);

    public Object instantiate();
}

