/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.sqm.produce.function;

import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import org.hibernate.QueryException;
import org.hibernate.query.spi.QueryEngine;
import org.hibernate.query.sqm.produce.function.ArgumentsValidator;
import org.hibernate.query.sqm.tree.SqmTypedNode;

public final class StandardArgumentsValidators {
    public static final ArgumentsValidator NONE = new ArgumentsValidator(){

        @Override
        public void validate(List<? extends SqmTypedNode<?>> arguments, String functionName, QueryEngine queryEngine) {
        }

        @Override
        public String getSignature() {
            return "([arg0[, ...]])";
        }
    };
    public static final ArgumentsValidator NO_ARGS = new ArgumentsValidator(){

        @Override
        public void validate(List<? extends SqmTypedNode<?>> arguments, String functionName, QueryEngine queryEngine) {
            if (!arguments.isEmpty()) {
                throw new QueryException(String.format(Locale.ROOT, "Function %s has no parameters, but %d arguments given", functionName, arguments.size()));
            }
        }

        @Override
        public String getSignature() {
            return "()";
        }
    };

    private StandardArgumentsValidators() {
    }

    public static ArgumentsValidator min(final int minNumOfArgs) {
        if (minNumOfArgs < 1) {
            throw new IllegalArgumentException();
        }
        return new ArgumentsValidator(){

            @Override
            public void validate(List<? extends SqmTypedNode<?>> arguments, String functionName, QueryEngine queryEngine) {
                if (arguments.size() < minNumOfArgs) {
                    throw new QueryException(String.format(Locale.ROOT, "Function %s() requires at least %d arguments, but only %d arguments given", functionName, minNumOfArgs, arguments.size()));
                }
            }

            @Override
            public String getSignature() {
                StringBuilder sig = new StringBuilder("(");
                for (int i = 0; i < minNumOfArgs; ++i) {
                    if (i != 0) {
                        sig.append(", ");
                    }
                    sig.append("arg").append(i);
                }
                sig.append("[, arg");
                sig.append(minNumOfArgs);
                sig.append("[, ...]])");
                return sig.toString();
            }
        };
    }

    public static ArgumentsValidator exactly(final int number) {
        return new ArgumentsValidator(){

            @Override
            public void validate(List<? extends SqmTypedNode<?>> arguments, String functionName, QueryEngine queryEngine) {
                if (arguments.size() != number) {
                    throw new QueryException(String.format(Locale.ROOT, "Function %s() has %d parameters, but %d arguments given", functionName, number, arguments.size()));
                }
            }

            @Override
            public String getSignature() {
                StringBuilder sig = new StringBuilder("(");
                for (int i = 0; i < number; ++i) {
                    if (i != 0) {
                        sig.append(", ");
                    }
                    sig.append("arg");
                    if (number <= 1) continue;
                    sig.append(i);
                }
                sig.append(")");
                return sig.toString();
            }
        };
    }

    public static ArgumentsValidator max(final int maxNumOfArgs) {
        return new ArgumentsValidator(){

            @Override
            public void validate(List<? extends SqmTypedNode<?>> arguments, String functionName, QueryEngine queryEngine) {
                if (arguments.size() > maxNumOfArgs) {
                    throw new QueryException(String.format(Locale.ROOT, "Function %s() allows at most %d arguments, but %d arguments given", functionName, maxNumOfArgs, arguments.size()));
                }
            }

            @Override
            public String getSignature() {
                StringBuilder sig = new StringBuilder("([");
                for (int i = 0; i < maxNumOfArgs; ++i) {
                    if (i != 0) {
                        sig.append(", ");
                    }
                    sig.append("arg").append(i);
                }
                sig.append("])");
                return sig.toString();
            }
        };
    }

    public static ArgumentsValidator between(final int minNumOfArgs, final int maxNumOfArgs) {
        return new ArgumentsValidator(){

            @Override
            public void validate(List<? extends SqmTypedNode<?>> arguments, String functionName, QueryEngine queryEngine) {
                if (arguments.size() < minNumOfArgs || arguments.size() > maxNumOfArgs) {
                    throw new QueryException(String.format(Locale.ROOT, "Function %s() requires between %d and %d arguments, but %d arguments given", functionName, minNumOfArgs, maxNumOfArgs, arguments.size()));
                }
            }

            @Override
            public String getSignature() {
                StringBuilder sig = new StringBuilder("(");
                for (int i = 0; i < maxNumOfArgs; ++i) {
                    if (i == minNumOfArgs) {
                        sig.append("[");
                    }
                    if (i != 0) {
                        sig.append(", ");
                    }
                    sig.append("arg").append(i);
                }
                sig.append("])");
                return sig.toString();
            }
        };
    }

    public static ArgumentsValidator of(Class<?> javaType) {
        return (arguments, functionName, queryEngine) -> arguments.forEach(arg -> {
            Class argType = arg.getNodeJavaType().getJavaTypeClass();
            if (!javaType.isAssignableFrom(argType)) {
                throw new QueryException(String.format(Locale.ROOT, "Function %s() has parameters of type %s, but argument of type %s given", functionName, javaType.getName(), argType.getName()));
            }
        });
    }

    public static ArgumentsValidator composite(ArgumentsValidator ... validators) {
        return StandardArgumentsValidators.composite(Arrays.asList(validators));
    }

    public static ArgumentsValidator composite(List<ArgumentsValidator> validators) {
        return (arguments, functionName, queryEngine) -> validators.forEach(individualValidator -> individualValidator.validate(arguments, functionName, queryEngine));
    }
}

