/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.mapper.pojo.automaticindexing.building.impl;

import java.lang.invoke.MethodHandles;
import java.util.Optional;
import org.hibernate.search.mapper.pojo.automaticindexing.ReindexOnUpdate;
import org.hibernate.search.mapper.pojo.automaticindexing.building.impl.AbstractPojoIndexingDependencyCollectorDirectValueNode;
import org.hibernate.search.mapper.pojo.automaticindexing.building.impl.DerivedDependencyWalkingInfo;
import org.hibernate.search.mapper.pojo.automaticindexing.building.impl.PojoImplicitReindexingResolverBuildingHelper;
import org.hibernate.search.mapper.pojo.automaticindexing.building.impl.PojoIndexingDependencyCollectorNode;
import org.hibernate.search.mapper.pojo.automaticindexing.building.impl.PojoIndexingDependencyCollectorPropertyNode;
import org.hibernate.search.mapper.pojo.automaticindexing.building.impl.PojoIndexingDependencyCollectorTypeNode;
import org.hibernate.search.mapper.pojo.logging.impl.Log;
import org.hibernate.search.mapper.pojo.model.path.PojoModelPathValueNode;
import org.hibernate.search.mapper.pojo.model.path.binding.impl.PojoModelPathBinder;
import org.hibernate.search.mapper.pojo.model.path.impl.BoundPojoModelPathValueNode;
import org.hibernate.search.util.common.data.impl.LinkedNode;
import org.hibernate.search.util.common.logging.impl.LoggerFactory;

public class PojoIndexingDependencyCollectorMonomorphicDirectValueNode<P, V>
extends AbstractPojoIndexingDependencyCollectorDirectValueNode<P, V> {
    private static final Log log = (Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup());

    static <P, V> PojoIndexingDependencyCollectorMonomorphicDirectValueNode<P, V> create(PojoIndexingDependencyCollectorPropertyNode<?, P> parentNode, BoundPojoModelPathValueNode<?, P, V> modelPathFromLastEntityNode, PojoImplicitReindexingResolverBuildingHelper buildingHelper) {
        return new PojoIndexingDependencyCollectorMonomorphicDirectValueNode<P, V>(parentNode, modelPathFromLastEntityNode, AbstractPojoIndexingDependencyCollectorDirectValueNode.Metadata.create(buildingHelper, parentNode, modelPathFromLastEntityNode.getExtractorPath()), buildingHelper);
    }

    PojoIndexingDependencyCollectorMonomorphicDirectValueNode(PojoIndexingDependencyCollectorPropertyNode<?, P> parentNode, BoundPojoModelPathValueNode<?, P, V> modelPathFromLastEntityNode, AbstractPojoIndexingDependencyCollectorDirectValueNode.Metadata metadata, PojoImplicitReindexingResolverBuildingHelper buildingHelper) {
        super(parentNode, modelPathFromLastEntityNode, metadata, buildingHelper);
    }

    @Override
    public PojoIndexingDependencyCollectorTypeNode<V> type() {
        return new PojoIndexingDependencyCollectorTypeNode(this, this.modelPathFromLastEntityNode.type(), this.buildingHelper);
    }

    @Override
    public void collectDependency() {
        this.doCollectDependency(null);
    }

    @Override
    void collectDependency(BoundPojoModelPathValueNode<?, ?, ?> dirtyPathFromEntityType) {
        if (this.metadata.derivedFrom.isEmpty()) {
            this.parentNode.parentNode().collectDependency(dirtyPathFromEntityType);
        } else {
            this.collectDependency();
        }
    }

    @Override
    void doCollectDependency(LinkedNode<DerivedDependencyWalkingInfo> derivedDependencyPath) {
        ReindexOnUpdate composedReindexOnUpdate;
        ReindexOnUpdate reindexOnUpdate = composedReindexOnUpdate = derivedDependencyPath == null ? this.metadata.reindexOnUpdate : ((DerivedDependencyWalkingInfo)derivedDependencyPath.last.value).node.composeReindexOnUpdate(this.lastEntityNode(), this.metadata.reindexOnUpdate);
        if (ReindexOnUpdate.NO.equals((Object)composedReindexOnUpdate)) {
            return;
        }
        if (this.metadata.derivedFrom.isEmpty()) {
            this.parentNode.parentNode().collectDependency(this.modelPathFromLastEntityNode);
        } else {
            PojoIndexingDependencyCollectorTypeNode lastTypeNode = this.parentNode.parentNode();
            for (PojoModelPathValueNode path : this.metadata.derivedFrom) {
                DerivedDependencyWalkingInfo newDerivedDependencyInfo = new DerivedDependencyWalkingInfo(this, path);
                if (derivedDependencyPath != null) {
                    this.checkForDerivedDependencyCycle(derivedDependencyPath, newDerivedDependencyInfo);
                }
                LinkedNode updatedDerivedDependencyPath = derivedDependencyPath == null ? LinkedNode.of((Object)newDerivedDependencyInfo) : derivedDependencyPath.withHead((Object)newDerivedDependencyInfo);
                PojoModelPathBinder.bind(lastTypeNode, path, PojoIndexingDependencyCollectorNode.walker((LinkedNode<DerivedDependencyWalkingInfo>)updatedDerivedDependencyPath));
            }
        }
    }

    private void checkForDerivedDependencyCycle(LinkedNode<DerivedDependencyWalkingInfo> derivedDependencyPath, DerivedDependencyWalkingInfo newDerivedDependencyInfo) {
        Optional cycle = derivedDependencyPath.findAndReverse(other -> newDerivedDependencyInfo.definingTypeModel.equals(other.definingTypeModel) && newDerivedDependencyInfo.derivedFromPath.equals(other.derivedFromPath));
        if (cycle.isPresent()) {
            throw log.infiniteRecursionForDerivedFrom(newDerivedDependencyInfo.definingTypeModel, (LinkedNode<DerivedDependencyWalkingInfo>)((LinkedNode)cycle.get()));
        }
    }
}

