/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.elytron;

import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.Path;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.UnrecoverableKeyException;
import javax.crypto.SecretKey;
import org.jboss.as.controller.AbstractAddStepHandler;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationDefinition;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.SimpleAttributeDefinition;
import org.jboss.as.controller.SimpleAttributeDefinitionBuilder;
import org.jboss.as.controller.SimpleOperationDefinitionBuilder;
import org.jboss.as.controller.SimpleResourceDefinition;
import org.jboss.as.controller.capability.RuntimeCapability;
import org.jboss.as.controller.descriptions.ResourceDescriptionResolver;
import org.jboss.as.controller.descriptions.StandardResourceDescriptionResolver;
import org.jboss.as.controller.operations.validation.CharsetValidator;
import org.jboss.as.controller.operations.validation.ParameterValidator;
import org.jboss.as.controller.operations.validation.StringAllowedValuesValidator;
import org.jboss.as.controller.registry.AttributeAccess;
import org.jboss.as.controller.registry.ImmutableManagementResourceRegistration;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.controller.registry.OperationEntry;
import org.jboss.as.controller.services.path.PathManager;
import org.jboss.as.controller.services.path.PathManagerService;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.jboss.msc.Service;
import org.jboss.msc.inject.Injector;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceRegistry;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.msc.service.StartException;
import org.jboss.msc.value.InjectedValue;
import org.wildfly.common.function.ExceptionFunction;
import org.wildfly.common.function.ExceptionSupplier;
import org.wildfly.extension.elytron.BaseAddHandler;
import org.wildfly.extension.elytron.Capabilities;
import org.wildfly.extension.elytron.ElytronExtension;
import org.wildfly.extension.elytron.ElytronReloadRequiredWriteAttributeHandler;
import org.wildfly.extension.elytron.ElytronRuntimeOnlyHandler;
import org.wildfly.extension.elytron.FileAttributeDefinitions;
import org.wildfly.extension.elytron.KeyStoreService;
import org.wildfly.extension.elytron.KeyStoreServiceUtil;
import org.wildfly.extension.elytron.ModifiableKeyStoreService;
import org.wildfly.extension.elytron.TrivialCapabilityServiceRemoveHandler;
import org.wildfly.extension.elytron.TrivialService;
import org.wildfly.extension.elytron._private.ElytronSubsystemMessages;
import org.wildfly.security.auth.realm.FileSystemSecurityRealm;
import org.wildfly.security.auth.realm.FileSystemSecurityRealmBuilder;
import org.wildfly.security.auth.server.NameRewriter;
import org.wildfly.security.auth.server.SecurityRealm;
import org.wildfly.security.credential.SecretKeyCredential;
import org.wildfly.security.credential.source.CredentialSource;
import org.wildfly.security.credential.store.CredentialStore;
import org.wildfly.security.credential.store.CredentialStoreException;
import org.wildfly.security.password.spec.Encoding;

class FileSystemRealmDefinition
extends SimpleResourceDefinition {
    static final SimpleAttributeDefinition PATH = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("path", FileAttributeDefinitions.PATH).setAttributeGroup("file")).setRequired(true)).setRestartAllServices()).build();
    static final SimpleAttributeDefinition RELATIVE_TO = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("relative-to", FileAttributeDefinitions.RELATIVE_TO).setAttributeGroup("file")).setRestartAllServices()).build();
    static final SimpleAttributeDefinition LEVELS = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("levels", ModelType.INT, true).setDefaultValue(new ModelNode(2))).setAllowExpression(true)).setRestartAllServices()).build();
    static final SimpleAttributeDefinition ENCODED = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("encoded", ModelType.BOOLEAN, true).setDefaultValue(ModelNode.TRUE)).setAllowExpression(true)).setRestartAllServices()).build();
    static final SimpleAttributeDefinition HASH_ENCODING = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("hash-encoding", ModelType.STRING, true).setDefaultValue(new ModelNode("base64"))).setValidator((ParameterValidator)new StringAllowedValuesValidator(new String[]{"base64", "hex"}))).setAllowExpression(true)).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_RESOURCE_SERVICES})).build();
    static final SimpleAttributeDefinition HASH_CHARSET = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("hash-charset", ModelType.STRING, true).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_RESOURCE_SERVICES})).setDefaultValue(new ModelNode("UTF-8"))).setValidator((ParameterValidator)new CharsetValidator())).setAllowExpression(true)).build();
    static final SimpleAttributeDefinition CREDENTIAL_STORE = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("credential-store", ModelType.STRING, false).setAllowExpression(true)).setRequired(false)).setRequires(new String[]{"secret-key"})).setMinSize(1)).setRestartAllServices()).setCapabilityReference("org.wildfly.security.credential-store", "org.wildfly.security.security-realm")).build();
    static final SimpleAttributeDefinition SECRET_KEY = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("secret-key", ModelType.STRING, false).setAllowExpression(true)).setRequired(false)).setRequires(new String[]{"credential-store"})).setMinSize(1)).setRestartAllServices()).build();
    static final SimpleAttributeDefinition KEY_STORE = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("key-store", ModelType.STRING, true).setAllowExpression(true)).setRequires(new String[]{"key-store-alias"})).setMinSize(1)).setRestartAllServices()).setCapabilityReference("org.wildfly.security.key-store", "org.wildfly.security.security-realm", true)).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_RESOURCE_SERVICES})).build();
    static final SimpleAttributeDefinition KEY_STORE_ALIAS = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("key-store-alias", ModelType.STRING, true).setAllowExpression(true)).setRequires(new String[]{"key-store"})).setMinSize(1)).setRestartAllServices()).build();
    static final AttributeDefinition[] ATTRIBUTES = new AttributeDefinition[]{PATH, RELATIVE_TO, LEVELS, ENCODED, HASH_ENCODING, HASH_CHARSET, CREDENTIAL_STORE, SECRET_KEY, KEY_STORE, KEY_STORE_ALIAS};
    private static final AbstractAddStepHandler ADD = new RealmAddHandler();
    private static final OperationStepHandler REMOVE = new TrivialCapabilityServiceRemoveHandler(ADD, Capabilities.MODIFIABLE_SECURITY_REALM_RUNTIME_CAPABILITY, Capabilities.SECURITY_REALM_RUNTIME_CAPABILITY);

    FileSystemRealmDefinition() {
        super(new SimpleResourceDefinition.Parameters(PathElement.pathElement((String)"filesystem-realm"), (ResourceDescriptionResolver)ElytronExtension.getResourceDescriptionResolver("filesystem-realm")).setAddHandler((OperationStepHandler)ADD).setRemoveHandler(REMOVE).setAddRestartLevel(OperationEntry.Flag.RESTART_RESOURCE_SERVICES).setRemoveRestartLevel(OperationEntry.Flag.RESTART_RESOURCE_SERVICES).setCapabilities(new RuntimeCapability[]{Capabilities.MODIFIABLE_SECURITY_REALM_RUNTIME_CAPABILITY, Capabilities.SECURITY_REALM_RUNTIME_CAPABILITY}));
    }

    public void registerAttributes(ManagementResourceRegistration resourceRegistration) {
        ElytronReloadRequiredWriteAttributeHandler handler = new ElytronReloadRequiredWriteAttributeHandler(ATTRIBUTES);
        for (AttributeDefinition attr : ATTRIBUTES) {
            resourceRegistration.registerReadWriteAttribute(attr, null, (OperationStepHandler)handler);
        }
    }

    public void registerOperations(ManagementResourceRegistration resourceRegistration) {
        super.registerOperations(resourceRegistration);
        StandardResourceDescriptionResolver resolver = ElytronExtension.getResourceDescriptionResolver("filesystem-realm");
        if (ElytronExtension.isServerOrHostController((ImmutableManagementResourceRegistration)resourceRegistration)) {
            UpdateKeyPairHandler.register(resourceRegistration, (ResourceDescriptionResolver)resolver);
            VerifyRealmIntegrity.register(resourceRegistration, (ResourceDescriptionResolver)resolver);
        }
    }

    private static Service getFileSystemService(OperationContext context) throws OperationFailedException {
        PathAddress currentAddress;
        ServiceName mainServiceName;
        ServiceRegistry serviceRegistry = context.getServiceRegistry(true);
        ServiceController<SecurityRealm> serviceContainer = ElytronExtension.getRequiredService(serviceRegistry, mainServiceName = Capabilities.MODIFIABLE_SECURITY_REALM_RUNTIME_CAPABILITY.fromBaseCapability((currentAddress = context.getCurrentAddress()).getLastElement().getValue()).getCapabilityServiceName(), SecurityRealm.class);
        ServiceController.State serviceState = serviceContainer.getState();
        if (serviceState != ServiceController.State.UP) {
            throw ElytronSubsystemMessages.ROOT_LOGGER.requiredServiceNotUp(mainServiceName, serviceState);
        }
        return serviceContainer.getService();
    }

    private static class RealmAddHandler
    extends BaseAddHandler {
        private RealmAddHandler() {
            super(Capabilities.SECURITY_REALM_RUNTIME_CAPABILITY, ATTRIBUTES);
        }

        private static SecretKey getSecretKey(OperationContext context, String credentialStoreReference, String alias) throws OperationFailedException {
            ExceptionFunction credentialStoreApi = (ExceptionFunction)context.getCapabilityRuntimeAPI("org.wildfly.security.credential-store-api", credentialStoreReference, ExceptionFunction.class);
            CredentialStore credentialStoreResource = (CredentialStore)credentialStoreApi.apply((Object)context);
            try {
                SecretKeyCredential credential = (SecretKeyCredential)credentialStoreResource.retrieve(alias, SecretKeyCredential.class);
                if (credential == null) {
                    throw ElytronSubsystemMessages.ROOT_LOGGER.credentialDoesNotExist(alias, SecretKeyCredential.class.getSimpleName());
                }
                return credential.getSecretKey();
            }
            catch (CredentialStoreException e) {
                throw ElytronSubsystemMessages.ROOT_LOGGER.unableToLoadCredentialStore(e);
            }
        }

        private static char[] getKeyStorePassword(KeyStoreService keyStoreService) throws RuntimeException {
            InjectedValue credentialSourceSupplierInjector = new InjectedValue();
            try {
                return keyStoreService.resolveKeyPassword((ExceptionSupplier<CredentialSource, Exception>)((ExceptionSupplier)credentialSourceSupplierInjector.getOptionalValue()));
            }
            catch (Exception e) {
                throw ElytronSubsystemMessages.ROOT_LOGGER.unableToGetKeyStorePassword();
            }
        }

        protected void performRuntime(OperationContext context, ModelNode operation, ModelNode model) throws OperationFailedException {
            ServiceTarget serviceTarget = context.getServiceTarget();
            String address = context.getCurrentAddressValue();
            ServiceName mainServiceName = Capabilities.MODIFIABLE_SECURITY_REALM_RUNTIME_CAPABILITY.fromBaseCapability(address).getCapabilityServiceName();
            ServiceName aliasServiceName = Capabilities.SECURITY_REALM_RUNTIME_CAPABILITY.fromBaseCapability(address).getCapabilityServiceName();
            final int levels = LEVELS.resolveModelAttribute(context, model).asInt();
            final boolean encoded = ENCODED.resolveModelAttribute(context, model).asBoolean();
            final String path = PATH.resolveModelAttribute(context, model).asString();
            final String relativeTo = RELATIVE_TO.resolveModelAttribute(context, model).asStringOrNull();
            final String hashEncoding = HASH_ENCODING.resolveModelAttribute(context, model).asString();
            final String hashCharset = HASH_CHARSET.resolveModelAttribute(context, model).asString();
            String credentialStore = CREDENTIAL_STORE.resolveModelAttribute(context, model).asStringOrNull();
            String secretKey = SECRET_KEY.resolveModelAttribute(context, model).asStringOrNull();
            final String keyStoreName = KEY_STORE.resolveModelAttribute(context, model).asStringOrNull();
            final String keyPairAlias = KEY_STORE_ALIAS.resolveModelAttribute(context, model).asStringOrNull();
            final InjectedValue keyStoreInjector = new InjectedValue();
            final InjectedValue pathManagerInjector = new InjectedValue();
            final InjectedValue nameRewriterInjector = new InjectedValue();
            SecretKey key = null;
            if (credentialStore != null && secretKey != null) {
                key = RealmAddHandler.getSecretKey(context, credentialStore, secretKey);
            }
            final SecretKey finalKey = key;
            final ServiceRegistry keyStoreServiceRegistry = context.getServiceRegistry(true);
            TrivialService<SecurityRealm> fileSystemRealmService = new TrivialService<SecurityRealm>(new TrivialService.ValueSupplier<SecurityRealm>(){
                private FileAttributeDefinitions.PathResolver pathResolver;
                ModifiableKeyStoreService keyStoreService;

                @Override
                public SecurityRealm get() throws StartException {
                    Encoding encoding;
                    this.pathResolver = FileAttributeDefinitions.pathResolver();
                    Path rootPath = this.pathResolver.path(path).relativeTo(relativeTo, (PathManager)pathManagerInjector.getOptionalValue()).resolve().toPath();
                    NameRewriter nameRewriter = (NameRewriter)nameRewriterInjector.getOptionalValue();
                    Charset charset = Charset.forName(hashCharset);
                    Encoding encoding2 = encoding = "hex".equals(hashEncoding) ? Encoding.HEX : Encoding.BASE64;
                    if (nameRewriter == null) {
                        nameRewriter = NameRewriter.IDENTITY_REWRITER;
                    }
                    KeyStore keyStore = (KeyStore)keyStoreInjector.getOptionalValue();
                    PrivateKey privateKey = null;
                    PublicKey publicKey = null;
                    if (keyStore != null) {
                        try {
                            this.keyStoreService = KeyStoreServiceUtil.getModifiableKeyStoreService(keyStoreServiceRegistry, keyStoreName);
                            char[] keyPassword = RealmAddHandler.getKeyStorePassword((KeyStoreService)this.keyStoreService);
                            if (!keyStore.containsAlias(keyPairAlias)) {
                                throw ElytronSubsystemMessages.ROOT_LOGGER.keyStoreMissingAlias(keyPairAlias);
                            }
                            privateKey = (PrivateKey)keyStore.getKey(keyPairAlias, keyPassword);
                            publicKey = keyStore.getCertificate(keyPairAlias).getPublicKey();
                            if (privateKey == null) {
                                throw ElytronSubsystemMessages.ROOT_LOGGER.missingPrivateKey(keyStoreName, keyPairAlias);
                            }
                            if (publicKey == null) {
                                throw ElytronSubsystemMessages.ROOT_LOGGER.missingPublicKey(keyStoreName, keyPairAlias);
                            }
                        }
                        catch (KeyStoreException | NoSuchAlgorithmException | UnrecoverableKeyException | OperationFailedException e) {
                            throw ElytronSubsystemMessages.ROOT_LOGGER.unableToAccessEntryFromKeyStore(keyPairAlias, keyStoreName);
                        }
                    }
                    FileSystemSecurityRealmBuilder fileSystemRealmBuilder = FileSystemSecurityRealm.builder().setRoot(rootPath).setNameRewriter(nameRewriter).setLevels(levels).setEncoded(encoded).setHashEncoding(encoding).setHashCharset(charset);
                    if (finalKey != null) {
                        fileSystemRealmBuilder.setSecretKey(finalKey);
                    }
                    if (privateKey != null && publicKey != null) {
                        fileSystemRealmBuilder.setPrivateKey(privateKey);
                        fileSystemRealmBuilder.setPublicKey(publicKey);
                    }
                    return fileSystemRealmBuilder.build();
                }

                @Override
                public void dispose() {
                    if (this.pathResolver != null) {
                        this.pathResolver.clear();
                        this.pathResolver = null;
                    }
                }
            });
            ServiceBuilder serviceBuilder = serviceTarget.addService(mainServiceName, fileSystemRealmService).addAliases(new ServiceName[]{aliasServiceName});
            if (credentialStore != null) {
                serviceBuilder.requires(context.getCapabilityServiceName(RuntimeCapability.buildDynamicCapabilityName((String)"org.wildfly.security.credential-store", (String)credentialStore), CredentialStore.class));
            }
            if (keyStoreName != null) {
                serviceBuilder.addDependency(context.getCapabilityServiceName(RuntimeCapability.buildDynamicCapabilityName((String)"org.wildfly.security.key-store", (String)keyStoreName), KeyStore.class), KeyStore.class, (Injector)keyStoreInjector);
            }
            if (relativeTo != null) {
                serviceBuilder.addDependency(PathManagerService.SERVICE_NAME, PathManager.class, (Injector)pathManagerInjector);
                serviceBuilder.requires(FileAttributeDefinitions.pathName(relativeTo));
            }
            serviceBuilder.install();
        }
    }

    static class VerifyRealmIntegrity
    extends ElytronRuntimeOnlyHandler {
        VerifyRealmIntegrity() {
        }

        static void register(ManagementResourceRegistration resourceRegistration, ResourceDescriptionResolver descriptionResolver) {
            resourceRegistration.registerOperationHandler((OperationDefinition)new SimpleOperationDefinitionBuilder("verify-integrity", descriptionResolver).setRuntimeOnly().build(), (OperationStepHandler)new VerifyRealmIntegrity());
        }

        protected void executeRuntimeStep(OperationContext context, ModelNode operation) throws OperationFailedException {
            TrivialService filesystemService = (TrivialService)FileSystemRealmDefinition.getFileSystemService(context);
            FileSystemSecurityRealm fileSystemRealm = (FileSystemSecurityRealm)filesystemService.getValue();
            try {
                if (!fileSystemRealm.hasIntegrityEnabled()) {
                    throw ElytronSubsystemMessages.ROOT_LOGGER.filesystemMissingKeypair();
                }
                FileSystemSecurityRealm.IntegrityResult result = fileSystemRealm.verifyRealmIntegrity();
                if (!result.isValid()) {
                    throw ElytronSubsystemMessages.ROOT_LOGGER.filesystemIntegrityInvalid(result.getIdentityNames());
                }
            }
            catch (IOException e) {
                throw ElytronSubsystemMessages.ROOT_LOGGER.unableToVerifyIntegrity(e, e.getLocalizedMessage());
            }
        }
    }

    static class UpdateKeyPairHandler
    extends ElytronRuntimeOnlyHandler {
        UpdateKeyPairHandler() {
        }

        static void register(ManagementResourceRegistration resourceRegistration, ResourceDescriptionResolver descriptionResolver) {
            resourceRegistration.registerOperationHandler((OperationDefinition)new SimpleOperationDefinitionBuilder("update-key-pair", descriptionResolver).setRuntimeOnly().build(), (OperationStepHandler)new UpdateKeyPairHandler());
        }

        protected void executeRuntimeStep(OperationContext context, ModelNode operation) throws OperationFailedException {
            TrivialService filesystemService = (TrivialService)FileSystemRealmDefinition.getFileSystemService(context);
            FileSystemSecurityRealm fileSystemRealm = (FileSystemSecurityRealm)filesystemService.getValue();
            try {
                if (!fileSystemRealm.hasIntegrityEnabled()) {
                    throw ElytronSubsystemMessages.ROOT_LOGGER.filesystemMissingKeypair();
                }
                fileSystemRealm.updateRealmKeyPair();
            }
            catch (IOException e) {
                throw ElytronSubsystemMessages.ROOT_LOGGER.unableToVerifyIntegrity(e, e.getLocalizedMessage());
            }
        }
    }
}

