/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.undertow.filters;

import java.util.function.Consumer;
import org.jboss.as.controller.AbstractAddStepHandler;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.wildfly.extension.undertow.Handler;
import org.wildfly.extension.undertow.UndertowService;
import org.wildfly.extension.undertow.filters.FilterService;

class FilterAdd
extends AbstractAddStepHandler {
    private Handler handler;

    FilterAdd(Handler handler) {
        super(handler.getAttributes());
        this.handler = handler;
    }

    protected void performRuntime(OperationContext context, ModelNode operation, ModelNode model) throws OperationFailedException {
        String name = context.getCurrentAddressValue();
        ServiceTarget target = context.getServiceTarget();
        ServiceBuilder sb = target.addService(UndertowService.FILTER.append(new String[]{name}));
        Consumer serviceConsumer = sb.provides(new ServiceName[]{UndertowService.FILTER.append(new String[]{name})});
        sb.setInstance((Service)new FilterService(serviceConsumer, this.handler, this.getResolvedModel(context, model)));
        sb.setInitialMode(ServiceController.Mode.ON_DEMAND);
        sb.install();
    }

    private ModelNode getResolvedModel(OperationContext context, ModelNode model) throws OperationFailedException {
        ModelNode resolved = new ModelNode();
        for (AttributeDefinition attribute : this.attributes) {
            resolved.get(attribute.getName()).set(attribute.resolveModelAttribute(context, model));
        }
        return resolved;
    }
}

