/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ejb3.subsystem.deployment;

import jakarta.ejb.NoMoreTimeoutsException;
import jakarta.ejb.NoSuchObjectLocalException;
import jakarta.ejb.ScheduleExpression;
import java.io.Serializable;
import java.util.Date;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.ModelVersion;
import org.jboss.as.controller.ObjectListAttributeDefinition;
import org.jboss.as.controller.ObjectTypeAttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationDefinition;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.SimpleAttributeDefinition;
import org.jboss.as.controller.SimpleAttributeDefinitionBuilder;
import org.jboss.as.controller.SimpleOperationDefinitionBuilder;
import org.jboss.as.controller.SimpleResourceDefinition;
import org.jboss.as.controller.descriptions.ResourceDescriptionResolver;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.controller.registry.OperationEntry;
import org.jboss.as.ejb3.component.EJBComponent;
import org.jboss.as.ejb3.logging.EjbLogger;
import org.jboss.as.ejb3.subsystem.EJB3Extension;
import org.jboss.as.ejb3.subsystem.EJB3SubsystemModel;
import org.jboss.as.ejb3.subsystem.deployment.AbstractEJBComponentRuntimeHandler;
import org.jboss.as.ejb3.timerservice.spi.ManagedTimer;
import org.jboss.as.ejb3.timerservice.spi.ManagedTimerService;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;

public class TimerResourceDefinition<T extends EJBComponent>
extends SimpleResourceDefinition {
    private static final ResourceDescriptionResolver RESOURCE_DESCRIPTION_RESOLVER = EJB3Extension.getResourceDescriptionResolver("timer");
    private static final SimpleAttributeDefinition TIME_REMAINING = ((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("time-remaining", ModelType.LONG, true).setStorageRuntime()).build();
    private static final SimpleAttributeDefinition NEXT_TIMEOUT = ((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("next-timeout", ModelType.LONG, true).setStorageRuntime()).build();
    private static final SimpleAttributeDefinition CALENDAR_TIMER = ((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("calendar-timer", ModelType.BOOLEAN, true).setStorageRuntime()).build();
    private static final SimpleAttributeDefinition PERSISTENT = ((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("persistent", ModelType.BOOLEAN, true).setStorageRuntime()).build();
    private static final SimpleAttributeDefinition ACTIVE = ((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("active", ModelType.BOOLEAN, true).setStorageRuntime()).build();
    static final SimpleAttributeDefinition DAY_OF_MONTH = ((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("day-of-month", ModelType.STRING, true).setStorageRuntime()).build();
    static final SimpleAttributeDefinition DAY_OF_WEEK = ((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("day-of-week", ModelType.STRING, true).setStorageRuntime()).build();
    static final SimpleAttributeDefinition HOUR = ((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("hour", ModelType.STRING, true).setStorageRuntime()).build();
    static final SimpleAttributeDefinition MINUTE = ((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("minute", ModelType.STRING, true).setStorageRuntime()).build();
    static final SimpleAttributeDefinition SECOND = ((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("second", ModelType.STRING, true).setStorageRuntime()).build();
    static final SimpleAttributeDefinition MONTH = ((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("month", ModelType.STRING, true).setStorageRuntime()).build();
    static final SimpleAttributeDefinition YEAR = ((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("year", ModelType.STRING, true).setStorageRuntime()).build();
    static final SimpleAttributeDefinition TIMEZONE = ((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("timezone", ModelType.STRING, true).setStorageRuntime()).build();
    static final SimpleAttributeDefinition START = ((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("start", ModelType.LONG, true).setStorageRuntime()).build();
    static final SimpleAttributeDefinition END = ((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("end", ModelType.LONG, true).setStorageRuntime()).build();
    public static final ObjectListAttributeDefinition SCHEDULE = ObjectListAttributeDefinition.Builder.of((String)"schedule", (ObjectTypeAttributeDefinition)ObjectTypeAttributeDefinition.Builder.of((String)"schedule", (AttributeDefinition[])new AttributeDefinition[]{YEAR, MONTH, DAY_OF_MONTH, DAY_OF_WEEK, HOUR, MINUTE, SECOND, TIMEZONE, START, END}).build()).build();
    private static final SimpleAttributeDefinition INFO = ((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("info", ModelType.STRING, true).setStorageRuntime()).build();
    @Deprecated
    private static final SimpleAttributeDefinition PRIMARY_KEY = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("primary-key", ModelType.STRING, true).setStorageRuntime()).setDeprecated(ModelVersion.create((int)9))).build();
    private static final OperationDefinition SUSPEND = new SimpleOperationDefinitionBuilder("suspend", RESOURCE_DESCRIPTION_RESOLVER).setRuntimeOnly().build();
    private static final OperationDefinition ACTIVATE = new SimpleOperationDefinitionBuilder("activate", RESOURCE_DESCRIPTION_RESOLVER).setRuntimeOnly().build();
    private static final OperationDefinition CANCEL = new SimpleOperationDefinitionBuilder("cancel", RESOURCE_DESCRIPTION_RESOLVER).setRuntimeOnly().build();
    private static final OperationDefinition TRIGGER = new SimpleOperationDefinitionBuilder("trigger", RESOURCE_DESCRIPTION_RESOLVER).setRuntimeOnly().build();
    private final AbstractEJBComponentRuntimeHandler<T> parentHandler;

    TimerResourceDefinition(AbstractEJBComponentRuntimeHandler<T> parentHandler) {
        super(EJB3SubsystemModel.TIMER_PATH, RESOURCE_DESCRIPTION_RESOLVER, null, null, OperationEntry.Flag.RESTART_NONE, OperationEntry.Flag.RESTART_RESOURCE_SERVICES);
        this.parentHandler = parentHandler;
    }

    public void registerChildren(ManagementResourceRegistration resourceRegistration) {
        super.registerChildren(resourceRegistration);
    }

    public void registerOperations(ManagementResourceRegistration resourceRegistration) {
        super.registerOperations(resourceRegistration);
        resourceRegistration.registerOperationHandler(SUSPEND, (OperationStepHandler)new AbstractTimerHandler(){

            @Override
            void executeRuntime(OperationContext context, ModelNode operation) throws OperationFailedException {
                final ManagedTimer timer = this.getTimer(context, operation, true);
                timer.suspend();
                context.completeStep(new OperationContext.RollbackHandler(){

                    public void handleRollback(OperationContext context, ModelNode operation) {
                        timer.activate();
                    }
                });
            }
        });
        resourceRegistration.registerOperationHandler(ACTIVATE, (OperationStepHandler)new AbstractTimerHandler(){

            @Override
            void executeRuntime(OperationContext context, ModelNode operation) throws OperationFailedException {
                final ManagedTimer timer = this.getTimer(context, operation, true);
                if (timer.isActive()) {
                    throw EjbLogger.ROOT_LOGGER.timerIsActive(timer);
                }
                timer.activate();
                context.completeStep(new OperationContext.RollbackHandler(){

                    public void handleRollback(OperationContext context, ModelNode operation) {
                        timer.suspend();
                    }
                });
            }
        });
        resourceRegistration.registerOperationHandler(CANCEL, (OperationStepHandler)new AbstractTimerHandler(){

            @Override
            void executeRuntime(OperationContext context, ModelNode operation) throws OperationFailedException {
                ManagedTimer timer = this.getTimer(context, operation, true);
                timer.cancel();
                context.completeStep(OperationContext.RollbackHandler.NOOP_ROLLBACK_HANDLER);
            }
        });
        resourceRegistration.registerOperationHandler(TRIGGER, (OperationStepHandler)new AbstractTimerHandler(){

            @Override
            void executeRuntime(OperationContext context, ModelNode operation) throws OperationFailedException {
                ManagedTimer timer = this.getTimer(context, operation, true);
                try {
                    timer.invoke();
                }
                catch (Exception e) {
                    throw EjbLogger.ROOT_LOGGER.timerInvocationFailed(e);
                }
                context.completeStep(OperationContext.RollbackHandler.NOOP_ROLLBACK_HANDLER);
            }
        });
    }

    public void registerAttributes(ManagementResourceRegistration resourceRegistration) {
        resourceRegistration.registerReadOnlyAttribute((AttributeDefinition)TIME_REMAINING, (OperationStepHandler)new AbstractReadAttributeHandler(){

            @Override
            protected void readAttribute(ManagedTimer timer, ModelNode toSet) {
                if (timer.isCanceled()) {
                    return;
                }
                try {
                    long time = timer.getTimeRemaining();
                    toSet.set(time);
                }
                catch (NoMoreTimeoutsException nmte) {
                    if (EjbLogger.ROOT_LOGGER.isDebugEnabled()) {
                        EjbLogger.ROOT_LOGGER.debug("No more timeouts for timer " + timer);
                    }
                }
                catch (NoSuchObjectLocalException noSuchObjectLocalException) {
                    // empty catch block
                }
            }
        });
        resourceRegistration.registerReadOnlyAttribute((AttributeDefinition)NEXT_TIMEOUT, (OperationStepHandler)new AbstractReadAttributeHandler(){

            @Override
            protected void readAttribute(ManagedTimer timer, ModelNode toSet) {
                if (timer.isCanceled()) {
                    return;
                }
                try {
                    Date d = timer.getNextTimeout();
                    if (d != null) {
                        toSet.set(d.getTime());
                    }
                }
                catch (NoMoreTimeoutsException noMoreTimeoutsException) {
                }
                catch (NoSuchObjectLocalException noSuchObjectLocalException) {
                    // empty catch block
                }
            }
        });
        resourceRegistration.registerReadOnlyAttribute((AttributeDefinition)CALENDAR_TIMER, (OperationStepHandler)new AbstractReadAttributeHandler(){

            @Override
            protected void readAttribute(ManagedTimer timer, ModelNode toSet) {
                if (timer.isCanceled()) {
                    return;
                }
                try {
                    boolean calendarTimer = timer.isCalendarTimer();
                    toSet.set(calendarTimer);
                }
                catch (NoSuchObjectLocalException noSuchObjectLocalException) {
                    // empty catch block
                }
            }
        });
        resourceRegistration.registerReadOnlyAttribute((AttributeDefinition)PERSISTENT, (OperationStepHandler)new AbstractReadAttributeHandler(){

            @Override
            protected void readAttribute(ManagedTimer timer, ModelNode toSet) {
                if (timer.isCanceled()) {
                    return;
                }
                try {
                    boolean persistent = timer.isPersistent();
                    toSet.set(persistent);
                }
                catch (NoSuchObjectLocalException noSuchObjectLocalException) {
                    // empty catch block
                }
            }
        });
        resourceRegistration.registerReadOnlyAttribute((AttributeDefinition)ACTIVE, (OperationStepHandler)new AbstractReadAttributeHandler(){

            @Override
            protected void readAttribute(ManagedTimer timer, ModelNode toSet) {
                boolean active = timer.isActive();
                toSet.set(active);
            }
        });
        resourceRegistration.registerReadOnlyAttribute((AttributeDefinition)SCHEDULE, (OperationStepHandler)new AbstractReadAttributeHandler(){

            @Override
            protected void readAttribute(ManagedTimer timer, ModelNode toSet) {
                if (timer.isCanceled() || !timer.isCalendarTimer()) {
                    return;
                }
                try {
                    ScheduleExpression sched = timer.getSchedule();
                    this.addString(toSet, sched.getYear(), YEAR.getName());
                    this.addString(toSet, sched.getMonth(), MONTH.getName());
                    this.addString(toSet, sched.getDayOfMonth(), DAY_OF_MONTH.getName());
                    this.addString(toSet, sched.getDayOfWeek(), DAY_OF_WEEK.getName());
                    this.addString(toSet, sched.getHour(), HOUR.getName());
                    this.addString(toSet, sched.getMinute(), MINUTE.getName());
                    this.addString(toSet, sched.getSecond(), SECOND.getName());
                    this.addString(toSet, sched.getTimezone(), TIMEZONE.getName());
                    this.addDate(toSet, sched.getStart(), START.getName());
                    this.addDate(toSet, sched.getEnd(), END.getName());
                }
                catch (NoSuchObjectLocalException noSuchObjectLocalException) {
                    // empty catch block
                }
            }

            private void addString(ModelNode schedNode, String value, String name) {
                ModelNode node = schedNode.get(name);
                if (value != null) {
                    node.set(value);
                }
            }

            private void addDate(ModelNode schedNode, Date value, String name) {
                ModelNode node = schedNode.get(name);
                if (value != null) {
                    node.set(value.getTime());
                }
            }
        });
        resourceRegistration.registerReadOnlyAttribute((AttributeDefinition)PRIMARY_KEY, (OperationStepHandler)new AbstractReadAttributeHandler(){

            @Override
            protected void readAttribute(ManagedTimer timer, ModelNode toSet) {
            }
        });
        resourceRegistration.registerReadOnlyAttribute((AttributeDefinition)INFO, (OperationStepHandler)new AbstractReadAttributeHandler(){

            @Override
            protected void readAttribute(ManagedTimer timer, ModelNode toSet) {
                if (timer.isCanceled()) {
                    return;
                }
                try {
                    Serializable info = timer.getInfo();
                    if (info != null) {
                        toSet.set(info.toString());
                    }
                }
                catch (NoSuchObjectLocalException noSuchObjectLocalException) {
                    // empty catch block
                }
            }
        });
    }

    abstract class AbstractReadAttributeHandler
    extends AbstractTimerHandler {
        AbstractReadAttributeHandler() {
        }

        @Override
        void executeRuntime(OperationContext context, ModelNode operation) throws OperationFailedException {
            String opName = operation.require("operation").asString();
            if (!opName.equals("read-attribute")) {
                throw EjbLogger.ROOT_LOGGER.unknownOperations(opName);
            }
            ManagedTimer timer = this.getTimer(context, operation);
            if (timer != null) {
                this.readAttribute(timer, context.getResult());
            }
            context.completeStep(OperationContext.RollbackHandler.NOOP_ROLLBACK_HANDLER);
        }

        protected abstract void readAttribute(ManagedTimer var1, ModelNode var2);
    }

    abstract class AbstractTimerHandler
    implements OperationStepHandler {
        AbstractTimerHandler() {
        }

        public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
            if (context.isNormalServer()) {
                context.addStep(new OperationStepHandler(){

                    public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
                        AbstractTimerHandler.this.executeRuntime(context, operation);
                    }
                }, OperationContext.Stage.RUNTIME);
            }
        }

        protected ManagedTimer getTimer(OperationContext context, ModelNode operation) throws OperationFailedException {
            return this.getTimer(context, operation, false);
        }

        protected ManagedTimer getTimer(OperationContext context, ModelNode operation, boolean notNull) throws OperationFailedException {
            PathAddress address;
            String timerId;
            Object ejbcomponent = TimerResourceDefinition.this.parentHandler.getComponent(context, operation);
            ManagedTimerService timerService = ((EJBComponent)((Object)ejbcomponent)).getTimerService();
            ManagedTimer timer = timerService.findTimer(timerId = (address = PathAddress.pathAddress((ModelNode)operation.require("address"))).getLastElement().getValue());
            if (timer == null && notNull) {
                throw EjbLogger.ROOT_LOGGER.timerNotFound(timerId);
            }
            return timer;
        }

        abstract void executeRuntime(OperationContext var1, ModelNode var2) throws OperationFailedException;
    }
}

