/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jca.core.naming;

import jakarta.resource.Referenceable;
import java.util.Hashtable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.Name;
import javax.naming.NamingException;
import javax.naming.Reference;
import javax.naming.StringRefAddr;
import org.jboss.jca.core.CoreBundle;
import org.jboss.jca.core.CoreLogger;
import org.jboss.jca.core.naming.Util;
import org.jboss.jca.core.spi.naming.JndiStrategy;
import org.jboss.logging.Logger;
import org.jboss.logging.Messages;

public class ExplicitJndiStrategy
implements JndiStrategy {
    private static CoreLogger log = (CoreLogger)Logger.getMessageLogger(CoreLogger.class, (String)ExplicitJndiStrategy.class.getName());
    private static CoreBundle bundle = (CoreBundle)Messages.getBundle(CoreBundle.class);
    private static ConcurrentMap<String, Object> objs = new ConcurrentHashMap<String, Object>();

    public Object getObjectInstance(Object obj, Name name, Context nameCtx, Hashtable<?, ?> environment) throws Exception {
        Reference ref = (Reference)obj;
        String className = (String)ref.get("class").getContent();
        String cfname = (String)ref.get("name").getContent();
        return objs.get(ExplicitJndiStrategy.qualifiedName(cfname, className));
    }

    public String[] bindConnectionFactories(String deployment, Object[] cfs) throws Throwable {
        throw new IllegalStateException("JNDI names are required");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] bindConnectionFactories(String deployment, Object[] cfs, String[] jndis) throws Throwable {
        if (deployment == null) {
            throw new IllegalArgumentException("Deployment is null");
        }
        if (deployment.trim().equals("")) {
            throw new IllegalArgumentException("Deployment is empty");
        }
        if (cfs == null) {
            throw new IllegalArgumentException("CFS is null");
        }
        if (cfs.length == 0) {
            throw new IllegalArgumentException("CFS is empty");
        }
        if (jndis == null) {
            throw new IllegalArgumentException("JNDIs is null");
        }
        if (jndis.length == 0) {
            throw new IllegalArgumentException("JNDIs is empty");
        }
        if (cfs.length != jndis.length) {
            throw new IllegalArgumentException("Number of connection factories doesn't match number of JNDI names");
        }
        InitialContext context = new InitialContext();
        try {
            for (int i = 0; i < cfs.length; ++i) {
                String jndiName = jndis[i];
                Object cf = cfs[i];
                if (log.isTraceEnabled()) {
                    log.tracef("Binding %s under %s", cf.getClass().getName(), jndiName);
                }
                if (cf == null) {
                    throw new IllegalArgumentException("Connection factory is null");
                }
                if (jndiName == null) {
                    throw new IllegalArgumentException("JNDI name is null");
                }
                String className = cf.getClass().getName();
                Reference ref = new Reference(className, new StringRefAddr("class", className), ExplicitJndiStrategy.class.getName(), null);
                ref.add(new StringRefAddr("name", jndiName));
                if (objs.putIfAbsent(ExplicitJndiStrategy.qualifiedName(jndiName, className), cf) != null) {
                    throw new Exception(bundle.deploymentFailedSinceJndiNameHasDeployed(className, jndiName));
                }
                Referenceable referenceable = (Referenceable)cf;
                referenceable.setReference(ref);
                Util.bind((Context)context, jndiName, cf);
                if (!log.isDebugEnabled()) continue;
                log.debug("Bound " + cf.getClass().getName() + " under " + jndiName);
            }
        }
        finally {
            if (context != null) {
                try {
                    context.close();
                }
                catch (NamingException namingException) {}
            }
        }
        return jndis;
    }

    public void unbindConnectionFactories(String deployment, Object[] cfs) throws Throwable {
        throw new IllegalStateException("JNDI names are required");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unbindConnectionFactories(String deployment, Object[] cfs, String[] jndis) throws Throwable {
        if (cfs == null) {
            throw new IllegalArgumentException("CFS is null");
        }
        if (cfs.length == 0) {
            throw new IllegalArgumentException("CFS is empty");
        }
        if (jndis == null) {
            throw new IllegalArgumentException("JNDIs is null");
        }
        if (jndis.length == 0) {
            throw new IllegalArgumentException("JNDIs is empty");
        }
        if (cfs.length != jndis.length) {
            throw new IllegalArgumentException("Number of connection factories doesn't match number of JNDI names");
        }
        InitialContext context = null;
        try {
            context = new InitialContext();
            for (int i = 0; i < cfs.length; ++i) {
                String jndiName = jndis[i];
                Object cf = cfs[i];
                if (cf == null) {
                    throw new IllegalArgumentException("Connection factory is null");
                }
                if (jndiName == null) {
                    throw new IllegalArgumentException("JNDI name is null");
                }
                String className = cf.getClass().getName();
                log.tracef("Unbinding %s under %s", className, jndiName);
                Util.unbind((Context)context, jndiName);
                objs.remove(ExplicitJndiStrategy.qualifiedName(jndiName, className));
                if (!log.isDebugEnabled()) continue;
                log.debug("Unbound " + className + " under " + jndiName);
            }
        }
        catch (Throwable t) {
            log.exceptionDuringUnbind(t);
        }
        finally {
            if (context != null) {
                try {
                    context.close();
                }
                catch (NamingException i) {}
            }
        }
    }

    public String[] bindAdminObjects(String deployment, Object[] aos) throws Throwable {
        throw new IllegalStateException("JNDI names are required");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] bindAdminObjects(String deployment, Object[] aos, String[] jndis) throws Throwable {
        if (deployment == null) {
            throw new IllegalArgumentException("Deployment is null");
        }
        if (deployment.trim().equals("")) {
            throw new IllegalArgumentException("Deployment is empty");
        }
        if (aos == null) {
            throw new IllegalArgumentException("AOS is null");
        }
        if (aos.length == 0) {
            throw new IllegalArgumentException("AOS is empty");
        }
        if (jndis == null) {
            throw new IllegalArgumentException("JNDIs is null");
        }
        if (jndis.length == 0) {
            throw new IllegalArgumentException("JNDIs is empty");
        }
        if (aos.length != jndis.length) {
            throw new IllegalArgumentException("Number of admin objects doesn't match number of JNDI names");
        }
        InitialContext context = new InitialContext();
        try {
            for (int i = 0; i < aos.length; ++i) {
                String jndiName = jndis[i];
                Object ao = aos[i];
                if (log.isTraceEnabled()) {
                    log.tracef("Binding %s under %s", ao.getClass().getName(), jndiName);
                }
                if (ao == null) {
                    throw new IllegalArgumentException("Admin object is null");
                }
                if (jndiName == null) {
                    throw new IllegalArgumentException("JNDI name is null");
                }
                if (ao instanceof Referenceable) {
                    String className = ao.getClass().getName();
                    Reference ref = new Reference(className, new StringRefAddr("class", className), ExplicitJndiStrategy.class.getName(), null);
                    ref.add(new StringRefAddr("name", jndiName));
                    if (objs.putIfAbsent(ExplicitJndiStrategy.qualifiedName(jndiName, className), ao) != null) {
                        throw new Exception(bundle.deploymentFailedSinceJndiNameHasDeployed(className, jndiName));
                    }
                    Referenceable referenceable = (Referenceable)ao;
                    referenceable.setReference(ref);
                }
                Util.bind((Context)context, jndiName, ao);
                if (!log.isDebugEnabled()) continue;
                log.debug("Bound " + ao.getClass().getName() + " under " + jndiName);
            }
        }
        finally {
            if (context != null) {
                try {
                    context.close();
                }
                catch (NamingException namingException) {}
            }
        }
        return jndis;
    }

    public void unbindAdminObjects(String deployment, Object[] aos) throws Throwable {
        throw new IllegalStateException("JNDI names are required");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unbindAdminObjects(String deployment, Object[] aos, String[] jndis) throws Throwable {
        if (aos == null) {
            throw new IllegalArgumentException("AOS is null");
        }
        if (aos.length == 0) {
            throw new IllegalArgumentException("AOS is empty");
        }
        if (jndis == null) {
            throw new IllegalArgumentException("JNDIs is null");
        }
        if (jndis.length == 0) {
            throw new IllegalArgumentException("JNDIs is empty");
        }
        if (aos.length != jndis.length) {
            throw new IllegalArgumentException("Number of admin objects doesn't match number of JNDI names");
        }
        InitialContext context = null;
        try {
            context = new InitialContext();
            for (int i = 0; i < aos.length; ++i) {
                String jndiName = jndis[i];
                Object ao = aos[i];
                if (ao == null) {
                    throw new IllegalArgumentException("Admin object is null");
                }
                if (jndiName == null) {
                    throw new IllegalArgumentException("JNDI name is null");
                }
                String className = ao.getClass().getName();
                log.tracef("Unbinding %s under %s", className, jndiName);
                Util.unbind((Context)context, jndiName);
                objs.remove(ExplicitJndiStrategy.qualifiedName(jndiName, className));
                if (!log.isDebugEnabled()) continue;
                log.debug("Unbound " + className + " under " + jndiName);
            }
        }
        catch (Throwable t) {
            log.exceptionDuringUnbind(t);
        }
        finally {
            if (context != null) {
                try {
                    context.close();
                }
                catch (NamingException i) {}
            }
        }
    }

    public JndiStrategy clone() throws CloneNotSupportedException {
        return (JndiStrategy)super.clone();
    }

    private static String qualifiedName(String name, String className) {
        return className + "#" + name;
    }
}

