/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.envers.internal.entities.mapper.relation.query;

import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.envers.configuration.Configuration;
import org.hibernate.envers.internal.entities.mapper.relation.MiddleComponentData;
import org.hibernate.envers.internal.entities.mapper.relation.MiddleIdData;
import org.hibernate.envers.internal.entities.mapper.relation.query.AbstractRelationQueryGenerator;
import org.hibernate.envers.internal.tools.query.Parameters;
import org.hibernate.envers.internal.tools.query.QueryBuilder;
import org.hibernate.internal.util.StringHelper;

public final class TwoEntityOneAuditedQueryGenerator
extends AbstractRelationQueryGenerator {
    private final MiddleIdData referencedIdData;
    private final MiddleComponentData[] componentDatas;

    public TwoEntityOneAuditedQueryGenerator(Configuration configuration, String versionsMiddleEntityName, MiddleIdData referencingIdData, MiddleIdData referencedIdData, boolean revisionTypeInId, String orderorderByCollectionRoley, MiddleComponentData ... componentData) {
        super(configuration, versionsMiddleEntityName, referencingIdData, revisionTypeInId, orderorderByCollectionRoley);
        this.referencedIdData = referencedIdData;
        this.componentDatas = componentData;
    }

    @Override
    protected QueryBuilder buildQueryBuilderCommon(SessionFactoryImplementor sessionFactory) {
        String originalIdPropertyName = this.configuration.getOriginalIdPropertyName();
        String eeOriginalIdPropertyPath = "ee__." + originalIdPropertyName;
        QueryBuilder qb = new QueryBuilder(this.entityName, "ee__", sessionFactory);
        qb.addFrom(this.referencedIdData.getEntityName(), "e__", false);
        qb.addProjection("new list", "ee__, e__", null, false);
        Parameters rootParameters = qb.getRootParameters();
        this.referencedIdData.getPrefixedMapper().addIdsEqualToQuery(rootParameters, eeOriginalIdPropertyPath, this.referencedIdData.getOriginalMapper(), "e__");
        this.referencingIdData.getPrefixedMapper().addNamedIdEqualsToQuery(rootParameters, originalIdPropertyName, true);
        if (!StringHelper.isEmpty((String)this.orderByCollectionRole)) {
            qb.addOrderFragment("e__", this.orderByCollectionRole);
        }
        return qb;
    }

    @Override
    protected void applyValidPredicates(QueryBuilder qb, Parameters rootParameters, boolean inclusive) {
        String revisionPropertyPath = this.configuration.getRevisionNumberPath();
        String originalIdPropertyName = this.configuration.getOriginalIdPropertyName();
        String eeOriginalIdPropertyPath = "ee__." + originalIdPropertyName;
        this.auditStrategy.addAssociationAtRevisionRestriction(qb, rootParameters, revisionPropertyPath, this.configuration.getRevisionEndFieldName(), true, this.referencingIdData, this.entityName, eeOriginalIdPropertyPath, revisionPropertyPath, originalIdPropertyName, "ee__", true, this.componentDatas);
        rootParameters.addWhereWithNamedParam(this.getRevisionTypePath(), "!=", "delrevisiontype");
    }

    @Override
    protected void applyValidAndRemovePredicates(QueryBuilder remQb) {
        Parameters disjoint = remQb.getRootParameters().addSubParameters("or");
        Parameters valid = disjoint.addSubParameters("and");
        Parameters removed = disjoint.addSubParameters("and");
        this.applyValidPredicates(remQb, valid, false);
        removed.addWhereWithNamedParam(this.configuration.getRevisionNumberPath(), "=", "revision");
        removed.addWhereWithNamedParam(this.getRevisionTypePath(), "=", "delrevisiontype");
    }
}

