/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.amqp;

import jakarta.jms.Topic;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.activemq.artemis.api.core.QueueConfiguration;
import org.apache.activemq.artemis.api.core.RoutingType;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.core.config.BridgeConfiguration;
import org.apache.activemq.artemis.core.server.Queue;
import org.apache.activemq.artemis.core.server.impl.AddressInfo;
import org.apache.activemq.artemis.protocol.amqp.proton.AmqpSupport;
import org.apache.activemq.artemis.tests.integration.amqp.AmqpClientTestSupport;
import org.apache.activemq.artemis.tests.util.Wait;
import org.apache.activemq.artemis.utils.Wait;
import org.apache.activemq.transport.amqp.client.AmqpClient;
import org.apache.activemq.transport.amqp.client.AmqpConnection;
import org.apache.activemq.transport.amqp.client.AmqpMessage;
import org.apache.activemq.transport.amqp.client.AmqpReceiver;
import org.apache.activemq.transport.amqp.client.AmqpSender;
import org.apache.activemq.transport.amqp.client.AmqpSession;
import org.apache.activemq.transport.amqp.client.AmqpValidator;
import org.apache.qpid.proton.amqp.Symbol;
import org.apache.qpid.proton.amqp.UnsignedByte;
import org.apache.qpid.proton.amqp.messaging.AmqpValue;
import org.apache.qpid.proton.amqp.messaging.Header;
import org.apache.qpid.proton.amqp.messaging.Section;
import org.apache.qpid.proton.engine.Sender;
import org.apache.qpid.proton.message.Message;
import org.jgroups.util.UUID;
import org.junit.Assert;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AmqpSendReceiveTest
extends AmqpClientTestSupport {
    protected static final Logger LOG = LoggerFactory.getLogger(AmqpSendReceiveTest.class);

    @Override
    protected boolean isAutoCreateQueues() {
        return false;
    }

    @Override
    protected boolean isAutoCreateAddresses() {
        return false;
    }

    @Test(timeout=60000L)
    public void testAcceptWithoutSettling() throws Exception {
        AmqpClient client = this.createAmqpClient();
        AmqpConnection connection = this.addConnection(client.connect());
        AmqpSession session = connection.createSession();
        AmqpReceiver receiver = session.createReceiver(this.getQueueName());
        this.sendMessages(this.getQueueName(), 10);
        for (int i = 0; i < 10; ++i) {
            receiver.flow(1);
            AmqpMessage receive = receiver.receive();
            receive.accept(false);
            receive.settle();
        }
        receiver.close();
        connection.close();
        Queue queue = this.getProxyToQueue(this.getQueueName());
        AmqpSendReceiveTest.assertNotNull((Object)queue);
        Wait.assertEquals((long)0L, () -> ((Queue)queue).getMessageCount());
    }

    @Test(timeout=60000L)
    public void testQueueReceiverReadMessage() throws Exception {
        this.sendMessages(this.getQueueName(), 1);
        AmqpClient client = this.createAmqpClient();
        AmqpConnection connection = this.addConnection(client.connect());
        AmqpSession session = connection.createSession();
        AmqpReceiver receiver = session.createReceiver(this.getQueueName());
        Queue queueView = this.getProxyToQueue(this.getQueueName());
        AmqpSendReceiveTest.assertEquals((long)1L, (long)queueView.getMessageCount());
        receiver.flow(1);
        AmqpSendReceiveTest.assertNotNull((Object)receiver.receive(5L, TimeUnit.SECONDS));
        receiver.close();
        AmqpSendReceiveTest.assertEquals((long)1L, (long)queueView.getMessageCount());
        connection.close();
    }

    @Test(timeout=60000L)
    public void testCoreBridge() throws Exception {
        this.server.getRemotingService().createAcceptor("acceptor", "vm://0").start();
        this.server.getConfiguration().addConnectorConfiguration("connector", "vm://0");
        this.server.deployBridge(new BridgeConfiguration().setName(this.getTestName()).setQueueName(this.getQueueName()).setForwardingAddress(this.getQueueName(1)).setConfirmationWindowSize(10).setStaticConnectors(Arrays.asList("connector")));
        this.sendMessages(this.getQueueName(), 1);
        AmqpClient client = this.createAmqpClient();
        AmqpConnection connection = this.addConnection(client.connect());
        AmqpSession session = connection.createSession();
        AmqpReceiver receiver = session.createReceiver(this.getQueueName(1));
        Queue queueView = this.getProxyToQueue(this.getQueueName());
        Wait.assertEquals((int)1, () -> ((Queue)queueView).getConsumerCount());
        Wait.assertEquals((long)0L, () -> ((Queue)queueView).getMessageCount());
        queueView = this.getProxyToQueue(this.getQueueName(1));
        Wait.assertEquals((int)1, () -> ((Queue)queueView).getConsumerCount());
        Wait.assertEquals((long)1L, () -> ((Queue)queueView).getMessageCount());
        receiver.flow(1);
        AmqpMessage message = receiver.receive(5L, TimeUnit.SECONDS);
        AmqpSendReceiveTest.assertNotNull((Object)message);
        message.accept();
        receiver.close();
        Wait.assertEquals((long)0L, () -> ((Queue)queueView).getMessageCount());
        connection.close();
    }

    @Test(timeout=60000L)
    public void testMessageDurableFalse() throws Exception {
        this.sendMessages(this.getQueueName(), 1, false);
        AmqpClient client = this.createAmqpClient();
        AmqpConnection connection = this.addConnection(client.connect());
        AmqpSession session = connection.createSession();
        AmqpReceiver receiver = session.createReceiver(this.getQueueName());
        Queue queueView = this.getProxyToQueue(this.getQueueName());
        AmqpSendReceiveTest.assertEquals((long)1L, (long)queueView.getMessageCount());
        receiver.flow(1);
        AmqpMessage receive = receiver.receive(5L, TimeUnit.SECONDS);
        AmqpSendReceiveTest.assertNotNull((Object)receive);
        AmqpSendReceiveTest.assertFalse((boolean)receive.isDurable());
        receiver.close();
        AmqpSendReceiveTest.assertEquals((long)1L, (long)queueView.getMessageCount());
        connection.close();
    }

    @Test(timeout=60000L)
    public void testMessageDurableTrue() throws Exception {
        this.sendMessages(this.getQueueName(), 1, true);
        AmqpClient client = this.createAmqpClient();
        AmqpConnection connection = this.addConnection(client.connect());
        AmqpSession session = connection.createSession();
        AmqpReceiver receiver = session.createReceiver(this.getQueueName());
        Queue queueView = this.getProxyToQueue(this.getQueueName());
        AmqpSendReceiveTest.assertEquals((long)1L, (long)queueView.getMessageCount());
        receiver.flow(1);
        AmqpMessage receive = receiver.receive(5L, TimeUnit.SECONDS);
        AmqpSendReceiveTest.assertNotNull((Object)receive);
        AmqpSendReceiveTest.assertTrue((boolean)receive.isDurable());
        receiver.close();
        AmqpSendReceiveTest.assertEquals((long)1L, (long)queueView.getMessageCount());
        connection.close();
    }

    @Test(timeout=60000L)
    public void testTwoQueueReceiversOnSameConnectionReadMessagesNoDispositions() throws Exception {
        int MSG_COUNT = 4;
        this.sendMessages(this.getQueueName(), MSG_COUNT);
        AmqpClient client = this.createAmqpClient();
        AmqpConnection connection = this.addConnection(client.connect());
        AmqpSession session = connection.createSession();
        AmqpReceiver receiver1 = session.createReceiver(this.getQueueName());
        Queue queueView = this.getProxyToQueue(this.getQueueName());
        AmqpSendReceiveTest.assertEquals((long)MSG_COUNT, (long)queueView.getMessageCount());
        receiver1.flow(2);
        AmqpSendReceiveTest.assertNotNull((Object)receiver1.receive(5L, TimeUnit.SECONDS));
        AmqpSendReceiveTest.assertNotNull((Object)receiver1.receive(5L, TimeUnit.SECONDS));
        AmqpReceiver receiver2 = session.createReceiver(this.getQueueName());
        AmqpSendReceiveTest.assertEquals((long)2L, (long)this.server.getTotalConsumerCount());
        receiver2.flow(2);
        AmqpSendReceiveTest.assertNotNull((Object)receiver2.receive(5L, TimeUnit.SECONDS));
        AmqpSendReceiveTest.assertNotNull((Object)receiver2.receive(5L, TimeUnit.SECONDS));
        AmqpSendReceiveTest.assertEquals((long)0L, (long)queueView.getMessagesAcknowledged());
        receiver1.close();
        receiver2.close();
        AmqpSendReceiveTest.assertEquals((long)MSG_COUNT, (long)queueView.getMessageCount());
        connection.close();
    }

    @Test(timeout=60000L)
    public void testTwoQueueReceiversOnSameConnectionReadMessagesAcceptOnEach() throws Exception {
        int MSG_COUNT = 4;
        this.sendMessages(this.getQueueName(), MSG_COUNT);
        AmqpClient client = this.createAmqpClient();
        AmqpConnection connection = this.addConnection(client.connect());
        AmqpSession session = connection.createSession();
        AmqpReceiver receiver1 = session.createReceiver(this.getQueueName());
        final Queue queueView = this.getProxyToQueue(this.getQueueName());
        AmqpSendReceiveTest.assertEquals((long)MSG_COUNT, (long)queueView.getMessageCount());
        receiver1.flow(2);
        AmqpMessage message = receiver1.receive(5L, TimeUnit.SECONDS);
        AmqpSendReceiveTest.assertNotNull((Object)message);
        message.accept();
        message = receiver1.receive(5L, TimeUnit.SECONDS);
        AmqpSendReceiveTest.assertNotNull((Object)message);
        message.accept();
        AmqpSendReceiveTest.assertTrue((String)"Should have ack'd two", (boolean)Wait.waitFor((Wait.Condition)new Wait.Condition(){

            public boolean isSatisfied() throws Exception {
                return queueView.getMessagesAcknowledged() == 2L;
            }
        }, (long)TimeUnit.SECONDS.toMillis(5L), (long)TimeUnit.MILLISECONDS.toMillis(50L)));
        AmqpReceiver receiver2 = session.createReceiver(this.getQueueName());
        AmqpSendReceiveTest.assertEquals((long)2L, (long)this.server.getTotalConsumerCount());
        receiver2.flow(2);
        message = receiver2.receive(5L, TimeUnit.SECONDS);
        AmqpSendReceiveTest.assertNotNull((Object)message);
        message.accept();
        message = receiver2.receive(5L, TimeUnit.SECONDS);
        AmqpSendReceiveTest.assertNotNull((Object)message);
        message.accept();
        AmqpSendReceiveTest.assertTrue((String)"Queue should be empty now", (boolean)Wait.waitFor((Wait.Condition)new Wait.Condition(){

            public boolean isSatisfied() throws Exception {
                return queueView.getMessagesAcknowledged() == 4L;
            }
        }, (long)TimeUnit.SECONDS.toMillis(15L), (long)TimeUnit.MILLISECONDS.toMillis(10L)));
        receiver1.close();
        receiver2.close();
        Wait.assertEquals((long)0L, () -> ((Queue)queueView).getMessageCount());
        connection.close();
    }

    @Test(timeout=60000L)
    public void testSecondReceiverOnQueueGetsAllUnconsumedMessages() throws Exception {
        int MSG_COUNT = 20;
        this.sendMessages(this.getQueueName(), MSG_COUNT);
        AmqpClient client = this.createAmqpClient();
        AmqpConnection connection = this.addConnection(client.connect());
        AmqpSession session = connection.createSession();
        AmqpReceiver receiver1 = session.createReceiver(this.getQueueName());
        final Queue queueView = this.getProxyToQueue(this.getQueueName());
        AmqpSendReceiveTest.assertEquals((long)MSG_COUNT, (long)queueView.getMessageCount());
        receiver1.flow(20);
        AmqpSendReceiveTest.assertTrue((String)"Should have dispatch to prefetch", (boolean)Wait.waitFor((Wait.Condition)new Wait.Condition(){

            public boolean isSatisfied() throws Exception {
                return queueView.getDeliveringCount() >= 2;
            }
        }, (long)TimeUnit.SECONDS.toMillis(5L), (long)TimeUnit.MILLISECONDS.toMillis(50L)));
        receiver1.close();
        AmqpReceiver receiver2 = session.createReceiver(this.getQueueName());
        AmqpSendReceiveTest.assertEquals((long)1L, (long)this.server.getTotalConsumerCount());
        receiver2.flow(MSG_COUNT * 2);
        AmqpMessage message = receiver2.receive(5L, TimeUnit.SECONDS);
        AmqpSendReceiveTest.assertNotNull((Object)message);
        message.accept();
        message = receiver2.receive(5L, TimeUnit.SECONDS);
        AmqpSendReceiveTest.assertNotNull((Object)message);
        message.accept();
        AmqpSendReceiveTest.assertTrue((String)"Should have ack'd two", (boolean)Wait.waitFor((Wait.Condition)new Wait.Condition(){

            public boolean isSatisfied() throws Exception {
                return queueView.getMessagesAcknowledged() == 2L;
            }
        }, (long)TimeUnit.SECONDS.toMillis(5L), (long)TimeUnit.MILLISECONDS.toMillis(50L)));
        receiver2.close();
        Wait.assertEquals((long)(MSG_COUNT - 2), () -> ((Queue)queueView).getMessageCount());
        connection.close();
    }

    @Test(timeout=60000L)
    public void testSimpleSendOneReceiveOne() throws Exception {
        AmqpClient client = this.createAmqpClient();
        AmqpConnection connection = this.addConnection(client.connect());
        AmqpSession session = connection.createSession();
        AmqpSender sender = session.createSender(this.getQueueName());
        AmqpMessage message = new AmqpMessage();
        message.setMessageId("msg1");
        message.setMessageAnnotation("serialNo", (Object)1);
        message.setText("Test-Message");
        sender.send(message);
        sender.close();
        LOG.debug("Attempting to read message with receiver");
        AmqpReceiver receiver = session.createReceiver(this.getQueueName());
        receiver.flow(2);
        AmqpMessage received = receiver.receive(10L, TimeUnit.SECONDS);
        AmqpSendReceiveTest.assertNotNull((String)"Should have read message", (Object)received);
        AmqpSendReceiveTest.assertEquals((Object)"msg1", (Object)received.getMessageId());
        received.accept();
        receiver.close();
        connection.close();
    }

    @Test(timeout=60000L)
    public void testSendFilterAnnotation() throws Exception {
        AmqpClient client = this.createAmqpClient();
        AmqpConnection connection = this.addConnection(client.connect());
        AmqpSession session = connection.createSession();
        AmqpSender sender = session.createSender(this.getQueueName());
        AmqpMessage message = new AmqpMessage();
        message.setMessageId("msg1");
        message.setMessageAnnotation("x-opt-serialNo", (Object)1);
        message.setText("Test-Message");
        sender.send(message);
        message = new AmqpMessage();
        message.setMessageId("msg2");
        message.setMessageAnnotation("x-opt-serialNo", (Object)2);
        message.setText("Test-Message 2");
        sender.send(message);
        sender.close();
        LOG.debug("Attempting to read message with receiver");
        AmqpReceiver receiver = session.createReceiver(this.getQueueName(), "\"m.x-opt-serialNo\"=2");
        receiver.flow(2);
        AmqpMessage received = receiver.receive(10L, TimeUnit.SECONDS);
        AmqpSendReceiveTest.assertNotNull((String)"Should have read message", (Object)received);
        AmqpSendReceiveTest.assertEquals((Object)"msg2", (Object)received.getMessageId());
        received.accept();
        Assert.assertNull((Object)receiver.receiveNoWait());
        receiver.close();
        connection.close();
    }

    @Test(timeout=60000L)
    public void testCloseBusyReceiver() throws Exception {
        int MSG_COUNT = 20;
        AmqpClient client = this.createAmqpClient();
        AmqpConnection connection = this.addConnection(client.connect());
        AmqpSession session = connection.createSession();
        AmqpSender sender = session.createSender(this.getQueueName());
        for (int i = 0; i < 20; ++i) {
            AmqpMessage message = new AmqpMessage();
            message.setMessageId("msg" + i);
            message.setMessageAnnotation("serialNo", (Object)i);
            message.setText("Test-Message");
            this.instanceLog.debug((Object)("Sending message: " + message.getMessageId()));
            sender.send(message);
        }
        sender.close();
        Queue queue = this.getProxyToQueue(this.getQueueName());
        Wait.assertEquals((long)20L, () -> ((Queue)queue).getMessageCount());
        AmqpReceiver receiver1 = session.createReceiver(this.getQueueName());
        receiver1.flow(20);
        AmqpMessage received = receiver1.receive(5L, TimeUnit.SECONDS);
        AmqpSendReceiveTest.assertNotNull((String)"Should have got a message", (Object)received);
        AmqpSendReceiveTest.assertEquals((Object)"msg0", (Object)received.getMessageId());
        receiver1.close();
        AmqpReceiver receiver2 = session.createReceiver(this.getQueueName());
        receiver2.flow(200);
        for (int i = 0; i < 20; ++i) {
            received = receiver2.receive(5L, TimeUnit.SECONDS);
            AmqpSendReceiveTest.assertNotNull((String)"Should have got a message", (Object)received);
            this.instanceLog.debug((Object)("Read message: " + received.getMessageId()));
            AmqpSendReceiveTest.assertEquals((Object)("msg" + i), (Object)received.getMessageId());
        }
        receiver2.close();
        connection.close();
    }

    @Test(timeout=60000L)
    public void testReceiveWithJMSSelectorFilter() throws Exception {
        AmqpClient client = this.createAmqpClient();
        AmqpConnection connection = this.addConnection(client.connect());
        AmqpSession session = connection.createSession();
        AmqpMessage message1 = new AmqpMessage();
        message1.setGroupId("abcdefg");
        message1.setApplicationProperty("sn", (Object)100);
        AmqpMessage message2 = new AmqpMessage();
        message2.setGroupId("hijklm");
        message2.setApplicationProperty("sn", (Object)200);
        AmqpSender sender = session.createSender(this.getQueueName());
        sender.send(message1);
        sender.send(message2);
        sender.close();
        AmqpReceiver receiver = session.createReceiver(this.getQueueName(), "sn = 100");
        receiver.flow(2);
        AmqpMessage received = receiver.receive(5L, TimeUnit.SECONDS);
        AmqpSendReceiveTest.assertNotNull((String)"Should have read a message", (Object)received);
        AmqpSendReceiveTest.assertEquals((Object)100, (Object)received.getApplicationProperty("sn"));
        AmqpSendReceiveTest.assertEquals((Object)"abcdefg", (Object)received.getGroupId());
        received.accept();
        AmqpSendReceiveTest.assertNull((Object)receiver.receive(1L, TimeUnit.SECONDS));
        receiver.close();
        connection.close();
    }

    @Test(timeout=60000L)
    public void testReceiveWithJMSSelectorFilterOnJMSType() throws Exception {
        AmqpClient client = this.createAmqpClient();
        AmqpConnection connection = this.addConnection(client.connect());
        AmqpSession session = connection.createSession();
        AmqpMessage message1 = new AmqpMessage();
        message1.setText("msg:1");
        AmqpMessage message2 = new AmqpMessage();
        message2.setSubject("target");
        message2.setText("msg:2");
        AmqpSender sender = session.createSender(this.getQueueName());
        sender.send(message1);
        sender.send(message2);
        sender.close();
        AmqpReceiver receiver = session.createReceiver(this.getQueueName(), "JMSType = 'target'");
        receiver.flow(2);
        AmqpMessage received = receiver.receive(5L, TimeUnit.SECONDS);
        AmqpSendReceiveTest.assertNotNull((String)"Should have read a message", (Object)received);
        AmqpSendReceiveTest.assertEquals((Object)"target", (Object)received.getSubject());
        received.accept();
        AmqpSendReceiveTest.assertNull((Object)receiver.receive(1L, TimeUnit.SECONDS));
        receiver.close();
        connection.close();
    }

    @Test(timeout=60000L)
    public void testAdvancedLinkFlowControl() throws Exception {
        int MSG_COUNT = 20;
        AmqpClient client = this.createAmqpClient();
        AmqpConnection connection = this.addConnection(client.connect());
        AmqpSession session = connection.createSession();
        AmqpSender sender = session.createSender(this.getQueueName());
        for (int i = 0; i < 20; ++i) {
            AmqpMessage message = new AmqpMessage();
            message.setMessageId("msg" + i);
            message.setMessageAnnotation("serialNo", (Object)i);
            message.setText("Test-Message");
            sender.send(message);
        }
        sender.close();
        LOG.debug("Attempting to read first two messages with receiver #1");
        AmqpReceiver receiver1 = session.createReceiver(this.getQueueName());
        receiver1.flow(2);
        AmqpMessage message1 = receiver1.receive(10L, TimeUnit.SECONDS);
        AmqpMessage message2 = receiver1.receive(10L, TimeUnit.SECONDS);
        AmqpSendReceiveTest.assertNotNull((String)"Should have read message 1", (Object)message1);
        AmqpSendReceiveTest.assertNotNull((String)"Should have read message 2", (Object)message2);
        AmqpSendReceiveTest.assertEquals((Object)"msg0", (Object)message1.getMessageId());
        AmqpSendReceiveTest.assertEquals((Object)"msg1", (Object)message2.getMessageId());
        message1.accept();
        message2.accept();
        LOG.debug("Attempting to read next two messages with receiver #2");
        AmqpReceiver receiver2 = session.createReceiver(this.getQueueName());
        receiver2.flow(2);
        AmqpMessage message3 = receiver2.receive(10L, TimeUnit.SECONDS);
        AmqpMessage message4 = receiver2.receive(10L, TimeUnit.SECONDS);
        AmqpSendReceiveTest.assertNotNull((String)"Should have read message 3", (Object)message3);
        AmqpSendReceiveTest.assertNotNull((String)"Should have read message 4", (Object)message4);
        AmqpSendReceiveTest.assertEquals((Object)"msg2", (Object)message3.getMessageId());
        AmqpSendReceiveTest.assertEquals((Object)"msg3", (Object)message4.getMessageId());
        message3.accept();
        message4.accept();
        LOG.debug("Attempting to read remaining messages with receiver #1");
        receiver1.flow(16);
        for (int i = 4; i < 20; ++i) {
            AmqpMessage message = receiver1.receive(10L, TimeUnit.SECONDS);
            AmqpSendReceiveTest.assertNotNull((String)"Should have read a message", (Object)message);
            AmqpSendReceiveTest.assertEquals((Object)("msg" + i), (Object)message.getMessageId());
            message.accept();
        }
        receiver1.close();
        receiver2.close();
        connection.close();
    }

    @Test(timeout=60000L)
    public void testDispatchOrderWithPrefetchOfOne() throws Exception {
        AmqpMessage message;
        int i;
        int MSG_COUNT = 20;
        AmqpClient client = this.createAmqpClient();
        AmqpConnection connection = this.addConnection(client.connect());
        AmqpSession session = connection.createSession();
        AmqpSender sender = session.createSender(this.getQueueName());
        for (int i2 = 0; i2 < 20; ++i2) {
            AmqpMessage message2 = new AmqpMessage();
            message2.setMessageId("msg" + i2);
            message2.setMessageAnnotation("serialNo", (Object)i2);
            message2.setText("Test-Message");
            sender.send(message2);
        }
        sender.close();
        AmqpReceiver receiver1 = session.createReceiver(this.getQueueName());
        receiver1.flow(1);
        AmqpReceiver receiver2 = session.createReceiver(this.getQueueName());
        receiver2.flow(1);
        AmqpMessage message1 = receiver1.receive(10L, TimeUnit.SECONDS);
        AmqpMessage message2 = receiver2.receive(10L, TimeUnit.SECONDS);
        AmqpSendReceiveTest.assertNotNull((String)"Should have read message 1", (Object)message1);
        AmqpSendReceiveTest.assertNotNull((String)"Should have read message 2", (Object)message2);
        AmqpSendReceiveTest.assertEquals((Object)"msg0", (Object)message1.getMessageId());
        AmqpSendReceiveTest.assertEquals((Object)"msg1", (Object)message2.getMessageId());
        message1.accept();
        message2.accept();
        receiver1.flow(1);
        AmqpMessage message3 = receiver1.receive(10L, TimeUnit.SECONDS);
        receiver2.flow(1);
        AmqpMessage message4 = receiver2.receive(10L, TimeUnit.SECONDS);
        AmqpSendReceiveTest.assertNotNull((String)"Should have read message 3", (Object)message3);
        AmqpSendReceiveTest.assertNotNull((String)"Should have read message 4", (Object)message4);
        AmqpSendReceiveTest.assertEquals((Object)"msg2", (Object)message3.getMessageId());
        AmqpSendReceiveTest.assertEquals((Object)"msg3", (Object)message4.getMessageId());
        message3.accept();
        message4.accept();
        LOG.debug("*** Attempting to read remaining messages with both receivers");
        int splitCredit = 8;
        LOG.debug("**** Receiver #1 granting credit[{}] for its block of messages", (Object)splitCredit);
        receiver1.flow(splitCredit);
        for (i = 0; i < splitCredit; ++i) {
            message = receiver1.receive(10L, TimeUnit.SECONDS);
            AmqpSendReceiveTest.assertNotNull((String)"Receiver #1 should have read a message", (Object)message);
            LOG.debug("Receiver #1 read message: {}", (Object)message.getMessageId());
            message.accept();
        }
        LOG.debug("**** Receiver #2 granting credit[{}] for its block of messages", (Object)splitCredit);
        receiver2.flow(splitCredit);
        for (i = 0; i < splitCredit; ++i) {
            message = receiver2.receive(10L, TimeUnit.SECONDS);
            AmqpSendReceiveTest.assertNotNull((String)("Receiver #2 should have read message[" + i + "]"), (Object)message);
            LOG.debug("Receiver #2 read message: {}", (Object)message.getMessageId());
            message.accept();
        }
        receiver1.close();
        receiver2.close();
        connection.close();
    }

    @Test(timeout=60000L)
    public void testReceiveMessageAndRefillCreditBeforeAccept() throws Exception {
        AmqpClient client = this.createAmqpClient();
        AmqpConnection connection = this.addConnection(client.connect());
        AmqpSession session = connection.createSession();
        String address = this.getQueueName();
        AmqpReceiver receiver = session.createReceiver(address);
        AmqpSender sender = session.createSender(address);
        for (int i = 0; i < 2; ++i) {
            AmqpMessage message = new AmqpMessage();
            message.setMessageId("msg" + i);
            sender.send(message);
        }
        sender.close();
        receiver.flow(1);
        AmqpMessage received = receiver.receive(5L, TimeUnit.SECONDS);
        AmqpSendReceiveTest.assertNotNull((Object)received);
        receiver.flow(1);
        received.accept();
        received = receiver.receive(10L, TimeUnit.SECONDS);
        AmqpSendReceiveTest.assertNotNull((Object)received);
        received.accept();
        receiver.close();
        connection.close();
    }

    @Test(timeout=60000L)
    public void testReceiveMessageAndRefillCreditBeforeAcceptOnQueueAsync() throws Exception {
        final AmqpClient client = this.createAmqpClient();
        final LinkedList errors = new LinkedList();
        final CountDownLatch receiverReady = new CountDownLatch(1);
        ExecutorService executorService = Executors.newCachedThreadPool();
        final String address = this.getQueueName();
        executorService.submit(new Runnable(){

            @Override
            public void run() {
                try {
                    LOG.debug("Starting consumer connection");
                    AmqpConnection connection = AmqpSendReceiveTest.this.addConnection(client.connect());
                    AmqpSession session = connection.createSession();
                    AmqpReceiver receiver = session.createReceiver(address);
                    receiver.flow(1);
                    receiverReady.countDown();
                    AmqpMessage received = receiver.receive(5L, TimeUnit.SECONDS);
                    Assert.assertNotNull((Object)received);
                    receiver.flow(1);
                    received.accept();
                    received = receiver.receive(5L, TimeUnit.SECONDS);
                    Assert.assertNotNull((Object)received);
                    received.accept();
                    receiver.close();
                    connection.close();
                }
                catch (Exception error) {
                    errors.add(error);
                }
            }
        });
        executorService.submit(new Runnable(){

            @Override
            public void run() {
                try {
                    receiverReady.await(20L, TimeUnit.SECONDS);
                    AmqpConnection connection = AmqpSendReceiveTest.this.addConnection(client.connect());
                    AmqpSession session = connection.createSession();
                    AmqpSender sender = session.createSender(address);
                    for (int i = 0; i < 2; ++i) {
                        AmqpMessage message = new AmqpMessage();
                        message.setMessageId("msg" + i);
                        sender.send(message);
                    }
                    sender.close();
                    connection.close();
                }
                catch (Exception ignored) {
                    ignored.printStackTrace();
                }
            }
        });
        executorService.shutdown();
        executorService.awaitTermination(20L, TimeUnit.SECONDS);
        AmqpSendReceiveTest.assertTrue((String)("no errors: " + errors), (boolean)errors.isEmpty());
    }

    @Test(timeout=60000L)
    public void testMessageDurabliltyFollowsSpec() throws Exception {
        AmqpClient client = this.createAmqpClient();
        AmqpConnection connection = this.addConnection(client.connect());
        AmqpSession session = connection.createSession();
        AmqpSender sender = session.createSender(this.getQueueName());
        AmqpReceiver receiver1 = session.createReceiver(this.getQueueName());
        Queue queue = this.getProxyToQueue(this.getQueueName());
        AmqpMessage message1 = new AmqpMessage();
        message1.setText("Test-Message -> non-durable");
        message1.setDurable(false);
        message1.setMessageId("ID:Message:1");
        sender.send(message1);
        Wait.assertEquals((long)1L, () -> ((Queue)queue).getMessageCount());
        receiver1.flow(1);
        message1 = receiver1.receive(50L, TimeUnit.SECONDS);
        AmqpSendReceiveTest.assertNotNull((String)"Should have read a message", (Object)message1);
        AmqpSendReceiveTest.assertFalse((String)"First message sent should not be durable", (boolean)message1.isDurable());
        message1.accept();
        AmqpMessage message2 = new AmqpMessage();
        message2.setText("Test-Message -> durable");
        message2.setDurable(true);
        message2.setMessageId("ID:Message:2");
        sender.send(message2);
        Wait.assertEquals((long)1L, () -> ((Queue)queue).getMessageCount());
        receiver1.flow(1);
        message2 = receiver1.receive(50L, TimeUnit.SECONDS);
        AmqpSendReceiveTest.assertNotNull((String)"Should have read a message", (Object)message2);
        AmqpSendReceiveTest.assertTrue((String)"Second message sent should be durable", (boolean)message2.isDurable());
        message2.accept();
        sender.close();
        connection.close();
    }

    @Test(timeout=60000L)
    public void testMessageWithHeaderMarkedDurableIsPersisted() throws Exception {
        this.doTestBrokerRestartAndDurability(true, true, false);
    }

    @Test(timeout=60000L)
    public void testMessageWithHeaderMarkedNonDurableIsNotPersisted() throws Exception {
        this.doTestBrokerRestartAndDurability(false, true, true);
    }

    @Test(timeout=60000L)
    public void testMessageWithHeaderDefaultedNonDurableIsNotPersisted() throws Exception {
        this.doTestBrokerRestartAndDurability(false, true, false);
    }

    @Test(timeout=60000L)
    public void testMessageWithNoHeaderIsNotPersisted() throws Exception {
        this.doTestBrokerRestartAndDurability(false, false, false);
    }

    private void doTestBrokerRestartAndDurability(boolean durable, boolean enforceHeader, boolean explicitSetNonDurable) throws Exception {
        AmqpClient client = this.createAmqpClient();
        AmqpConnection connection = this.addConnection(client.connect());
        AmqpSession session = connection.createSession();
        AmqpSender sender = session.createSender(this.getQueueName());
        Queue queueView1 = this.getProxyToQueue(this.getQueueName());
        Message protonMessage = Message.Factory.create();
        protonMessage.setMessageId((Object)"ID:Message:1");
        protonMessage.setBody((Section)new AmqpValue((Object)("Test-Message -> " + (durable ? "durable" : "non-durable"))));
        if (durable || enforceHeader) {
            Header header = new Header();
            if (durable) {
                header.setDurable(Boolean.valueOf(true));
            } else if (explicitSetNonDurable) {
                header.setDurable(Boolean.valueOf(false));
            } else {
                header.setPriority(UnsignedByte.valueOf((byte)5));
                AmqpSendReceiveTest.assertNull((Object)header.getDurable());
            }
            protonMessage.setHeader(header);
        } else {
            AmqpSendReceiveTest.assertNull((String)"Should not have a header", (Object)protonMessage.getHeader());
        }
        AmqpMessage message = new AmqpMessage(protonMessage);
        sender.send(message);
        connection.close();
        Wait.assertEquals((long)1L, () -> ((Queue)queueView1).getMessageCount());
        this.server.stop();
        this.server.start();
        connection = this.addConnection(client.connect());
        session = connection.createSession();
        AmqpReceiver receiver = session.createReceiver(this.getQueueName());
        Queue queueView2 = this.getProxyToQueue(this.getQueueName());
        if (durable) {
            Wait.assertTrue((String)"Message should not have returned", () -> queueView2.getMessageCount() == 1L);
        } else {
            Wait.assertTrue((String)"Message should have been restored", () -> queueView2.getMessageCount() == 0L);
        }
        receiver.flow(1);
        message = receiver.receive(1L, TimeUnit.SECONDS);
        if (durable) {
            AmqpSendReceiveTest.assertNotNull((String)"Should have read a message", (Object)message);
        } else {
            AmqpSendReceiveTest.assertNull((String)"Should not have read a message", (Object)message);
        }
        connection.close();
    }

    @Test(timeout=60000L)
    public void testReceiveMessageBeyondAckedAmountQueue() throws Exception {
        int MSG_COUNT = 50;
        AmqpClient client = this.createAmqpClient();
        AmqpConnection connection = this.addConnection(client.connect());
        AmqpSession session = connection.createSession();
        String address = this.getQueueName();
        AmqpReceiver receiver = session.createReceiver(address);
        AmqpSender sender = session.createSender(address);
        Queue destinationView = this.getProxyToQueue(address);
        for (int i = 0; i < 50; ++i) {
            AmqpMessage message = new AmqpMessage();
            message.setMessageId("msg" + i);
            sender.send(message);
        }
        ArrayList<AmqpMessage> pendingAcks = new ArrayList<AmqpMessage>();
        for (int i = 0; i < 50; ++i) {
            receiver.flow(1);
            AmqpMessage received = receiver.receive(5L, TimeUnit.SECONDS);
            AmqpSendReceiveTest.assertNotNull((Object)received);
            pendingAcks.add(received);
        }
        AmqpMessage message = new AmqpMessage();
        message.setMessageId("msg-final");
        sender.send(message);
        for (AmqpMessage pendingAck : pendingAcks) {
            pendingAck.accept();
        }
        Wait.assertEquals((int)0, () -> ((Queue)destinationView).getDeliveringCount());
        sender.close();
        receiver.close();
        connection.close();
    }

    @Test(timeout=60000L)
    public void testTwoPresettledReceiversReceiveAllMessages() throws Exception {
        AmqpMessage message;
        int i;
        int MSG_COUNT = 100;
        AmqpClient client = this.createAmqpClient();
        AmqpConnection connection = this.addConnection(client.connect());
        AmqpSession session = connection.createSession();
        String address = this.getQueueName();
        AmqpSender sender = session.createSender(address);
        AmqpReceiver receiver1 = session.createReceiver(address, null, false, true);
        AmqpReceiver receiver2 = session.createReceiver(address, null, false, true);
        for (int i2 = 0; i2 < 100; ++i2) {
            AmqpMessage message2 = new AmqpMessage();
            message2.setMessageId("msg" + i2);
            sender.send(message2);
        }
        LOG.debug("Attempting to read first two messages with receiver #1");
        receiver1.flow(2);
        AmqpMessage message1 = receiver1.receive(10L, TimeUnit.SECONDS);
        AmqpMessage message2 = receiver1.receive(10L, TimeUnit.SECONDS);
        AmqpSendReceiveTest.assertNotNull((String)"Should have read message 1", (Object)message1);
        AmqpSendReceiveTest.assertNotNull((String)"Should have read message 2", (Object)message2);
        AmqpSendReceiveTest.assertEquals((Object)"msg0", (Object)message1.getMessageId());
        AmqpSendReceiveTest.assertEquals((Object)"msg1", (Object)message2.getMessageId());
        message1.accept();
        message2.accept();
        LOG.debug("Attempting to read next two messages with receiver #2");
        receiver2.flow(2);
        AmqpMessage message3 = receiver2.receive(10L, TimeUnit.SECONDS);
        AmqpMessage message4 = receiver2.receive(10L, TimeUnit.SECONDS);
        AmqpSendReceiveTest.assertNotNull((String)"Should have read message 3", (Object)message3);
        AmqpSendReceiveTest.assertNotNull((String)"Should have read message 4", (Object)message4);
        AmqpSendReceiveTest.assertEquals((Object)"msg2", (Object)message3.getMessageId());
        AmqpSendReceiveTest.assertEquals((Object)"msg3", (Object)message4.getMessageId());
        message3.accept();
        message4.accept();
        LOG.debug("*** Attempting to read remaining messages with both receivers");
        int splitCredit = 48;
        LOG.debug("**** Receiver #1 granting credit[{}] for its block of messages", (Object)splitCredit);
        receiver1.flow(splitCredit);
        for (i = 0; i < splitCredit; ++i) {
            message = receiver1.receive(10L, TimeUnit.SECONDS);
            AmqpSendReceiveTest.assertNotNull((String)"Receiver #1 should have read a message", (Object)message);
            LOG.debug("Receiver #1 read message: {}", (Object)message.getMessageId());
            message.accept();
        }
        LOG.debug("**** Receiver #2 granting credit[{}] for its block of messages", (Object)splitCredit);
        receiver2.flow(splitCredit);
        for (i = 0; i < splitCredit; ++i) {
            message = receiver2.receive(10L, TimeUnit.SECONDS);
            AmqpSendReceiveTest.assertNotNull((String)("Receiver #2 should have read a message[" + i + "]"), (Object)message);
            LOG.debug("Receiver #2 read message: {}", (Object)message.getMessageId());
            message.accept();
        }
        receiver1.close();
        receiver2.close();
        connection.close();
    }

    @Test(timeout=60000L)
    public void testDeliveryDelayOfferedWhenRequested() throws Exception {
        AmqpClient client = this.createAmqpClient();
        client.setValidator(new AmqpValidator(){

            public void inspectOpenedResource(Sender sender) {
                Symbol[] offered = sender.getRemoteOfferedCapabilities();
                if (!org.apache.activemq.transport.amqp.AmqpSupport.contains((Symbol[])offered, (Symbol)AmqpSupport.DELAYED_DELIVERY)) {
                    this.markAsInvalid("Broker did not indicate it support delayed message delivery");
                }
            }
        });
        AmqpConnection connection = this.addConnection(client.connect());
        AmqpSession session = connection.createSession();
        AmqpSender sender = session.createSender(this.getQueueName(), new Symbol[]{AmqpSupport.DELAYED_DELIVERY});
        AmqpSendReceiveTest.assertNotNull((Object)sender);
        connection.getStateInspector().assertValid();
        sender.close();
        connection.close();
    }

    @Test(timeout=60000L)
    public void testMessageWithToFieldSetToSenderAddress() throws Exception {
        this.doTestMessageWithToFieldSet(false, this.getQueueName());
    }

    @Test(timeout=60000L)
    public void testMessageWithToFieldSetToRandomAddress() throws Exception {
        this.doTestMessageWithToFieldSet(false, UUID.randomUUID().toString());
    }

    @Test(timeout=60000L)
    public void testMessageWithToFieldSetToEmpty() throws Exception {
        this.doTestMessageWithToFieldSet(false, "");
    }

    @Test(timeout=60000L)
    public void testMessageWithToFieldSetToNull() throws Exception {
        this.doTestMessageWithToFieldSet(false, null);
    }

    @Test(timeout=60000L)
    public void testMessageWithToFieldSetWithAnonymousSender() throws Exception {
        this.doTestMessageWithToFieldSet(true, this.getQueueName());
    }

    private void doTestMessageWithToFieldSet(boolean anonymous, String expected) throws Exception {
        AmqpClient client = this.createAmqpClient();
        AmqpConnection connection = this.addConnection(client.connect());
        AmqpSession session = connection.createSession();
        String address = this.getQueueName();
        AmqpSender sender = session.createSender(anonymous ? null : address);
        AmqpMessage message = new AmqpMessage();
        message.setAddress(expected);
        message.setMessageId("msg:1");
        sender.send(message);
        AmqpReceiver receiver = session.createReceiver(address);
        Queue queueView = this.getProxyToQueue(address);
        Wait.assertEquals((long)1L, () -> ((Queue)queueView).getMessageCount());
        receiver.flow(1);
        AmqpMessage received = receiver.receive(5L, TimeUnit.SECONDS);
        AmqpSendReceiveTest.assertNotNull((Object)received);
        AmqpSendReceiveTest.assertEquals((Object)expected, (Object)received.getAddress());
        receiver.close();
        Wait.assertEquals((long)1L, () -> ((Queue)queueView).getMessageCount());
        connection.close();
    }

    @Test(timeout=60000L)
    public void testLinkDetatchErrorIsCorrectWhenQueueDoesNotExists() throws Exception {
        AmqpClient client = this.createAmqpClient();
        AmqpConnection connection = this.addConnection(client.connect());
        AmqpSession session = connection.createSession();
        Exception expectedException = null;
        try {
            session.createSender("AnAddressThatDoesNotExist");
            AmqpSendReceiveTest.fail((String)"Creating a sender here on an address that doesn't exist should fail");
        }
        catch (Exception e) {
            expectedException = e;
        }
        AmqpSendReceiveTest.assertNotNull((Object)expectedException);
        AmqpSendReceiveTest.assertTrue((boolean)expectedException.getMessage().contains("amqp:not-found"));
        AmqpSendReceiveTest.assertTrue((boolean)expectedException.getMessage().contains("target address does not exist"));
        connection.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=60000L)
    public void testSendingAndReceivingToQueueWithDifferentAddressAndQueueName() throws Exception {
        String queueName = "TestQueueName";
        String address = "TestAddress";
        this.server.addAddressInfo(new AddressInfo(SimpleString.toSimpleString((String)address), RoutingType.ANYCAST));
        this.server.createQueue(new QueueConfiguration(new SimpleString(queueName)).setAddress(new SimpleString(address)).setRoutingType(RoutingType.ANYCAST));
        AmqpClient client = this.createAmqpClient();
        try (AmqpConnection connection = this.addConnection(client.connect());){
            AmqpSession session = connection.createSession();
            AmqpSender sender = session.createSender(address);
            AmqpReceiver receiver = session.createReceiver(address);
            receiver.flow(1);
            AmqpMessage message = new AmqpMessage();
            message.setText("TestPayload");
            sender.send(message);
            AmqpMessage receivedMessage = receiver.receive(5000L, TimeUnit.MILLISECONDS);
            AmqpSendReceiveTest.assertNotNull((Object)receivedMessage);
        }
    }

    @Test(timeout=60000L)
    public void testSendReceiveLotsOfDurableMessagesOnQueue() throws Exception {
        this.doTestSendReceiveLotsOfDurableMessages(Queue.class);
    }

    @Test(timeout=60000L)
    public void testSendReceiveLotsOfDurableMessagesOnTopic() throws Exception {
        this.doTestSendReceiveLotsOfDurableMessages(Topic.class);
    }

    private void doTestSendReceiveLotsOfDurableMessages(Class<?> destType) throws Exception {
        int MSG_COUNT = 1000;
        AmqpClient client = this.createAmqpClient();
        AmqpConnection connection = this.addConnection(client.connect());
        AmqpSession session = connection.createSession();
        final CountDownLatch done = new CountDownLatch(1000);
        final AtomicBoolean error = new AtomicBoolean(false);
        ExecutorService executor = Executors.newSingleThreadExecutor();
        String address = Queue.class.equals(destType) ? this.getQueueName() : this.getTopicName();
        final AmqpReceiver receiver = session.createReceiver(address);
        receiver.flow(1000);
        AmqpSender sender = session.createSender(address);
        Queue queueView = this.getProxyToQueue(address);
        executor.execute(new Runnable(){

            @Override
            public void run() {
                for (int i = 0; i < 1000; ++i) {
                    try {
                        AmqpMessage received = receiver.receive(5L, TimeUnit.SECONDS);
                        received.accept();
                        done.countDown();
                        continue;
                    }
                    catch (Exception ex) {
                        LOG.debug("Caught error: {}", (Object)ex.getClass().getSimpleName());
                        error.set(true);
                    }
                }
            }
        });
        for (int i = 0; i < 1000; ++i) {
            AmqpMessage message = new AmqpMessage();
            message.setMessageId("msg" + i);
            sender.send(message);
        }
        AmqpSendReceiveTest.assertTrue((String)("did not read all messages, waiting on: " + done.getCount()), (boolean)done.await(10L, TimeUnit.SECONDS));
        AmqpSendReceiveTest.assertFalse((String)"should not be any errors on receive", (boolean)error.get());
        Wait.assertEquals((int)0, () -> ((Queue)queueView).getDeliveringCount());
        sender.close();
        receiver.close();
        connection.close();
    }

    @Test(timeout=60000L)
    public void testReceiveRejecting() throws Exception {
        int MSG_COUNT = 1000;
        AmqpClient client = this.createAmqpClient();
        AmqpConnection connection = this.addConnection(client.connect());
        AmqpSession session = connection.createSession();
        String address = this.getQueueName();
        AmqpSender sender = session.createSender(address);
        for (int i = 0; i < 1000; ++i) {
            AmqpMessage message = new AmqpMessage();
            message.setMessageId("msg" + i);
            sender.send(message);
        }
        Queue queueView = this.getProxyToQueue(address);
        for (int i = 0; i < 1000; ++i) {
            AmqpReceiver receiver = session.createReceiver(address);
            receiver.flow(1000);
            AmqpMessage received = receiver.receive(5L, TimeUnit.SECONDS);
            Assert.assertNotNull((Object)received);
            Assert.assertEquals((Object)("msg" + i), (Object)received.getMessageId());
            received.accept();
            receiver.close();
        }
        AmqpReceiver receiver = session.createReceiver(address);
        receiver.flow(1000);
        Assert.assertNull((Object)receiver.receive(1L, TimeUnit.MILLISECONDS));
        Wait.assertEquals((int)0, () -> ((Queue)queueView).getDeliveringCount());
        connection.close();
    }
}

