/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.client;

import org.apache.activemq.artemis.api.core.Message;
import org.apache.activemq.artemis.api.core.QueueConfiguration;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.api.core.client.ClientConsumer;
import org.apache.activemq.artemis.api.core.client.ClientMessage;
import org.apache.activemq.artemis.api.core.client.ClientProducer;
import org.apache.activemq.artemis.api.core.client.ClientSession;
import org.apache.activemq.artemis.api.core.client.ClientSessionFactory;
import org.apache.activemq.artemis.api.core.client.ServerLocator;
import org.apache.activemq.artemis.core.config.Configuration;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.core.server.ActiveMQServers;
import org.apache.activemq.artemis.tests.util.ActiveMQTestBase;
import org.apache.activemq.artemis.utils.RandomUtil;
import org.jboss.logging.Logger;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class MessagePriorityTest
extends ActiveMQTestBase {
    private static final Logger log = Logger.getLogger(MessagePriorityTest.class);
    private ActiveMQServer server;
    private ClientSession session;
    private ClientSessionFactory sf;
    private ServerLocator locator;

    @Test
    public void testMessagePriority() throws Exception {
        SimpleString queue = RandomUtil.randomSimpleString();
        SimpleString address = RandomUtil.randomSimpleString();
        this.session.createQueue(new QueueConfiguration(queue).setAddress(address).setDurable(Boolean.valueOf(false)));
        ClientProducer producer = this.session.createProducer(address);
        for (int i = 0; i < 10; ++i) {
            ClientMessage m = this.createTextMessage(this.session, Integer.toString(i));
            m.setPriority((byte)i);
            producer.send((Message)m);
        }
        ClientConsumer consumer = this.session.createConsumer(queue);
        this.session.start();
        for (int i = 9; i >= 0; --i) {
            ClientMessage m = consumer.receive(500L);
            Assert.assertNotNull((Object)m);
            Assert.assertEquals((long)i, (long)m.getPriority());
        }
        consumer.close();
        this.session.deleteQueue(queue);
    }

    @Test
    public void testMessagePriorityWithClientSidePrioritization() throws Exception {
        ClientMessage m;
        int i;
        SimpleString queue = RandomUtil.randomSimpleString();
        SimpleString address = RandomUtil.randomSimpleString();
        this.session.createQueue(new QueueConfiguration(queue).setAddress(address).setDurable(Boolean.valueOf(false)));
        this.session.start();
        ClientProducer producer = this.session.createProducer(address);
        ClientConsumer consumer = this.session.createConsumer(queue);
        for (i = 0; i < 10; ++i) {
            m = this.createTextMessage(this.session, Integer.toString(i));
            m.setPriority((byte)i);
            producer.send((Message)m);
        }
        Thread.sleep(1000L);
        for (i = 9; i >= 0; --i) {
            m = consumer.receive(500L);
            log.debug((Object)("received msg " + m.getPriority()));
            Assert.assertNotNull((Object)m);
            Assert.assertEquals((long)i, (long)m.getPriority());
        }
        consumer.close();
        this.session.deleteQueue(queue);
    }

    @Test
    public void testMessageOrderWithSamePriority() throws Exception {
        SimpleString queue = RandomUtil.randomSimpleString();
        SimpleString address = RandomUtil.randomSimpleString();
        this.session.createQueue(new QueueConfiguration(queue).setAddress(address).setDurable(Boolean.valueOf(false)));
        ClientProducer producer = this.session.createProducer(address);
        ClientMessage[] messages = new ClientMessage[10];
        messages[0] = this.createTextMessage(this.session, "a");
        messages[0].setPriority((byte)0);
        messages[1] = this.createTextMessage(this.session, "b");
        messages[1].setPriority((byte)0);
        messages[2] = this.createTextMessage(this.session, "c");
        messages[2].setPriority((byte)0);
        messages[3] = this.createTextMessage(this.session, "d");
        messages[3].setPriority((byte)7);
        messages[4] = this.createTextMessage(this.session, "e");
        messages[4].setPriority((byte)7);
        messages[5] = this.createTextMessage(this.session, "f");
        messages[5].setPriority((byte)7);
        messages[6] = this.createTextMessage(this.session, "g");
        messages[6].setPriority((byte)3);
        messages[7] = this.createTextMessage(this.session, "h");
        messages[7].setPriority((byte)3);
        messages[8] = this.createTextMessage(this.session, "i");
        messages[8].setPriority((byte)3);
        messages[9] = this.createTextMessage(this.session, "j");
        messages[9].setPriority((byte)9);
        for (int i = 0; i < 10; ++i) {
            producer.send((Message)messages[i]);
        }
        ClientConsumer consumer = this.session.createConsumer(queue);
        this.session.start();
        MessagePriorityTest.expectMessage((byte)9, "j", consumer);
        MessagePriorityTest.expectMessage((byte)7, "d", consumer);
        MessagePriorityTest.expectMessage((byte)7, "e", consumer);
        MessagePriorityTest.expectMessage((byte)7, "f", consumer);
        MessagePriorityTest.expectMessage((byte)3, "g", consumer);
        MessagePriorityTest.expectMessage((byte)3, "h", consumer);
        MessagePriorityTest.expectMessage((byte)3, "i", consumer);
        MessagePriorityTest.expectMessage((byte)0, "a", consumer);
        MessagePriorityTest.expectMessage((byte)0, "b", consumer);
        MessagePriorityTest.expectMessage((byte)0, "c", consumer);
        consumer.close();
        this.session.deleteQueue(queue);
    }

    @Test
    public void testOutOfOrderAcknowledgement() throws Exception {
        SimpleString queue = RandomUtil.randomSimpleString();
        SimpleString address = RandomUtil.randomSimpleString();
        this.session.createQueue(new QueueConfiguration(queue).setAddress(address).setDurable(Boolean.valueOf(false)));
        ClientProducer producer = this.session.createProducer(address);
        ClientConsumer consumer = this.session.createConsumer(queue);
        this.session.start();
        for (int i = 0; i < 10; ++i) {
            ClientMessage m = this.createTextMessage(this.session, Integer.toString(i));
            m.setPriority((byte)i);
            producer.send((Message)m);
        }
        Thread.sleep(500L);
        ClientMessage m = consumer.receive(500L);
        Assert.assertNotNull((Object)m);
        Assert.assertEquals((long)9L, (long)m.getPriority());
        m.acknowledge();
        consumer.close();
        consumer = this.session.createConsumer(queue);
        for (int i = 8; i >= 0; --i) {
            m = consumer.receive(500L);
            Assert.assertNotNull((Object)m);
            Assert.assertEquals((long)i, (long)m.getPriority());
            m.acknowledge();
        }
        consumer.close();
        this.session.deleteQueue(queue);
    }

    @Test
    public void testManyMessages() throws Exception {
        ClientMessage msg;
        int i;
        ClientMessage msg2;
        int i2;
        SimpleString queue = RandomUtil.randomSimpleString();
        SimpleString address = RandomUtil.randomSimpleString();
        this.session.createQueue(new QueueConfiguration(queue).setAddress(address).setDurable(Boolean.valueOf(false)));
        ClientProducer producer = this.session.createProducer(address);
        for (i2 = 0; i2 < 777; ++i2) {
            msg2 = this.session.createMessage(true);
            msg2.setPriority((byte)5);
            msg2.putBooleanProperty("fast", false);
            producer.send((Message)msg2);
        }
        for (i2 = 0; i2 < 333; ++i2) {
            msg2 = this.session.createMessage(true);
            msg2.setPriority((byte)6);
            msg2.putBooleanProperty("fast", true);
            producer.send((Message)msg2);
        }
        ClientConsumer consumer = this.session.createConsumer(queue);
        this.session.start();
        for (i = 0; i < 333; ++i) {
            msg = consumer.receive(5000L);
            MessagePriorityTest.assertNotNull((Object)msg);
            msg.acknowledge();
            MessagePriorityTest.assertTrue((boolean)msg.getBooleanProperty("fast"));
        }
        for (i = 0; i < 777; ++i) {
            msg = consumer.receive(5000L);
            MessagePriorityTest.assertNotNull((Object)msg);
            msg.acknowledge();
            MessagePriorityTest.assertFalse((boolean)msg.getBooleanProperty("fast"));
        }
        consumer.close();
        this.session.deleteQueue(queue);
        this.session.close();
    }

    @Before
    public void setUp() throws Exception {
        super.setUp();
        Configuration config = this.createDefaultInVMConfig();
        this.server = this.addServer(ActiveMQServers.newActiveMQServer((Configuration)config, (boolean)false));
        this.server.start();
        this.locator = this.createInVMNonHALocator().setBlockOnNonDurableSend(true).setBlockOnDurableSend(true);
        this.sf = this.createSessionFactory(this.locator);
        this.session = this.addClientSession(this.sf.createSession(false, true, true));
    }

    private static void expectMessage(byte expectedPriority, String expectedStringInBody, ClientConsumer consumer) throws Exception {
        ClientMessage m = consumer.receive(500L);
        Assert.assertNotNull((Object)m);
        Assert.assertEquals((long)expectedPriority, (long)m.getPriority());
        Assert.assertEquals((Object)expectedStringInBody, (Object)m.getBodyBuffer().readString());
    }
}

