/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.client;

import org.apache.activemq.artemis.api.core.ActiveMQException;
import org.apache.activemq.artemis.api.core.ActiveMQExceptionType;
import org.apache.activemq.artemis.api.core.Message;
import org.apache.activemq.artemis.api.core.client.ClientProducer;
import org.apache.activemq.artemis.api.core.client.ClientSession;
import org.apache.activemq.artemis.api.core.client.ClientSessionFactory;
import org.apache.activemq.artemis.api.core.client.ServerLocator;
import org.apache.activemq.artemis.core.config.Configuration;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.tests.util.ActiveMQTestBase;
import org.apache.activemq.artemis.utils.RandomUtil;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class ProducerCloseTest
extends ActiveMQTestBase {
    private ActiveMQServer server;
    private ClientSessionFactory sf;
    private ClientSession session;
    private ServerLocator locator;

    @Test
    public void testCanNotUseAClosedProducer() throws Exception {
        final ClientProducer producer = this.session.createProducer(RandomUtil.randomSimpleString());
        Assert.assertFalse((boolean)producer.isClosed());
        producer.close();
        Assert.assertTrue((boolean)producer.isClosed());
        ActiveMQTestBase.expectActiveMQException((ActiveMQExceptionType)ActiveMQExceptionType.OBJECT_CLOSED, (ActiveMQTestBase.ActiveMQAction)new ActiveMQTestBase.ActiveMQAction(){

            public void run() throws ActiveMQException {
                producer.send((Message)ProducerCloseTest.this.session.createMessage(false));
            }
        });
    }

    @Before
    public void setUp() throws Exception {
        super.setUp();
        Configuration config = this.createDefaultInVMConfig();
        this.server = this.createServer(false, config);
        this.server.start();
        this.locator = this.createInVMNonHALocator();
        this.sf = this.createSessionFactory(this.locator);
        this.session = this.sf.createSession(false, true, true);
    }
}

