/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.client;

import org.apache.activemq.artemis.api.core.ActiveMQException;
import org.apache.activemq.artemis.api.core.ActiveMQExceptionType;
import org.apache.activemq.artemis.api.core.Message;
import org.apache.activemq.artemis.api.core.QueueConfiguration;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.api.core.client.ClientConsumer;
import org.apache.activemq.artemis.api.core.client.ClientMessage;
import org.apache.activemq.artemis.api.core.client.ClientProducer;
import org.apache.activemq.artemis.api.core.client.ClientRequestor;
import org.apache.activemq.artemis.api.core.client.ClientSession;
import org.apache.activemq.artemis.api.core.client.ClientSessionFactory;
import org.apache.activemq.artemis.api.core.client.MessageHandler;
import org.apache.activemq.artemis.api.core.client.ServerLocator;
import org.apache.activemq.artemis.core.client.impl.ClientMessageImpl;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.core.settings.impl.AddressFullMessagePolicy;
import org.apache.activemq.artemis.core.settings.impl.AddressSettings;
import org.apache.activemq.artemis.tests.util.ActiveMQTestBase;
import org.apache.activemq.artemis.utils.RandomUtil;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class RequestorTest
extends ActiveMQTestBase {
    private ActiveMQServer server;
    private ClientSessionFactory sf;
    private ServerLocator locator;

    @Test
    public void testRequest() throws Exception {
        SimpleString key = RandomUtil.randomSimpleString();
        long value = RandomUtil.randomLong();
        SimpleString requestAddress = new SimpleString("AdTest");
        SimpleString requestQueue = RandomUtil.randomSimpleString();
        ClientSession session = this.sf.createSession(false, true, true);
        session.start();
        session.createQueue(new QueueConfiguration(requestQueue).setAddress(requestAddress).setDurable(Boolean.valueOf(false)).setTemporary(Boolean.valueOf(true)));
        ClientConsumer requestConsumer = session.createConsumer(requestQueue);
        requestConsumer.setMessageHandler((MessageHandler)new SimpleMessageHandler(key, session));
        ClientRequestor requestor = new ClientRequestor(session, requestAddress);
        ClientMessage request = session.createMessage(false);
        request.putLongProperty(key, value);
        ClientMessage reply = requestor.request(request, 500L);
        Assert.assertNotNull((String)"reply was not received", (Object)reply);
        Assert.assertEquals((Object)value, (Object)reply.getObjectProperty(key));
        Thread.sleep(5000L);
        session.close();
    }

    @Test
    public void testManyRequestsOverBlocked() throws Exception {
        SimpleString key = RandomUtil.randomSimpleString();
        long value = RandomUtil.randomLong();
        AddressSettings settings = new AddressSettings().setAddressFullMessagePolicy(AddressFullMessagePolicy.BLOCK).setMaxSizeBytes(1024L);
        this.server.getAddressSettingsRepository().addMatch("#", (Object)settings);
        SimpleString requestAddress = new SimpleString("RequestAddress");
        SimpleString requestQueue = new SimpleString("RequestAddress Queue");
        ClientSession sessionRequest = this.sf.createSession(false, true, true);
        sessionRequest.createQueue(new QueueConfiguration(requestQueue).setAddress(requestAddress));
        sessionRequest.start();
        ClientConsumer requestConsumer = sessionRequest.createConsumer(requestQueue);
        requestConsumer.setMessageHandler((MessageHandler)new SimpleMessageHandler(key, sessionRequest));
        for (int i = 0; i < 2000; ++i) {
            ClientSession session = this.sf.createSession(false, true, true);
            session.start();
            ClientRequestor requestor = new ClientRequestor(session, requestAddress);
            ClientMessage request = session.createMessage(false);
            request.putLongProperty(key, value);
            ClientMessage reply = requestor.request(request, 5000L);
            Assert.assertNotNull((String)"reply was not received", (Object)reply);
            reply.acknowledge();
            Assert.assertEquals((Object)value, (Object)reply.getObjectProperty(key));
            requestor.close();
            session.close();
        }
        sessionRequest.close();
    }

    @Test
    public void testTwoRequests() throws Exception {
        SimpleString key = RandomUtil.randomSimpleString();
        long value = RandomUtil.randomLong();
        SimpleString requestAddress = RandomUtil.randomSimpleString();
        SimpleString requestQueue = RandomUtil.randomSimpleString();
        ClientSessionFactory sf = this.createSessionFactory(this.locator);
        ClientSession session = sf.createSession(false, true, true);
        session.start();
        session.createQueue(new QueueConfiguration(requestQueue).setAddress(requestAddress).setDurable(Boolean.valueOf(false)).setTemporary(Boolean.valueOf(true)));
        ClientConsumer requestConsumer = session.createConsumer(requestQueue);
        requestConsumer.setMessageHandler((MessageHandler)new SimpleMessageHandler(key, session));
        ClientRequestor requestor = new ClientRequestor(session, requestAddress);
        ClientMessage request = session.createMessage(false);
        request.putLongProperty(key, value);
        ClientMessage reply = requestor.request(request, 500L);
        Assert.assertNotNull((String)"reply was not received", (Object)reply);
        Assert.assertEquals((Object)value, (Object)reply.getObjectProperty(key));
        request = session.createMessage(false);
        request.putLongProperty(key, value + 1L);
        reply = requestor.request(request, 500L);
        Assert.assertNotNull((String)"reply was not received", (Object)reply);
        Assert.assertEquals((Object)(value + 1L), (Object)reply.getObjectProperty(key));
        session.close();
    }

    @Test
    public void testRequestWithRequestConsumerWhichDoesNotReply() throws Exception {
        SimpleString requestAddress = RandomUtil.randomSimpleString();
        SimpleString requestQueue = RandomUtil.randomSimpleString();
        ClientSessionFactory sf = this.createSessionFactory(this.locator);
        ClientSession session = sf.createSession(false, true, true);
        session.start();
        session.createQueue(new QueueConfiguration(requestQueue).setAddress(requestAddress).setDurable(Boolean.valueOf(false)).setTemporary(Boolean.valueOf(true)));
        ClientConsumer requestConsumer = session.createConsumer(requestQueue);
        requestConsumer.setMessageHandler(new MessageHandler(){

            public void onMessage(ClientMessage request) {
            }
        });
        ClientRequestor requestor = new ClientRequestor(session, requestAddress);
        ClientMessage request = session.createMessage(false);
        ClientMessage reply = requestor.request(request, 500L);
        Assert.assertNull((Object)reply);
        session.close();
    }

    @Test
    public void testClientRequestorConstructorWithClosedSession() throws Exception {
        final SimpleString requestAddress = RandomUtil.randomSimpleString();
        ClientSessionFactory sf = this.createSessionFactory(this.locator);
        final ClientSession session = sf.createSession(false, true, true);
        session.close();
        ActiveMQTestBase.ActiveMQAction activeMQAction = new ActiveMQTestBase.ActiveMQAction(){

            public void run() throws Exception {
                new ClientRequestor(session, requestAddress);
            }
        };
        ActiveMQTestBase.expectActiveMQException((String)"ClientRequestor's session must not be closed", (ActiveMQExceptionType)ActiveMQExceptionType.OBJECT_CLOSED, (ActiveMQTestBase.ActiveMQAction)activeMQAction);
    }

    @Test
    public void testClose() throws Exception {
        SimpleString key = RandomUtil.randomSimpleString();
        long value = RandomUtil.randomLong();
        SimpleString requestAddress = RandomUtil.randomSimpleString();
        SimpleString requestQueue = RandomUtil.randomSimpleString();
        ClientSessionFactory sf = this.createSessionFactory(this.locator);
        final ClientSession session = sf.createSession(false, true, true);
        session.start();
        session.createQueue(new QueueConfiguration(requestQueue).setAddress(requestAddress).setDurable(Boolean.valueOf(false)).setTemporary(Boolean.valueOf(true)));
        ClientConsumer requestConsumer = session.createConsumer(requestQueue);
        requestConsumer.setMessageHandler((MessageHandler)new SimpleMessageHandler(key, session));
        final ClientRequestor requestor = new ClientRequestor(session, requestAddress);
        ClientMessage request = session.createMessage(false);
        request.putLongProperty(key, value);
        ClientMessage reply = requestor.request(request, 500L);
        Assert.assertNotNull((String)"reply was not received", (Object)reply);
        Assert.assertEquals((Object)value, (Object)reply.getObjectProperty(key));
        request = session.createMessage(false);
        request.putLongProperty(key, value + 1L);
        requestor.close();
        ActiveMQTestBase.ActiveMQAction activeMQAction = new ActiveMQTestBase.ActiveMQAction(){

            public void run() throws Exception {
                requestor.request(session.createMessage(false), 500L);
            }
        };
        ActiveMQTestBase.expectActiveMQException((String)"can not send a request on a closed ClientRequestor", (ActiveMQExceptionType)ActiveMQExceptionType.OBJECT_CLOSED, (ActiveMQTestBase.ActiveMQAction)activeMQAction);
    }

    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.server = this.createServer(false, this.createDefaultInVMConfig());
        this.server.start();
        this.locator = this.createInVMNonHALocator().setAckBatchSize(0);
        this.sf = this.createSessionFactory(this.locator);
    }

    private final class SimpleMessageHandler
    implements MessageHandler {
        private final SimpleString key;
        private final ClientSession session;

        private SimpleMessageHandler(SimpleString key, ClientSession session) {
            this.key = key;
            this.session = session;
        }

        public void onMessage(ClientMessage request) {
            try {
                ClientMessage reply = this.session.createMessage(false);
                SimpleString replyTo = (SimpleString)request.getObjectProperty(ClientMessageImpl.REPLYTO_HEADER_NAME);
                long value = (Long)request.getObjectProperty(this.key);
                reply.putLongProperty(this.key, value);
                ClientProducer replyProducer = this.session.createProducer(replyTo);
                replyProducer.send((Message)reply);
                request.acknowledge();
            }
            catch (ActiveMQException e) {
                e.printStackTrace();
            }
        }
    }
}

