/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.cluster.distribution;

import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.activemq.artemis.api.config.ActiveMQDefaultConfiguration;
import org.apache.activemq.artemis.api.core.ActiveMQException;
import org.apache.activemq.artemis.api.core.BroadcastEndpointFactory;
import org.apache.activemq.artemis.api.core.BroadcastGroupConfiguration;
import org.apache.activemq.artemis.api.core.DiscoveryGroupConfiguration;
import org.apache.activemq.artemis.api.core.Message;
import org.apache.activemq.artemis.api.core.QueueConfiguration;
import org.apache.activemq.artemis.api.core.RoutingType;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.api.core.TransportConfiguration;
import org.apache.activemq.artemis.api.core.UDPBroadcastEndpointFactory;
import org.apache.activemq.artemis.api.core.client.ActiveMQClient;
import org.apache.activemq.artemis.api.core.client.ClientConsumer;
import org.apache.activemq.artemis.api.core.client.ClientMessage;
import org.apache.activemq.artemis.api.core.client.ClientProducer;
import org.apache.activemq.artemis.api.core.client.ClientSession;
import org.apache.activemq.artemis.api.core.client.ClientSessionFactory;
import org.apache.activemq.artemis.api.core.client.ServerLocator;
import org.apache.activemq.artemis.core.client.impl.ServerLocatorInternal;
import org.apache.activemq.artemis.core.client.impl.Topology;
import org.apache.activemq.artemis.core.client.impl.TopologyMemberImpl;
import org.apache.activemq.artemis.core.config.ClusterConnectionConfiguration;
import org.apache.activemq.artemis.core.config.Configuration;
import org.apache.activemq.artemis.core.config.HAPolicyConfiguration;
import org.apache.activemq.artemis.core.config.ha.DistributedPrimitiveManagerConfiguration;
import org.apache.activemq.artemis.core.config.ha.LiveOnlyPolicyConfiguration;
import org.apache.activemq.artemis.core.config.ha.ReplicaPolicyConfiguration;
import org.apache.activemq.artemis.core.config.ha.ReplicatedPolicyConfiguration;
import org.apache.activemq.artemis.core.config.ha.ReplicationBackupPolicyConfiguration;
import org.apache.activemq.artemis.core.config.ha.ReplicationPrimaryPolicyConfiguration;
import org.apache.activemq.artemis.core.config.ha.SharedStoreMasterPolicyConfiguration;
import org.apache.activemq.artemis.core.config.ha.SharedStoreSlavePolicyConfiguration;
import org.apache.activemq.artemis.core.config.impl.ConfigurationImpl;
import org.apache.activemq.artemis.core.persistence.StorageManager;
import org.apache.activemq.artemis.core.postoffice.Binding;
import org.apache.activemq.artemis.core.postoffice.Bindings;
import org.apache.activemq.artemis.core.postoffice.PostOffice;
import org.apache.activemq.artemis.core.postoffice.QueueBinding;
import org.apache.activemq.artemis.core.postoffice.impl.LocalQueueBinding;
import org.apache.activemq.artemis.core.protocol.core.impl.CoreProtocolManagerFactory;
import org.apache.activemq.artemis.core.server.ActiveMQComponent;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.core.server.ActiveMQServers;
import org.apache.activemq.artemis.core.server.NodeManager;
import org.apache.activemq.artemis.core.server.cluster.ActiveMQServerSideProtocolManagerFactory;
import org.apache.activemq.artemis.core.server.cluster.ClusterConnection;
import org.apache.activemq.artemis.core.server.cluster.ClusterManager;
import org.apache.activemq.artemis.core.server.cluster.RemoteQueueBinding;
import org.apache.activemq.artemis.core.server.cluster.impl.BridgeMetrics;
import org.apache.activemq.artemis.core.server.cluster.impl.ClusterConnectionImpl;
import org.apache.activemq.artemis.core.server.cluster.impl.ClusterConnectionMetrics;
import org.apache.activemq.artemis.core.server.cluster.impl.MessageLoadBalancingType;
import org.apache.activemq.artemis.core.server.group.GroupingHandler;
import org.apache.activemq.artemis.core.server.group.impl.GroupingHandlerConfiguration;
import org.apache.activemq.artemis.core.server.impl.AddressInfo;
import org.apache.activemq.artemis.core.server.impl.InVMNodeManager;
import org.apache.activemq.artemis.quorum.file.FileBasedPrimitiveManager;
import org.apache.activemq.artemis.spi.core.protocol.ProtocolManagerFactory;
import org.apache.activemq.artemis.spi.core.remoting.ClientProtocolManagerFactory;
import org.apache.activemq.artemis.tests.util.ActiveMQTestBase;
import org.apache.activemq.artemis.utils.PortCheckRule;
import org.jboss.logging.Logger;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.ClassRule;

public abstract class ClusterTestBase
extends ActiveMQTestBase {
    private static final Logger log = Logger.getLogger(ClusterTestBase.class);
    private static final int[] PORTS = new int[]{61616, 61617, 61618, 61619, 61620, 61621, 61622, 61623, 61624, 61625};
    @ClassRule
    public static PortCheckRule rule = new PortCheckRule(PORTS);
    private static final long TIMEOUT_START_SERVER = 10L;
    private static final SimpleString COUNT_PROP = new SimpleString("count_prop");
    protected static final SimpleString FILTER_PROP = new SimpleString("animal");
    private static final int MAX_SERVERS = 10;
    protected ConsumerHolder[] consumers;
    protected ActiveMQServer[] servers;
    protected NodeManager[] nodeManagers;
    protected ClientSessionFactory[] sfs;
    protected long[] timeStarts;
    protected ServerLocator[] locators;
    private DistributedPrimitiveManagerConfiguration pluggableQuorumConfiguration = null;
    private static final int MAX_CONSUMERS = 100;

    protected int getLargeMessageSize() {
        return 500;
    }

    protected boolean isLargeMessage() {
        return false;
    }

    protected boolean isForceUniqueStorageManagerIds() {
        return true;
    }

    private DistributedPrimitiveManagerConfiguration getOrCreatePluggableQuorumConfiguration() {
        if (this.pluggableQuorumConfiguration != null) {
            return this.pluggableQuorumConfiguration;
        }
        try {
            this.pluggableQuorumConfiguration = new DistributedPrimitiveManagerConfiguration(FileBasedPrimitiveManager.class.getName(), Collections.singletonMap("locks-folder", this.temporaryFolder.newFolder("manager").toString()));
        }
        catch (IOException ioException) {
            log.error((Object)ioException);
            return null;
        }
        return this.pluggableQuorumConfiguration;
    }

    @Before
    public void setUp() throws Exception {
        super.setUp();
        ClusterTestBase.forceGC();
        this.consumers = new ConsumerHolder[100];
        this.servers = new ActiveMQServer[10];
        this.timeStarts = new long[10];
        this.sfs = new ClientSessionFactory[10];
        this.nodeManagers = new NodeManager[10];
        int nodeManagersLength = this.nodeManagers.length;
        for (int i = 0; i < nodeManagersLength; ++i) {
            this.nodeManagers[i] = new InVMNodeManager(this.isSharedStore(), new File(this.getJournalDir(i, true)));
        }
        this.locators = new ServerLocator[10];
    }

    protected HAType haType() {
        return HAType.SharedNothingReplication;
    }

    protected final boolean isSharedStore() {
        return HAType.SharedStore.equals((Object)this.haType());
    }

    @After
    public void tearDown() throws Exception {
        this.logTopologyDiagram();
        for (int i = 0; i < 10; ++i) {
            this.addActiveMQComponent((ActiveMQComponent)this.nodeManagers[i]);
        }
        this.servers = null;
        this.sfs = null;
        this.consumers = new ConsumerHolder[100];
        this.nodeManagers = null;
        super.tearDown();
    }

    protected ClientConsumer getConsumer(int node) {
        return this.consumers[node].consumer;
    }

    protected void waitForFailoverTopology(int bNode, int ... nodes) throws Exception {
        ActiveMQServer server = this.servers[bNode];
        log.debug((Object)("waiting for " + Arrays.toString(nodes) + " on the topology for server = " + server));
        long start = System.currentTimeMillis();
        int waitMillis = 2000;
        int sleepTime = 50;
        int nWaits = 0;
        while (server.getClusterManager() == null && nWaits++ < 40) {
            Thread.sleep(50L);
        }
        Set ccs = server.getClusterManager().getClusterConnections();
        if (ccs.size() != 1) {
            throw new IllegalStateException("You need a single cluster connection on this version of waitForTopology on ServiceTestBase");
        }
        boolean exists = false;
        for (int node : nodes) {
            ClusterConnectionImpl clusterConnection = (ClusterConnectionImpl)ccs.iterator().next();
            Topology topology = clusterConnection.getTopology();
            TransportConfiguration nodeConnector = ((ClusterConnection)this.servers[node].getClusterManager().getClusterConnections().iterator().next()).getConnector();
            do {
                Collection members = topology.getMembers();
                for (TopologyMemberImpl member : members) {
                    if (member.getConnector().getA() == null || !((TransportConfiguration)member.getConnector().getA()).equals((Object)nodeConnector)) continue;
                    exists = true;
                    break;
                }
                if (exists) break;
                Thread.sleep(10L);
            } while (System.currentTimeMillis() - start < 30000L);
            if (exists) continue;
            String msg = "Timed out waiting for cluster topology of " + Arrays.toString(nodes) + " (received " + topology.getMembers().size() + ") topology = " + topology + ")";
            log.error((Object)msg);
            this.logTopologyDiagram();
            throw new Exception(msg);
        }
    }

    private void logTopologyDiagram() {
        try {
            StringBuffer topologyDiagram = new StringBuffer();
            for (ActiveMQServer activeMQServer : this.servers) {
                if (activeMQServer == null) continue;
                topologyDiagram.append("\n").append(activeMQServer.getIdentity()).append("\n");
                if (activeMQServer.isStarted()) {
                    Set ccs = activeMQServer.getClusterManager().getClusterConnections();
                    if (ccs.size() >= 1) {
                        ClusterConnectionImpl clusterConnection = (ClusterConnectionImpl)ccs.iterator().next();
                        Collection members = clusterConnection.getTopology().getMembers();
                        for (TopologyMemberImpl member : members) {
                            String nodeId = member.getNodeId();
                            String liveServer = null;
                            String backupServer = null;
                            for (ActiveMQServer server : this.servers) {
                                if (server == null || server.getNodeID() == null || !server.isActive() || !server.getNodeID().toString().equals(nodeId)) continue;
                                if (server.isActive()) {
                                    liveServer = server.getIdentity();
                                    if (member.getLive() != null) {
                                        liveServer = liveServer + "(notified)";
                                        continue;
                                    }
                                    liveServer = liveServer + "(not notified)";
                                    continue;
                                }
                                backupServer = server.getIdentity();
                                liveServer = member.getBackup() != null ? liveServer + "(notified)" : liveServer + "(not notified)";
                            }
                            topologyDiagram.append("\t").append("|\n").append("\t->").append(liveServer).append("/").append(backupServer).append("\n");
                        }
                        continue;
                    }
                    topologyDiagram.append("-> no cluster connections\n");
                    continue;
                }
                topologyDiagram.append("-> stopped\n");
            }
            topologyDiagram.append("\n");
            log.debug((Object)topologyDiagram.toString());
        }
        catch (Throwable e) {
            log.warn((Object)("error printing the topology::" + e.getMessage()), e);
        }
    }

    protected void waitForMessages(int node, String address, int count) throws Exception {
        ActiveMQServer server = this.servers[node];
        if (server == null) {
            throw new IllegalArgumentException("No server at " + node);
        }
        PostOffice po = server.getPostOffice();
        long start = System.currentTimeMillis();
        int messageCount = 0;
        do {
            if ((messageCount = this.getMessageCount(po, address)) == count) {
                return;
            }
            Thread.sleep(10L);
        } while (System.currentTimeMillis() - start < 30000L);
        throw new IllegalStateException("Timed out waiting for messages (messageCount = " + messageCount + ", expecting = " + count);
    }

    protected void waitForServerRestart(int node) throws Exception {
        long waitTimeout = 30000L;
        if (!this.isSharedStore()) {
            waitTimeout = 65000L;
        }
        if (!this.servers[node].waitForActivation(waitTimeout, TimeUnit.MILLISECONDS)) {
            String msg = "Timed out waiting for server starting = " + node;
            log.error((Object)msg);
            throw new IllegalStateException(msg);
        }
    }

    protected void waitForBindings(int node, String address, int expectedBindingCount, int expectedConsumerCount, boolean local) throws Exception {
        log.debug((Object)("waiting for bindings on node " + node + " address " + address + " expectedBindingCount " + expectedBindingCount + " consumerCount " + expectedConsumerCount + " local " + local));
        ActiveMQServer server = this.servers[node];
        if (server == null) {
            throw new IllegalArgumentException("No server at " + node);
        }
        long timeout = 30000L;
        if (this.waitForBindings(server, address, local, expectedBindingCount, expectedConsumerCount, timeout)) {
            return;
        }
        PostOffice po = server.getPostOffice();
        Bindings bindings = po.getBindingsForAddress(new SimpleString(address));
        log.debug((Object)"=======================================================================");
        log.debug((Object)("Binding information for address = " + address + " on node " + node));
        for (Binding binding : bindings.getBindings()) {
            if (!binding.isConnected() || (!(binding instanceof LocalQueueBinding) || !local) && (!(binding instanceof RemoteQueueBinding) || local)) continue;
            QueueBinding qBinding = (QueueBinding)binding;
            log.debug((Object)("Binding = " + qBinding + ", queue=" + qBinding.getQueue()));
        }
        StringWriter writer = new StringWriter();
        PrintWriter out = new PrintWriter(writer);
        try {
            for (ActiveMQServer activeMQServer : this.servers) {
                if (activeMQServer == null) continue;
                out.println(this.clusterDescription(activeMQServer));
                out.println(this.debugBindings(activeMQServer, activeMQServer.getConfiguration().getManagementNotificationAddress().toString()));
            }
            for (ActiveMQServer activeMQServer : this.servers) {
                out.println("Management bindings on " + activeMQServer);
                if (activeMQServer == null) continue;
                out.println(this.debugBindings(activeMQServer, activeMQServer.getConfiguration().getManagementNotificationAddress().toString()));
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        this.logAndSystemOut(writer.toString());
        throw new IllegalStateException("Didn't get the expected number of bindings, look at the logging for more information");
    }

    protected String debugBindings(ActiveMQServer server, String address) throws Exception {
        StringWriter str = new StringWriter();
        PrintWriter out = new PrintWriter(str);
        if (server == null) {
            return "server is shutdown";
        }
        PostOffice po = server.getPostOffice();
        if (po == null) {
            return "server is shutdown";
        }
        Bindings bindings = po.getBindingsForAddress(new SimpleString(address));
        out.println("=======================================================================");
        out.println("Binding information for address = " + address + " on " + server);
        for (Binding binding : bindings.getBindings()) {
            QueueBinding qBinding = (QueueBinding)binding;
            out.println("Binding = " + qBinding + ", queue=" + qBinding.getQueue());
        }
        out.println("=======================================================================");
        return str.toString();
    }

    protected void createQueue(int node, String address, String queueName, String filterVal, boolean durable) throws Exception {
        this.createQueue(node, address, queueName, filterVal, durable, null, null);
    }

    protected void createQueue(int node, String address, String queueName, String filterVal, boolean durable, RoutingType routingType) throws Exception {
        this.createQueue(node, address, queueName, filterVal, durable, null, null, routingType);
    }

    protected void createQueue(int node, String address, String queueName, String filterVal, boolean durable, String user, String password) throws Exception {
        this.createQueue(node, address, queueName, filterVal, durable, user, password, RoutingType.MULTICAST);
    }

    protected void createQueue(int node, String address, String queueName, String filterVal, boolean durable, String user, String password, RoutingType routingType) throws Exception {
        ClientSessionFactory sf = this.sfs[node];
        if (sf == null) {
            throw new IllegalArgumentException("No sf at " + node);
        }
        ClientSession session = this.addClientSession(sf.createSession(user, password, false, true, true, false, 0x100000));
        String filterString = null;
        if (filterVal != null) {
            filterString = FILTER_PROP.toString() + "='" + filterVal + "'";
        }
        log.debug((Object)("Creating " + queueName + " , address " + address + " on " + this.servers[node]));
        session.createQueue(new QueueConfiguration(queueName).setAddress(address).setRoutingType(routingType).setFilterString(filterString).setDurable(Boolean.valueOf(durable)));
        session.close();
    }

    protected void createAddressInfo(int node, String address, RoutingType routingType, int defaulMaxConsumers, boolean defaultPurgeOnNoConsumers) throws Exception {
        AddressInfo addressInfo = new AddressInfo(new SimpleString(address));
        addressInfo.addRoutingType(routingType);
        this.servers[node].addOrUpdateAddressInfo(addressInfo);
    }

    protected void deleteQueue(int node, String queueName) throws Exception {
        ClientSessionFactory sf = this.sfs[node];
        if (sf == null) {
            throw new IllegalArgumentException("No sf at " + node);
        }
        ClientSession session = sf.createSession(false, true, true);
        session.deleteQueue(queueName);
        session.close();
    }

    protected void addConsumer(int consumerID, int node, String queueName, String filterVal) throws Exception {
        this.addConsumer(consumerID, node, queueName, filterVal, true);
    }

    protected void addConsumer(int consumerID, int node, String queueName, String filterVal, boolean autoCommitAcks) throws Exception {
        this.addConsumer(consumerID, node, queueName, filterVal, autoCommitAcks, null, null);
    }

    protected void addConsumer(int consumerID, int node, String queueName, String filterVal, boolean autoCommitAcks, String user, String password) throws Exception {
        try {
            if (this.consumers[consumerID] != null) {
                throw new IllegalArgumentException("Already a consumer at " + node);
            }
            ClientSessionFactory sf = this.sfs[node];
            if (sf == null) {
                throw new IllegalArgumentException("No sf at " + node);
            }
            ClientSession session = this.addClientSession(sf.createSession(user, password, false, false, autoCommitAcks, false, 0x100000));
            String filterString = null;
            if (filterVal != null) {
                filterString = FILTER_PROP.toString() + "='" + filterVal + "'";
            }
            ClientConsumer consumer = this.addClientConsumer(session.createConsumer(queueName, filterString));
            session.start();
            this.consumers[consumerID] = new ConsumerHolder(consumerID, consumer, session, node);
        }
        catch (Exception e) {
            e.printStackTrace();
            System.out.println(ActiveMQTestBase.threadDump((String)" - fired by ClusterTestBase::addConsumer"));
            throw e;
        }
    }

    protected void removeConsumer(int consumerID) {
        ConsumerHolder holder = this.consumers[consumerID];
        if (holder == null) {
            throw new IllegalArgumentException("No consumer at " + consumerID);
        }
        holder.close();
        this.consumers[consumerID] = null;
    }

    protected void closeAllConsumers() {
        if (this.consumers == null) {
            return;
        }
        for (int i = 0; i < this.consumers.length; ++i) {
            ConsumerHolder holder = this.consumers[i];
            if (holder == null) continue;
            holder.close();
            this.consumers[i] = null;
        }
    }

    protected void closeAllSessionFactories() {
        if (this.sfs != null) {
            for (int i = 0; i < this.sfs.length; ++i) {
                ClusterTestBase.closeSessionFactory((ClientSessionFactory)this.sfs[i]);
                this.sfs[i] = null;
            }
        }
        super.closeAllSessionFactories();
    }

    protected void closeAllServerLocatorsFactories() {
        for (int i = 0; i < this.locators.length; ++i) {
            ClusterTestBase.closeServerLocator((ServerLocator)this.locators[i]);
            this.locators[i] = null;
        }
        super.closeAllServerLocatorsFactories();
    }

    protected void closeSessionFactory(int node) {
        ClientSessionFactory sf = this.sfs[node];
        if (sf == null) {
            throw new IllegalArgumentException("No sf at " + node);
        }
        sf.close();
        this.sfs[node] = null;
    }

    protected void sendInRange(int node, String address, int msgStart, int msgEnd, boolean durable, String filterVal) throws Exception {
        this.sendInRange(node, address, msgStart, msgEnd, durable, filterVal, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void sendInRange(int node, String address, int msgStart, int msgEnd, boolean durable, String filterVal, AtomicInteger duplicateDetectionSeq) throws Exception {
        ClientSessionFactory sf = this.sfs[node];
        if (sf == null) {
            throw new IllegalArgumentException("No sf at " + node);
        }
        try (ClientSession session = sf.createSession(false, false, false);){
            ClientProducer producer = session.createProducer(address);
            for (int i = msgStart; i < msgEnd; ++i) {
                ClientMessage message = session.createMessage(durable);
                if (filterVal != null) {
                    message.putStringProperty(FILTER_PROP, new SimpleString(filterVal));
                }
                if (duplicateDetectionSeq != null) {
                    String str = Integer.toString(duplicateDetectionSeq.incrementAndGet());
                    message.putStringProperty(Message.HDR_DUPLICATE_DETECTION_ID, new SimpleString(str));
                }
                message.putIntProperty(COUNT_PROP, i);
                if (this.isLargeMessage()) {
                    message.setBodyInputStream(ClusterTestBase.createFakeLargeStream((long)this.getLargeMessageSize()));
                }
                producer.send((Message)message);
                if (i % 100 != 0) continue;
                session.commit();
            }
            session.commit();
        }
    }

    protected void sendWithProperty(int node, String address, int numMessages, boolean durable, SimpleString key, SimpleString val) throws Exception {
        this.sendInRange(node, address, 0, numMessages, durable, key, val);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void sendInRange(int node, String address, int msgStart, int msgEnd, boolean durable, SimpleString key, SimpleString val) throws Exception {
        ClientSessionFactory sf = this.sfs[node];
        if (sf == null) {
            throw new IllegalArgumentException("No sf at " + node);
        }
        try (ClientSession session = sf.createSession(false, true, true);){
            ClientProducer producer = session.createProducer(address);
            for (int i = msgStart; i < msgEnd; ++i) {
                ClientMessage message = session.createMessage(durable);
                if (this.isLargeMessage()) {
                    message.setBodyInputStream(ClusterTestBase.createFakeLargeStream((long)this.getLargeMessageSize()));
                }
                message.putStringProperty(key, val);
                message.putIntProperty(COUNT_PROP, i);
                producer.send((Message)message);
            }
        }
    }

    protected void setUpGroupHandler(GroupingHandlerConfiguration.TYPE type, int node) {
        this.setUpGroupHandler(type, node, 5000);
    }

    protected void setUpGroupHandler(GroupingHandlerConfiguration.TYPE type, int node, int timeout) {
        this.setUpGroupHandler(type, node, timeout, -1L, ActiveMQDefaultConfiguration.getDefaultGroupingHandlerReaperPeriod());
    }

    protected void setUpGroupHandler(GroupingHandlerConfiguration.TYPE type, int node, int timeout, long groupTimeout, long reaperPeriod) {
        this.servers[node].getConfiguration().setGroupingHandlerConfiguration(new GroupingHandlerConfiguration().setName(new SimpleString("grouparbitrator")).setType(type).setAddress(new SimpleString("queues")).setTimeout((long)timeout).setGroupTimeout(groupTimeout).setReaperPeriod(reaperPeriod));
    }

    protected void setUpGroupHandler(GroupingHandler groupingHandler, int node) {
        this.servers[node].setGroupingHandler(groupingHandler);
    }

    protected void send(int node, String address, int numMessages, boolean durable, String filterVal) throws Exception {
        this.send(node, address, numMessages, durable, filterVal, null);
    }

    protected void send(int node, String address, int numMessages, boolean durable, String filterVal, AtomicInteger duplicateDetectionCounter) throws Exception {
        this.sendInRange(node, address, 0, numMessages, durable, filterVal, duplicateDetectionCounter);
    }

    protected void verifyReceiveAllInRange(boolean ack, int msgStart, int msgEnd, int ... consumerIDs) throws Exception {
        this.verifyReceiveAllInRangeNotBefore(ack, -1L, msgStart, msgEnd, consumerIDs);
    }

    protected void verifyReceiveAllInRange(int msgStart, int msgEnd, int ... consumerIDs) throws Exception {
        this.verifyReceiveAllInRangeNotBefore(false, -1L, msgStart, msgEnd, consumerIDs);
    }

    protected void verifyReceiveAllWithGroupIDRoundRobin(int msgStart, int msgEnd, int ... consumerIDs) throws Exception {
        this.verifyReceiveAllWithGroupIDRoundRobin(true, -1L, msgStart, msgEnd, consumerIDs);
    }

    protected int verifyReceiveAllOnSingleConsumer(int msgStart, int msgEnd, int ... consumerIDs) throws Exception {
        return this.verifyReceiveAllOnSingleConsumer(true, msgStart, msgEnd, consumerIDs);
    }

    protected void verifyReceiveAllWithGroupIDRoundRobin(boolean ack, long firstReceiveTime, int msgStart, int msgEnd, int ... consumerIDs) throws Exception {
        HashMap<SimpleString, Integer> groupIdsReceived = new HashMap<SimpleString, Integer>();
        for (int i = 0; i < consumerIDs.length; ++i) {
            ConsumerHolder holder = this.consumers[consumerIDs[i]];
            if (holder == null) {
                throw new IllegalArgumentException("No consumer at " + consumerIDs[i]);
            }
            for (int j = msgStart; j < msgEnd; ++j) {
                SimpleString id;
                ClientMessage message = holder.consumer.receive(2000L);
                if (message == null) {
                    log.debug((Object)"*** dumping consumers:");
                    this.dumpConsumers();
                    Assert.assertNotNull((String)("consumer " + consumerIDs[i] + " did not receive message " + j), (Object)message);
                }
                if (ack) {
                    message.acknowledge();
                }
                if (firstReceiveTime != -1L) {
                    Assert.assertTrue((String)"Message received too soon", (System.currentTimeMillis() >= firstReceiveTime ? 1 : 0) != 0);
                }
                if (groupIdsReceived.get(id = (SimpleString)message.getObjectProperty(Message.HDR_GROUP_ID)) == null) {
                    groupIdsReceived.put(id, i);
                    continue;
                }
                if ((Integer)groupIdsReceived.get(id) == i) continue;
                Assert.fail((String)("consumer " + groupIdsReceived.get(id) + " already bound to groupid " + id + " received on consumer " + i));
            }
        }
    }

    protected int verifyReceiveAllOnSingleConsumer(boolean ack, int msgStart, int msgEnd, int ... consumerIDs) throws Exception {
        int groupIdsReceived = -1;
        for (int i = 0; i < consumerIDs.length; ++i) {
            ConsumerHolder holder = this.consumers[consumerIDs[i]];
            if (holder == null) {
                throw new IllegalArgumentException("No consumer at " + consumerIDs[i]);
            }
            ClientMessage message = holder.consumer.receive(2000L);
            if (message == null) continue;
            groupIdsReceived = i;
            for (int j = msgStart + 1; j < msgEnd; ++j) {
                message = holder.consumer.receive(2000L);
                if (message == null) {
                    Assert.fail((String)("consumer " + i + " did not receive all messages"));
                }
                if (!ack) continue;
                message.acknowledge();
            }
        }
        return groupIdsReceived;
    }

    protected void verifyReceiveAllInRangeNotBefore(boolean ack, long firstReceiveTime, int msgStart, int msgEnd, int ... consumerIDs) throws Exception {
        boolean outOfOrder = false;
        String firstOutOfOrderMessage = null;
        for (int consumerID : consumerIDs) {
            ConsumerHolder holder = this.consumers[consumerID];
            if (holder == null) {
                throw new IllegalArgumentException("No consumer at " + consumerID);
            }
            for (int j = msgStart; j < msgEnd; ++j) {
                ClientMessage message = holder.consumer.receive(30000L);
                if (message == null) {
                    log.debug((Object)"*** dumping consumers:");
                    this.dumpConsumers();
                    Assert.fail((String)("consumer " + consumerID + " did not receive message " + j));
                }
                if (this.isLargeMessage()) {
                    this.checkMessageBody(message);
                }
                if (ack) {
                    message.acknowledge();
                }
                if (firstReceiveTime != -1L) {
                    Assert.assertTrue((String)"Message received too soon", (System.currentTimeMillis() >= firstReceiveTime ? 1 : 0) != 0);
                }
                if (j == (Integer)message.getObjectProperty(COUNT_PROP)) continue;
                if (firstOutOfOrderMessage == null) {
                    firstOutOfOrderMessage = "expected " + j + " received " + message.getObjectProperty(COUNT_PROP);
                }
                outOfOrder = true;
                log.debug((Object)("Message j=" + j + " was received out of order = " + message.getObjectProperty(COUNT_PROP)));
                log.debug((Object)("Message j=" + j + " was received out of order = " + message.getObjectProperty(COUNT_PROP)));
            }
        }
        Assert.assertFalse((String)("Messages were consumed out of order::" + firstOutOfOrderMessage), (boolean)outOfOrder);
    }

    private void dumpConsumers() throws Exception {
        for (int i = 0; i < this.consumers.length; ++i) {
            if (this.consumers[i] == null || this.consumers[i].consumer.isClosed()) continue;
            log.debug((Object)("Dumping consumer " + i));
            this.checkReceive(i);
        }
    }

    protected String clusterDescription(ActiveMQServer server) {
        String br;
        String out = br = "-------------------------\n";
        out = out + "ActiveMQ Artemis server " + server + "\n";
        ClusterManager clusterManager = server.getClusterManager();
        if (clusterManager == null) {
            out = out + "N/A";
        } else {
            for (ClusterConnection cc : clusterManager.getClusterConnections()) {
                out = out + cc.describe() + "\n";
                out = out + cc.getTopology().describe();
            }
        }
        out = out + "\n\nfull topology:";
        return out + br;
    }

    protected void verifyReceiveAll(boolean ack, int numMessages, int ... consumerIDs) throws Exception {
        this.verifyReceiveAllInRange(ack, 0, numMessages, consumerIDs);
    }

    protected void verifyReceiveAll(int numMessages, int ... consumerIDs) throws Exception {
        this.verifyReceiveAllInRange(false, 0, numMessages, consumerIDs);
    }

    protected void verifyReceiveAllNotBefore(long firstReceiveTime, int numMessages, int ... consumerIDs) throws Exception {
        this.verifyReceiveAllInRangeNotBefore(false, firstReceiveTime, 0, numMessages, consumerIDs);
    }

    protected void checkReceive(int ... consumerIDs) throws Exception {
        for (int consumerID : consumerIDs) {
            ClientMessage message;
            ConsumerHolder holder = this.consumers[consumerID];
            if (holder == null) {
                throw new IllegalArgumentException("No consumer at " + consumerID);
            }
            do {
                if ((message = holder.consumer.receive(500L)) != null) {
                    log.debug((Object)("check receive Consumer " + consumerID + " received message " + message.getObjectProperty(COUNT_PROP)));
                    continue;
                }
                log.debug((Object)("check receive Consumer " + consumerID + " null message"));
            } while (message != null);
        }
    }

    protected void verifyReceiveRoundRobin(int numMessages, int ... consumerIDs) throws Exception {
        int count = 0;
        for (int i = 0; i < numMessages; ++i) {
            if (consumerIDs[count] >= 0) {
                ConsumerHolder holder = this.consumers[consumerIDs[count]];
                if (holder == null) {
                    throw new IllegalArgumentException("No consumer at " + consumerIDs[i]);
                }
                ClientMessage message = holder.consumer.receive(30000L);
                Assert.assertNotNull((String)("consumer " + consumerIDs[count] + " did not receive message " + i), (Object)message);
                Assert.assertEquals((String)("consumer " + consumerIDs[count] + " message " + i), (Object)i, (Object)message.getObjectProperty(COUNT_PROP));
                message.acknowledge();
                this.consumers[consumerIDs[count]].session.commit();
            }
            if (++count != consumerIDs.length) continue;
            count = 0;
        }
    }

    protected void verifyReceiveRoundRobinInSomeOrder(int numMessages, int ... consumerIDs) throws Exception {
        if (numMessages < consumerIDs.length) {
            throw new IllegalStateException("You must send more messages than consumers specified or the algorithm won't work");
        }
        this.verifyReceiveRoundRobinInSomeOrder(true, numMessages, consumerIDs);
    }

    protected void verifyReceiveRoundRobinInSomeOrder(boolean ack, int numMessages, int ... consumerIDs) throws Exception {
        if (numMessages < consumerIDs.length) {
            throw new IllegalStateException("not enough messages");
        }
        ArrayList<OrderedConsumerHolder> sorted = new ArrayList<OrderedConsumerHolder>();
        for (int consumerID : consumerIDs) {
            ConsumerHolder holder = this.consumers[consumerID];
            ClientMessage msg = holder.consumer.receive(10000L);
            Assert.assertNotNull((String)"msg must exist", (Object)msg);
            int count = msg.getIntProperty(COUNT_PROP);
            OrderedConsumerHolder orderedHolder = new OrderedConsumerHolder();
            orderedHolder.consumer = holder;
            orderedHolder.order = count;
            sorted.add(orderedHolder);
            if (!ack) continue;
            msg.acknowledge();
        }
        Collections.sort(sorted);
        int count = 0;
        for (OrderedConsumerHolder holder : sorted) {
            if (holder.order != count) {
                throw new IllegalStateException("Out of order");
            }
            ++count;
        }
        block2: while (count < numMessages) {
            for (OrderedConsumerHolder holder : sorted) {
                ClientMessage msg = holder.consumer.consumer.receive(10000L);
                Assert.assertNotNull((String)"msg must exist", (Object)msg);
                int p = msg.getIntProperty(COUNT_PROP);
                if (p != count) {
                    throw new IllegalStateException("Out of order 2");
                }
                if (ack) {
                    msg.acknowledge();
                }
                if (++count != numMessages) continue;
                break block2;
            }
        }
    }

    protected void verifyReceiveRoundRobinInSomeOrderWithCounts(boolean ack, int[] messageCounts, int ... consumerIDs) throws Exception {
        ArrayList receivedCounts = new ArrayList();
        HashSet<Integer> counts = new HashSet<Integer>();
        for (int n : consumerIDs) {
            ClientMessage message;
            ConsumerHolder holder = this.consumers[n];
            if (holder == null) {
                throw new IllegalArgumentException("No consumer at " + n);
            }
            LinkedList<Integer> list = new LinkedList<Integer>();
            receivedCounts.add(list);
            do {
                if ((message = holder.consumer.receive(1000L)) == null) continue;
                int count = (Integer)message.getObjectProperty(COUNT_PROP);
                this.checkMessageBody(message);
                Assert.assertFalse((boolean)counts.contains(count));
                counts.add(count);
                list.add(count);
                if (!ack) continue;
                message.acknowledge();
            } while (message != null);
        }
        for (int n : messageCounts) {
            Assert.assertTrue((boolean)counts.contains(n));
        }
        LinkedList[] lists = new LinkedList[consumerIDs.length];
        block3: for (int i = 0; i < messageCounts.length; ++i) {
            for (LinkedList linkedList : receivedCounts) {
                int elem = (Integer)linkedList.get(0);
                if (elem != messageCounts[i]) continue;
                lists[i] = linkedList;
                continue block3;
            }
        }
        int index = 0;
        for (int messageCount : messageCounts) {
            LinkedList list = lists[index];
            Assert.assertNotNull((Object)list);
            int elem = (Integer)list.poll();
            Assert.assertEquals((long)messageCount, (long)elem);
            if (++index != consumerIDs.length) continue;
            index = 0;
        }
    }

    private void checkMessageBody(ClientMessage message) {
        if (this.isLargeMessage()) {
            for (int posMsg = 0; posMsg < this.getLargeMessageSize(); ++posMsg) {
                ClusterTestBase.assertEquals((long)ClusterTestBase.getSamplebyte((long)posMsg), (long)message.getBodyBuffer().readByte());
            }
        }
    }

    protected void verifyReceiveRoundRobinInSomeOrderNoAck(int numMessages, int ... consumerIDs) throws Exception {
        if (numMessages < consumerIDs.length) {
            throw new IllegalStateException("You must send more messages than consumers specified or the algorithm won't work");
        }
        this.verifyReceiveRoundRobinInSomeOrder(false, numMessages, consumerIDs);
    }

    protected void verifyClusterMetrics(int node, String clusterName, long expectedMessagesPendingAcknowledgement, long expectedMessagesAcknowledged) {
        ClusterConnection clusterConnection = this.servers[node].getClusterManager().getClusterConnection(clusterName);
        ClusterConnectionMetrics clusterMetrics = clusterConnection.getMetrics();
        ClusterTestBase.assertEquals((long)expectedMessagesPendingAcknowledgement, (long)clusterMetrics.getMessagesPendingAcknowledgement());
        ClusterTestBase.assertEquals((long)expectedMessagesAcknowledged, (long)clusterMetrics.getMessagesAcknowledged());
    }

    protected void verifyBridgeMetrics(int node, String clusterName, String bridgeNodeId, long expectedMessagesPendingAcknowledgement, long expectedMessagesAcknowledged) {
        ClusterConnection clusterConnection = this.servers[node].getClusterManager().getClusterConnection(clusterName);
        BridgeMetrics bridgeMetrics = clusterConnection.getBridgeMetrics(bridgeNodeId);
        ClusterTestBase.assertEquals((long)expectedMessagesPendingAcknowledgement, (long)bridgeMetrics.getMessagesPendingAcknowledgement());
        ClusterTestBase.assertEquals((long)expectedMessagesAcknowledged, (long)bridgeMetrics.getMessagesAcknowledged());
    }

    protected int[] getReceivedOrder(int consumerID) throws Exception {
        return this.getReceivedOrder(consumerID, false);
    }

    protected int[] getReceivedOrder(int consumerID, boolean ack) throws Exception {
        ConsumerHolder consumer = this.consumers[consumerID];
        if (consumer == null) {
            throw new IllegalArgumentException("No consumer at " + consumerID);
        }
        ArrayList<Integer> ints = new ArrayList<Integer>();
        ClientMessage message = null;
        do {
            if ((message = consumer.consumer.receive(500L)) == null) continue;
            if (this.isLargeMessage()) {
                this.checkMessageBody(message);
            }
            if (ack) {
                message.acknowledge();
            }
            int count = (Integer)message.getObjectProperty(COUNT_PROP);
            ints.add(count);
        } while (message != null);
        int[] res = new int[ints.size()];
        int j = 0;
        for (Integer i : ints) {
            res[j++] = i;
        }
        if (ack) {
            this.consumers[consumerID].session.commit();
        }
        return res;
    }

    protected void verifyNotReceive(int ... consumerIDs) throws Exception {
        for (int i = 0; i < consumerIDs.length; ++i) {
            ConsumerHolder holder = this.consumers[consumerIDs[i]];
            if (holder == null) {
                throw new IllegalArgumentException("No consumer at " + consumerIDs[i]);
            }
            Assert.assertNull((String)("consumer " + i + " received message"), (Object)holder.consumer.receiveImmediate());
        }
    }

    protected void setupSessionFactory(int node, boolean netty) throws Exception {
        this.setupSessionFactory(node, netty, false);
    }

    protected void setupSessionFactory(int node, boolean netty, boolean ha) throws Exception {
        this.setupSessionFactory(node, netty, ha, null, null);
    }

    protected void setupSessionFactory(int node, boolean netty, boolean ha, String user, String password) throws Exception {
        if (this.sfs[node] != null) {
            throw new IllegalArgumentException("Already a factory at " + node);
        }
        Map params = ClusterTestBase.generateParams((int)node, (boolean)netty);
        TransportConfiguration serverTotc = netty ? new TransportConfiguration(ActiveMQTestBase.NETTY_CONNECTOR_FACTORY, params) : new TransportConfiguration(INVM_CONNECTOR_FACTORY, params);
        this.setSessionFactoryCreateLocator(node, ha, serverTotc);
        this.locators[node].setProtocolManagerFactory((ClientProtocolManagerFactory)ActiveMQServerSideProtocolManagerFactory.getInstance((ServerLocator)this.locators[node], (StorageManager)this.servers[node].getStorageManager()));
        this.locators[node].setBlockOnNonDurableSend(true).setBlockOnDurableSend(true);
        this.addServerLocator(this.locators[node]);
        ClientSessionFactory sf = this.createSessionFactory(this.locators[node]);
        ClientSession session = sf.createSession(user, password, false, true, true, false, 0x100000);
        session.close();
        this.sfs[node] = sf;
    }

    protected void setSessionFactoryCreateLocator(int node, boolean ha, TransportConfiguration serverTotc) {
        this.locators[node] = ha ? ActiveMQClient.createServerLocatorWithHA((TransportConfiguration[])new TransportConfiguration[]{serverTotc}) : ActiveMQClient.createServerLocatorWithoutHA((TransportConfiguration[])new TransportConfiguration[]{serverTotc});
    }

    protected void setupSessionFactory(int node, boolean netty, int reconnectAttempts) throws Exception {
        ClientSessionFactory sf;
        if (this.sfs[node] != null) {
            throw new IllegalArgumentException("Already a server at " + node);
        }
        Map params = ClusterTestBase.generateParams((int)node, (boolean)netty);
        TransportConfiguration serverTotc = netty ? new TransportConfiguration(ActiveMQTestBase.NETTY_CONNECTOR_FACTORY, params) : new TransportConfiguration(INVM_CONNECTOR_FACTORY, params);
        this.locators[node] = ActiveMQClient.createServerLocatorWithoutHA((TransportConfiguration[])new TransportConfiguration[]{serverTotc}).setBlockOnNonDurableSend(true).setBlockOnDurableSend(true).setReconnectAttempts(reconnectAttempts);
        this.addServerLocator(this.locators[node]);
        this.sfs[node] = sf = this.createSessionFactory(this.locators[node]);
    }

    protected void setupSessionFactory(int node, int backupNode, boolean netty, boolean blocking) throws Exception {
        ClientSessionFactory sf;
        if (this.sfs[node] != null) {
            throw new IllegalArgumentException("Already a server at " + node);
        }
        Map params = ClusterTestBase.generateParams((int)node, (boolean)netty);
        TransportConfiguration serverToTC = ClusterTestBase.createTransportConfiguration((boolean)netty, (boolean)false, (Map)params);
        this.locators[node] = this.addServerLocator(ActiveMQClient.createServerLocatorWithHA((TransportConfiguration[])new TransportConfiguration[]{serverToTC})).setRetryInterval(100L).setRetryIntervalMultiplier(1.0).setReconnectAttempts(300).setBlockOnNonDurableSend(blocking).setBlockOnDurableSend(blocking);
        String identity = "TestClientConnector,live=" + node + ",backup=" + backupNode;
        ((ServerLocatorInternal)this.locators[node]).setIdentity(identity);
        this.sfs[node] = sf = this.createSessionFactory(this.locators[node]);
    }

    protected void setupSessionFactory(int node, int backupNode, boolean netty) throws Exception {
        this.setupSessionFactory(node, backupNode, netty, true);
    }

    protected ActiveMQServer getServer(int node) {
        if (this.servers[node] == null) {
            throw new IllegalArgumentException("No server at node " + node);
        }
        return this.servers[node];
    }

    protected void setupServer(int node, boolean fileStorage, boolean netty) throws Exception {
        this.setupLiveServer(node, fileStorage, HAType.SharedNothingReplication, netty, false);
    }

    protected void setupLiveServer(int node, boolean fileStorage, boolean netty, boolean isLive) throws Exception {
        this.setupLiveServer(node, fileStorage, HAType.SharedNothingReplication, netty, isLive);
    }

    protected boolean isResolveProtocols() {
        return false;
    }

    protected void setupLiveServer(int node, boolean fileStorage, HAType haType, boolean netty, boolean liveOnly) throws Exception {
        if (this.servers[node] != null) {
            throw new IllegalArgumentException("Already a server at node " + node);
        }
        Object haPolicyConfiguration = liveOnly ? new LiveOnlyPolicyConfiguration() : this.haPolicyLiveConfiguration(haType);
        ConfigurationImpl configuration = this.createBasicConfig(node).setJournalMaxIO_AIO(1000).setThreadPoolMaxSize(10).clearAcceptorConfigurations().addAcceptorConfiguration(ClusterTestBase.createTransportConfiguration((boolean)netty, (boolean)true, (Map)ClusterTestBase.generateParams((int)node, (boolean)netty))).setHAPolicyConfiguration((HAPolicyConfiguration)haPolicyConfiguration).setResolveProtocols(this.isResolveProtocols());
        boolean sharedStorage = HAType.SharedStore.equals((Object)haType);
        ActiveMQServer server = fileStorage ? (sharedStorage ? this.createInVMFailoverServer(true, (Configuration)configuration, this.nodeManagers[node], node) : this.createServer((Configuration)configuration)) : (sharedStorage ? this.createInVMFailoverServer(false, (Configuration)configuration, this.nodeManagers[node], node) : this.createServer(false, (Configuration)configuration));
        server.addProtocolManagerFactory((ProtocolManagerFactory)new CoreProtocolManagerFactory());
        server.setIdentity(((Object)((Object)this)).getClass().getSimpleName() + "/Live(" + node + ")");
        this.servers[node] = this.addServer(server);
    }

    private HAPolicyConfiguration haPolicyLiveConfiguration(HAType haType) {
        switch (haType) {
            case SharedStore: {
                return new SharedStoreMasterPolicyConfiguration();
            }
            case SharedNothingReplication: {
                return new ReplicatedPolicyConfiguration();
            }
            case PluggableQuorumReplication: {
                return ReplicationPrimaryPolicyConfiguration.withDefault().setDistributedManagerConfiguration(this.getOrCreatePluggableQuorumConfiguration());
            }
        }
        throw new AssertionError((Object)("Unsupported haType = " + (Object)((Object)haType)));
    }

    protected void setupBackupServer(int node, int liveNode, boolean fileStorage, HAType haType, boolean netty) throws Exception {
        ActiveMQServer server;
        if (this.servers[node] != null) {
            throw new IllegalArgumentException("Already a server at node " + node);
        }
        TransportConfiguration liveConfig = ClusterTestBase.createTransportConfiguration((boolean)netty, (boolean)false, (Map)ClusterTestBase.generateParams((int)liveNode, (boolean)netty));
        TransportConfiguration backupConfig = ClusterTestBase.createTransportConfiguration((boolean)netty, (boolean)false, (Map)ClusterTestBase.generateParams((int)node, (boolean)netty));
        TransportConfiguration acceptorConfig = ClusterTestBase.createTransportConfiguration((boolean)netty, (boolean)true, (Map)ClusterTestBase.generateParams((int)node, (boolean)netty));
        boolean sharedStorage = HAType.SharedStore.equals((Object)haType);
        ConfigurationImpl configuration = this.createBasicConfig(sharedStorage ? liveNode : node).clearAcceptorConfigurations().addAcceptorConfiguration(acceptorConfig).addConnectorConfiguration(liveConfig.getName(), liveConfig).addConnectorConfiguration(backupConfig.getName(), backupConfig).setHAPolicyConfiguration(this.haPolicyBackupConfiguration(haType));
        if (sharedStorage) {
            server = this.createInVMFailoverServer(true, (Configuration)configuration, this.nodeManagers[liveNode], liveNode);
        } else {
            boolean enablePersistency = fileStorage ? true : configuration.isPersistenceEnabled();
            server = this.addServer(ActiveMQServers.newActiveMQServer((Configuration)configuration, (boolean)enablePersistency));
        }
        server.setIdentity(((Object)((Object)this)).getClass().getSimpleName() + "/Backup(" + node + " of live " + liveNode + ")");
        this.servers[node] = this.addServer(server);
    }

    private HAPolicyConfiguration haPolicyBackupConfiguration(HAType haType) {
        switch (haType) {
            case SharedStore: {
                return new SharedStoreSlavePolicyConfiguration();
            }
            case SharedNothingReplication: {
                return new ReplicaPolicyConfiguration();
            }
            case PluggableQuorumReplication: {
                return ReplicationBackupPolicyConfiguration.withDefault().setDistributedManagerConfiguration(this.getOrCreatePluggableQuorumConfiguration());
            }
        }
        throw new AssertionError((Object)("Unsupported ha type = " + (Object)((Object)haType)));
    }

    protected void setupLiveServerWithDiscovery(int node, String groupAddress, int port, boolean fileStorage, boolean netty, boolean sharedStorage) throws Exception {
        ActiveMQServer server;
        if (this.servers[node] != null) {
            throw new IllegalArgumentException("Already a server at node " + node);
        }
        Map params = ClusterTestBase.generateParams((int)node, (boolean)netty);
        TransportConfiguration connector = ClusterTestBase.createTransportConfiguration((boolean)netty, (boolean)false, (Map)params);
        ArrayList<String> connectorPairs = new ArrayList<String>();
        connectorPairs.add(connector.getName());
        UDPBroadcastEndpointFactory endpoint = new UDPBroadcastEndpointFactory().setGroupAddress(groupAddress).setGroupPort(port);
        BroadcastGroupConfiguration bcConfig = new BroadcastGroupConfiguration().setName("bg1").setBroadcastPeriod(200L).setConnectorInfos(connectorPairs).setEndpointFactory((BroadcastEndpointFactory)endpoint);
        DiscoveryGroupConfiguration dcConfig = new DiscoveryGroupConfiguration().setName("dg1").setRefreshTimeout(1000L).setDiscoveryInitialWaitTimeout(1000L).setBroadcastEndpointFactory((BroadcastEndpointFactory)endpoint);
        ConfigurationImpl configuration = this.createBasicConfig(node).setJournalMaxIO_AIO(1000).clearAcceptorConfigurations().addAcceptorConfiguration(ClusterTestBase.createTransportConfiguration((boolean)netty, (boolean)true, (Map)params)).addConnectorConfiguration(connector.getName(), connector).addBroadcastGroupConfiguration(bcConfig).addDiscoveryGroupConfiguration(dcConfig.getName(), dcConfig).setHAPolicyConfiguration((HAPolicyConfiguration)(sharedStorage ? new SharedStoreMasterPolicyConfiguration() : new ReplicatedPolicyConfiguration()));
        if (fileStorage) {
            if (sharedStorage) {
                server = this.createInVMFailoverServer(true, (Configuration)configuration, this.nodeManagers[node], node);
            } else {
                server = this.addServer(ActiveMQServers.newActiveMQServer((Configuration)configuration));
                server.setIdentity("Server " + node);
            }
        } else if (sharedStorage) {
            server = this.createInVMFailoverServer(false, (Configuration)configuration, this.nodeManagers[node], node);
        } else {
            server = this.addServer(ActiveMQServers.newActiveMQServer((Configuration)configuration, (boolean)false));
            server.setIdentity("Server " + node);
        }
        this.servers[node] = server;
    }

    protected void setupBackupServerWithDiscovery(int node, int liveNode, String groupAddress, int port, boolean fileStorage, boolean netty, boolean sharedStorage) throws Exception {
        ActiveMQServer server;
        if (this.servers[node] != null) {
            throw new IllegalArgumentException("Already a server at node " + node);
        }
        Map params = ClusterTestBase.generateParams((int)node, (boolean)netty);
        TransportConfiguration connector = ClusterTestBase.createTransportConfiguration((boolean)netty, (boolean)false, (Map)params);
        ArrayList<String> connectorPairs = new ArrayList<String>();
        connectorPairs.add(connector.getName());
        UDPBroadcastEndpointFactory endpoint = new UDPBroadcastEndpointFactory().setGroupAddress(groupAddress).setGroupPort(port);
        BroadcastGroupConfiguration bcConfig = new BroadcastGroupConfiguration().setName("bg1").setBroadcastPeriod(1000L).setConnectorInfos(connectorPairs).setEndpointFactory((BroadcastEndpointFactory)endpoint);
        DiscoveryGroupConfiguration dcConfig = new DiscoveryGroupConfiguration().setName("dg1").setRefreshTimeout(5000L).setDiscoveryInitialWaitTimeout(5000L).setBroadcastEndpointFactory((BroadcastEndpointFactory)endpoint);
        ConfigurationImpl configuration = this.createBasicConfig(sharedStorage ? liveNode : node).clearAcceptorConfigurations().addAcceptorConfiguration(ClusterTestBase.createTransportConfiguration((boolean)netty, (boolean)true, (Map)params)).addConnectorConfiguration(connector.getName(), connector).addBroadcastGroupConfiguration(bcConfig).addDiscoveryGroupConfiguration(dcConfig.getName(), dcConfig).setHAPolicyConfiguration((HAPolicyConfiguration)(sharedStorage ? new SharedStoreSlavePolicyConfiguration() : new ReplicatedPolicyConfiguration()));
        if (sharedStorage) {
            server = this.createInVMFailoverServer(fileStorage, (Configuration)configuration, this.nodeManagers[liveNode], liveNode);
        } else {
            boolean enablePersistency = fileStorage ? configuration.isPersistenceEnabled() : false;
            server = this.addServer(ActiveMQServers.newActiveMQServer((Configuration)configuration, (boolean)enablePersistency));
        }
        this.servers[node] = server;
    }

    protected void clearServer(int ... nodes) {
        for (int i = 0; i < nodes.length; ++i) {
            if (this.servers[nodes[i]] == null) {
                throw new IllegalArgumentException("No server at node " + nodes[i]);
            }
            this.servers[nodes[i]] = null;
        }
    }

    protected void clearAllServers() {
        for (int i = 0; i < this.servers.length; ++i) {
            this.servers[i] = null;
        }
    }

    protected void setupClusterConnection(String name, int nodeFrom, int nodeTo, String address, MessageLoadBalancingType messageLoadBalancingType, int maxHops, boolean netty, boolean allowDirectConnectionsOnly) {
        ActiveMQServer serverFrom = this.servers[nodeFrom];
        if (serverFrom == null) {
            throw new IllegalStateException("No server at node " + nodeFrom);
        }
        TransportConfiguration connectorFrom = ClusterTestBase.createTransportConfiguration((boolean)netty, (boolean)false, (Map)ClusterTestBase.generateParams((int)nodeFrom, (boolean)netty));
        serverFrom.getConfiguration().getConnectorConfigurations().put(name, connectorFrom);
        ArrayList<String> pairs = null;
        if (nodeTo != -1) {
            TransportConfiguration serverTotc = ClusterTestBase.createTransportConfiguration((boolean)netty, (boolean)false, (Map)ClusterTestBase.generateParams((int)nodeTo, (boolean)netty));
            serverFrom.getConfiguration().getConnectorConfigurations().put(serverTotc.getName(), serverTotc);
            pairs = new ArrayList<String>();
            pairs.add(serverTotc.getName());
        }
        Configuration config = serverFrom.getConfiguration();
        ClusterConnectionConfiguration clusterConf = new ClusterConnectionConfiguration().setName(name).setAddress(address).setConnectorName(name).setRetryInterval(100L).setMessageLoadBalancingType(messageLoadBalancingType).setMaxHops(maxHops).setConfirmationWindowSize(1024).setStaticConnectors(pairs).setAllowDirectConnectionsOnly(allowDirectConnectionsOnly);
        config.getClusterConfigurations().add(clusterConf);
    }

    protected void setupClusterConnection(String name, int nodeFrom, int nodeTo, String address, MessageLoadBalancingType messageLoadBalancingType, int maxHops, int reconnectAttempts, long retryInterval, boolean netty, boolean allowDirectConnectionsOnly) {
        ActiveMQServer serverFrom = this.servers[nodeFrom];
        if (serverFrom == null) {
            throw new IllegalStateException("No server at node " + nodeFrom);
        }
        TransportConfiguration connectorFrom = ClusterTestBase.createTransportConfiguration((boolean)netty, (boolean)false, (Map)ClusterTestBase.generateParams((int)nodeFrom, (boolean)netty));
        serverFrom.getConfiguration().getConnectorConfigurations().put(name, connectorFrom);
        ArrayList<String> pairs = null;
        if (nodeTo != -1) {
            TransportConfiguration serverTotc = ClusterTestBase.createTransportConfiguration((boolean)netty, (boolean)false, (Map)ClusterTestBase.generateParams((int)nodeTo, (boolean)netty));
            serverFrom.getConfiguration().getConnectorConfigurations().put(serverTotc.getName(), serverTotc);
            pairs = new ArrayList<String>();
            pairs.add(serverTotc.getName());
        }
        Configuration config = serverFrom.getConfiguration();
        ClusterConnectionConfiguration clusterConf = new ClusterConnectionConfiguration().setName(name).setAddress(address).setConnectorName(name).setReconnectAttempts(reconnectAttempts).setRetryInterval(retryInterval).setMessageLoadBalancingType(messageLoadBalancingType).setMaxHops(maxHops).setConfirmationWindowSize(1024).setStaticConnectors(pairs).setAllowDirectConnectionsOnly(allowDirectConnectionsOnly);
        config.getClusterConfigurations().add(clusterConf);
    }

    protected void setupClusterConnection(String name, String uri, int server) throws Exception {
        ActiveMQServer serverFrom = this.servers[server];
        if (serverFrom == null) {
            throw new IllegalStateException("No server at node " + server);
        }
        ClusterConnectionConfiguration configuration = new ClusterConnectionConfiguration(new URI(uri)).setName(name);
        serverFrom.getConfiguration().addClusterConfiguration(configuration);
    }

    protected void setupClusterConnection(String name, String address, MessageLoadBalancingType messageLoadBalancingType, int maxHops, boolean netty, int nodeFrom, int ... nodesTo) {
        this.setupClusterConnection(name, address, messageLoadBalancingType, maxHops, netty, null, nodeFrom, nodesTo);
    }

    private List<String> getClusterConnectionTCNames(boolean netty, ActiveMQServer serverFrom, int[] nodesTo) {
        ArrayList<String> pairs = new ArrayList<String>();
        for (int element : nodesTo) {
            TransportConfiguration serverTotc = ClusterTestBase.createTransportConfiguration((boolean)netty, (boolean)false, (Map)ClusterTestBase.generateParams((int)element, (boolean)netty));
            serverFrom.getConfiguration().getConnectorConfigurations().put(serverTotc.getName(), serverTotc);
            pairs.add(serverTotc.getName());
        }
        return pairs;
    }

    protected void setupClusterConnection(ClusterConnectionConfiguration clusterConf, boolean netty, int nodeFrom, int ... nodesTo) {
        ActiveMQServer serverFrom = this.servers[nodeFrom];
        if (serverFrom == null) {
            throw new IllegalStateException("No server at node " + nodeFrom);
        }
        TransportConfiguration connectorFrom = ClusterTestBase.createTransportConfiguration((boolean)netty, (boolean)false, (Map)ClusterTestBase.generateParams((int)nodeFrom, (boolean)netty));
        serverFrom.getConfiguration().getConnectorConfigurations().put(connectorFrom.getName(), connectorFrom);
        List<String> pairs = this.getClusterConnectionTCNames(netty, serverFrom, nodesTo);
        Configuration config = serverFrom.getConfiguration();
        clusterConf.setConnectorName(connectorFrom.getName()).setConfirmationWindowSize(1024).setStaticConnectors(pairs);
        config.getClusterConfigurations().add(clusterConf);
    }

    protected void setupClusterConnection(String name, String address, MessageLoadBalancingType messageLoadBalancingType, int maxHops, boolean netty, ClusterConfigCallback cb, int nodeFrom, int ... nodesTo) {
        ActiveMQServer serverFrom = this.servers[nodeFrom];
        if (serverFrom == null) {
            throw new IllegalStateException("No server at node " + nodeFrom);
        }
        TransportConfiguration connectorFrom = ClusterTestBase.createTransportConfiguration((boolean)netty, (boolean)false, (Map)ClusterTestBase.generateParams((int)nodeFrom, (boolean)netty));
        serverFrom.getConfiguration().getConnectorConfigurations().put(connectorFrom.getName(), connectorFrom);
        List<String> pairs = this.getClusterConnectionTCNames(netty, serverFrom, nodesTo);
        Configuration config = serverFrom.getConfiguration();
        ClusterConnectionConfiguration clusterConf = this.createClusterConfig(name, address, messageLoadBalancingType, maxHops, connectorFrom, pairs);
        if (cb != null) {
            cb.configure(clusterConf);
        }
        config.getClusterConfigurations().add(clusterConf);
    }

    protected void setupClusterConnection(String name, String address, MessageLoadBalancingType messageLoadBalancingType, int maxHops, int reconnectAttempts, long retryInterval, boolean netty, int nodeFrom, int ... nodesTo) {
        ActiveMQServer serverFrom = this.servers[nodeFrom];
        if (serverFrom == null) {
            throw new IllegalStateException("No server at node " + nodeFrom);
        }
        TransportConfiguration connectorFrom = ClusterTestBase.createTransportConfiguration((boolean)netty, (boolean)false, (Map)ClusterTestBase.generateParams((int)nodeFrom, (boolean)netty));
        serverFrom.getConfiguration().getConnectorConfigurations().put(connectorFrom.getName(), connectorFrom);
        List<String> pairs = this.getClusterConnectionTCNames(netty, serverFrom, nodesTo);
        Configuration config = serverFrom.getConfiguration();
        ClusterConnectionConfiguration clusterConf = new ClusterConnectionConfiguration().setName(name).setAddress(address).setConnectorName(connectorFrom.getName()).setRetryInterval(retryInterval).setReconnectAttempts(reconnectAttempts).setCallTimeout(100L).setCallFailoverTimeout(100L).setMessageLoadBalancingType(messageLoadBalancingType).setMaxHops(maxHops).setConfirmationWindowSize(1024).setStaticConnectors(pairs);
        config.getClusterConfigurations().add(clusterConf);
    }

    private ClusterConnectionConfiguration createClusterConfig(String name, String address, MessageLoadBalancingType messageLoadBalancingType, int maxHops, TransportConfiguration connectorFrom, List<String> pairs) {
        return new ClusterConnectionConfiguration().setName(name).setAddress(address).setConnectorName(connectorFrom.getName()).setRetryInterval(250L).setMessageLoadBalancingType(messageLoadBalancingType).setMaxHops(maxHops).setConfirmationWindowSize(1024).setStaticConnectors(pairs);
    }

    protected void setupClusterConnectionWithBackups(String name, String address, MessageLoadBalancingType messageLoadBalancingType, int maxHops, boolean netty, int nodeFrom, int[] nodesTo) {
        ActiveMQServer serverFrom = this.servers[nodeFrom];
        if (serverFrom == null) {
            throw new IllegalStateException("No server at node " + nodeFrom);
        }
        TransportConfiguration connectorFrom = ClusterTestBase.createTransportConfiguration((boolean)netty, (boolean)false, (Map)ClusterTestBase.generateParams((int)nodeFrom, (boolean)netty));
        serverFrom.getConfiguration().getConnectorConfigurations().put(name, connectorFrom);
        List<String> pairs = this.getClusterConnectionTCNames(netty, serverFrom, nodesTo);
        Configuration config = serverFrom.getConfiguration();
        ClusterConnectionConfiguration clusterConf = new ClusterConnectionConfiguration().setName(name).setAddress(address).setConnectorName(name).setRetryInterval(250L).setMessageLoadBalancingType(messageLoadBalancingType).setMaxHops(maxHops).setConfirmationWindowSize(1024).setStaticConnectors(pairs);
        config.getClusterConfigurations().add(clusterConf);
    }

    protected void setupDiscoveryClusterConnection(String name, int node, String discoveryGroupName, String address, MessageLoadBalancingType messageLoadBalancingType, int maxHops, boolean netty) {
        ActiveMQServer server = this.servers[node];
        if (server == null) {
            throw new IllegalStateException("No server at node " + node);
        }
        TransportConfiguration connectorConfig = ClusterTestBase.createTransportConfiguration((boolean)netty, (boolean)false, (Map)ClusterTestBase.generateParams((int)node, (boolean)netty));
        server.getConfiguration().getConnectorConfigurations().put(name, connectorConfig);
        Configuration config = server.getConfiguration();
        ClusterConnectionConfiguration clusterConf = new ClusterConnectionConfiguration().setName(name).setAddress(address).setConnectorName(name).setRetryInterval(100L).setDuplicateDetection(true).setMessageLoadBalancingType(messageLoadBalancingType).setMaxHops(maxHops).setConfirmationWindowSize(1024).setDiscoveryGroupName(discoveryGroupName);
        List clusterConfs = config.getClusterConfigurations();
        clusterConfs.add(clusterConf);
    }

    protected void startServers(int ... nodes) throws Exception {
        for (int node : nodes) {
            boolean waitForPrevious;
            log.debug((Object)("#test start node " + node));
            long currentTime = System.currentTimeMillis();
            boolean waitForSelf = currentTime - this.timeStarts[node] < 10L;
            boolean bl = waitForPrevious = node > 0 && currentTime - this.timeStarts[node - 1] < 10L;
            if (waitForPrevious || waitForSelf) {
                Thread.sleep(10L);
            }
            this.timeStarts[node] = System.currentTimeMillis();
            log.debug((Object)("starting server " + this.servers[node]));
            this.servers[node].start();
            log.debug((Object)("started server " + this.servers[node]));
            this.waitForServerToStart(this.servers[node]);
            if (this.servers[node].getStorageManager() == null || !this.isForceUniqueStorageManagerIds()) continue;
            for (int i = 0; i < node * 1000; ++i) {
                this.servers[node].getStorageManager().generateID();
            }
        }
    }

    protected void stopClusterConnections(int ... nodes) throws Exception {
        for (int node : nodes) {
            if (!this.servers[node].isStarted()) continue;
            for (ClusterConnection cc : this.servers[node].getClusterManager().getClusterConnections()) {
                cc.stop();
                cc.flushExecutor();
            }
        }
    }

    protected void stopServers(int ... nodes) throws Exception {
        log.debug((Object)("Stopping nodes " + Arrays.toString(nodes)));
        Exception exception = null;
        for (int node : nodes) {
            if (this.servers[node] == null || !this.servers[node].isStarted()) continue;
            try {
                if (System.currentTimeMillis() - this.timeStarts[node] < 10L) {
                    Thread.sleep(10L);
                }
                this.timeStarts[node] = System.currentTimeMillis();
                log.debug((Object)("stopping server " + node));
                this.servers[node].stop();
                log.debug((Object)("server " + node + " stopped"));
            }
            catch (Exception e) {
                exception = e;
            }
        }
        if (exception != null) {
            throw exception;
        }
    }

    protected boolean isFileStorage() {
        return true;
    }

    protected String getServerUri(int node) throws URISyntaxException {
        ActiveMQServer server = this.servers[node];
        if (server == null) {
            throw new IllegalStateException("No server at node " + server);
        }
        int port = 61616 + node;
        return "tcp://localhost:" + port;
    }

    public static interface ClusterConfigCallback {
        public void configure(ClusterConnectionConfiguration var1);
    }

    class OrderedConsumerHolder
    implements Comparable<OrderedConsumerHolder> {
        ConsumerHolder consumer;
        int order;

        OrderedConsumerHolder() {
        }

        @Override
        public int compareTo(OrderedConsumerHolder o) {
            int thisOrder = this.order;
            int otherOrder = o.order;
            return Integer.compare(thisOrder, otherOrder);
        }
    }

    protected static class ConsumerHolder {
        final ClientConsumer consumer;
        final ClientSession session;
        final int id;
        final int node;

        public ClientConsumer getConsumer() {
            return this.consumer;
        }

        public ClientSession getSession() {
            return this.session;
        }

        public int getId() {
            return this.id;
        }

        public int getNode() {
            return this.node;
        }

        ConsumerHolder(int id, ClientConsumer consumer, ClientSession session, int node) {
            this.id = id;
            this.node = node;
            this.consumer = consumer;
            this.session = session;
        }

        void close() {
            if (this.consumer != null) {
                try {
                    this.consumer.close();
                }
                catch (ActiveMQException activeMQException) {
                    // empty catch block
                }
            }
            if (this.session != null) {
                try {
                    this.session.close();
                }
                catch (ActiveMQException activeMQException) {
                    // empty catch block
                }
            }
        }

        public String toString() {
            return "id=" + this.id + ", consumer=" + this.consumer + ", session=" + this.session;
        }
    }

    public static enum HAType {
        SharedStore,
        SharedNothingReplication,
        PluggableQuorumReplication;

    }
}

