/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.server;

import java.util.Arrays;
import java.util.Collection;
import org.apache.activemq.artemis.api.core.Message;
import org.apache.activemq.artemis.api.core.QueueConfiguration;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.api.core.client.ClientConsumer;
import org.apache.activemq.artemis.api.core.client.ClientMessage;
import org.apache.activemq.artemis.api.core.client.ClientProducer;
import org.apache.activemq.artemis.api.core.client.ClientSession;
import org.apache.activemq.artemis.api.core.client.ClientSessionFactory;
import org.apache.activemq.artemis.core.persistence.impl.journal.BatchingIDGenerator;
import org.apache.activemq.artemis.core.persistence.impl.journal.JournalStorageManager;
import org.apache.activemq.artemis.core.postoffice.impl.LocalQueueBinding;
import org.apache.activemq.artemis.core.server.impl.ScaleDownHandler;
import org.apache.activemq.artemis.core.settings.impl.AddressSettings;
import org.apache.activemq.artemis.tests.integration.cluster.distribution.ClusterTestBase;
import org.apache.activemq.artemis.tests.util.Wait;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class ScaleDownDirectTest
extends ClusterTestBase {
    private final boolean isNetty;

    @Parameterized.Parameters(name="isNetty={0}")
    public static Collection getParameters() {
        return Arrays.asList({false}, {true});
    }

    public ScaleDownDirectTest(boolean isNetty) {
        this.isNetty = isNetty;
    }

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.setupLiveServer(0, this.isFileStorage(), this.isNetty, true);
        this.setupLiveServer(1, this.isFileStorage(), this.isNetty, true);
        this.startServers(0, 1);
        this.setupSessionFactory(0, this.isNetty);
        this.setupSessionFactory(1, this.isNetty);
    }

    @Test
    public void testSendMixedSmallMessages() throws Exception {
        this.internalTest(100, 100);
    }

    @Test
    public void testSendMixedLargelMessages() throws Exception {
        this.internalTest(204800, 100);
    }

    protected void internalTest(int bufferSize, int numberOfMessages) throws Exception {
        ClientMessage message;
        int i;
        ClientSessionFactory sf = this.sfs[0];
        ClientSession session = sf.createSession(true, true);
        session.createQueue(new QueueConfiguration("queue1").setAddress("ad1"));
        ClientProducer producer = session.createProducer("ad1");
        byte[] buffer = new byte[bufferSize];
        for (i = 0; i < bufferSize; ++i) {
            buffer[i] = ScaleDownDirectTest.getSamplebyte((long)i);
        }
        for (i = 0; i < numberOfMessages; ++i) {
            message = session.createMessage(true);
            message.putIntProperty("i", i);
            message.getBodyBuffer().writeBytes(buffer);
            producer.send((Message)message);
        }
        session.createQueue(new QueueConfiguration("queue2").setAddress("ad1"));
        for (i = numberOfMessages; i < numberOfMessages * 2; ++i) {
            message = session.createMessage(true);
            message.putIntProperty("i", i);
            message.getBodyBuffer().writeBytes(buffer);
            producer.send((Message)message);
        }
        ScaleDownDirectTest.assertEquals((long)(numberOfMessages * 2), (long)this.performScaledown());
        this.sfs[0].close();
        session.close();
        this.stopServers(0);
        session = this.sfs[1].createSession(true, true);
        ClientConsumer consumer1 = session.createConsumer("queue1");
        session.start();
        for (int i2 = 0; i2 < numberOfMessages * 2; ++i2) {
            ClientMessage message2 = consumer1.receive(5000L);
            ScaleDownDirectTest.assertNotNull((Object)message2);
            ScaleDownDirectTest.assertEquals((long)i2, (long)message2.getIntProperty("i").intValue());
            this.checkBody(message2, bufferSize);
        }
        ClientMessage messageCheckNull = consumer1.receiveImmediate();
        ScaleDownDirectTest.assertNull((Object)messageCheckNull);
        ClientConsumer consumer2 = session.createConsumer("queue2");
        for (int i3 = numberOfMessages; i3 < numberOfMessages * 2; ++i3) {
            ClientMessage message3 = consumer2.receive(5000L);
            ScaleDownDirectTest.assertNotNull((Object)message3);
            ScaleDownDirectTest.assertEquals((long)i3, (long)message3.getIntProperty("i").intValue());
            this.checkBody(message3, bufferSize);
        }
        messageCheckNull = consumer2.receiveImmediate();
        ScaleDownDirectTest.assertNull((Object)messageCheckNull);
    }

    @Test
    public void testPaging() throws Exception {
        ClientMessage message;
        int i;
        int CHUNK_SIZE = 50;
        int messageCount = 0;
        String addressName = "testAddress";
        String queueName = "testQueue";
        this.createQueue(0, "testAddress", "testQueue", null, true);
        this.createQueue(1, "testAddress", "testQueue", null, true);
        ClientSessionFactory sf = this.sfs[0];
        ClientSession session = this.addClientSession(sf.createSession(false, false));
        ClientProducer producer = this.addClientProducer(session.createProducer("testAddress"));
        AddressSettings defaultSetting = new AddressSettings().setPageSizeBytes(10240).setMaxSizeBytes(20480L);
        this.servers[0].getAddressSettingsRepository().addMatch("#", (Object)defaultSetting);
        while (!this.servers[0].getPagingManager().getPageStore(new SimpleString("testAddress")).isPaging()) {
            for (i = 0; i < 50; ++i) {
                message = session.createMessage(true);
                message.getBodyBuffer().writeBytes(new byte[1024]);
                producer.send((Message)message);
                ++messageCount;
            }
            session.commit();
        }
        ScaleDownDirectTest.assertEquals((long)messageCount, (long)this.performScaledown());
        this.servers[0].stop();
        this.addConsumer(0, 1, "testQueue", null);
        for (i = 0; i < messageCount; ++i) {
            message = this.consumers[0].getConsumer().receive(500L);
            Assert.assertNotNull((Object)message);
        }
        Assert.assertNull((Object)this.consumers[0].getConsumer().receiveImmediate());
        this.removeConsumer(0);
    }

    @Test
    public void testBasicScaleDown() throws Exception {
        int TEST_SIZE = 2;
        String addressName = "testAddress";
        String queueName1 = "testQueue1";
        String queueName2 = "testQueue2";
        this.createQueue(0, "testAddress", "testQueue1", null, true);
        this.createQueue(0, "testAddress", "testQueue2", null, true);
        this.createQueue(1, "testAddress", "testQueue1", null, true);
        this.createQueue(1, "testAddress", "testQueue2", null, true);
        this.send(0, "testAddress", 2, true, null);
        this.addConsumer(1, 0, "testQueue2", null, false);
        ClientMessage clientMessage = this.consumers[1].getConsumer().receive(250L);
        Assert.assertNotNull((Object)clientMessage);
        clientMessage.acknowledge();
        this.consumers[1].getSession().commit();
        this.removeConsumer(1);
        Wait.assertEquals((int)2, () -> this.getMessageCount(((LocalQueueBinding)this.servers[0].getPostOffice().getBinding(new SimpleString("testQueue1"))).getQueue()));
        Wait.assertEquals((int)1, () -> this.getMessageCount(((LocalQueueBinding)this.servers[0].getPostOffice().getBinding(new SimpleString("testQueue2"))).getQueue()));
        ScaleDownDirectTest.assertEquals((long)2L, (long)this.performScaledown());
        this.servers[0].stop();
        this.addConsumer(0, 1, "testQueue1", null);
        clientMessage = this.consumers[0].getConsumer().receive(250L);
        Assert.assertNotNull((Object)clientMessage);
        clientMessage.acknowledge();
        clientMessage = this.consumers[0].getConsumer().receive(250L);
        Assert.assertNotNull((Object)clientMessage);
        clientMessage.acknowledge();
        clientMessage = this.consumers[0].getConsumer().receive(250L);
        Assert.assertNull((Object)clientMessage);
        this.removeConsumer(0);
        this.addConsumer(0, 1, "testQueue2", null);
        clientMessage = this.consumers[0].getConsumer().receive(250L);
        Assert.assertNotNull((Object)clientMessage);
        clientMessage.acknowledge();
        clientMessage = this.consumers[0].getConsumer().receive(250L);
        Assert.assertNull((Object)clientMessage);
        this.removeConsumer(0);
    }

    @Test
    public void testTemporaryQueues() throws Exception {
        String addressName1 = "testAddress1";
        String addressName2 = "testAddress2";
        String queueName1 = "testQueue1";
        String queueName2 = "testQueue2";
        String queueName3 = "testQueue3";
        ClientSessionFactory sf = this.sfs[0];
        ClientSession session = sf.createSession(true, true);
        session.createQueue(new QueueConfiguration("testQueue1").setAddress("testAddress1").setDurable(Boolean.valueOf(false)).setTemporary(Boolean.valueOf(true)));
        session.createQueue(new QueueConfiguration("testQueue2").setAddress("testAddress2"));
        session.createQueue(new QueueConfiguration("testQueue3").setAddress("testAddress2").setDurable(Boolean.valueOf(false)).setTemporary(Boolean.valueOf(true)));
        ClientProducer producer1 = session.createProducer("testAddress1");
        producer1.send((Message)session.createMessage(true));
        ClientProducer producer2 = session.createProducer("testAddress2");
        producer2.send((Message)session.createMessage(true));
        Wait.assertEquals((int)1, () -> this.getMessageCount(((LocalQueueBinding)this.servers[0].getPostOffice().getBinding(new SimpleString("testQueue1"))).getQueue()));
        Wait.assertEquals((int)1, () -> this.getMessageCount(((LocalQueueBinding)this.servers[0].getPostOffice().getBinding(new SimpleString("testQueue2"))).getQueue()));
        Wait.assertEquals((int)1, () -> this.getMessageCount(((LocalQueueBinding)this.servers[0].getPostOffice().getBinding(new SimpleString("testQueue3"))).getQueue()));
        ScaleDownDirectTest.assertEquals((long)1L, (long)this.performScaledown());
        this.sfs[0].close();
        session.close();
        this.servers[0].stop();
        Assert.assertNull((Object)this.servers[1].getPostOffice().getBinding(new SimpleString("testQueue1")));
        Assert.assertEquals((long)1L, (long)this.getMessageCount(((LocalQueueBinding)this.servers[1].getPostOffice().getBinding(new SimpleString("testQueue2"))).getQueue()));
        Assert.assertNull((Object)this.servers[1].getPostOffice().getBinding(new SimpleString("testQueue3")));
    }

    @Test
    public void testScaleDownWithBigQueueID() throws Exception {
        int TEST_SIZE = 2;
        String addressName = "testAddress";
        String queueName1 = "testQueue1";
        JournalStorageManager manager = (JournalStorageManager)this.servers[0].getStorageManager();
        BatchingIDGenerator idGenerator = (BatchingIDGenerator)manager.getIDGenerator();
        idGenerator.forceNextID(2147483747L);
        long nextId = idGenerator.generateID();
        ScaleDownDirectTest.assertTrue((nextId > Integer.MAX_VALUE ? 1 : 0) != 0);
        manager = (JournalStorageManager)this.servers[1].getStorageManager();
        idGenerator = (BatchingIDGenerator)manager.getIDGenerator();
        idGenerator.forceNextID(2147483847L);
        nextId = idGenerator.generateID();
        ScaleDownDirectTest.assertTrue((nextId > Integer.MAX_VALUE ? 1 : 0) != 0);
        this.createQueue(0, "testAddress", "testQueue1", null, true);
        this.createQueue(1, "testAddress", "testQueue1", null, true);
        this.send(0, "testAddress", 2, true, null);
        Wait.assertEquals((int)2, () -> this.getMessageCount(((LocalQueueBinding)this.servers[0].getPostOffice().getBinding(new SimpleString("testQueue1"))).getQueue()));
        ScaleDownDirectTest.assertEquals((long)2L, (long)this.performScaledown());
        this.servers[0].stop();
        this.addConsumer(0, 1, "testQueue1", null);
        ClientMessage clientMessage = this.consumers[0].getConsumer().receive(250L);
        Assert.assertNotNull((Object)clientMessage);
        clientMessage.acknowledge();
        clientMessage = this.consumers[0].getConsumer().receive(250L);
        Assert.assertNotNull((Object)clientMessage);
        clientMessage.acknowledge();
        clientMessage = this.consumers[0].getConsumer().receive(250L);
        Assert.assertNull((Object)clientMessage);
        this.removeConsumer(0);
    }

    private void checkBody(ClientMessage message, int bufferSize) {
        ScaleDownDirectTest.assertEquals((long)bufferSize, (long)message.getBodySize());
        byte[] body = new byte[message.getBodySize()];
        message.getBodyBuffer().readBytes(body);
        for (int bpos = 0; bpos < bufferSize; ++bpos) {
            if (ScaleDownDirectTest.getSamplebyte((long)bpos) == body[bpos]) continue;
            ScaleDownDirectTest.fail((String)("body comparison failure at " + message));
        }
    }

    private long performScaledown() throws Exception {
        ScaleDownHandler handler = new ScaleDownHandler(this.servers[0].getPagingManager(), this.servers[0].getPostOffice(), this.servers[0].getNodeManager(), this.servers[0].getClusterManager().getClusterController(), this.servers[0].getStorageManager());
        return handler.scaleDownMessages(this.sfs[1], this.servers[1].getNodeID(), this.servers[0].getConfiguration().getClusterUser(), this.servers[0].getConfiguration().getClusterPassword());
    }
}

