/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.server;

import java.lang.reflect.Field;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.activemq.artemis.core.config.Configuration;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.core.server.ServiceRegistry;
import org.apache.activemq.artemis.core.server.impl.ActiveMQServerImpl;
import org.apache.activemq.artemis.core.server.impl.ServiceRegistryImpl;
import org.apache.activemq.artemis.tests.util.ActiveMQTestBase;
import org.apache.activemq.artemis.utils.ActiveMQThreadFactory;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;

public class SuppliedThreadPoolTest
extends ActiveMQTestBase {
    private ActiveMQServer server;
    private ServiceRegistry serviceRegistry;

    @Before
    public void setup() throws Exception {
        this.serviceRegistry = new ServiceRegistryImpl();
        this.serviceRegistry.setExecutorService(Executors.newFixedThreadPool(1, (ThreadFactory)ActiveMQThreadFactory.defaultThreadFactory()));
        this.serviceRegistry.setIOExecutorService(Executors.newFixedThreadPool(5, (ThreadFactory)ActiveMQThreadFactory.defaultThreadFactory()));
        this.serviceRegistry.setScheduledExecutorService(Executors.newScheduledThreadPool(1, (ThreadFactory)ActiveMQThreadFactory.defaultThreadFactory()));
        this.server = new ActiveMQServerImpl((Configuration)this.createBasicConfig(), null, null, null, this.serviceRegistry);
        this.server.start();
        this.server.waitForActivation(100L, TimeUnit.MILLISECONDS);
    }

    @After
    public void tearDown() throws Exception {
        if (this.server.isActive()) {
            this.server.stop();
        }
        this.serviceRegistry.getExecutorService().shutdown();
        this.serviceRegistry.getScheduledExecutorService().shutdown();
        this.serviceRegistry.getIOExecutorService().shutdown();
        super.tearDown();
    }

    @Test
    public void testSuppliedThreadPoolsAreCorrectlySet() throws Exception {
        SuppliedThreadPoolTest.assertEquals((Object)this.serviceRegistry.getScheduledExecutorService(), (Object)this.server.getScheduledPool());
        Field field = this.server.getExecutorFactory().getClass().getDeclaredField("parent");
        field.setAccessible(true);
        SuppliedThreadPoolTest.assertEquals((Object)this.serviceRegistry.getExecutorService(), (Object)field.get(this.server.getExecutorFactory()));
    }

    @Test
    public void testServerDoesNotShutdownSuppliedThreadPoolsOnStop() throws Exception {
        this.server.stop();
        ScheduledExecutorService scheduledExecutorService = this.server.getScheduledPool();
        Field field = this.server.getExecutorFactory().getClass().getDeclaredField("parent");
        field.setAccessible(true);
        ExecutorService threadPool = (ExecutorService)field.get(this.server.getExecutorFactory());
        SuppliedThreadPoolTest.assertNotNull((Object)threadPool);
        SuppliedThreadPoolTest.assertNotNull((Object)scheduledExecutorService);
        SuppliedThreadPoolTest.assertFalse((boolean)threadPool.isShutdown());
        SuppliedThreadPoolTest.assertFalse((boolean)scheduledExecutorService.isShutdown());
    }

    @Test
    public void testCanRestartWithSuppliedThreadPool() throws Exception {
        this.server.stop();
        this.server.start();
        this.server.waitForActivation(100L, TimeUnit.MILLISECONDS);
        this.testSuppliedThreadPoolsAreCorrectlySet();
    }

    @Test
    public void testJobsGetScheduledToSuppliedThreadPool() throws Exception {
        this.server.stop();
        ScheduledThreadPoolExecutor scheduledExecutorService = (ScheduledThreadPoolExecutor)this.server.getScheduledPool();
        Field field = this.server.getExecutorFactory().getClass().getDeclaredField("parent");
        field.setAccessible(true);
        ThreadPoolExecutor threadPool = (ThreadPoolExecutor)field.get(this.server.getExecutorFactory());
        SuppliedThreadPoolTest.assertTrue((threadPool.getCompletedTaskCount() > 0L ? 1 : 0) != 0);
        SuppliedThreadPoolTest.assertTrue((scheduledExecutorService.getTaskCount() > 0L ? 1 : 0) != 0);
    }
}

