/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.messaging.activemq;

import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.jboss.as.controller.AbstractRemoveStepHandler;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.wildfly.extension.messaging.activemq.MessagingServices;

class AddressSettingRemove
extends AbstractRemoveStepHandler {
    static final OperationStepHandler INSTANCE = new AddressSettingRemove();

    AddressSettingRemove() {
    }

    protected void performRuntime(OperationContext context, ModelNode operation, ModelNode model) throws OperationFailedException {
        ActiveMQServer server = AddressSettingRemove.getServer(context, operation);
        if (server != null) {
            PathAddress address = PathAddress.pathAddress((ModelNode)operation.require("address"));
            server.getAddressSettingsRepository().removeMatch(address.getLastElement().getValue());
        }
    }

    static ActiveMQServer getServer(OperationContext context, ModelNode operation) {
        ServiceName serviceName = MessagingServices.getActiveMQServiceName(PathAddress.pathAddress((ModelNode)operation.get("address")));
        ServiceController controller = context.getServiceRegistry(true).getService(serviceName);
        if (controller != null) {
            return (ActiveMQServer)ActiveMQServer.class.cast(controller.getValue());
        }
        return null;
    }
}

