/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.server.deployment.module;

import java.nio.ByteBuffer;
import java.security.ProtectionDomain;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.jboss.as.server.deployment.AttachmentKey;
import org.jboss.modules.ClassTransformer;

public class DelegatingClassTransformer
implements ClassTransformer {
    private final List<ClassTransformer> delegateTransformers = new CopyOnWriteArrayList<ClassTransformer>();
    public static final AttachmentKey<DelegatingClassTransformer> ATTACHMENT_KEY = AttachmentKey.create(DelegatingClassTransformer.class);
    private volatile boolean active = false;

    public void addTransformer(ClassTransformer classTransformer) {
        this.delegateTransformers.add(classTransformer);
    }

    public void setActive(boolean active) {
        this.active = active;
    }

    public ByteBuffer transform(ClassLoader loader, String className, ProtectionDomain protectionDomain, ByteBuffer originalBuffer) throws IllegalArgumentException {
        ByteBuffer transformedBuffer = originalBuffer;
        if (this.active) {
            for (ClassTransformer transformer : this.delegateTransformers) {
                ByteBuffer result = transformer.transform(loader, className, protectionDomain, transformedBuffer);
                if (result == null) continue;
                transformedBuffer = result;
            }
        }
        return transformedBuffer;
    }
}

