/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.concurrent;

import java.security.AccessController;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.jboss.resteasy.concurrent.ContextualExecutorService;
import org.jboss.resteasy.concurrent.ContextualScheduledExecutorService;
import org.jboss.resteasy.resteasy_jaxrs.i18n.LogMessages;
import org.jboss.resteasy.spi.ResteasyProviderFactory;
import org.jboss.resteasy.spi.concurrent.ThreadContext;
import org.jboss.resteasy.spi.concurrent.ThreadContexts;
import org.jboss.resteasy.spi.config.ConfigurationFactory;

public class ContextualExecutors {
    private static final String EXECUTOR_SERVICE_JNDI = "java:comp/DefaultManagedExecutorService";
    private static final String SCHEDULED_EXECUTOR_SERVICE_JNDI = "java:comp/DefaultManagedScheduledExecutorService";
    private static final Map<String, Boolean> JNDI_LOOKUPS = new ConcurrentHashMap<String, Boolean>();

    public static Executor executor() {
        Map<ThreadContext<Object>, Object> contexts = ContextualExecutors.getContexts();
        return task -> ContextualExecutors.runnable(contexts, task).run();
    }

    public static ContextualExecutorService threadPool() {
        Object delegate = ContextualExecutors.lookup(EXECUTOR_SERVICE_JNDI);
        boolean managed = true;
        if (delegate == null) {
            delegate = Executors.newCachedThreadPool(new ContextualThreadFactory("contextual-pool"));
            managed = false;
        }
        return ContextualExecutors.wrap(delegate, managed);
    }

    public static ContextualScheduledExecutorService scheduledThreadPool() {
        int poolSize = ContextualExecutors.getConfigValue("resteasy.async.timeout.scheduler.min.pool.size", Integer.class, () -> 1);
        return ContextualExecutors.scheduledThreadPool(poolSize, new ContextualThreadFactory("contextual-scheduled-pool"));
    }

    public static ContextualScheduledExecutorService scheduledThreadPool(int poolSize, ThreadFactory threadFactory) {
        ScheduledExecutorService delegate = (ScheduledExecutorService)ContextualExecutors.lookup(SCHEDULED_EXECUTOR_SERVICE_JNDI);
        boolean managed = true;
        if (delegate == null) {
            delegate = Executors.newScheduledThreadPool(poolSize, threadFactory);
            managed = false;
        }
        return ContextualExecutors.wrap(delegate, managed);
    }

    public static ContextualExecutorService wrap(ExecutorService delegate) {
        return ContextualExecutors.wrap(delegate, true);
    }

    public static ContextualExecutorService wrap(ExecutorService delegate, boolean managed) {
        if (delegate == null) {
            return null;
        }
        if (delegate instanceof ScheduledExecutorService) {
            return ContextualExecutors.wrap((ScheduledExecutorService)delegate, managed);
        }
        if (delegate instanceof ContextualExecutorService && managed == ((ContextualExecutorService)delegate).isManaged()) {
            if (managed == ((ContextualExecutorService)delegate).isManaged()) {
                return (ContextualExecutorService)delegate;
            }
            return new ContextualExecutorService(((ContextualExecutorService)delegate).getDelegate(), managed);
        }
        return new ContextualExecutorService(delegate, managed);
    }

    public static ContextualScheduledExecutorService wrap(ScheduledExecutorService delegate) {
        return ContextualExecutors.wrap(delegate, true);
    }

    public static ContextualScheduledExecutorService wrap(ScheduledExecutorService delegate, boolean managed) {
        if (delegate == null) {
            return null;
        }
        if (delegate instanceof ContextualScheduledExecutorService && managed == ((ContextualScheduledExecutorService)delegate).isManaged()) {
            if (managed == ((ContextualScheduledExecutorService)delegate).isManaged()) {
                return (ContextualScheduledExecutorService)delegate;
            }
            return new ContextualScheduledExecutorService(((ContextualScheduledExecutorService)delegate).getDelegate(), managed);
        }
        return new ContextualScheduledExecutorService(delegate, managed);
    }

    public static ContextualScheduledExecutorService wrapOrLookup(ScheduledExecutorService delegate) {
        if (delegate != null) {
            return ContextualExecutors.wrap(delegate, true);
        }
        ScheduledExecutorService found = (ScheduledExecutorService)ContextualExecutors.lookup(SCHEDULED_EXECUTOR_SERVICE_JNDI);
        return found == null ? null : ContextualExecutors.wrap(found, true);
    }

    public static Runnable runnable(Runnable task) {
        return ContextualExecutors.runnable(ContextualExecutors.getContexts(), task);
    }

    public static <V> Callable<V> callable(Callable<V> task) {
        Map<ThreadContext<Object>, Object> contexts = ContextualExecutors.getContexts();
        return () -> {
            try {
                for (Map.Entry entry : contexts.entrySet()) {
                    ((ThreadContext)entry.getKey()).push(entry.getValue());
                }
                Iterator iterator = task.call();
                return iterator;
            }
            finally {
                ContextualExecutors.reset(contexts);
            }
        };
    }

    public static <T> Collection<? extends Callable<T>> callable(Collection<? extends Callable<T>> tasks) {
        return tasks.stream().map(ContextualExecutors::callable).collect(Collectors.toList());
    }

    private static Runnable runnable(Map<ThreadContext<Object>, Object> contexts, Runnable task) {
        return () -> {
            try {
                for (Map.Entry entry : contexts.entrySet()) {
                    ((ThreadContext)entry.getKey()).push(entry.getValue());
                }
                task.run();
            }
            finally {
                ContextualExecutors.reset(contexts);
            }
        };
    }

    private static Map<ThreadContext<Object>, Object> getContexts() {
        LinkedHashMap<ThreadContext<Object>, Object> contexts = new LinkedHashMap<ThreadContext<Object>, Object>();
        ThreadContexts threadContexts = ResteasyProviderFactory.getInstance().getContextData(ThreadContexts.class);
        if (threadContexts == null) {
            threadContexts = new ThreadContexts();
        }
        for (ThreadContext<Object> context : threadContexts.getThreadContexts()) {
            contexts.put(context, context.capture());
        }
        return contexts;
    }

    private static void reset(Map<ThreadContext<Object>, Object> contexts) {
        Throwable error = null;
        for (Map.Entry<ThreadContext<Object>, Object> context : contexts.entrySet()) {
            try {
                context.getKey().reset(context.getValue());
            }
            catch (Throwable t) {
                if (error == null) {
                    error = t;
                    continue;
                }
                error.addSuppressed(t);
            }
        }
        if (error != null) {
            LogMessages.LOGGER.unableToResetThreadContext(error, Thread.currentThread().getName());
        }
    }

    private static <T extends ExecutorService> T lookup(String jndiName) {
        block8: {
            Boolean performLookup = JNDI_LOOKUPS.get(jndiName);
            if (performLookup != null && performLookup.booleanValue()) {
                try {
                    return (T)((ExecutorService)InitialContext.doLookup(jndiName));
                }
                catch (NamingException namingException) {
                    break block8;
                }
                catch (Exception e) {
                    LogMessages.LOGGER.failedToLookupManagedExecutorService(e, jndiName);
                    break block8;
                }
            }
            if (performLookup == null) {
                try {
                    ExecutorService service = (ExecutorService)InitialContext.doLookup(jndiName);
                    JNDI_LOOKUPS.put(jndiName, Boolean.TRUE);
                    return (T)service;
                }
                catch (NamingException service) {
                }
                catch (Exception e) {
                    LogMessages.LOGGER.failedToLookupManagedExecutorService(e, jndiName);
                }
                JNDI_LOOKUPS.put(jndiName, Boolean.FALSE);
            }
        }
        return null;
    }

    private static <T> T getConfigValue(String name, Class<T> type, Supplier<T> dft) {
        if (System.getSecurityManager() == null) {
            return ConfigurationFactory.getInstance().getConfiguration().getOptionalValue(name, type).orElseGet(dft);
        }
        return (T)AccessController.doPrivileged(() -> ConfigurationFactory.getInstance().getConfiguration().getOptionalValue(name, type).orElseGet(dft));
    }

    private static class ContextualThreadFactory
    implements ThreadFactory {
        private static final AtomicInteger POOL_COUNTER = new AtomicInteger(0);
        private final AtomicInteger threadCounter = new AtomicInteger(0);
        private final String prefix;

        private ContextualThreadFactory(String prefix) {
            this.prefix = prefix;
        }

        @Override
        public Thread newThread(Runnable r) {
            Thread thread = new Thread(r, String.format("%s-%d-thread-%d", this.prefix, POOL_COUNTER.incrementAndGet(), this.threadCounter.incrementAndGet()));
            if (System.getSecurityManager() == null) {
                thread.setDaemon(true);
                thread.setPriority(5);
                return thread;
            }
            return AccessController.doPrivileged(() -> {
                thread.setDaemon(true);
                thread.setPriority(5);
                return thread;
            });
        }
    }
}

