/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.messaging.activemq;

import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.jboss.as.controller.AbstractRemoveStepHandler;
import org.jboss.as.controller.OperationContext;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.wildfly.extension.messaging.activemq.MessagingServices;
import org.wildfly.extension.messaging.activemq.logging.MessagingLogger;

class QueueRemove
extends AbstractRemoveStepHandler {
    static final QueueRemove INSTANCE = new QueueRemove();

    private QueueRemove() {
    }

    protected void performRuntime(OperationContext context, ModelNode operation, ModelNode model) {
        ServiceName serviceName = MessagingServices.getActiveMQServiceName(context.getCurrentAddress());
        String name = context.getCurrentAddressValue();
        ServiceName queueServiceName = MessagingServices.getQueueBaseServiceName(serviceName).append(new String[]{name});
        if (context.getServiceRegistry(false).getService(queueServiceName) != null) {
            context.removeService(queueServiceName);
        } else {
            ServiceController serverService = context.getServiceRegistry(false).getService(serviceName);
            try {
                ((ActiveMQServer)serverService.getValue()).destroyQueue(new SimpleString(name), null, false);
            }
            catch (Exception ex) {
                MessagingLogger.ROOT_LOGGER.failedToDestroy("queue", name);
            }
        }
    }

    protected void recoverServices(OperationContext context, ModelNode operation, ModelNode model) {
    }
}

