/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.metamodel.internal;

import jakarta.persistence.ManyToMany;
import jakarta.persistence.OneToOne;
import jakarta.persistence.metamodel.Type;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import org.hibernate.AssertionFailure;
import org.hibernate.PropertyNotFoundException;
import org.hibernate.boot.model.convert.spi.ConverterDescriptor;
import org.hibernate.internal.EntityManagerMessageLogger;
import org.hibernate.internal.HEMLogging;
import org.hibernate.mapping.Any;
import org.hibernate.mapping.Collection;
import org.hibernate.mapping.Component;
import org.hibernate.mapping.List;
import org.hibernate.mapping.Map;
import org.hibernate.mapping.OneToMany;
import org.hibernate.mapping.PersistentClass;
import org.hibernate.mapping.Property;
import org.hibernate.mapping.SimpleValue;
import org.hibernate.mapping.Value;
import org.hibernate.metamodel.AttributeClassification;
import org.hibernate.metamodel.RepresentationMode;
import org.hibernate.metamodel.UnsupportedMappingException;
import org.hibernate.metamodel.ValueClassification;
import org.hibernate.metamodel.internal.AttributeContext;
import org.hibernate.metamodel.internal.AttributeMetadata;
import org.hibernate.metamodel.internal.MemberResolver;
import org.hibernate.metamodel.internal.MetadataContext;
import org.hibernate.metamodel.internal.PluralAttributeMetadata;
import org.hibernate.metamodel.internal.PluralAttributeMetadataImpl;
import org.hibernate.metamodel.internal.SingularAttributeMetadata;
import org.hibernate.metamodel.internal.SingularAttributeMetadataImpl;
import org.hibernate.metamodel.internal.ValueContext;
import org.hibernate.metamodel.mapping.AttributeMapping;
import org.hibernate.metamodel.mapping.CompositeIdentifierMapping;
import org.hibernate.metamodel.mapping.EmbeddableMappingType;
import org.hibernate.metamodel.mapping.EmbeddableValuedModelPart;
import org.hibernate.metamodel.mapping.EntityIdentifierMapping;
import org.hibernate.metamodel.mapping.EntityVersionMapping;
import org.hibernate.metamodel.model.domain.AbstractIdentifiableType;
import org.hibernate.metamodel.model.domain.DomainType;
import org.hibernate.metamodel.model.domain.EmbeddableDomainType;
import org.hibernate.metamodel.model.domain.EntityDomainType;
import org.hibernate.metamodel.model.domain.IdentifiableDomainType;
import org.hibernate.metamodel.model.domain.ManagedDomainType;
import org.hibernate.metamodel.model.domain.PersistentAttribute;
import org.hibernate.metamodel.model.domain.SimpleDomainType;
import org.hibernate.metamodel.model.domain.SingularPersistentAttribute;
import org.hibernate.metamodel.model.domain.internal.AnyMappingDomainTypeImpl;
import org.hibernate.metamodel.model.domain.internal.AttributeContainer;
import org.hibernate.metamodel.model.domain.internal.EmbeddableTypeImpl;
import org.hibernate.metamodel.model.domain.internal.EntityTypeImpl;
import org.hibernate.metamodel.model.domain.internal.MapMember;
import org.hibernate.metamodel.model.domain.internal.MappedSuperclassTypeImpl;
import org.hibernate.metamodel.model.domain.internal.PluralAttributeBuilder;
import org.hibernate.metamodel.model.domain.internal.SingularAttributeImpl;
import org.hibernate.metamodel.spi.EmbeddableRepresentationStrategy;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.property.access.internal.PropertyAccessMapImpl;
import org.hibernate.property.access.spi.Getter;
import org.hibernate.type.AnyType;
import org.hibernate.type.EntityType;
import org.hibernate.type.Type;
import org.hibernate.type.descriptor.java.JavaType;
import org.hibernate.type.descriptor.java.spi.JavaTypeRegistry;
import org.hibernate.type.spi.CompositeTypeImplementor;

public class AttributeFactory {
    private static final EntityManagerMessageLogger LOG = HEMLogging.messageLogger(AttributeFactory.class);
    private final MetadataContext context;
    private static final MemberResolver embeddedMemberResolver = (attributeContext, metadataContext) -> {
        EmbeddableDomainType ownerType = (EmbeddableDomainType)attributeContext.getOwnerType();
        Component ownerBootDescriptor = metadataContext.getEmbeddableBootDescriptor(ownerType);
        CompositeTypeImplementor ownerComponentType = (CompositeTypeImplementor)ownerBootDescriptor.getType();
        EmbeddableValuedModelPart ownerMappingModelDescriptor = ownerComponentType.getMappingModelPart();
        EmbeddableRepresentationStrategy ownerRepStrategy = ownerMappingModelDescriptor == null ? ownerBootDescriptor.getBuildingContext().getBootstrapContext().getRepresentationStrategySelector().resolveStrategy(ownerBootDescriptor, null, metadataContext.getRuntimeModelCreationContext()) : ownerMappingModelDescriptor.getEmbeddableTypeDescriptor().getRepresentationStrategy();
        if (ownerRepStrategy.getMode() == RepresentationMode.MAP) {
            return new MapMember(attributeContext.getPropertyMapping().getName(), attributeContext.getPropertyMapping().getType().getReturnedClass());
        }
        return ownerRepStrategy.resolvePropertyAccess(attributeContext.getPropertyMapping()).getGetter().getMember();
    };
    private static final MemberResolver virtualIdentifierMemberResolver = (attributeContext, metadataContext) -> {
        String attributeName;
        AbstractIdentifiableType identifiableType = (AbstractIdentifiableType)attributeContext.getOwnerType();
        EntityPersister entityPersister = AttributeFactory.getDeclarerEntityPersister(identifiableType, metadataContext);
        EntityIdentifierMapping identifierMapping = entityPersister.getIdentifierMapping();
        if (identifierMapping.getNature() != EntityIdentifierMapping.Nature.VIRTUAL) {
            throw new IllegalArgumentException("expecting IdClass mapping");
        }
        CompositeIdentifierMapping cid = (CompositeIdentifierMapping)identifierMapping;
        EmbeddableMappingType embeddable = cid.getPartMappingType();
        AttributeMapping attributeMapping = embeddable.findAttributeMapping(attributeName = attributeContext.getPropertyMapping().getName());
        if (attributeMapping == null) {
            throw new PropertyNotFoundException("Unable to locate property named " + attributeName + " on " + embeddable.getJavaType().getJavaTypeClass().getName());
        }
        Getter getter = attributeMapping.getPropertyAccess().getGetter();
        return getter instanceof PropertyAccessMapImpl.GetterImpl ? new MapMember(attributeName, attributeContext.getPropertyMapping().getType().getReturnedClass()) : getter.getMember();
    };
    private static final MemberResolver normalMemberResolver = (attributeContext, metadataContext) -> {
        ManagedDomainType ownerType = attributeContext.getOwnerType();
        Property property = attributeContext.getPropertyMapping();
        Type.PersistenceType persistenceType = ownerType.getPersistenceType();
        if (Type.PersistenceType.EMBEDDABLE == persistenceType) {
            return embeddedMemberResolver.resolveMember(attributeContext, metadataContext);
        }
        if (Type.PersistenceType.ENTITY == persistenceType || Type.PersistenceType.MAPPED_SUPERCLASS == persistenceType) {
            String propertyName;
            AbstractIdentifiableType identifiableType = (AbstractIdentifiableType)ownerType;
            EntityPersister declaringEntityPersister = AttributeFactory.getDeclaringEntity(identifiableType, metadataContext);
            AttributeMapping attributeMapping = declaringEntityPersister.findAttributeMapping(propertyName = property.getName());
            if (attributeMapping == null) {
                return virtualIdentifierMemberResolver.resolveMember(attributeContext, metadataContext);
            }
            Getter getter = declaringEntityPersister.getRepresentationStrategy().resolvePropertyAccess(property).getGetter();
            return getter instanceof PropertyAccessMapImpl.GetterImpl ? new MapMember(propertyName, property.getType().getReturnedClass()) : getter.getMember();
        }
        throw new IllegalArgumentException("Unexpected owner type : " + persistenceType);
    };
    private final MemberResolver identifierMemberResolver = (attributeContext, metadataContext) -> {
        AbstractIdentifiableType identifiableType = (AbstractIdentifiableType)attributeContext.getOwnerType();
        EntityPersister declaringEntityMapping = AttributeFactory.getDeclaringEntity(identifiableType, metadataContext);
        EntityIdentifierMapping identifierMapping = declaringEntityMapping.getIdentifierMapping();
        String attributeName = attributeContext.getPropertyMapping().getName();
        if (!attributeName.equals(identifierMapping.getAttributeName())) {
            return virtualIdentifierMemberResolver.resolveMember(attributeContext, metadataContext);
        }
        Getter getter = declaringEntityMapping.getRepresentationStrategy().resolvePropertyAccess(attributeContext.getPropertyMapping()).getGetter();
        if (getter instanceof PropertyAccessMapImpl.GetterImpl) {
            return new MapMember(identifierMapping.getAttributeName(), identifierMapping.getJavaType().getJavaTypeClass());
        }
        return getter.getMember();
    };
    private final MemberResolver versionMemberResolver = (attributeContext, metadataContext) -> {
        AbstractIdentifiableType identifiableType = (AbstractIdentifiableType)attributeContext.getOwnerType();
        EntityPersister entityPersister = AttributeFactory.getDeclaringEntity(identifiableType, metadataContext);
        EntityVersionMapping versionMapping = entityPersister.getVersionMapping();
        assert (entityPersister.isVersioned());
        assert (versionMapping != null);
        String versionPropertyName = attributeContext.getPropertyMapping().getName();
        if (!versionPropertyName.equals(versionMapping.getVersionAttribute().getAttributeName())) {
            throw new IllegalArgumentException("Given property did not match declared version property");
        }
        Getter getter = entityPersister.getRepresentationStrategy().resolvePropertyAccess(attributeContext.getPropertyMapping()).getGetter();
        if (getter instanceof PropertyAccessMapImpl.GetterImpl) {
            return new MapMember(versionPropertyName, versionMapping.getJavaType().getJavaTypeClass());
        }
        return getter.getMember();
    };

    public AttributeFactory(MetadataContext context) {
        this.context = context;
    }

    public <X, Y> PersistentAttribute<X, Y> buildAttribute(ManagedDomainType<X> ownerType, Property property) {
        return AttributeFactory.buildAttribute(ownerType, property, this.context);
    }

    public static <X, Y> PersistentAttribute<X, Y> buildAttribute(ManagedDomainType<X> ownerType, Property property, MetadataContext metadataContext) {
        if (property.isSynthetic()) {
            LOG.tracef("Skipping synthetic property %s(%s)", ownerType.getTypeName(), property.getName());
            return null;
        }
        LOG.tracef("Building attribute [%s.%s]", ownerType.getTypeName(), property.getName());
        AttributeContext<X> attributeContext = AttributeFactory.wrap(ownerType, property);
        AttributeMetadata<X, Y> attributeMetadata = AttributeFactory.determineAttributeMetadata(attributeContext, normalMemberResolver, metadataContext);
        if (attributeMetadata instanceof PluralAttributeMetadata) {
            return PluralAttributeBuilder.build((PluralAttributeMetadata)attributeMetadata, property.isGeneric(), metadataContext);
        }
        ValueContext valueContext = ((SingularAttributeMetadata)attributeMetadata).getValueContext();
        DomainType<Y> metaModelType = AttributeFactory.determineSimpleType(valueContext, metadataContext);
        JavaType<?> relationalJavaType = AttributeFactory.determineRelationalJavaType(valueContext, metaModelType, metadataContext);
        return new SingularAttributeImpl<X, Y>(ownerType, attributeMetadata.getName(), attributeMetadata.getAttributeClassification(), metaModelType, relationalJavaType, attributeMetadata.getMember(), false, false, property.isOptional(), property.isGeneric(), metadataContext);
    }

    private static <X> AttributeContext<X> wrap(final ManagedDomainType<X> ownerType, final Property property) {
        return new AttributeContext<X>(){

            @Override
            public ManagedDomainType<X> getOwnerType() {
                return ownerType;
            }

            @Override
            public Property getPropertyMapping() {
                return property;
            }
        };
    }

    public <X, Y> SingularPersistentAttribute<X, Y> buildIdAttribute(IdentifiableDomainType<X> ownerType, Property property) {
        LOG.tracef("Building identifier attribute [%s.%s]", ownerType.getTypeName(), property.getName());
        SingularAttributeMetadata attributeMetadata = (SingularAttributeMetadata)this.determineAttributeMetadata(AttributeFactory.wrap(ownerType, property), this.identifierMemberResolver);
        return new SingularAttributeImpl.Identifier(ownerType, property.getName(), (SimpleDomainType)this.determineSimpleType(attributeMetadata.getValueContext()), attributeMetadata.getMember(), attributeMetadata.getAttributeClassification(), property.isGeneric(), this.context);
    }

    public <X, Y> SingularAttributeImpl<X, Y> buildVersionAttribute(IdentifiableDomainType<X> ownerType, Property property) {
        LOG.tracef("Building version attribute [%s.%s]", ownerType.getTypeName(), property.getName());
        SingularAttributeMetadata attributeMetadata = (SingularAttributeMetadata)this.determineAttributeMetadata(AttributeFactory.wrap(ownerType, property), this.versionMemberResolver);
        return new SingularAttributeImpl.Version(ownerType, property.getName(), attributeMetadata.getAttributeClassification(), (SimpleDomainType)this.determineSimpleType(attributeMetadata.getValueContext()), attributeMetadata.getMember(), this.context);
    }

    private <Y> DomainType<Y> determineSimpleType(ValueContext typeContext) {
        return AttributeFactory.determineSimpleType(typeContext, this.context);
    }

    public static <Y> DomainType<Y> determineSimpleType(ValueContext typeContext, MetadataContext context) {
        switch (typeContext.getValueClassification()) {
            case BASIC: {
                SimpleValue simpleValue;
                Class<Object> returnedClass = typeContext.getJpaBindableType();
                if (returnedClass.isAssignableFrom(Object.class) && (simpleValue = (SimpleValue)typeContext.getHibernateValue()).getTypeParameters() != null && typeContext.getAttributeMetadata().getOwnerType() instanceof EntityDomainType) {
                    returnedClass = simpleValue.getType().getReturnedClass();
                }
                return context.resolveBasicType(returnedClass);
            }
            case ENTITY: {
                Type type = typeContext.getHibernateValue().getType();
                if (type instanceof EntityType) {
                    EntityType entityType = (EntityType)type;
                    IdentifiableDomainType domainType = context.locateIdentifiableType(entityType.getAssociatedEntityName());
                    if (domainType == null) {
                        JavaType domainJavaType = context.getJavaTypeRegistry().resolveDescriptor(typeContext.getJpaBindableType());
                        return new EntityTypeImpl(domainJavaType, context.getJpaMetamodel());
                    }
                    return domainType;
                }
                assert (type instanceof AnyType);
                AnyType anyType = (AnyType)type;
                JavaType<Class> baseJtd = context.getTypeConfiguration().getJavaTypeRegistry().resolveDescriptor(anyType.getReturnedClass());
                return new AnyMappingDomainTypeImpl((Any)typeContext.getHibernateValue(), anyType, baseJtd, context.getTypeConfiguration(), context.getMetamodel(), context.getRuntimeModelCreationContext().getSessionFactory());
            }
            case EMBEDDABLE: {
                Component component = (Component)typeContext.getHibernateValue();
                if (!component.isDynamic()) {
                    assert (component.getComponentClassName() != null);
                    Class<?> embeddableClass = component.getComponentClass();
                    EmbeddableDomainType<?> cached = context.locateEmbeddable(embeddableClass, component);
                    if (cached != null) {
                        return cached;
                    }
                    JavaTypeRegistry registry = context.getTypeConfiguration().getJavaTypeRegistry();
                    JavaType javaType = registry.resolveManagedTypeDescriptor(embeddableClass);
                    EmbeddableTypeImpl embeddableType = new EmbeddableTypeImpl(javaType, false, context.getJpaMetamodel());
                    context.registerEmbeddableType(embeddableType, component);
                    return embeddableType;
                }
                JavaType javaType = context.getJavaTypeRegistry().getDescriptor((java.lang.reflect.Type)((Object)java.util.Map.class));
                EmbeddableTypeImpl embeddableType = new EmbeddableTypeImpl(javaType, true, context.getJpaMetamodel());
                context.registerComponentByEmbeddable(embeddableType, component);
                AttributeContainer.InFlightAccess inFlightAccess = embeddableType.getInFlightAccess();
                for (Property property : component.getProperties()) {
                    PersistentAttribute attribute = AttributeFactory.buildAttribute(embeddableType, property, context);
                    if (attribute == null) continue;
                    inFlightAccess.addAttribute(attribute);
                }
                inFlightAccess.finishUp();
                return embeddableType;
            }
        }
        throw new AssertionFailure("Unknown type : " + typeContext.getValueClassification());
    }

    private static JavaType<?> determineRelationalJavaType(ValueContext typeContext, DomainType<?> metaModelType, MetadataContext context) {
        ConverterDescriptor descriptor;
        if (typeContext.getValueClassification() == ValueClassification.BASIC && (descriptor = ((SimpleValue)typeContext.getHibernateValue()).getJpaAttributeConverterDescriptor()) != null) {
            return context.getJavaTypeRegistry().resolveDescriptor(descriptor.getRelationalValueResolvedType().getErasedType());
        }
        return metaModelType.getExpressibleJavaType();
    }

    private static EntityPersister getDeclaringEntity(AbstractIdentifiableType<?> ownerType, MetadataContext metadataContext) {
        return AttributeFactory.getDeclarerEntityPersister(ownerType, metadataContext);
    }

    private static EntityPersister getDeclarerEntityPersister(AbstractIdentifiableType<?> ownerType, MetadataContext metadataContext) {
        Type.PersistenceType persistenceType = ownerType.getPersistenceType();
        if (persistenceType == Type.PersistenceType.ENTITY) {
            return metadataContext.getMetamodel().getEntityDescriptor(ownerType.getTypeName());
        }
        if (persistenceType == Type.PersistenceType.MAPPED_SUPERCLASS) {
            PersistentClass persistentClass = metadataContext.getPersistentClassHostingProperties((MappedSuperclassTypeImpl)ownerType);
            return metadataContext.getMetamodel().findEntityDescriptor(persistentClass.getClassName());
        }
        throw new AssertionFailure("Cannot get the metamodel for PersistenceType: " + persistenceType);
    }

    private <X, Y> AttributeMetadata<X, Y> determineAttributeMetadata(AttributeContext<X> attributeContext, MemberResolver memberResolver) {
        return AttributeFactory.determineAttributeMetadata(attributeContext, memberResolver, this.context);
    }

    private static <X, Y> AttributeMetadata<X, Y> determineAttributeMetadata(AttributeContext<X> attributeContext, MemberResolver memberResolver, MetadataContext context) {
        Property propertyMapping = attributeContext.getPropertyMapping();
        String propertyName = propertyMapping.getName();
        LOG.tracef("Starting attribute metadata determination [%s]", propertyName);
        Member member = memberResolver.resolveMember(attributeContext, context);
        LOG.tracef("    Determined member [%s]", member);
        Value value = propertyMapping.getValue();
        Type type = value.getType();
        LOG.tracef("    Determined type [name=%s, class=%s]", type.getName(), type.getClass().getName());
        if (type.isAnyType()) {
            return new SingularAttributeMetadataImpl(propertyMapping, attributeContext.getOwnerType(), member, AttributeClassification.ANY, context);
        }
        if (type.isAssociationType()) {
            if (type.isEntityType()) {
                return new SingularAttributeMetadataImpl(propertyMapping, attributeContext.getOwnerType(), member, AttributeFactory.determineSingularAssociationClassification(member), context);
            }
            if (value instanceof Collection) {
                Value keyValue;
                Type keyType;
                AttributeClassification elementClassification;
                AttributeClassification attributeClassification;
                Collection collValue = (Collection)value;
                Value elementValue = collValue.getElement();
                Type elementType = elementValue.getType();
                boolean isManyToMany = AttributeFactory.isManyToMany(member);
                if (elementType.isAnyType()) {
                    attributeClassification = AttributeClassification.ELEMENT_COLLECTION;
                    elementClassification = AttributeClassification.ANY;
                } else if (elementValue instanceof Component) {
                    elementClassification = AttributeClassification.EMBEDDED;
                    attributeClassification = AttributeClassification.ELEMENT_COLLECTION;
                } else if (elementType.isAssociationType()) {
                    attributeClassification = elementClassification = isManyToMany ? AttributeClassification.MANY_TO_MANY : AttributeClassification.ONE_TO_MANY;
                } else {
                    elementClassification = AttributeClassification.BASIC;
                    attributeClassification = AttributeClassification.ELEMENT_COLLECTION;
                }
                AttributeClassification indexClassification = value instanceof Map ? ((keyType = (keyValue = ((Map)value).getIndex()).getType()).isAnyType() ? AttributeClassification.ANY : (keyValue instanceof Component ? AttributeClassification.EMBEDDED : (keyType.isAssociationType() ? AttributeClassification.MANY_TO_ONE : AttributeClassification.BASIC))) : (value instanceof List ? AttributeClassification.BASIC : null);
                return new PluralAttributeMetadataImpl(propertyMapping, attributeContext.getOwnerType(), member, attributeClassification, elementClassification, indexClassification, context);
            }
            if (value instanceof OneToMany) {
                throw new IllegalArgumentException("HUH???");
            }
        } else {
            if (propertyMapping.isComposite()) {
                return new SingularAttributeMetadataImpl(propertyMapping, attributeContext.getOwnerType(), member, AttributeClassification.EMBEDDED, context);
            }
            return new SingularAttributeMetadataImpl(propertyMapping, attributeContext.getOwnerType(), member, AttributeClassification.BASIC, context);
        }
        throw new UnsupportedMappingException("oops, we are missing something: " + propertyMapping);
    }

    public static AttributeClassification determineSingularAssociationClassification(Member member) {
        if (member instanceof Field) {
            return ((Field)member).getAnnotation(OneToOne.class) != null ? AttributeClassification.ONE_TO_ONE : AttributeClassification.MANY_TO_ONE;
        }
        if (member instanceof MapMember) {
            return AttributeClassification.MANY_TO_ONE;
        }
        return ((Method)member).getAnnotation(OneToOne.class) != null ? AttributeClassification.ONE_TO_ONE : AttributeClassification.MANY_TO_ONE;
    }

    protected <Y> Class<Y> accountForPrimitiveTypes(Class<Y> declaredType) {
        return AttributeFactory.accountForPrimitiveTypes(declaredType, this.context);
    }

    public static <Y> Class<Y> accountForPrimitiveTypes(Class<Y> declaredType, MetadataContext metadataContext) {
        return declaredType;
    }

    public static ParameterizedType getSignatureType(Member member) {
        java.lang.reflect.Type type = member instanceof Field ? ((Field)member).getGenericType() : (member instanceof Method ? ((Method)member).getGenericReturnType() : ((MapMember)member).getType());
        if (type instanceof Class) {
            return null;
        }
        return (ParameterizedType)type;
    }

    public static boolean isManyToMany(Member member) {
        if (member instanceof Field) {
            return ((Field)member).getAnnotation(ManyToMany.class) != null;
        }
        if (member instanceof Method) {
            return ((Method)member).getAnnotation(ManyToMany.class) != null;
        }
        return false;
    }
}

