/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.metamodel.mapping;

import java.io.Serializable;
import java.util.Collections;
import java.util.List;
import org.hibernate.cache.MutableCacheKeyBuilder;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.metamodel.mapping.JdbcMapping;
import org.hibernate.metamodel.mapping.SqlExpressible;
import org.hibernate.metamodel.mapping.ValueMapping;
import org.hibernate.type.descriptor.converter.spi.BasicValueConverter;
import org.hibernate.type.descriptor.java.JavaType;

public interface BasicValuedMapping
extends ValueMapping,
SqlExpressible {
    @Override
    default public int getJdbcTypeCount() {
        return 1;
    }

    @Override
    default public List<JdbcMapping> getJdbcMappings() {
        return Collections.singletonList(this.getJdbcMapping());
    }

    @Override
    default public JdbcMapping getJdbcMapping(int index) {
        if (index != 0) {
            throw new IndexOutOfBoundsException(index);
        }
        return this.getJdbcMapping();
    }

    @Override
    default public JdbcMapping getSingleJdbcMapping() {
        return this.getJdbcMapping();
    }

    @Override
    public JdbcMapping getJdbcMapping();

    @Override
    default public Object disassemble(Object value, SharedSessionContractImplementor session) {
        return this.getJdbcMapping().convertToRelationalValue(value);
    }

    @Override
    default public void addToCacheKey(MutableCacheKeyBuilder cacheKey, Object value, SharedSessionContractImplementor session) {
        int hashCode;
        Serializable disassemble;
        if (value == null) {
            return;
        }
        JdbcMapping jdbcMapping = this.getJdbcMapping();
        BasicValueConverter converter = jdbcMapping.getValueConverter();
        if (converter == null) {
            disassemble = jdbcMapping.getJavaTypeDescriptor().getMutabilityPlan().disassemble(value, session);
            hashCode = jdbcMapping.getMappedJavaType().extractHashCode(value);
        } else {
            Object relationalValue = converter.toRelationalValue(value);
            JavaType relationalJavaType = converter.getRelationalJavaType();
            disassemble = relationalJavaType.getMutabilityPlan().disassemble(relationalValue, session);
            hashCode = relationalJavaType.extractHashCode(relationalValue);
        }
        cacheKey.addValue(disassemble);
        cacheKey.addHashCode(hashCode);
    }
}

