/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.persister.collection.mutation;

import org.hibernate.engine.jdbc.batch.internal.BasicBatchKey;
import org.hibernate.engine.jdbc.mutation.JdbcValueBindings;
import org.hibernate.engine.jdbc.mutation.MutationExecutor;
import org.hibernate.engine.jdbc.mutation.spi.MutationExecutorService;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.metamodel.mapping.ForeignKeyDescriptor;
import org.hibernate.persister.collection.mutation.CollectionMutationTarget;
import org.hibernate.persister.collection.mutation.CollectionTableMapping;
import org.hibernate.persister.collection.mutation.OperationProducer;
import org.hibernate.persister.collection.mutation.RemoveCoordinator;
import org.hibernate.persister.collection.mutation.RowMutationOperations;
import org.hibernate.sql.model.ModelMutationLogging;
import org.hibernate.sql.model.MutationType;
import org.hibernate.sql.model.ast.MutatingTableReference;
import org.hibernate.sql.model.internal.MutationOperationGroupSingle;
import org.hibernate.sql.model.jdbc.JdbcMutationOperation;

public class RemoveCoordinatorStandard
implements RemoveCoordinator {
    private final CollectionMutationTarget mutationTarget;
    private final OperationProducer operationProducer;
    private final BasicBatchKey batchKey;
    private MutationOperationGroupSingle operationGroup;

    public RemoveCoordinatorStandard(CollectionMutationTarget mutationTarget, OperationProducer operationProducer) {
        this.mutationTarget = mutationTarget;
        this.operationProducer = operationProducer;
        this.batchKey = new BasicBatchKey(mutationTarget.getRolePath() + "#REMOVE");
    }

    public String toString() {
        return "RemoveCoordinator(" + this.mutationTarget.getRolePath() + ")";
    }

    @Override
    public CollectionMutationTarget getMutationTarget() {
        return this.mutationTarget;
    }

    @Override
    public String getSqlString() {
        if (this.operationGroup == null) {
            this.operationGroup = this.buildOperationGroup();
        }
        JdbcMutationOperation operation = (JdbcMutationOperation)this.operationGroup.getSingleOperation();
        return operation.getSqlString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deleteAllRows(Object key, SharedSessionContractImplementor session) {
        if (ModelMutationLogging.MODEL_MUTATION_LOGGER_DEBUG_ENABLED) {
            ModelMutationLogging.MODEL_MUTATION_LOGGER.debugf("Deleting collection - %s : %s", (Object)this.mutationTarget.getRolePath(), key);
        }
        if (this.operationGroup == null) {
            this.operationGroup = this.buildOperationGroup();
        }
        MutationExecutorService mutationExecutorService = session.getFactory().getServiceRegistry().getService(MutationExecutorService.class);
        MutationExecutor mutationExecutor = mutationExecutorService.createExecutor(() -> this.batchKey, this.operationGroup, session);
        try {
            JdbcValueBindings jdbcValueBindings = mutationExecutor.getJdbcValueBindings();
            ForeignKeyDescriptor fkDescriptor = this.mutationTarget.getTargetPart().getKeyDescriptor();
            fkDescriptor.getKeyPart().decompose(key, 0, jdbcValueBindings, null, RowMutationOperations.DEFAULT_RESTRICTOR, session);
            mutationExecutor.execute(key, null, null, null, session);
        }
        finally {
            mutationExecutor.release();
        }
    }

    private MutationOperationGroupSingle buildOperationGroup() {
        assert (this.mutationTarget.getTargetPart() != null);
        assert (this.mutationTarget.getTargetPart().getKeyDescriptor() != null);
        if (ModelMutationLogging.MODEL_MUTATION_LOGGER_TRACE_ENABLED) {
            ModelMutationLogging.MODEL_MUTATION_LOGGER.tracef("Starting RemoveCoordinator#buildOperationGroup - %s", (Object)this.mutationTarget.getRolePath());
        }
        CollectionTableMapping tableMapping = this.mutationTarget.getCollectionTableMapping();
        MutatingTableReference tableReference = new MutatingTableReference(tableMapping);
        return new MutationOperationGroupSingle(MutationType.DELETE, this.mutationTarget, this.operationProducer.createOperation(tableReference));
    }
}

