/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.sql.results.graph.entity.internal;

import org.hibernate.LockMode;
import org.hibernate.metamodel.mapping.EntityValuedModelPart;
import org.hibernate.spi.NavigablePath;
import org.hibernate.sql.ast.tree.from.TableGroup;
import org.hibernate.sql.ast.tree.from.TableGroupJoin;
import org.hibernate.sql.ast.tree.from.TableGroupProducer;
import org.hibernate.sql.results.graph.AssemblerCreationState;
import org.hibernate.sql.results.graph.DomainResultAssembler;
import org.hibernate.sql.results.graph.FetchParentAccess;
import org.hibernate.sql.results.graph.Fetchable;
import org.hibernate.sql.results.graph.FetchableContainer;
import org.hibernate.sql.results.graph.Initializer;
import org.hibernate.sql.results.graph.entity.AbstractEntityResultGraphNode;
import org.hibernate.sql.results.graph.entity.EntityResult;
import org.hibernate.sql.results.graph.entity.EntityResultGraphNode;
import org.hibernate.sql.results.graph.entity.internal.EntityAssembler;
import org.hibernate.sql.results.graph.entity.internal.EntityResultInitializer;

public class EntityResultImpl
extends AbstractEntityResultGraphNode
implements EntityResult {
    private final TableGroup tableGroup;
    private final String resultVariable;

    public EntityResultImpl(NavigablePath navigablePath, EntityValuedModelPart entityValuedModelPart, TableGroup tableGroup, String resultVariable) {
        super(entityValuedModelPart, navigablePath);
        this.tableGroup = tableGroup;
        this.resultVariable = resultVariable;
    }

    @Override
    public NavigablePath resolveNavigablePath(Fetchable fetchable) {
        if (fetchable instanceof TableGroupProducer && this.getNavigablePath().isAliased()) {
            for (TableGroupJoin tableGroupJoin : this.tableGroup.getTableGroupJoins()) {
                NavigablePath navigablePath = tableGroupJoin.getNavigablePath();
                if (!tableGroupJoin.getJoinedGroup().isFetched() || !fetchable.getNavigableRole().getLocalName().equals(navigablePath.getLocalName()) || tableGroupJoin.getJoinedGroup().getModelPart() != fetchable) continue;
                return navigablePath;
            }
        }
        return super.resolveNavigablePath(fetchable);
    }

    @Override
    public FetchableContainer getReferencedMappingType() {
        return this.getReferencedMappingContainer();
    }

    @Override
    public EntityValuedModelPart getReferencedModePart() {
        return this.getEntityValuedModelPart();
    }

    @Override
    public String getResultVariable() {
        return this.resultVariable;
    }

    protected LockMode getLockMode(AssemblerCreationState creationState) {
        return creationState.determineEffectiveLockMode(this.tableGroup.getSourceAlias());
    }

    public DomainResultAssembler createResultAssembler(FetchParentAccess parentAccess, AssemblerCreationState creationState) {
        Initializer initializer = creationState.resolveInitializer(this.getNavigablePath(), this.getReferencedModePart(), () -> new EntityResultInitializer((EntityResultGraphNode)this, this.getNavigablePath(), this.getLockMode(creationState), this.getIdentifierFetch(), this.getDiscriminatorFetch(), this.getRowIdResult(), creationState));
        return new EntityAssembler(this.getResultJavaType(), initializer.asEntityInitializer());
    }

    public String toString() {
        return "EntityResultImpl {" + this.getNavigablePath() + "}";
    }
}

