/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.tuple.entity;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.hibernate.HibernateException;
import org.hibernate.MappingException;
import org.hibernate.boot.spi.MetadataImplementor;
import org.hibernate.bytecode.enhance.spi.interceptor.EnhancementHelper;
import org.hibernate.bytecode.internal.BytecodeEnhancementMetadataNonPojoImpl;
import org.hibernate.bytecode.internal.BytecodeEnhancementMetadataPojoImpl;
import org.hibernate.bytecode.spi.BytecodeEnhancementMetadata;
import org.hibernate.dialect.Dialect;
import org.hibernate.engine.OptimisticLockStyle;
import org.hibernate.engine.spi.CascadeStyle;
import org.hibernate.engine.spi.CascadeStyles;
import org.hibernate.engine.spi.CascadingActions;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.generator.BeforeExecutionGenerator;
import org.hibernate.generator.Generator;
import org.hibernate.generator.OnExecutionGenerator;
import org.hibernate.internal.CoreLogging;
import org.hibernate.internal.CoreMessageLogger;
import org.hibernate.internal.util.ReflectHelper;
import org.hibernate.internal.util.collections.ArrayHelper;
import org.hibernate.internal.util.collections.CollectionHelper;
import org.hibernate.mapping.Component;
import org.hibernate.mapping.GeneratorCreator;
import org.hibernate.mapping.PersistentClass;
import org.hibernate.mapping.Property;
import org.hibernate.mapping.Subclass;
import org.hibernate.metamodel.spi.RuntimeModelCreationContext;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.persister.spi.PersisterCreationContext;
import org.hibernate.tuple.IdentifierProperty;
import org.hibernate.tuple.NonIdentifierAttribute;
import org.hibernate.tuple.PropertyFactory;
import org.hibernate.tuple.entity.CompositeGeneratorBuilder;
import org.hibernate.tuple.entity.VersionProperty;
import org.hibernate.type.AssociationType;
import org.hibernate.type.CollectionType;
import org.hibernate.type.ComponentType;
import org.hibernate.type.CompositeType;
import org.hibernate.type.EntityType;
import org.hibernate.type.ManyToOneType;
import org.hibernate.type.Type;

@Deprecated(since="6", forRemoval=true)
public class EntityMetamodel
implements Serializable {
    private static final CoreMessageLogger LOG = CoreLogging.messageLogger(EntityMetamodel.class);
    public static final int NO_VERSION_INDX = -66;
    private final SessionFactoryImplementor sessionFactory;
    private final String name;
    private final String rootName;
    private EntityType entityType;
    private final int subclassId;
    private final IdentifierProperty identifierAttribute;
    private final boolean versioned;
    private final int propertySpan;
    private final int versionPropertyIndex;
    private final NonIdentifierAttribute[] properties;
    private final String[] propertyNames;
    private final Type[] propertyTypes;
    private final boolean[] propertyLaziness;
    private final boolean[] propertyUpdateability;
    private final boolean[] nonlazyPropertyUpdateability;
    private final boolean[] propertyCheckability;
    private final boolean[] propertyInsertability;
    private final boolean[] propertyNullability;
    private final boolean[] propertyVersionability;
    private final CascadeStyle[] cascadeStyles;
    private final boolean hasPreInsertGeneratedValues;
    private final boolean hasPreUpdateGeneratedValues;
    private final boolean hasInsertGeneratedValues;
    private final boolean hasUpdateGeneratedValues;
    private final Generator[] generators;
    private final Map<String, Integer> propertyIndexes = new HashMap<String, Integer>();
    private final boolean hasCollections;
    private final boolean hasOwnedCollections;
    private final BitSet mutablePropertiesIndexes;
    private final boolean hasLazyProperties;
    private final boolean hasNonIdentifierPropertyNamedId;
    private final int[] naturalIdPropertyNumbers;
    private final boolean hasImmutableNaturalId;
    private final boolean hasCacheableNaturalId;
    private boolean lazy;
    private final boolean hasCascades;
    private final boolean hasCascadeDelete;
    private final boolean mutable;
    private final boolean isAbstract;
    private final boolean selectBeforeUpdate;
    private final boolean dynamicUpdate;
    private final boolean dynamicInsert;
    private final OptimisticLockStyle optimisticLockStyle;
    private final boolean polymorphic;
    private final String superclass;
    private final boolean explicitPolymorphism;
    private final boolean inherited;
    private final boolean hasSubclasses;
    private final Set<String> subclassEntityNames;
    private final Map<Class<?>, String> entityNameByInheritanceClassMap;
    private final BeforeExecutionGenerator versionGenerator;
    private final BytecodeEnhancementMetadata bytecodeEnhancementMetadata;

    @Deprecated(since="6.0")
    public EntityMetamodel(PersistentClass persistentClass, EntityPersister persister, PersisterCreationContext creationContext) {
        this(persistentClass, persister, (RuntimeModelCreationContext)creationContext);
    }

    public EntityMetamodel(PersistentClass persistentClass, EntityPersister persister, RuntimeModelCreationContext creationContext) {
        this.sessionFactory = creationContext.getSessionFactory();
        this.name = persistentClass.getEntityName().intern();
        this.rootName = persistentClass.getRootClass().getEntityName().intern();
        this.subclassId = persistentClass.getSubclassId();
        this.identifierAttribute = PropertyFactory.buildIdentifierAttribute(persistentClass, this.sessionFactory.getGenerator(this.rootName));
        this.versioned = persistentClass.isVersioned();
        boolean collectionsInDefaultFetchGroupEnabled = creationContext.getSessionFactoryOptions().isCollectionsInDefaultFetchGroupEnabled();
        if (persistentClass.hasPojoRepresentation()) {
            HashSet<String> idAttributeNames;
            CompositeType nonAggregatedCidMapper;
            Component identifierMapperComponent = persistentClass.getIdentifierMapper();
            if (identifierMapperComponent != null) {
                nonAggregatedCidMapper = identifierMapperComponent.getType();
                idAttributeNames = new HashSet();
                for (Property property : identifierMapperComponent.getProperties()) {
                    idAttributeNames.add(property.getName());
                }
            } else {
                nonAggregatedCidMapper = null;
                idAttributeNames = Collections.singleton(this.identifierAttribute.getName());
            }
            this.bytecodeEnhancementMetadata = BytecodeEnhancementMetadataPojoImpl.from(persistentClass, idAttributeNames, nonAggregatedCidMapper, collectionsInDefaultFetchGroupEnabled, creationContext.getMetadata());
        } else {
            this.bytecodeEnhancementMetadata = new BytecodeEnhancementMetadataNonPojoImpl(persistentClass.getEntityName());
        }
        boolean hasLazy = false;
        this.propertySpan = persistentClass.getPropertyClosureSpan();
        this.properties = new NonIdentifierAttribute[this.propertySpan];
        ArrayList<Integer> naturalIdNumbers = new ArrayList<Integer>();
        this.propertyNames = new String[this.propertySpan];
        this.propertyTypes = new Type[this.propertySpan];
        this.propertyUpdateability = new boolean[this.propertySpan];
        this.propertyInsertability = new boolean[this.propertySpan];
        this.nonlazyPropertyUpdateability = new boolean[this.propertySpan];
        this.propertyCheckability = new boolean[this.propertySpan];
        this.propertyNullability = new boolean[this.propertySpan];
        this.propertyVersionability = new boolean[this.propertySpan];
        this.propertyLaziness = new boolean[this.propertySpan];
        this.cascadeStyles = new CascadeStyle[this.propertySpan];
        this.generators = new Generator[this.propertySpan];
        boolean foundPreInsertGeneratedValues = false;
        boolean foundPreUpdateGeneratedValues = false;
        boolean foundPostInsertGeneratedValues = false;
        boolean foundPostUpdateGeneratedValues = false;
        int tempVersionProperty = -66;
        boolean foundCascade = false;
        boolean foundCascadeDelete = false;
        boolean foundCollection = false;
        boolean foundOwnedCollection = false;
        BitSet mutableIndexes = new BitSet();
        boolean foundNonIdentifierPropertyNamedId = false;
        boolean foundUpdateableNaturalIdProperty = false;
        BeforeExecutionGenerator tempVersionGenerator = null;
        List<Property> props = persistentClass.getPropertyClosure();
        for (int i = 0; i < props.size(); ++i) {
            Type propertyType;
            boolean lazy;
            Object attribute;
            Property property = props.get(i);
            if (property == persistentClass.getVersion()) {
                tempVersionProperty = i;
                attribute = PropertyFactory.buildVersionProperty(persister, this.sessionFactory, i, property, this.bytecodeEnhancementMetadata.isEnhancedForLazyLoading());
            } else {
                attribute = PropertyFactory.buildEntityBasedAttribute(persister, this.sessionFactory, i, property, this.bytecodeEnhancementMetadata.isEnhancedForLazyLoading(), creationContext);
            }
            this.properties[i] = attribute;
            if (property.isNaturalIdentifier()) {
                naturalIdNumbers.add(i);
                if (property.isUpdateable()) {
                    foundUpdateableNaturalIdProperty = true;
                }
            }
            if ("id".equals(property.getName())) {
                foundNonIdentifierPropertyNamedId = true;
            }
            boolean bl = lazy = !EnhancementHelper.includeInBaseFetchGroup(property, this.bytecodeEnhancementMetadata.isEnhancedForLazyLoading(), entityName -> {
                MetadataImplementor metadata = creationContext.getMetadata();
                PersistentClass entityBinding = metadata.getEntityBinding(entityName);
                assert (entityBinding != null);
                return entityBinding.hasSubclasses();
            }, collectionsInDefaultFetchGroupEnabled);
            if (lazy) {
                hasLazy = true;
            }
            this.propertyLaziness[i] = lazy;
            this.propertyNames[i] = attribute.getName();
            this.propertyTypes[i] = propertyType = attribute.getType();
            this.propertyNullability[i] = attribute.isNullable();
            this.propertyUpdateability[i] = attribute.isUpdateable();
            this.propertyInsertability[i] = attribute.isInsertable();
            this.propertyVersionability[i] = attribute.isVersionable();
            this.nonlazyPropertyUpdateability[i] = attribute.isUpdateable() && !lazy;
            this.propertyCheckability[i] = this.propertyUpdateability[i] || propertyType.isAssociationType() && ((AssociationType)propertyType).isAlwaysDirtyChecked();
            this.cascadeStyles[i] = attribute.getCascadeStyle();
            Generator generator = EntityMetamodel.buildGenerator(this.name, property, creationContext);
            if (generator != null) {
                if (i == tempVersionProperty && !generator.generatedOnExecution()) {
                    tempVersionGenerator = (BeforeExecutionGenerator)generator;
                } else {
                    this.generators[i] = generator;
                    if (EntityMetamodel.generatedWithNoParameter(generator)) {
                        this.propertyInsertability[i] = false;
                        this.propertyUpdateability[i] = false;
                    }
                    if (generator.generatesOnInsert()) {
                        if (generator.generatedOnExecution()) {
                            foundPostInsertGeneratedValues = true;
                        } else {
                            foundPreInsertGeneratedValues = true;
                        }
                    }
                    if (generator.generatesOnUpdate()) {
                        if (generator.generatedOnExecution()) {
                            foundPostUpdateGeneratedValues = true;
                        } else {
                            foundPreUpdateGeneratedValues = true;
                        }
                    }
                }
            }
            if (attribute.isLazy()) {
                hasLazy = true;
            }
            if (this.cascadeStyles[i] != CascadeStyles.NONE) {
                foundCascade = true;
            }
            if (this.cascadeStyles[i].doCascade(CascadingActions.DELETE)) {
                foundCascadeDelete = true;
            }
            if (EntityMetamodel.indicatesCollection(attribute.getType())) {
                foundCollection = true;
            }
            if (EntityMetamodel.indicatesOwnedCollection(attribute.getType(), creationContext.getMetadata())) {
                foundOwnedCollection = true;
            }
            if (propertyType.isMutable() && this.propertyCheckability[i] && !(propertyType instanceof ComponentType)) {
                mutableIndexes.set(i);
            }
            this.mapPropertyToIndex(property, i);
        }
        if (naturalIdNumbers.isEmpty()) {
            this.naturalIdPropertyNumbers = null;
            this.hasImmutableNaturalId = false;
            this.hasCacheableNaturalId = false;
        } else {
            this.naturalIdPropertyNumbers = ArrayHelper.toIntArray(naturalIdNumbers);
            this.hasImmutableNaturalId = !foundUpdateableNaturalIdProperty;
            this.hasCacheableNaturalId = persistentClass.getNaturalIdCacheRegionName() != null;
        }
        this.hasPreInsertGeneratedValues = foundPreInsertGeneratedValues;
        this.hasPreUpdateGeneratedValues = foundPreUpdateGeneratedValues;
        this.hasInsertGeneratedValues = foundPostInsertGeneratedValues;
        this.hasUpdateGeneratedValues = foundPostUpdateGeneratedValues;
        this.versionGenerator = tempVersionGenerator;
        this.hasCascades = foundCascade;
        this.hasCascadeDelete = foundCascadeDelete;
        this.hasNonIdentifierPropertyNamedId = foundNonIdentifierPropertyNamedId;
        this.versionPropertyIndex = tempVersionProperty;
        this.hasLazyProperties = hasLazy;
        if (this.hasLazyProperties) {
            LOG.lazyPropertyFetchingAvailable(this.name);
        }
        this.lazy = persistentClass.isLazy() && (!persistentClass.hasPojoRepresentation() || !ReflectHelper.isFinalClass(persistentClass.getProxyInterface()));
        this.mutable = persistentClass.isMutable();
        if (persistentClass.isAbstract() == null) {
            this.isAbstract = persistentClass.hasPojoRepresentation() && ReflectHelper.isAbstractClass(persistentClass.getMappedClass());
        } else {
            this.isAbstract = persistentClass.isAbstract();
            if (!this.isAbstract && persistentClass.hasPojoRepresentation() && ReflectHelper.isAbstractClass(persistentClass.getMappedClass())) {
                LOG.entityMappedAsNonAbstract(this.name);
            }
        }
        this.selectBeforeUpdate = persistentClass.hasSelectBeforeUpdate();
        this.dynamicUpdate = persistentClass.useDynamicUpdate() || this.getBytecodeEnhancementMetadata().isEnhancedForLazyLoading() && this.getBytecodeEnhancementMetadata().getLazyAttributesMetadata().getFetchGroupNames().size() > 1;
        this.dynamicInsert = persistentClass.useDynamicInsert();
        this.polymorphic = persistentClass.isPolymorphic();
        this.explicitPolymorphism = persistentClass.isExplicitPolymorphism();
        this.inherited = persistentClass.isInherited();
        this.superclass = this.inherited ? persistentClass.getSuperclass().getEntityName() : null;
        this.hasSubclasses = persistentClass.hasSubclasses();
        this.optimisticLockStyle = persistentClass.getOptimisticLockStyle();
        boolean isAllOrDirty = this.optimisticLockStyle.isAllOrDirty();
        if (isAllOrDirty && !this.dynamicUpdate) {
            throw new MappingException("optimistic-lock=all|dirty requires dynamic-update=\"true\": " + this.name);
        }
        if (this.versionPropertyIndex != -66 && isAllOrDirty) {
            throw new MappingException("version and optimistic-lock=all|dirty are not a valid combination : " + this.name);
        }
        this.hasCollections = foundCollection;
        this.hasOwnedCollections = foundOwnedCollection;
        this.mutablePropertiesIndexes = mutableIndexes;
        HashSet<String> subclassEntityNamesLocal = new HashSet<String>();
        for (Subclass subclass : persistentClass.getSubclasses()) {
            subclassEntityNamesLocal.add(subclass.getEntityName());
        }
        subclassEntityNamesLocal.add(this.name);
        this.subclassEntityNames = CollectionHelper.toSmallSet(subclassEntityNamesLocal);
        HashMap entityNameByInheritanceClassMapLocal = new HashMap();
        if (persistentClass.hasPojoRepresentation()) {
            entityNameByInheritanceClassMapLocal.put(persistentClass.getMappedClass(), persistentClass.getEntityName());
            for (Subclass subclass : persistentClass.getSubclasses()) {
                entityNameByInheritanceClassMapLocal.put(subclass.getMappedClass(), subclass.getEntityName());
            }
        }
        this.entityNameByInheritanceClassMap = CollectionHelper.toSmallMap(entityNameByInheritanceClassMapLocal);
    }

    private static boolean generatedWithNoParameter(Generator generator) {
        return generator.generatedOnExecution() && !((OnExecutionGenerator)generator).writePropertyValue();
    }

    private static Generator buildGenerator(String entityName, Property mappingProperty, RuntimeModelCreationContext context) {
        Generator generator;
        GeneratorCreator generatorCreator = mappingProperty.getValueGeneratorCreator();
        if (generatorCreator != null && (generator = mappingProperty.createGenerator(context)).generatesSometimes()) {
            return generator;
        }
        if (mappingProperty.getValue() instanceof Component) {
            Dialect dialect = context.getDialect();
            CompositeGeneratorBuilder builder = new CompositeGeneratorBuilder(entityName, mappingProperty, dialect);
            Component component = (Component)mappingProperty.getValue();
            for (Property property : component.getProperties()) {
                builder.add(property.createGenerator(context));
            }
            return builder.build();
        }
        return null;
    }

    public Generator[] getGenerators() {
        return this.generators;
    }

    public BeforeExecutionGenerator getVersionGenerator() {
        return this.versionGenerator;
    }

    private void mapPropertyToIndex(Property property, int i) {
        this.propertyIndexes.put(property.getName(), i);
        if (property.getValue() instanceof Component) {
            Component composite = (Component)property.getValue();
            for (Property subproperty : composite.getProperties()) {
                this.propertyIndexes.put(property.getName() + "." + subproperty.getName(), i);
            }
        }
    }

    public boolean isNaturalIdentifierInsertGenerated() {
        if (this.naturalIdPropertyNumbers.length == 0) {
            throw new IllegalStateException("entity does not have a natural id: " + this.name);
        }
        for (int i = 0; i < this.naturalIdPropertyNumbers.length; ++i) {
            Generator strategy = this.generators[this.naturalIdPropertyNumbers[i]];
            if (strategy == null || !strategy.generatesOnInsert() || !strategy.generatedOnExecution()) continue;
            return true;
        }
        return false;
    }

    public int[] getNaturalIdentifierProperties() {
        return this.naturalIdPropertyNumbers;
    }

    public boolean hasNaturalIdentifier() {
        return this.naturalIdPropertyNumbers != null;
    }

    public boolean isNaturalIdentifierCached() {
        return this.hasNaturalIdentifier() && this.hasCacheableNaturalId;
    }

    public boolean hasImmutableNaturalId() {
        return this.hasImmutableNaturalId;
    }

    public Set<String> getSubclassEntityNames() {
        return this.subclassEntityNames;
    }

    private static boolean indicatesCollection(Type type) {
        if (type.isCollectionType()) {
            return true;
        }
        if (type.isComponentType()) {
            Type[] subtypes;
            for (Type subtype : subtypes = ((CompositeType)type).getSubtypes()) {
                if (!EntityMetamodel.indicatesCollection(subtype)) continue;
                return true;
            }
        }
        return false;
    }

    private static boolean indicatesOwnedCollection(Type type, MetadataImplementor metadata) {
        if (type.isCollectionType()) {
            String role = ((CollectionType)type).getRole();
            return !metadata.getCollectionBinding(role).isInverse();
        }
        if (type.isComponentType()) {
            Type[] subtypes;
            for (Type subtype : subtypes = ((CompositeType)type).getSubtypes()) {
                if (!EntityMetamodel.indicatesOwnedCollection(subtype, metadata)) continue;
                return true;
            }
        }
        return false;
    }

    public SessionFactoryImplementor getSessionFactory() {
        return this.sessionFactory;
    }

    public String getName() {
        return this.name;
    }

    public String getRootName() {
        return this.rootName;
    }

    public int getSubclassId() {
        return this.subclassId;
    }

    public EntityType getEntityType() {
        if (this.entityType == null) {
            this.entityType = new ManyToOneType(this.name, this.getSessionFactory().getTypeConfiguration());
        }
        return this.entityType;
    }

    public IdentifierProperty getIdentifierProperty() {
        return this.identifierAttribute;
    }

    public int getPropertySpan() {
        return this.propertySpan;
    }

    public int getVersionPropertyIndex() {
        return this.versionPropertyIndex;
    }

    public VersionProperty getVersionProperty() {
        if (-66 == this.versionPropertyIndex) {
            return null;
        }
        return (VersionProperty)this.properties[this.versionPropertyIndex];
    }

    public NonIdentifierAttribute[] getProperties() {
        return this.properties;
    }

    public int getPropertyIndex(String propertyName) {
        Integer index = this.getPropertyIndexOrNull(propertyName);
        if (index == null) {
            throw new HibernateException("Unable to resolve property: " + propertyName);
        }
        return index;
    }

    public Integer getPropertyIndexOrNull(String propertyName) {
        return this.propertyIndexes.get(propertyName);
    }

    public boolean hasCollections() {
        return this.hasCollections;
    }

    public boolean hasOwnedCollections() {
        return this.hasOwnedCollections;
    }

    public boolean hasMutableProperties() {
        return !this.mutablePropertiesIndexes.isEmpty();
    }

    public BitSet getMutablePropertiesIndexes() {
        return this.mutablePropertiesIndexes;
    }

    public boolean hasNonIdentifierPropertyNamedId() {
        return this.hasNonIdentifierPropertyNamedId;
    }

    public boolean hasLazyProperties() {
        return this.hasLazyProperties;
    }

    public boolean hasCascades() {
        return this.hasCascades;
    }

    public boolean hasCascadeDelete() {
        return this.hasCascadeDelete;
    }

    public boolean isMutable() {
        return this.mutable;
    }

    public boolean isSelectBeforeUpdate() {
        return this.selectBeforeUpdate;
    }

    public boolean isDynamicUpdate() {
        return this.dynamicUpdate;
    }

    public boolean isDynamicInsert() {
        return this.dynamicInsert;
    }

    public OptimisticLockStyle getOptimisticLockStyle() {
        return this.optimisticLockStyle;
    }

    public boolean isPolymorphic() {
        return this.polymorphic;
    }

    public String getSuperclass() {
        return this.superclass;
    }

    public boolean isExplicitPolymorphism() {
        return this.explicitPolymorphism;
    }

    public boolean isInherited() {
        return this.inherited;
    }

    public boolean hasSubclasses() {
        return this.hasSubclasses;
    }

    public boolean isLazy() {
        return this.lazy;
    }

    public void setLazy(boolean lazy) {
        this.lazy = lazy;
    }

    public boolean isVersioned() {
        return this.versioned;
    }

    public boolean isAbstract() {
        return this.isAbstract;
    }

    public String findEntityNameByEntityClass(Class<?> inheritanceClass) {
        return this.entityNameByInheritanceClassMap.get(inheritanceClass);
    }

    public String toString() {
        return "EntityMetamodel(" + this.name + ":" + ArrayHelper.toString(this.properties) + ")";
    }

    public String[] getPropertyNames() {
        return this.propertyNames;
    }

    public Type[] getPropertyTypes() {
        return this.propertyTypes;
    }

    public boolean[] getPropertyLaziness() {
        return this.propertyLaziness;
    }

    public boolean[] getPropertyUpdateability() {
        return this.propertyUpdateability;
    }

    public boolean[] getPropertyCheckability() {
        return this.propertyCheckability;
    }

    public boolean[] getNonlazyPropertyUpdateability() {
        return this.nonlazyPropertyUpdateability;
    }

    public boolean[] getPropertyInsertability() {
        return this.propertyInsertability;
    }

    public boolean[] getPropertyNullability() {
        return this.propertyNullability;
    }

    public boolean[] getPropertyVersionability() {
        return this.propertyVersionability;
    }

    public CascadeStyle[] getCascadeStyles() {
        return this.cascadeStyles;
    }

    public boolean hasPreInsertGeneratedValues() {
        return this.hasPreInsertGeneratedValues;
    }

    public boolean hasPreUpdateGeneratedValues() {
        return this.hasPreUpdateGeneratedValues;
    }

    public boolean hasInsertGeneratedValues() {
        return this.hasInsertGeneratedValues;
    }

    public boolean hasUpdateGeneratedValues() {
        return this.hasUpdateGeneratedValues;
    }

    public boolean isInstrumented() {
        return this.bytecodeEnhancementMetadata.isEnhancedForLazyLoading();
    }

    public BytecodeEnhancementMetadata getBytecodeEnhancementMetadata() {
        return this.bytecodeEnhancementMetadata;
    }
}

