/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.io;

import org.jboss.as.controller.AbstractAddStepHandler;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.registry.Resource;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.wildfly.extension.io.IOExtension;
import org.wildfly.extension.io.IORootDefinition;
import org.wildfly.extension.io.MaxThreadTrackerService;
import org.wildfly.extension.io.WorkerAdd;

class IOSubsystemAdd
extends AbstractAddStepHandler {
    static final IOSubsystemAdd INSTANCE = new IOSubsystemAdd();

    private IOSubsystemAdd() {
    }

    protected void performRuntime(OperationContext context, ModelNode operation, Resource resource) throws OperationFailedException {
        ModelNode workers = Resource.Tools.readModel((Resource)resource).get(IOExtension.WORKER_PATH.getKey());
        WorkerAdd.checkWorkerConfiguration(context, workers);
        MaxThreadTrackerService service = new MaxThreadTrackerService();
        ServiceName serviceName = IORootDefinition.IO_MAX_THREADS_RUNTIME_CAPABILITY.getCapabilityServiceName();
        final ServiceController controller = context.getServiceTarget().addService(serviceName, (Service)service).setInitialMode(ServiceController.Mode.NEVER).install();
        context.addStep(new OperationStepHandler(){

            public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
                controller.setMode(ServiceController.Mode.ACTIVE);
                context.completeStep(OperationContext.RollbackHandler.NOOP_ROLLBACK_HANDLER);
            }
        }, OperationContext.Stage.RUNTIME);
    }
}

