/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.lucene.search.projection.impl;

import java.util.Arrays;
import org.hibernate.search.backend.lucene.search.common.impl.LuceneSearchIndexScope;
import org.hibernate.search.backend.lucene.search.extraction.impl.LuceneResult;
import org.hibernate.search.backend.lucene.search.projection.impl.AbstractLuceneProjection;
import org.hibernate.search.backend.lucene.search.projection.impl.LuceneSearchProjection;
import org.hibernate.search.backend.lucene.search.projection.impl.SearchProjectionExtractContext;
import org.hibernate.search.backend.lucene.search.projection.impl.SearchProjectionRequestContext;
import org.hibernate.search.backend.lucene.search.projection.impl.SearchProjectionTransformContext;
import org.hibernate.search.engine.search.loading.spi.LoadingResult;
import org.hibernate.search.engine.search.loading.spi.ProjectionHitMapper;
import org.hibernate.search.engine.search.projection.SearchProjection;
import org.hibernate.search.engine.search.projection.spi.CompositeProjectionBuilder;

abstract class AbstractLuceneCompositeProjection<P>
extends AbstractLuceneProjection<Object[], P> {
    private final LuceneSearchProjection<?, ?>[] children;

    AbstractLuceneCompositeProjection(LuceneSearchIndexScope<?> scope, LuceneSearchProjection<?, ?> ... children) {
        super(scope);
        this.children = children;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[children=" + Arrays.toString(this.children) + "]";
    }

    @Override
    public void request(SearchProjectionRequestContext context) {
        for (LuceneSearchProjection<?, ?> child : this.children) {
            child.request(context);
        }
    }

    @Override
    public final Object[] extract(ProjectionHitMapper<?, ?> mapper, LuceneResult documentResult, SearchProjectionExtractContext context) {
        Object[] extractedData = new Object[this.children.length];
        for (int i = 0; i < extractedData.length; ++i) {
            LuceneSearchProjection<?, ?> child = this.children[i];
            extractedData[i] = child.extract(mapper, documentResult, context);
        }
        return extractedData;
    }

    @Override
    public final P transform(LoadingResult<?, ?> loadingResult, Object[] extractedData, SearchProjectionTransformContext context) {
        for (int i = 0; i < extractedData.length; ++i) {
            LuceneSearchProjection<?, ?> child = this.children[i];
            Object extractedElement = extractedData[i];
            extractedData[i] = LuceneSearchProjection.transformUnsafe(child, loadingResult, extractedElement, context);
        }
        return this.doTransform(extractedData);
    }

    abstract P doTransform(Object[] var1);

    static class Builder<P>
    implements CompositeProjectionBuilder<P> {
        private final AbstractLuceneCompositeProjection<P> projection;

        Builder(AbstractLuceneCompositeProjection<P> projection) {
            this.projection = projection;
        }

        public SearchProjection<P> build() {
            return this.projection;
        }
    }
}

