/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.web.hotrod.session.fine;

import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import org.infinispan.client.hotrod.RemoteCache;
import org.wildfly.clustering.ee.Immutability;
import org.wildfly.clustering.ee.MutatorFactory;
import org.wildfly.clustering.ee.cache.CacheProperties;
import org.wildfly.clustering.ee.hotrod.RemoteCacheMap;
import org.wildfly.clustering.ee.hotrod.RemoteCacheMutatorFactory;
import org.wildfly.clustering.marshalling.spi.Marshaller;
import org.wildfly.clustering.web.cache.session.CompositeImmutableSession;
import org.wildfly.clustering.web.cache.session.ImmutableSessionAttributeActivationNotifier;
import org.wildfly.clustering.web.cache.session.SessionAttributeActivationNotifier;
import org.wildfly.clustering.web.cache.session.SessionAttributes;
import org.wildfly.clustering.web.cache.session.SessionAttributesFactory;
import org.wildfly.clustering.web.cache.session.fine.FineImmutableSessionAttributes;
import org.wildfly.clustering.web.cache.session.fine.FineSessionAttributes;
import org.wildfly.clustering.web.hotrod.logging.Logger;
import org.wildfly.clustering.web.hotrod.session.HotRodSessionAttributesFactoryConfiguration;
import org.wildfly.clustering.web.hotrod.session.fine.SessionAttributeKey;
import org.wildfly.clustering.web.hotrod.session.fine.SessionAttributeNamesKey;
import org.wildfly.clustering.web.session.HttpSessionActivationListenerProvider;
import org.wildfly.clustering.web.session.ImmutableSession;
import org.wildfly.clustering.web.session.ImmutableSessionAttributes;
import org.wildfly.clustering.web.session.ImmutableSessionMetaData;

public class FineSessionAttributesFactory<S, C, L, V>
implements SessionAttributesFactory<C, AtomicReference<Map<String, UUID>>> {
    private final RemoteCache<SessionAttributeNamesKey, Map<String, UUID>> namesCache;
    private final RemoteCache<SessionAttributeKey, V> attributeCache;
    private final Marshaller<Object, V> marshaller;
    private final Immutability immutability;
    private final CacheProperties properties;
    private final MutatorFactory<SessionAttributeKey, V> mutatorFactory;
    private final HttpSessionActivationListenerProvider<S, C, L> provider;

    public FineSessionAttributesFactory(HotRodSessionAttributesFactoryConfiguration<S, C, L, Object, V> configuration) {
        this.namesCache = configuration.getCache();
        this.attributeCache = configuration.getCache();
        this.marshaller = configuration.getMarshaller();
        this.immutability = configuration.getImmutability();
        this.properties = configuration.getCacheProperties();
        this.mutatorFactory = new RemoteCacheMutatorFactory(this.attributeCache);
        this.provider = configuration.getHttpSessionActivationListenerProvider();
    }

    public AtomicReference<Map<String, UUID>> createValue(String id, Void context) {
        return new AtomicReference<Map<String, UUID>>(Collections.emptyMap());
    }

    public AtomicReference<Map<String, UUID>> findValue(String id) {
        return this.getValue(id, true);
    }

    public AtomicReference<Map<String, UUID>> tryValue(String id) {
        return this.getValue(id, false);
    }

    private AtomicReference<Map<String, UUID>> getValue(String id, boolean purgeIfInvalid) {
        Map names = (Map)this.namesCache.get((Object)new SessionAttributeNamesKey(id));
        if (names != null) {
            HashMap<SessionAttributeKey, String> attributes = new HashMap<SessionAttributeKey, String>();
            for (Map.Entry entry : names.entrySet()) {
                attributes.put(new SessionAttributeKey(id, (UUID)entry.getValue()), (String)entry.getKey());
            }
            Map entries = this.attributeCache.getAll(attributes.keySet());
            for (Map.Entry attribute : attributes.entrySet()) {
                Object value = entries.get(attribute.getKey());
                if (value != null) {
                    try {
                        this.marshaller.read(value);
                        continue;
                    }
                    catch (IOException e) {
                        Logger.ROOT_LOGGER.failedToActivateSessionAttribute(e, id, (String)attribute.getValue());
                    }
                } else {
                    Logger.ROOT_LOGGER.missingSessionAttributeCacheEntry(id, (String)attribute.getValue());
                }
                if (purgeIfInvalid) {
                    this.purge(id);
                }
                return null;
            }
            return new AtomicReference<Map<String, UUID>>(names);
        }
        return new AtomicReference<Map<String, UUID>>(Collections.emptyMap());
    }

    public boolean remove(String id) {
        SessionAttributeNamesKey key = new SessionAttributeNamesKey(id);
        Map names = (Map)this.namesCache.get((Object)key);
        if (names != null) {
            for (UUID attributeId : names.values()) {
                this.attributeCache.remove((Object)new SessionAttributeKey(id, attributeId));
            }
            this.namesCache.remove((Object)key);
        }
        return true;
    }

    public SessionAttributes createSessionAttributes(String id, AtomicReference<Map<String, UUID>> names, ImmutableSessionMetaData metaData, C context) {
        ImmutableSessionAttributeActivationNotifier notifier = new ImmutableSessionAttributeActivationNotifier(this.provider, (ImmutableSession)new CompositeImmutableSession(id, metaData, this.createImmutableSessionAttributes(id, names)), context);
        return new FineSessionAttributes((Object)new SessionAttributeNamesKey(id), names, this.namesCache, FineSessionAttributesFactory.getKeyFactory(id), (Map)new RemoteCacheMap(this.attributeCache), this.marshaller, this.mutatorFactory, this.immutability, this.properties, (SessionAttributeActivationNotifier)notifier);
    }

    public ImmutableSessionAttributes createImmutableSessionAttributes(String id, AtomicReference<Map<String, UUID>> names) {
        return new FineImmutableSessionAttributes(names, FineSessionAttributesFactory.getKeyFactory(id), this.attributeCache, this.marshaller);
    }

    private static Function<UUID, SessionAttributeKey> getKeyFactory(final String id) {
        return new Function<UUID, SessionAttributeKey>(){

            @Override
            public SessionAttributeKey apply(UUID attributeId) {
                return new SessionAttributeKey(id, attributeId);
            }
        };
    }
}

