/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.controller.audit;

import java.io.IOException;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.audit.AuditLogHandler;
import org.jboss.as.controller.audit.AuditLogItem;
import org.jboss.as.controller.audit.AuditLogItemFormatter;
import org.jboss.as.controller.audit.AuditLogger;
import org.jboss.as.controller.audit.InMemoryAuditLogHandler;
import org.jboss.as.controller.audit.JsonAuditLogItemFormatter;
import org.jboss.as.controller.audit.ManagedAuditLogger;
import org.jboss.as.controller.audit.SyslogAuditLogHandler;
import org.jboss.as.controller.logging.ControllerLogger;
import org.jboss.as.controller.operations.common.Util;
import org.jboss.as.controller.registry.Resource;
import org.jboss.as.core.security.AccessMechanism;
import org.jboss.dmr.ModelNode;

public class ManagedAuditLoggerImpl
implements ManagedAuditLogger,
ManagedAuditLogger.AuditLogHandlerUpdater {
    private static final short MAX_FAILURE_COUNT = 10;
    private final List<ManagedAuditLoggerImpl> childImpls;
    private final ManagedAuditLogConfiguration config;
    private HandlerUpdateTask handlerUpdateTask;
    private final List<AuditLogItem> queuedItems = new ArrayList<AuditLogItem>();
    private short failureCount;
    private final AtomicBoolean runDisabledFastPath = new AtomicBoolean(false);

    public ManagedAuditLoggerImpl(String asVersion, boolean server) {
        this.config = new CoreAuditLogConfiguration(asVersion, server);
        this.childImpls = new ArrayList<ManagedAuditLoggerImpl>();
    }

    private ManagedAuditLoggerImpl(ManagedAuditLoggerImpl src, boolean manualCommit) {
        assert (src.config instanceof CoreAuditLogConfiguration) : "Not an instance of CoreAuditLogConfiguration";
        this.config = new NewAuditLogConfiguration((CoreAuditLogConfiguration)src.config, manualCommit);
        this.childImpls = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void log(boolean readOnly, OperationContext.ResultAction resultAction, String userId, String domainUUID, AccessMechanism accessMechanism, InetAddress remoteAddress, Resource resultantModel, List<ModelNode> operations) {
        if (this.runDisabledFastPath.get()) {
            return;
        }
        this.config.lock();
        try {
            if (this.skipLogging(readOnly)) {
                return;
            }
            this.storeLogItem(AuditLogItem.createModelControllerItem(this.config.getAsVersion(), readOnly, this.config.isBooting(), resultAction, userId, domainUUID, accessMechanism, remoteAddress, resultantModel, operations));
        }
        catch (Exception e) {
            this.handleLoggingException(e);
        }
        finally {
            this.applyHandlerUpdates();
            this.config.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void logJmxMethodAccess(boolean readOnly, String userId, String domainUUID, AccessMechanism accessMechanism, InetAddress remoteAddress, String methodName, String[] methodSignature, Object[] methodParams, Throwable error) {
        if (this.runDisabledFastPath.get()) {
            return;
        }
        this.config.lock();
        try {
            if (this.skipLogging(readOnly)) {
                return;
            }
            this.storeLogItem(AuditLogItem.createMethodAccessItem(this.config.getAsVersion(), readOnly, this.config.isBooting(), userId, domainUUID, accessMechanism, remoteAddress, methodName, methodSignature, methodParams, error));
        }
        catch (Exception e) {
            this.handleLoggingException(e);
        }
        finally {
            this.applyHandlerUpdates();
            this.config.unlock();
        }
    }

    private boolean skipLogging(boolean readOnly) {
        if (this.config.isBooting() && !this.isLogBoot() || readOnly && !this.isLogReadOnly()) {
            if (this.getLoggerStatus() == AuditLogger.Status.DISABLED) {
                this.runDisabledFastPath.set(true);
            }
            return true;
        }
        return false;
    }

    @Override
    public ManagedAuditLoggerImpl createNewConfiguration(boolean manualCommit) {
        if (this.childImpls == null) {
            throw ControllerLogger.ROOT_LOGGER.canOnlyCreateChildAuditLoggerForMainAuditLogger();
        }
        ManagedAuditLoggerImpl child = new ManagedAuditLoggerImpl(this, manualCommit);
        this.childImpls.add(child);
        return child;
    }

    @Override
    public boolean isLogReadOnly() {
        this.config.lock();
        try {
            boolean bl = this.config.isLogReadOnly();
            return bl;
        }
        finally {
            this.config.unlock();
        }
    }

    @Override
    public void setLogReadOnly(boolean logReadOnly) {
        this.config.lock();
        try {
            this.config.setLogReadOnly(logReadOnly);
        }
        finally {
            this.config.unlock();
        }
    }

    @Override
    public boolean isLogBoot() {
        this.config.lock();
        try {
            boolean bl = this.config.isLogBoot();
            return bl;
        }
        finally {
            this.config.unlock();
        }
    }

    @Override
    public void setLogBoot(boolean logBoot) {
        this.config.lock();
        try {
            this.config.setLogBoot(logBoot);
            if (!logBoot && this.config.isBooting() && !this.config.isLogBoot()) {
                this.queuedItems.clear();
            }
        }
        finally {
            this.config.unlock();
        }
    }

    @Override
    public AuditLogger.Status getLoggerStatus() {
        this.config.lock();
        try {
            AuditLogger.Status status = this.config.getLoggerStatus();
            return status;
        }
        finally {
            this.config.unlock();
        }
    }

    @Override
    public void recycleHandler(String name) {
        this.config.lock();
        try {
            this.config.recycleHandler(name);
        }
        finally {
            this.config.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setLoggerStatus(AuditLogger.Status newStatus) {
        this.config.lock();
        try {
            if (newStatus == AuditLogger.Status.DISABLE_NEXT && this.config.getLoggerStatus() == AuditLogger.Status.DISABLED) {
                return;
            }
            this.config.setLoggerStatus(newStatus);
            if (newStatus == AuditLogger.Status.LOGGING) {
                for (AuditLogItem record : this.queuedItems) {
                    try {
                        this.writeLogItem(record);
                    }
                    catch (Exception e) {
                        this.handleLoggingException(e);
                    }
                }
                this.queuedItems.clear();
            } else if (newStatus == AuditLogger.Status.DISABLED) {
                this.queuedItems.clear();
            }
            this.runDisabledFastPath.set(false);
        }
        finally {
            this.config.unlock();
        }
    }

    private void storeLogItem(AuditLogItem item) throws IOException {
        switch (this.getLoggerStatus()) {
            case QUEUEING: {
                this.queuedItems.add(item);
                break;
            }
            case LOGGING: {
                this.writeLogItem(item);
                break;
            }
            case DISABLE_NEXT: {
                this.writeLogItem(item);
                this.config.setLoggerStatus(AuditLogger.Status.DISABLED);
            }
            case DISABLED: {
                this.runDisabledFastPath.set(true);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeLogItem(AuditLogItem item) throws IOException {
        HashSet<String> formatterNames = new HashSet<String>();
        try {
            for (AuditLogHandler handler : this.config.getHandlersForLogging()) {
                formatterNames.add(handler.getFormatterName());
                handler.writeLogItem(item);
            }
        }
        finally {
            for (String formatterName : formatterNames) {
                this.config.getFormatter(formatterName).clear();
            }
        }
    }

    private void handleLoggingException(Exception e) {
        ControllerLogger.MGMT_OP_LOGGER.failedToUpdateAuditLog(e);
        this.failureCount = (short)(this.failureCount + 1);
        if (this.failureCount == 10) {
            this.setLoggerStatus(AuditLogger.Status.DISABLED);
            ControllerLogger.MGMT_OP_LOGGER.disablingLoggingDueToFailures(this.failureCount);
        }
    }

    @Override
    public ManagedAuditLogger.AuditLogHandlerUpdater getUpdater() {
        return this;
    }

    @Override
    public void addHandler(AuditLogHandler handler) {
        this.config.lock();
        try {
            if (this.handlerUpdateTask == null) {
                this.handlerUpdateTask = new HandlerUpdateTask();
            }
            this.handlerUpdateTask.addHandler(handler);
            this.runDisabledFastPath.set(false);
        }
        finally {
            this.config.unlock();
        }
    }

    @Override
    public void updateHandler(AuditLogHandler handler) {
        this.config.lock();
        try {
            AuditLogHandler existing = this.config.getConfiguredHandler(handler.getName());
            if (handler.isDifferent(existing)) {
                if (this.handlerUpdateTask == null) {
                    this.handlerUpdateTask = new HandlerUpdateTask();
                }
                this.handlerUpdateTask.replaceHandler(handler);
                this.runDisabledFastPath.set(false);
            }
        }
        finally {
            this.config.unlock();
        }
    }

    @Override
    public void removeHandler(String name) {
        this.config.lock();
        try {
            if (this.handlerUpdateTask == null) {
                this.handlerUpdateTask = new HandlerUpdateTask();
            }
            this.handlerUpdateTask.removeHandler(name);
            this.runDisabledFastPath.set(false);
        }
        finally {
            this.config.unlock();
        }
    }

    @Override
    public void addHandlerReference(PathAddress referenceAddress) {
        this.config.lock();
        try {
            if (this.handlerUpdateTask == null) {
                this.handlerUpdateTask = new HandlerUpdateTask();
            }
            this.handlerUpdateTask.addHandlerReference(referenceAddress);
            this.runDisabledFastPath.set(false);
        }
        finally {
            this.config.unlock();
        }
    }

    @Override
    public void removeHandlerReference(PathAddress referenceAddress) {
        this.config.lock();
        try {
            if (this.handlerUpdateTask == null) {
                this.handlerUpdateTask = new HandlerUpdateTask();
            }
            this.handlerUpdateTask.removeHandlerReference(referenceAddress);
            this.runDisabledFastPath.set(false);
        }
        finally {
            this.config.unlock();
        }
    }

    @Override
    public void rollbackChanges() {
        this.config.lock();
        try {
            if (this.handlerUpdateTask != null) {
                this.handlerUpdateTask.rollbackChanges();
                this.handlerUpdateTask = null;
            }
        }
        finally {
            this.config.unlock();
        }
    }

    @Override
    public void applyChanges() {
        this.config.lock();
        try {
            if (!this.config.isManualCommit()) {
                throw new IllegalStateException("Attempt was made to manually apply changes when manual commit was not configured");
            }
            this.applyHandlerUpdates();
        }
        finally {
            this.config.unlock();
        }
    }

    private void applyHandlerUpdates() {
        if (this.handlerUpdateTask != null) {
            this.handlerUpdateTask.applyChanges();
            this.handlerUpdateTask = null;
        }
    }

    @Override
    public void removeFormatter(String name) {
        this.config.lock();
        try {
            this.config.removeFormatter(name);
        }
        finally {
            this.config.unlock();
        }
    }

    @Override
    public void addFormatter(AuditLogItemFormatter formatter) {
        this.config.lock();
        try {
            this.config.addFormatter(formatter);
        }
        finally {
            this.config.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateHandlerFormatter(String name, String formatterName) {
        this.config.lock();
        try {
            AuditLogHandler handler = this.config.getConfiguredHandler(name);
            handler.setFormatterName(formatterName);
            handler.setFormatter(this.config.getFormatter(formatterName));
        }
        finally {
            this.config.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateHandlerMaxFailureCount(String name, int count) {
        this.config.lock();
        try {
            AuditLogHandler handler = this.config.getConfiguredHandler(name);
            handler.setMaxFailureCount(count);
        }
        finally {
            this.config.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getHandlerFailureCount(String name) {
        this.config.lock();
        try {
            AuditLogHandler handler = this.config.getConfiguredHandler(name);
            int n = handler.getFailureCount();
            return n;
        }
        finally {
            this.config.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateSyslogHandlerFacility(String name, SyslogAuditLogHandler.Facility facility) {
        this.config.lock();
        try {
            SyslogAuditLogHandler handler = (SyslogAuditLogHandler)this.config.getConfiguredHandler(name);
            handler.setFacility(facility);
        }
        finally {
            this.config.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateSyslogHandlerAppName(String name, String appName) {
        this.config.lock();
        try {
            SyslogAuditLogHandler handler = (SyslogAuditLogHandler)this.config.getConfiguredHandler(name);
            handler.setAppName(appName);
        }
        finally {
            this.config.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateSyslogHandlerReconnectTimeout(String name, int reconnectTimeout) {
        this.config.lock();
        try {
            SyslogAuditLogHandler handler = (SyslogAuditLogHandler)this.config.getConfiguredHandler(name);
            handler.setReconnectTimeout(reconnectTimeout);
        }
        finally {
            this.config.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean getHandlerDisabledDueToFailure(String name) {
        this.config.lock();
        try {
            AuditLogHandler handler = this.config.getConfiguredHandler(name);
            boolean bl = handler.isDisabledDueToFailures();
            return bl;
        }
        finally {
            this.config.unlock();
        }
    }

    @Override
    public JsonAuditLogItemFormatter getJsonFormatter(String name) {
        this.config.lock();
        try {
            JsonAuditLogItemFormatter jsonAuditLogItemFormatter = (JsonAuditLogItemFormatter)this.config.getFormatter(name);
            return jsonAuditLogItemFormatter;
        }
        finally {
            this.config.unlock();
        }
    }

    @Override
    public List<ModelNode> listLastEntries(String name) {
        this.config.lock();
        try {
            List<ModelNode> list = this.config.getConfiguredHandler(name).listLastEntries();
            return list;
        }
        finally {
            this.config.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateInMemoryHandlerMaxHistory(String name, int maxHistory) {
        this.config.lock();
        try {
            InMemoryAuditLogHandler handler = (InMemoryAuditLogHandler)this.config.getConfiguredHandler(name);
            handler.setMaxHistory(maxHistory);
        }
        finally {
            this.config.unlock();
        }
    }

    @Override
    public void bootDone() {
        this.config.lock();
        try {
            this.config.setBooting(false);
            if (this.childImpls != null) {
                for (ManagedAuditLogger managedAuditLogger : this.childImpls) {
                    managedAuditLogger.bootDone();
                }
            }
            if (this.config.getLoggerStatus() == AuditLogger.Status.QUEUEING) {
                this.setLoggerStatus(AuditLogger.Status.DISABLED);
            }
        }
        finally {
            this.config.unlock();
        }
    }

    @Override
    public void startBoot() {
        this.config.lock();
        try {
            this.config.setBooting(true);
            if (this.childImpls != null) {
                this.childImpls.clear();
            }
            this.config.setLoggerStatus(AuditLogger.Status.QUEUEING);
        }
        finally {
            this.config.unlock();
        }
    }

    private class HandlerUpdateTask {
        private Map<String, AuditLogHandler> addedHandlers;
        private Map<String, AuditLogHandler> replacedHandlers;
        private Set<String> removedHandlers;
        private Set<PathAddress> addedReferences;
        private Set<PathAddress> removedReferences;
        private Map<String, String> updatedFormatters;

        private HandlerUpdateTask() {
        }

        void addHandler(AuditLogHandler handler) {
            assert (ManagedAuditLoggerImpl.this.config.isCore()) : "Not available for non-core configuration";
            if (this.removedHandlers != null && this.removedHandlers.contains(handler.getName())) {
                throw ControllerLogger.ROOT_LOGGER.attemptToBothRemoveAndAddHandlerUpdateInstead();
            }
            if (this.addedHandlers == null) {
                this.addedHandlers = new HashMap<String, AuditLogHandler>();
            }
            this.addedHandlers.put(handler.getName(), handler);
            ManagedAuditLoggerImpl.this.config.putConfiguredHandler(handler);
            handler.setFormatter(ManagedAuditLoggerImpl.this.config.getFormatter(handler.getFormatterName()));
        }

        void replaceHandler(AuditLogHandler handler) {
            assert (ManagedAuditLoggerImpl.this.config.isCore()) : "Not available for non-core configuration";
            if (this.addedHandlers != null && this.addedHandlers.containsKey(handler.getName())) {
                this.addHandler(handler);
                return;
            }
            if (this.replacedHandlers == null) {
                this.replacedHandlers = new HashMap<String, AuditLogHandler>();
            }
            this.replacedHandlers.put(handler.getName(), handler);
        }

        void removeHandler(String name) {
            Set<PathAddress> references;
            assert (ManagedAuditLoggerImpl.this.config.isCore()) : "Not available for non-core configuration";
            if (this.addedHandlers != null && this.addedHandlers.containsKey(name)) {
                throw ControllerLogger.ROOT_LOGGER.attemptToBothAddAndRemoveAndHandlerFromCompositeOperation();
            }
            if (this.replacedHandlers != null && this.replacedHandlers.containsKey(name)) {
                throw ControllerLogger.ROOT_LOGGER.attemptToBothUpdateAndRemoveHandlerFromCompositeOperation();
            }
            AuditLogHandler handler = ManagedAuditLoggerImpl.this.config.getConfiguredHandler(name);
            if (handler != null && !(references = handler.getReferences()).isEmpty() && !references.containsAll(this.removedReferences)) {
                HashSet<PathAddress> activeReferences = new HashSet<PathAddress>(references);
                activeReferences.removeAll(this.removedReferences);
                throw ControllerLogger.ROOT_LOGGER.handlerIsReferencedBy(this.removedReferences);
            }
            ManagedAuditLoggerImpl.this.config.removeConfiguredHandler(name);
            if (this.removedHandlers == null) {
                this.removedHandlers = new HashSet<String>();
            }
            this.removedHandlers.add(name);
        }

        void addHandlerReference(PathAddress referenceAddress) {
            if (this.removedReferences != null && this.removedReferences.contains(referenceAddress)) {
                throw ControllerLogger.ROOT_LOGGER.attemptToBothRemoveAndAddHandlerReferenceFromCompositeOperation();
            }
            if (this.addedReferences == null) {
                this.addedReferences = new HashSet<PathAddress>();
            }
            this.addedReferences.add(referenceAddress);
            ManagedAuditLoggerImpl.this.config.addHandlerReference(Util.getNameFromAddress(referenceAddress));
            String name = Util.getNameFromAddress(referenceAddress);
            AuditLogHandler handler = ManagedAuditLoggerImpl.this.config.getConfiguredHandler(name);
            if (handler == null) {
                throw ControllerLogger.ROOT_LOGGER.noHandlerCalled(name);
            }
            handler.addReference(referenceAddress);
        }

        void removeHandlerReference(PathAddress address) {
            if (this.addedReferences != null && this.addedReferences.contains(address)) {
                throw ControllerLogger.ROOT_LOGGER.attemptToBothRemoveAndAddHandlerReferenceFromCompositeOperation();
            }
            if (this.removedReferences == null) {
                this.removedReferences = new HashSet<PathAddress>();
            }
            this.removedReferences.add(address);
        }

        void rollbackChanges() {
            if (this.addedReferences != null && !this.addedReferences.isEmpty()) {
                for (PathAddress address : this.addedReferences) {
                    String name = Util.getNameFromAddress(address);
                    ManagedAuditLoggerImpl.this.config.removeHandlerReference(name);
                    AuditLogHandler handler = ManagedAuditLoggerImpl.this.config.getConfiguredHandler(name);
                    if (handler == null) continue;
                    handler.removeReference(address);
                }
            }
            if (this.addedHandlers != null && this.addedHandlers.size() > 0) {
                for (AuditLogHandler handler : this.addedHandlers.values()) {
                    ManagedAuditLoggerImpl.this.config.removeConfiguredHandler(handler.getName());
                }
            }
        }

        void applyChanges() {
            if (this.removedHandlers != null && !this.removedHandlers.isEmpty()) {
                for (String name : this.removedHandlers) {
                    AuditLogHandler handler = ManagedAuditLoggerImpl.this.config.removeConfiguredHandler(name);
                    if (handler == null) continue;
                    handler.stop();
                }
            }
            if (this.replacedHandlers != null && this.replacedHandlers.size() > 0) {
                for (AuditLogHandler handler : this.replacedHandlers.values()) {
                    AuditLogHandler existing = ManagedAuditLoggerImpl.this.config.removeConfiguredHandler(handler.getName());
                    if (existing != null) {
                        existing.stop();
                        for (PathAddress referenceAddress : existing.getReferences()) {
                            if (this.removedReferences == null || this.removedReferences.contains(referenceAddress)) continue;
                            handler.addReference(referenceAddress);
                        }
                    }
                    ManagedAuditLoggerImpl.this.config.putConfiguredHandler(handler);
                    handler.setFormatter(ManagedAuditLoggerImpl.this.config.getFormatter(handler.getFormatterName()));
                }
            }
            if (this.removedReferences != null && !this.removedReferences.isEmpty()) {
                for (PathAddress referenceAddress : this.removedReferences) {
                    String name = Util.getNameFromAddress(referenceAddress);
                    AuditLogHandler handler = ManagedAuditLoggerImpl.this.config.getConfiguredHandler(name);
                    if (handler != null) {
                        handler.removeReference(referenceAddress);
                    }
                    ManagedAuditLoggerImpl.this.config.removeHandlerReference(name);
                }
            }
        }
    }

    private static class SharedConfiguration {
        private final Lock auditLock = new ReentrantLock(true);
        private final String asVersion;
        private final boolean server;
        private final Map<String, AuditLogItemFormatter> formatters = new HashMap<String, AuditLogItemFormatter>();
        private final Map<String, AuditLogHandler> configuredHandlers = new HashMap<String, AuditLogHandler>();
        private boolean booting = true;

        SharedConfiguration(String asVersion, boolean server) {
            this.asVersion = asVersion;
            this.server = server;
        }

        public void recycleHandler(String name) {
            AuditLogHandler handler = this.configuredHandlers.get(name);
            handler.recycle();
        }

        void lock() {
            this.auditLock.lock();
        }

        void unlock() {
            this.auditLock.unlock();
        }

        String getAsVersion() {
            return this.asVersion;
        }

        boolean isServer() {
            return this.server;
        }

        Map<String, AuditLogHandler> getConfiguredHandlers() {
            return this.configuredHandlers;
        }

        AuditLogItemFormatter getFormatter(String name) {
            return this.formatters.get(name);
        }

        void addFormatter(AuditLogItemFormatter formatter) {
            this.formatters.put(formatter.getName(), formatter);
        }

        void removeFormatter(String name) {
            this.formatters.remove(name);
        }

        AuditLogHandler getConfiguredHandler(String name) {
            return this.configuredHandlers.get(name);
        }

        void putConfiguredHandler(AuditLogHandler handler) {
            this.configuredHandlers.put(handler.getName(), handler);
        }

        AuditLogHandler removeConfiguredHandler(String name) {
            return this.configuredHandlers.remove(name);
        }

        void setBooting(boolean booting) {
            this.booting = booting;
        }

        boolean isBooting() {
            return this.booting;
        }
    }

    private static class NewAuditLogConfiguration
    extends ManagedAuditLogConfiguration {
        NewAuditLogConfiguration(CoreAuditLogConfiguration core, boolean manualCommit) {
            super(core.sharedConfiguration, false, manualCommit);
        }

        @Override
        void putConfiguredHandler(AuditLogHandler handler) {
            throw new IllegalStateException("Only available in core configuration");
        }

        @Override
        AuditLogHandler removeConfiguredHandler(String name) {
            throw new IllegalStateException("Only available in core configuration");
        }

        @Override
        void addFormatter(AuditLogItemFormatter formatter) {
            throw new IllegalStateException("Only available in core configuration");
        }

        @Override
        void removeFormatter(String name) {
            throw new IllegalStateException("Only available in core configuration");
        }

        @Override
        void recycleHandler(String name) {
            throw new IllegalStateException("Only available in core configuration");
        }
    }

    private static class CoreAuditLogConfiguration
    extends ManagedAuditLogConfiguration {
        CoreAuditLogConfiguration(String asVersion, boolean server) {
            super(new SharedConfiguration(asVersion, server), true, false);
        }

        @Override
        void putConfiguredHandler(AuditLogHandler handler) {
            this.sharedConfiguration.putConfiguredHandler(handler);
        }

        @Override
        AuditLogHandler removeConfiguredHandler(String name) {
            return this.sharedConfiguration.removeConfiguredHandler(name);
        }

        @Override
        void addFormatter(AuditLogItemFormatter formatter) {
            this.sharedConfiguration.addFormatter(formatter);
        }

        @Override
        void removeFormatter(String name) {
            this.sharedConfiguration.removeFormatter(name);
        }

        @Override
        void recycleHandler(String name) {
            this.sharedConfiguration.recycleHandler(name);
        }
    }

    static abstract class ManagedAuditLogConfiguration {
        final boolean manualCommit;
        final boolean core;
        final SharedConfiguration sharedConfiguration;
        private volatile AuditLogger.Status status = AuditLogger.Status.QUEUEING;
        private volatile boolean logBoot = true;
        private volatile boolean logReadOnly;
        protected final Set<String> handlerReferences = Collections.synchronizedSet(new HashSet());

        ManagedAuditLogConfiguration(SharedConfiguration sharedConfiguration, boolean core, boolean manualCommit) {
            this.sharedConfiguration = sharedConfiguration;
            this.core = core;
            this.manualCommit = manualCommit;
        }

        boolean isManualCommit() {
            return this.manualCommit;
        }

        boolean hasHandlerReference(String name) {
            return this.handlerReferences.contains(name);
        }

        void addHandlerReference(String name) {
            this.handlerReferences.add(name);
        }

        void removeHandlerReference(String name) {
            this.handlerReferences.remove(name);
        }

        List<AuditLogHandler> getHandlersForLogging() {
            ArrayList<AuditLogHandler> list = new ArrayList<AuditLogHandler>();
            for (Map.Entry<String, AuditLogHandler> handlerEntry : this.sharedConfiguration.getConfiguredHandlers().entrySet()) {
                if (!handlerEntry.getValue().isActive() || !this.hasHandlerReference(handlerEntry.getKey())) continue;
                list.add(handlerEntry.getValue());
            }
            return list;
        }

        void lock() {
            this.sharedConfiguration.lock();
        }

        void unlock() {
            this.sharedConfiguration.unlock();
        }

        String getAsVersion() {
            return this.sharedConfiguration.getAsVersion();
        }

        boolean isServer() {
            return this.sharedConfiguration.isServer();
        }

        AuditLogItemFormatter getFormatter(String name) {
            return this.sharedConfiguration.getFormatter(name);
        }

        AuditLogHandler getConfiguredHandler(String name) {
            return this.sharedConfiguration.getConfiguredHandler(name);
        }

        void setBooting(boolean booting) {
            this.sharedConfiguration.setBooting(booting);
        }

        boolean isBooting() {
            return this.sharedConfiguration.isBooting();
        }

        boolean isLogReadOnly() {
            return this.logReadOnly;
        }

        void setLogReadOnly(boolean logReadOnly) {
            this.logReadOnly = logReadOnly;
        }

        boolean isLogBoot() {
            return this.logBoot;
        }

        void setLogBoot(boolean logBoot) {
            this.logBoot = logBoot;
        }

        AuditLogger.Status getLoggerStatus() {
            return this.status;
        }

        void setLoggerStatus(AuditLogger.Status newStatus) {
            this.status = newStatus;
        }

        boolean isCore() {
            return this.core;
        }

        abstract void putConfiguredHandler(AuditLogHandler var1);

        abstract AuditLogHandler removeConfiguredHandler(String var1);

        abstract void addFormatter(AuditLogItemFormatter var1);

        abstract void removeFormatter(String var1);

        abstract void recycleHandler(String var1);
    }
}

