/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.elasticsearch.gson.impl;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.Optional;
import java.util.function.Supplier;
import org.hibernate.search.backend.elasticsearch.gson.impl.AbstractNonRootJsonAccessor;
import org.hibernate.search.backend.elasticsearch.gson.impl.JsonAccessor;
import org.hibernate.search.backend.elasticsearch.gson.impl.JsonElementType;
import org.hibernate.search.backend.elasticsearch.gson.impl.JsonElementTypes;
import org.hibernate.search.backend.elasticsearch.gson.impl.UnexpectedJsonElementTypeException;

abstract class AbstractTypingJsonAccessor<T>
extends AbstractNonRootJsonAccessor<JsonElement, T> {
    public AbstractTypingJsonAccessor(JsonAccessor<JsonElement> parentAccessor) {
        super(parentAccessor);
    }

    @Override
    public Optional<T> get(JsonObject root) {
        return this.getParentAccessor().get(root).map(this::fromElement);
    }

    @Override
    public void set(JsonObject root, T newValue) {
        this.getParentAccessor().set(root, this.toElement(newValue));
    }

    @Override
    public T getOrCreate(JsonObject root, Supplier<? extends T> newValueSupplier) {
        return this.fromElement(this.getParentAccessor().getOrCreate(root, () -> this.toElement(newValueSupplier.get())));
    }

    private T fromElement(JsonElement parent) {
        JsonElementType<T> expectedType = this.getExpectedElementType();
        if (parent == null || parent.isJsonNull()) {
            return null;
        }
        if (!expectedType.isInstance(parent)) {
            if (JsonElementTypes.ARRAY.isInstance(parent)) {
                JsonArray parentAsArray = JsonElementTypes.ARRAY.fromElement(parent);
                int parentSize = parentAsArray.size();
                if (parentSize == 0) {
                    return null;
                }
                if (parentSize == 1) {
                    return this.fromElement(parentAsArray.get(0));
                }
            }
            throw new UnexpectedJsonElementTypeException(this, expectedType, parent);
        }
        return expectedType.fromElement(parent);
    }

    protected JsonElement toElement(T value) {
        return this.getExpectedElementType().toElement(value);
    }

    protected abstract JsonElementType<T> getExpectedElementType();

    @Override
    protected void appendRuntimeRelativePath(StringBuilder path) {
        path.append('(').append(this.getExpectedElementType()).append(')');
    }

    @Override
    protected void appendStaticRelativePath(StringBuilder path, boolean first) {
    }
}

