/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.elasticsearch.search.query.impl;

import com.google.gson.JsonObject;
import java.util.Map;
import java.util.Optional;
import org.hibernate.search.backend.elasticsearch.gson.impl.JsonAccessor;
import org.hibernate.search.backend.elasticsearch.search.aggregation.impl.ElasticsearchSearchAggregation;
import org.hibernate.search.backend.elasticsearch.search.projection.impl.ElasticsearchSearchProjection;
import org.hibernate.search.backend.elasticsearch.search.query.impl.Elasticsearch7SearchResultExtractor;
import org.hibernate.search.backend.elasticsearch.search.query.impl.ElasticsearchSearchQueryRequestContext;
import org.hibernate.search.engine.search.aggregation.AggregationKey;
import org.hibernate.search.engine.search.query.SearchResultTotal;
import org.hibernate.search.engine.search.query.spi.SimpleSearchResultTotal;

class Elasticsearch56SearchResultExtractor<H>
extends Elasticsearch7SearchResultExtractor<H> {
    private static final JsonAccessor<Long> HITS_TOTAL_ACCESSOR = HITS_ACCESSOR.property("total").asLong();

    Elasticsearch56SearchResultExtractor(ElasticsearchSearchQueryRequestContext requestContext, ElasticsearchSearchProjection<?, H> rootProjection, Map<AggregationKey<?>, ElasticsearchSearchAggregation<?>> aggregations) {
        super(requestContext, rootProjection, aggregations);
    }

    @Override
    protected SearchResultTotal extractTotal(JsonObject responseBody) {
        Optional<Long> hitsTotal = HITS_TOTAL_ACCESSOR.get(responseBody);
        return hitsTotal.isPresent() ? SimpleSearchResultTotal.exact((long)hitsTotal.get()) : SimpleSearchResultTotal.lowerBound((long)0L);
    }
}

