/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb.protocol.remote;

import jakarta.ejb.CreateException;
import jakarta.ejb.EJBException;
import jakarta.ejb.NoSuchEJBException;
import jakarta.transaction.InvalidTransactionException;
import jakarta.transaction.RollbackException;
import jakarta.transaction.SystemException;
import jakarta.transaction.Transaction;
import java.io.Closeable;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Method;
import java.net.InetSocketAddress;
import java.net.URI;
import java.nio.channels.ClosedChannelException;
import java.nio.charset.StandardCharsets;
import java.security.PrivilegedActionException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.zip.Deflater;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.InflaterInputStream;
import javax.transaction.xa.Xid;
import org.jboss.ejb._private.Keys;
import org.jboss.ejb._private.Logs;
import org.jboss.ejb.client.AbstractInvocationContext;
import org.jboss.ejb.client.Affinity;
import org.jboss.ejb.client.AttachmentKey;
import org.jboss.ejb.client.AttachmentKeys;
import org.jboss.ejb.client.ClusterAffinity;
import org.jboss.ejb.client.EJBClient;
import org.jboss.ejb.client.EJBClientContext;
import org.jboss.ejb.client.EJBClientInvocationContext;
import org.jboss.ejb.client.EJBLocator;
import org.jboss.ejb.client.EJBModuleIdentifier;
import org.jboss.ejb.client.EJBReceiverInvocationContext;
import org.jboss.ejb.client.EJBSessionCreationInvocationContext;
import org.jboss.ejb.client.NodeAffinity;
import org.jboss.ejb.client.RequestSendFailedException;
import org.jboss.ejb.client.SessionID;
import org.jboss.ejb.client.StatefulEJBLocator;
import org.jboss.ejb.client.StatelessEJBLocator;
import org.jboss.ejb.client.TransactionID;
import org.jboss.ejb.client.UserTransactionID;
import org.jboss.ejb.client.XidTransactionID;
import org.jboss.ejb.protocol.remote.DiscoveredNodeRegistry;
import org.jboss.ejb.protocol.remote.EENamespaceInteroperability;
import org.jboss.ejb.protocol.remote.NoFlushByteOutput;
import org.jboss.ejb.protocol.remote.NodeInformation;
import org.jboss.ejb.protocol.remote.PackedInteger;
import org.jboss.ejb.protocol.remote.ProtocolClassResolver;
import org.jboss.ejb.protocol.remote.ProtocolObjectResolver;
import org.jboss.ejb.protocol.remote.ProtocolV1ClassTable;
import org.jboss.ejb.protocol.remote.ProtocolV1ObjectPreResolver;
import org.jboss.ejb.protocol.remote.ProtocolV1ObjectResolver;
import org.jboss.ejb.protocol.remote.ProtocolV1ObjectTable;
import org.jboss.ejb.protocol.remote.ProtocolV3ObjectResolver;
import org.jboss.ejb.protocol.remote.ProtocolV3ObjectTable;
import org.jboss.ejb.protocol.remote.RetryExecutorWrapper;
import org.jboss.ejb.protocol.remote.TCCLUtils;
import org.jboss.ejb.protocol.remote.WrapperMessageOutputStream;
import org.jboss.marshalling.ByteInput;
import org.jboss.marshalling.ByteOutput;
import org.jboss.marshalling.ClassResolver;
import org.jboss.marshalling.ClassTable;
import org.jboss.marshalling.Marshaller;
import org.jboss.marshalling.MarshallerFactory;
import org.jboss.marshalling.Marshalling;
import org.jboss.marshalling.MarshallingConfiguration;
import org.jboss.marshalling.ObjectResolver;
import org.jboss.marshalling.ObjectTable;
import org.jboss.marshalling.Unmarshaller;
import org.jboss.remoting3.Channel;
import org.jboss.remoting3.Connection;
import org.jboss.remoting3.ConnectionPeerIdentity;
import org.jboss.remoting3.MessageInputStream;
import org.jboss.remoting3.MessageOutputStream;
import org.jboss.remoting3.RemotingOptions;
import org.jboss.remoting3._private.IntIndexHashMap;
import org.jboss.remoting3._private.IntIndexMap;
import org.jboss.remoting3.util.Invocation;
import org.jboss.remoting3.util.InvocationTracker;
import org.jboss.remoting3.util.StreamUtils;
import org.wildfly.common.Assert;
import org.wildfly.common.function.ExceptionBiFunction;
import org.wildfly.common.net.CidrAddress;
import org.wildfly.discovery.Discovery;
import org.wildfly.naming.client.NamingProvider;
import org.wildfly.security.auth.client.AuthenticationContext;
import org.wildfly.transaction.client.AbstractTransaction;
import org.wildfly.transaction.client.LocalTransaction;
import org.wildfly.transaction.client.RemoteTransaction;
import org.wildfly.transaction.client.RemoteTransactionContext;
import org.wildfly.transaction.client.XAOutflowHandle;
import org.wildfly.transaction.client.provider.remoting.SimpleIdResolver;
import org.xnio.Bits;
import org.xnio.Cancellable;
import org.xnio.FutureResult;
import org.xnio.IoFuture;
import org.xnio.IoUtils;
import org.xnio.XnioWorker;

class EJBClientChannel {
    private final MarshallerFactory marshallerFactory;
    private final Channel channel;
    private final int version;
    private final DiscoveredNodeRegistry discoveredNodeRegistry;
    private final InvocationTracker invocationTracker;
    private final MarshallingConfiguration configuration;
    private final IntIndexMap<UserTransactionID> userTxnIds = new IntIndexHashMap(UserTransactionID::getId);
    private final RemoteTransactionContext transactionContext;
    private final AtomicInteger finishedParts = new AtomicInteger(0);
    private final AtomicReference<FutureResult<EJBClientChannel>> futureResultRef;
    private final RetryExecutorWrapper retryExecutorWrapper;
    private static final AttachmentKey<MethodInvocation> INV_KEY = new AttachmentKey();

    EJBClientChannel(Channel channel, int version, DiscoveredNodeRegistry discoveredNodeRegistry, FutureResult<EJBClientChannel> futureResult, RetryExecutorWrapper retryExecutorWrapper) {
        this.channel = channel;
        this.version = version;
        this.discoveredNodeRegistry = discoveredNodeRegistry;
        this.retryExecutorWrapper = retryExecutorWrapper;
        this.marshallerFactory = Marshalling.getProvidedMarshallerFactory((String)"river");
        MarshallingConfiguration configuration = new MarshallingConfiguration();
        configuration.setClassResolver((ClassResolver)ProtocolClassResolver.INSTANCE);
        Connection connection = channel.getConnection();
        if (version < 3) {
            configuration.setClassTable((ClassTable)ProtocolV1ClassTable.INSTANCE);
            configuration.setObjectTable((ObjectTable)ProtocolV1ObjectTable.INSTANCE);
            configuration.setObjectResolver((ObjectResolver)new ProtocolV1ObjectResolver(connection, true));
            configuration.setObjectPreResolver((ObjectResolver)ProtocolV1ObjectPreResolver.INSTANCE);
            configuration.setVersion(2);
            this.finishedParts.set(2);
        } else {
            configuration.setObjectTable((ObjectTable)ProtocolV3ObjectTable.INSTANCE);
            configuration.setObjectResolver((ObjectResolver)new ProtocolV3ObjectResolver(connection, true));
            configuration.setVersion(4);
        }
        EENamespaceInteroperability.handleInteroperability(configuration, version);
        this.transactionContext = RemoteTransactionContext.getInstance();
        this.configuration = configuration;
        this.invocationTracker = new InvocationTracker(this.channel, ((Integer)channel.getOption(RemotingOptions.MAX_OUTBOUND_MESSAGES)).intValue(), EJBClientChannel::mask);
        this.futureResultRef = new AtomicReference<FutureResult<EJBClientChannel>>(futureResult);
        String nodeName = connection.getRemoteEndpointName();
        NodeInformation nodeInformation = discoveredNodeRegistry.getNodeInformation(nodeName);
        nodeInformation.addAddress(this);
        nodeInformation.setInvalid(false);
        channel.addCloseHandler((ignored1, ignored2) -> nodeInformation.removeConnection(this));
    }

    static int mask(int original) {
        return original & 0xFFFF;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private void processMessage(MessageInputStream message) {
        leaveOpen = false;
        try {
            msg = message.readUnsignedByte();
            remoteEndpoint = this.channel.getConnection().getRemoteEndpointName();
            switch (msg) {
                case 2: 
                case 5: 
                case 6: 
                case 7: 
                case 10: 
                case 11: 
                case 12: 
                case 13: 
                case 14: 
                case 20: 
                case 28: {
                    invId = message.readUnsignedShort();
                    leaveOpen = this.invocationTracker.signalResponse(invId, msg, message, false);
                    ** break;
lbl10:
                    // 1 sources

                    break;
                }
                case 27: {
                    inputStream = new DataInputStream(new InflaterInputStream((InputStream)message));
                    realMessageId = inputStream.readByte();
                    invId = inputStream.readUnsignedShort();
                    leaveOpen = this.invocationTracker.signalResponse(invId, (int)realMessageId, (MessageInputStream)new ResponseMessageInputStream(inputStream, invId), false);
                    ** break;
lbl17:
                    // 1 sources

                    break;
                }
                case 8: {
                    count = PackedInteger.readPackedInteger((DataInput)message);
                    nodeInformation = this.discoveredNodeRegistry.getNodeInformation(this.getChannel().getConnection().getRemoteEndpointName());
                    moduleList = new EJBModuleIdentifier[count];
                    for (i = 0; i < count; ++i) {
                        appName = message.readUTF();
                        moduleName = message.readUTF();
                        distinctName = message.readUTF();
                        moduleList[i] = moduleIdentifier = new EJBModuleIdentifier(appName, moduleName, distinctName);
                        if (!Logs.INVOCATION.isDebugEnabled()) continue;
                        Logs.INVOCATION.debugf("Received MODULE_AVAILABLE(%x) message from node %s for module %s", msg, remoteEndpoint, moduleIdentifier);
                    }
                    nodeInformation.addModules(this, moduleList);
                    this.finishPart(1);
                    ** break;
lbl33:
                    // 1 sources

                    break;
                }
                case 9: {
                    count = PackedInteger.readPackedInteger((DataInput)message);
                    nodeInformation = this.discoveredNodeRegistry.getNodeInformation(this.getChannel().getConnection().getRemoteEndpointName());
                    set = new HashSet<EJBModuleIdentifier>(count);
                    for (i = 0; i < count; ++i) {
                        appName = message.readUTF();
                        moduleName = message.readUTF();
                        distinctName = message.readUTF();
                        moduleIdentifier = new EJBModuleIdentifier(appName, moduleName, distinctName);
                        set.add(moduleIdentifier);
                        if (!Logs.INVOCATION.isDebugEnabled()) continue;
                        Logs.INVOCATION.debugf("Received MODULE_UNAVAILABLE(%x) message from node %s for module %s", msg, remoteEndpoint, moduleIdentifier);
                    }
                    nodeInformation.removeModules(this, set);
                    ** break;
lbl50:
                    // 1 sources

                    break;
                }
                case 21: 
                case 23: {
                    clusterCount = PackedInteger.readPackedInteger((DataInput)message);
                    for (i = 0; i < clusterCount; ++i) {
                        clusterName = message.readUTF();
                        memberCount = PackedInteger.readPackedInteger((DataInput)message);
                        for (j = 0; j < memberCount; ++j) {
                            nodeName = message.readUTF();
                            this.discoveredNodeRegistry.addNode(clusterName, nodeName, this.channel.getConnection().getPeerURI());
                            nodeInformation = this.discoveredNodeRegistry.getNodeInformation(nodeName);
                            if (Logs.INVOCATION.isDebugEnabled()) {
                                Logs.INVOCATION.debugf("Received CLUSTER_TOPOLOGY(%x) message from node %s, registering cluster %s to node %s", new Object[]{msg, remoteEndpoint, clusterName, nodeName});
                            }
                            mappingCount = PackedInteger.readPackedInteger((DataInput)message);
                            for (k = 0; k < mappingCount; ++k) {
                                b = message.readUnsignedByte();
                                ip6 = Bits.allAreClear((int)b, (int)1);
                                netmaskBits = b >>> 1;
                                sourceIpBytes = new byte[ip6 != false ? 16 : 4];
                                message.readFully(sourceIpBytes);
                                block = CidrAddress.create((byte[])sourceIpBytes, (int)netmaskBits);
                                destHost = message.readUTF();
                                destPort = message.readUnsignedShort();
                                destUnresolved = InetSocketAddress.createUnresolved(destHost, destPort);
                                nodeInformation.addAddress(this.channel.getConnection().getProtocol(), clusterName, block, destUnresolved);
                                if (!Logs.INVOCATION.isDebugEnabled()) continue;
                                Logs.INVOCATION.debugf("Received CLUSTER_TOPOLOGY(%x) message block from %s, registering block %s to address %s", new Object[]{msg, remoteEndpoint, block, destUnresolved});
                            }
                        }
                    }
                    this.finishPart(2);
                    ** break;
lbl81:
                    // 1 sources

                    break;
                }
                case 22: {
                    clusterCount = PackedInteger.readPackedInteger((DataInput)message);
                    for (i = 0; i < clusterCount; ++i) {
                        clusterName = message.readUTF();
                        this.discoveredNodeRegistry.removeCluster(clusterName);
                        if (Logs.INVOCATION.isDebugEnabled()) {
                            Logs.INVOCATION.debugf("Received CLUSTER_TOPOLOGY_REMOVAL(%x) message from node %s for cluster %s", msg, remoteEndpoint, clusterName);
                        }
                        for (NodeInformation nodeInformation : this.discoveredNodeRegistry.getAllNodeInformation()) {
                            nodeInformation.removeCluster(clusterName);
                        }
                    }
                    break;
                }
                case 24: {
                    clusterCount = PackedInteger.readPackedInteger((DataInput)message);
                    for (i = 0; i < clusterCount; ++i) {
                        clusterName = message.readUTF();
                        memberCount = PackedInteger.readPackedInteger((DataInput)message);
                        for (j = 0; j < memberCount; ++j) {
                            nodeName = message.readUTF();
                            this.discoveredNodeRegistry.removeNode(clusterName, nodeName);
                            nodeInformation = this.discoveredNodeRegistry.getNodeInformation(nodeName);
                            nodeInformation.removeCluster(clusterName);
                            if (!Logs.INVOCATION.isDebugEnabled()) continue;
                            Logs.INVOCATION.debugf("Received CLUSTER_TOPOLOGY_NODE_REMOVAL(%x) message from node %s for (cluster, node) = (%s, %s)", new Object[]{msg, remoteEndpoint, clusterName, nodeName});
                        }
                    }
                    break;
                }
                ** default:
lbl110:
                // 1 sources

                break;
            }
        }
        catch (IOException var3_4) {
        }
        finally {
            if (!leaveOpen) {
                IoUtils.safeClose((Closeable)message);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processInvocation(EJBReceiverInvocationContext receiverContext, ConnectionPeerIdentity peerIdentity) {
        MethodInvocation invocation = (MethodInvocation)this.invocationTracker.addInvocation(id -> new MethodInvocation(id, receiverContext));
        EJBClientInvocationContext invocationContext = receiverContext.getClientInvocationContext();
        invocationContext.putAttachment(INV_KEY, invocation);
        EJBLocator<?> locator = invocationContext.getLocator();
        int peerIdentityId = this.version >= 3 ? peerIdentity.getId() : 0;
        try (MessageOutputStream underlying = this.invocationTracker.allocateMessage();
             MessageOutputStream out = this.handleCompression(invocationContext, underlying);){
            out.write(3);
            out.writeShort(invocation.getIndex());
            Marshaller marshaller = this.getMarshaller();
            marshaller.start((ByteOutput)new NoFlushByteOutput(Marshalling.createByteOutput((OutputStream)out)));
            Method invokedMethod = invocationContext.getInvokedMethod();
            Object[] parameters = invocationContext.getParameters();
            if (this.version < 3) {
                out.writeUTF(invokedMethod.getName());
                out.writeUTF(invocationContext.getMethodSignatureString());
                marshaller.writeObject((Object)locator.getAppName());
                marshaller.writeObject((Object)locator.getModuleName());
                marshaller.writeObject((Object)locator.getDistinctName());
                marshaller.writeObject((Object)locator.getBeanName());
            } else {
                marshaller.writeObject((Object)locator.getIdentifier());
                marshaller.writeObject((Object)invocationContext.getMethodLocator());
                marshaller.writeInt(peerIdentityId);
                marshaller.writeObject((Object)invocationContext.getWeakAffinity());
                if (invocationContext.isCompressResponse()) {
                    int compressionLevel = invocationContext.getCompressionLevel() > 0 ? invocationContext.getCompressionLevel() : 9;
                    marshaller.writeByte(compressionLevel);
                } else {
                    marshaller.writeByte(0);
                }
                invocation.setOutflowHandle(this.writeTransaction((Transaction)invocationContext.getTransaction(), (DataOutput)marshaller, invocationContext.getAuthenticationContext()));
            }
            marshaller.writeObject(locator);
            if (parameters != null && parameters.length > 0) {
                for (Object object : parameters) {
                    marshaller.writeObject(object);
                }
            }
            Map<AttachmentKey<?>, ?> privateAttachments = invocationContext.getAttachments();
            Map<String, Object> contextData = invocationContext.getContextData();
            int totalContextData = contextData.size();
            if (this.version >= 3) {
                PackedInteger.writePackedInteger((DataOutput)marshaller, totalContextData);
                for (Map.Entry<String, Object> invocationContextData : contextData.entrySet()) {
                    marshaller.writeObject((Object)invocationContextData.getKey());
                    marshaller.writeObject(invocationContextData.getValue());
                }
            } else {
                boolean hasPrivateAttachments;
                AbstractTransaction abstractTransaction = invocationContext.getTransaction();
                HashMap marshalledPrivateAttachments = new HashMap();
                for (Map.Entry<AttachmentKey<?>, ?> entry : privateAttachments.entrySet()) {
                    AttachmentKey<?> key = entry.getKey();
                    if (key == AttachmentKeys.TRANSACTION_ID_KEY || ProtocolV1ObjectTable.INSTANCE.getObjectWriter(key) == null) continue;
                    marshalledPrivateAttachments.put(key, entry.getValue());
                }
                if (abstractTransaction != null) {
                    marshalledPrivateAttachments.put(AttachmentKeys.TRANSACTION_ID_KEY, this.calculateTransactionId((Transaction)abstractTransaction));
                }
                boolean bl = hasPrivateAttachments = !marshalledPrivateAttachments.isEmpty();
                if (hasPrivateAttachments) {
                    ++totalContextData;
                }
                if (abstractTransaction != null) {
                    ++totalContextData;
                }
                PackedInteger.writePackedInteger((DataOutput)marshaller, totalContextData);
                ProtocolObjectResolver.enableNonSerReplacement();
                try {
                    for (Map.Entry<String, Object> invocationContextData : contextData.entrySet()) {
                        marshaller.writeObject((Object)invocationContextData.getKey());
                        marshaller.writeObject(invocationContextData.getValue());
                    }
                }
                finally {
                    ProtocolObjectResolver.disableNonSerReplacement();
                }
                if (hasPrivateAttachments) {
                    marshaller.writeObject((Object)"org.jboss.ejb.client.invocation.attachments");
                    marshaller.writeObject(marshalledPrivateAttachments);
                }
                if (abstractTransaction != null) {
                    marshaller.writeObject((Object)"jboss.transaction.id");
                    marshaller.writeObject(marshalledPrivateAttachments.get(AttachmentKeys.TRANSACTION_ID_KEY));
                }
            }
            marshaller.finish();
        }
        catch (IOException e) {
            receiverContext.requestFailed((Exception)((Object)new RequestSendFailedException(e.getMessage() + " @ " + peerIdentity.getConnection().getPeerURI(), e, true)), this.getRetryExecutor(receiverContext));
        }
        catch (RollbackException | SystemException | RuntimeException e) {
            receiverContext.requestFailed((Exception)new EJBException(e.getMessage(), (Exception)e), this.getRetryExecutor(receiverContext));
            return;
        }
    }

    private MessageOutputStream handleCompression(EJBClientInvocationContext invocationContext, MessageOutputStream messageOutputStream) throws IOException {
        if (this.version == 1) {
            return messageOutputStream;
        }
        Boolean hintsDisabled = invocationContext.getProxyAttachment(AttachmentKeys.HINTS_DISABLED);
        if (hintsDisabled != null && hintsDisabled.booleanValue()) {
            if (Logs.REMOTING.isTraceEnabled()) {
                Logs.REMOTING.trace("Hints are disabled. Ignoring any CompressionHint on methods being invoked on view " + invocationContext.getViewClass());
            }
            return messageOutputStream;
        }
        int compressionLevel = invocationContext.getCompressionLevel();
        if (this.version == 2 && invocationContext.isCompressResponse()) {
            invocationContext.putAttachment(AttachmentKeys.COMPRESS_RESPONSE, true);
            invocationContext.putAttachment(AttachmentKeys.RESPONSE_COMPRESSION_LEVEL, compressionLevel);
            if (Logs.REMOTING.isTraceEnabled()) {
                Logs.REMOTING.trace("Letting the server know that the response of method " + invocationContext.getInvokedMethod() + " has to be compressed with compression level = " + compressionLevel);
            }
        }
        if (invocationContext.isCompressRequest()) {
            messageOutputStream.write(27);
            Deflater deflater = new Deflater(compressionLevel);
            DeflaterOutputStream deflaterOutputStream = new DeflaterOutputStream((OutputStream)messageOutputStream, deflater);
            if (Logs.REMOTING.isTraceEnabled()) {
                Logs.REMOTING.trace("Using a compressing stream with compression level = " + compressionLevel + " for request data for EJB invocation on method " + invocationContext.getInvokedMethod());
            }
            return new WrapperMessageOutputStream(messageOutputStream, deflaterOutputStream);
        }
        return messageOutputStream;
    }

    private TransactionID calculateTransactionId(Transaction transaction) throws RollbackException, SystemException, InvalidTransactionException {
        URI location = this.channel.getConnection().getPeerURI();
        Assert.assertNotNull((Object)transaction);
        if (transaction instanceof RemoteTransaction) {
            RemoteTransaction remoteTransaction = (RemoteTransaction)transaction;
            remoteTransaction.setLocation(location);
            SimpleIdResolver ir = (SimpleIdResolver)remoteTransaction.getProviderInterface(SimpleIdResolver.class);
            if (ir == null) {
                throw Logs.TXN.cannotEnlistTx();
            }
            return new UserTransactionID(this.channel.getConnection().getRemoteEndpointName(), ir.getTransactionId(this.channel.getConnection()));
        }
        if (transaction instanceof LocalTransaction) {
            LocalTransaction localTransaction = (LocalTransaction)transaction;
            XAOutflowHandle outflowHandle = this.transactionContext.outflowTransaction(location, localTransaction);
            outflowHandle.verifyEnlistment();
            return new XidTransactionID(outflowHandle.getXid());
        }
        throw Logs.TXN.cannotEnlistTx();
    }

    private XAOutflowHandle writeTransaction(Transaction transaction, DataOutput dataOutput, AuthenticationContext authenticationContext) throws IOException, RollbackException, SystemException {
        if (authenticationContext != null) {
            if (Logs.MAIN.isDebugEnabled()) {
                Logs.MAIN.debug("Using existing AuthenticationContext for writeTransaction(...)");
            }
            try {
                return (XAOutflowHandle)authenticationContext.run(() -> this._writeTransaction(transaction, dataOutput));
            }
            catch (PrivilegedActionException e) {
                Throwable cause = e.getCause();
                if (cause instanceof IOException) {
                    throw (IOException)cause;
                }
                if (cause instanceof RollbackException) {
                    throw (RollbackException)cause;
                }
                if (cause instanceof SystemException) {
                    throw (SystemException)cause;
                }
                throw new RuntimeException(e);
            }
        }
        if (Logs.MAIN.isDebugEnabled()) {
            Logs.MAIN.debug("No existing AuthenticationContext for writeTransaction(...)");
        }
        return this._writeTransaction(transaction, dataOutput);
    }

    private XAOutflowHandle _writeTransaction(Transaction transaction, DataOutput dataOutput) throws IOException, RollbackException, SystemException {
        URI location = this.channel.getConnection().getPeerURI();
        if (transaction == null) {
            dataOutput.writeByte(0);
            return null;
        }
        if (transaction instanceof RemoteTransaction) {
            RemoteTransaction remoteTransaction = (RemoteTransaction)transaction;
            remoteTransaction.setLocation(location);
            dataOutput.writeByte(1);
            SimpleIdResolver ir = (SimpleIdResolver)remoteTransaction.getProviderInterface(SimpleIdResolver.class);
            if (ir == null) {
                throw Logs.TXN.cannotEnlistTx();
            }
            int id = ir.getTransactionId(this.channel.getConnection());
            dataOutput.writeInt(id);
            int transactionTimeout = remoteTransaction.getEstimatedRemainingTime();
            if (transactionTimeout == 0) {
                throw Logs.TXN.outflowTransactionTimeoutElapsed(transaction);
            }
            PackedInteger.writePackedInteger(dataOutput, transactionTimeout);
            return null;
        }
        if (transaction instanceof LocalTransaction) {
            LocalTransaction localTransaction = (LocalTransaction)transaction;
            XAOutflowHandle outflowHandle = this.transactionContext.outflowTransaction(location, localTransaction);
            Xid xid = outflowHandle.getXid();
            dataOutput.writeByte(2);
            PackedInteger.writePackedInteger(dataOutput, xid.getFormatId());
            byte[] gtid = xid.getGlobalTransactionId();
            dataOutput.writeByte(gtid.length);
            dataOutput.write(gtid);
            byte[] bq = xid.getBranchQualifier();
            dataOutput.writeByte(bq.length);
            dataOutput.write(bq);
            int transactionTimeout = outflowHandle.getRemainingTime();
            if (transactionTimeout == 0) {
                throw Logs.TXN.outflowTransactionTimeoutElapsed(transaction);
            }
            PackedInteger.writePackedInteger(dataOutput, transactionTimeout);
            return outflowHandle;
        }
        throw Logs.TXN.cannotEnlistTx();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean cancelInvocation(EJBReceiverInvocationContext receiverContext, boolean cancelIfRunning) {
        if (this.version < 3 && !cancelIfRunning) {
            return false;
        }
        MethodInvocation invocation = receiverContext.getClientInvocationContext().getAttachment(INV_KEY);
        if (invocation == null) {
            return false;
        }
        if (invocation.alloc()) {
            try {
                int index = invocation.getIndex();
                try (MessageOutputStream out = this.invocationTracker.allocateMessage();){
                    out.write(4);
                    out.writeShort(index);
                    if (this.version >= 3) {
                        out.writeBoolean(cancelIfRunning);
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            finally {
                invocation.free();
            }
        }
        return invocation.receiverInvocationContext.getClientInvocationContext().awaitCancellationResult();
    }

    private Marshaller getMarshaller() throws IOException {
        return this.marshallerFactory.createMarshaller(this.configuration);
    }

    public <T> StatefulEJBLocator<T> openSession(StatelessEJBLocator<T> statelessLocator, ConnectionPeerIdentity identity, EJBSessionCreationInvocationContext clientInvocationContext) throws Exception {
        SessionOpenInvocation invocation = (SessionOpenInvocation)this.invocationTracker.addInvocation(id -> new SessionOpenInvocation(id, statelessLocator, clientInvocationContext));
        try (MessageOutputStream out = this.invocationTracker.allocateMessage();){
            out.write(1);
            out.writeShort(invocation.getIndex());
            EJBClientChannel.writeRawIdentifier(statelessLocator, out);
            if (this.version >= 3) {
                out.writeInt(identity.getId());
                invocation.setOutflowHandle(this.writeTransaction((Transaction)clientInvocationContext.getTransaction(), (DataOutput)out, clientInvocationContext.getAuthenticationContext()));
            }
        }
        catch (IOException e) {
            CreateException createException = new CreateException(e.getMessage());
            createException.initCause((Throwable)e);
            throw createException;
        }
        return invocation.getResult();
    }

    private static <T> void writeRawIdentifier(EJBLocator<T> statelessLocator, MessageOutputStream out) throws IOException {
        String appName = statelessLocator.getAppName();
        out.writeUTF(appName == null ? "" : appName);
        out.writeUTF(statelessLocator.getModuleName());
        String distinctName = statelessLocator.getDistinctName();
        out.writeUTF(distinctName == null ? "" : distinctName);
        out.writeUTF(statelessLocator.getBeanName());
    }

    static IoFuture<EJBClientChannel> construct(final Channel channel, final DiscoveredNodeRegistry discoveredNodeRegistry, final RetryExecutorWrapper retryExecutorWrapper) {
        final FutureResult futureResult = new FutureResult();
        channel.receiveMessage(new Channel.Receiver(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void handleError(Channel channel, IOException error) {
                ClassLoader oldCL = TCCLUtils.getAndSetSafeTCCL();
                try {
                    futureResult.setException(error);
                }
                finally {
                    TCCLUtils.resetTCCL(oldCL);
                }
            }

            public void handleEnd(Channel channel) {
                ClassLoader oldCL = TCCLUtils.getAndSetSafeTCCL();
                try {
                    futureResult.setCancelled();
                }
                finally {
                    TCCLUtils.resetTCCL(oldCL);
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void handleMessage(Channel channel, MessageInputStream message) {
                ClassLoader oldCL = TCCLUtils.getAndSetSafeTCCL();
                try {
                    int version = Math.min(4, StreamUtils.readInt8((InputStream)message));
                    while (message.read() != -1) {
                        message.skip(Long.MAX_VALUE);
                    }
                    try (MessageOutputStream out = channel.writeMessage();){
                        out.write(version);
                        out.writeUTF("river");
                    }
                    final EJBClientChannel ejbClientChannel = new EJBClientChannel(channel, version, discoveredNodeRegistry, (FutureResult<EJBClientChannel>)futureResult, retryExecutorWrapper);
                    channel.receiveMessage(new Channel.Receiver(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        public void handleError(Channel channel, IOException error) {
                            ClassLoader oldCL = TCCLUtils.getAndSetSafeTCCL();
                            try {
                                futureResult.setException(error);
                            }
                            finally {
                                IoUtils.safeClose((Closeable)channel);
                                TCCLUtils.resetTCCL(oldCL);
                            }
                        }

                        public void handleEnd(Channel channel) {
                            ClassLoader oldCL = TCCLUtils.getAndSetSafeTCCL();
                            try {
                                futureResult.setException((IOException)new EOFException());
                            }
                            finally {
                                IoUtils.safeClose((Closeable)channel);
                                TCCLUtils.resetTCCL(oldCL);
                            }
                        }

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        public void handleMessage(Channel channel, MessageInputStream message) {
                            ClassLoader oldCL = TCCLUtils.getAndSetSafeTCCL();
                            try {
                                ejbClientChannel.processMessage(message);
                            }
                            finally {
                                channel.receiveMessage((Channel.Receiver)this);
                                TCCLUtils.resetTCCL(oldCL);
                            }
                        }
                    });
                }
                catch (IOException e) {
                    channel.closeAsync();
                    channel.addCloseHandler((closed, exception) -> futureResult.setException(e));
                }
                finally {
                    TCCLUtils.resetTCCL(oldCL);
                }
            }
        });
        futureResult.addCancelHandler(new Cancellable(){

            public Cancellable cancel() {
                if (futureResult.setCancelled()) {
                    IoUtils.safeClose((Closeable)channel);
                }
                return this;
            }
        });
        return futureResult.getIoFuture();
    }

    InvocationTracker getInvocationTracker() {
        return this.invocationTracker;
    }

    private static void glueStackTraces(Throwable exception, StackTraceElement[] userStackTrace, int trimCount, String msg) {
        StackTraceElement[] est = exception.getStackTrace();
        StackTraceElement[] fst = Arrays.copyOf(est, est.length + userStackTrace.length - trimCount + 1);
        fst[est.length] = new StackTraceElement("..." + msg + "..", "", null, -1);
        System.arraycopy(userStackTrace, trimCount, fst, est.length + 1, userStackTrace.length - trimCount);
        exception.setStackTrace(fst);
    }

    Unmarshaller createUnmarshaller() throws IOException {
        return this.marshallerFactory.createUnmarshaller(this.configuration);
    }

    Channel getChannel() {
        return this.channel;
    }

    UserTransactionID allocateUserTransactionID() {
        UserTransactionID uti;
        byte[] nameBytes;
        ThreadLocalRandom random = ThreadLocalRandom.current();
        String nodeName = this.getChannel().getConnection().getRemoteEndpointName();
        try {
            nameBytes = nodeName.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw Assert.unreachableCode();
        }
        int length = nameBytes.length;
        if (length > 255) {
            throw Assert.unreachableCode();
        }
        byte[] target = new byte[6 + length];
        target[0] = 1;
        target[1] = (byte)length;
        System.arraycopy(nameBytes, 0, target, 2, length);
        while (true) {
            int id;
            if (this.userTxnIds.containsKey(id = random.nextInt())) {
                continue;
            }
            target[2 + length] = (byte)(id >> 24);
            target[3 + length] = (byte)(id >> 16);
            target[4 + length] = (byte)(id >> 8);
            target[5 + length] = (byte)id;
            uti = (UserTransactionID)TransactionID.createTransactionID(target);
            if (this.userTxnIds.putIfAbsent((Object)uti) == null) break;
        }
        return uti;
    }

    void finishPart(int bit) {
        FutureResult<EJBClientChannel> futureResult;
        int newVal;
        int oldVal;
        do {
            if (!Bits.allAreSet((int)(oldVal = this.finishedParts.get()), (int)bit)) continue;
            return;
        } while (!this.finishedParts.compareAndSet(oldVal, newVal = oldVal | bit));
        if (newVal == 3 && (futureResult = this.futureResultRef.get()) != null && this.futureResultRef.compareAndSet(futureResult, null)) {
            futureResult.setResult((Object)this);
        }
    }

    private static void disassociateRemoteTxIfPossible(AbstractInvocationContext context) {
        RemoteTransaction remote;
        AbstractTransaction transaction = context.getTransaction();
        if (transaction instanceof RemoteTransaction && !(remote = (RemoteTransaction)transaction).tryClearLocation()) {
            Logs.TXN.tracef("Could not disassociate remote transaction (already in-use or completed) from %s", remote.getLocation());
        }
    }

    private Executor getRetryExecutor() {
        return this.retryExecutorWrapper.getExecutor((Executor)this.getChannel().getConnection().getEndpoint().getXnioWorker());
    }

    private Executor getRetryExecutor(EJBReceiverInvocationContext ejbReceiverInvocationContext) {
        EJBClientContext ejbClientContext = ejbReceiverInvocationContext.getClientContext();
        Discovery discovery = ejbReceiverInvocationContext.getDiscovery();
        AuthenticationContext authentoicationContext = ejbReceiverInvocationContext.getAuthenticationContext();
        XnioWorker executor = this.getChannel().getConnection().getEndpoint().getXnioWorker();
        return this.retryExecutorWrapper.getExecutor((Executor)executor, ejbClientContext, discovery, authentoicationContext);
    }

    static class ResponseMessageInputStream
    extends MessageInputStream
    implements ByteInput {
        private final InputStream delegate;
        private final int id;

        ResponseMessageInputStream(InputStream delegate, int id) {
            this.delegate = delegate;
            this.id = id;
        }

        public int read() throws IOException {
            return this.delegate.read();
        }

        public int read(byte[] b, int off, int len) throws IOException {
            return this.delegate.read(b, off, len);
        }

        public long skip(long n) throws IOException {
            return this.delegate.skip(n);
        }

        public void close() throws IOException {
            this.delegate.close();
        }

        public int getId() {
            return this.id;
        }
    }

    final class MethodInvocation
    extends Invocation {
        private final EJBReceiverInvocationContext receiverInvocationContext;
        private final AtomicInteger refCounter;
        private XAOutflowHandle outflowHandle;

        MethodInvocation(int index, EJBReceiverInvocationContext receiverInvocationContext) {
            super(index);
            this.refCounter = new AtomicInteger(1);
            this.receiverInvocationContext = receiverInvocationContext;
        }

        boolean alloc() {
            int oldVal;
            AtomicInteger refCounter = this.refCounter;
            do {
                if ((oldVal = refCounter.get()) != 0) continue;
                return false;
            } while (!refCounter.compareAndSet(oldVal, oldVal + 1));
            return true;
        }

        void free() {
            AtomicInteger refCounter = this.refCounter;
            int newVal = refCounter.decrementAndGet();
            if (newVal == 0) {
                EJBClientChannel.this.invocationTracker.remove((Invocation)this);
            }
        }

        public void handleResponse(int parameter, MessageInputStream inputStream) {
            this.handleResponse(parameter, new DataInputStream((InputStream)inputStream));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private void handleResponse(int id, DataInputStream inputStream) {
            switch (id) {
                case 5: {
                    this.free();
                    EJBClientInvocationContext context = this.receiverInvocationContext.getClientInvocationContext();
                    if (EJBClientChannel.this.version >= 3) {
                        try {
                            byte[] b;
                            int updateBits;
                            int cmd = inputStream.readUnsignedByte();
                            XAOutflowHandle outflowHandle = this.getOutflowHandle();
                            if (outflowHandle != null) {
                                if (cmd == 0) {
                                    outflowHandle.forgetEnlistment();
                                } else if (cmd == 1) {
                                    outflowHandle.verifyEnlistment();
                                } else if (cmd == 2) {
                                    outflowHandle.nonMasterEnlistment();
                                }
                            }
                            if (Bits.allAreSet((int)(updateBits = inputStream.readUnsignedByte()), (int)1)) {
                                byte[] encoded = new byte[PackedInteger.readPackedInteger(inputStream)];
                                inputStream.readFully(encoded);
                                SessionID sessionID = SessionID.createSessionID(encoded);
                                Object invokedProxy = context.getInvokedProxy();
                                EJBClient.convertToStateful(invokedProxy, sessionID);
                                context.setLocator(EJBClient.getLocatorFor(invokedProxy));
                                if (Logs.INVOCATION.isDebugEnabled()) {
                                    Logs.INVOCATION.debugf("EJBClientChannel.handleResponse: updated Locator (sessionID); new = %s", context.getLocator().getAffinity());
                                }
                            }
                            if (Bits.allAreSet((int)updateBits, (int)2)) {
                                b = new byte[PackedInteger.readPackedInteger(inputStream)];
                                inputStream.readFully(b);
                                context.setWeakAffinity(new NodeAffinity(new String(b, StandardCharsets.UTF_8)));
                                if (Logs.INVOCATION.isDebugEnabled()) {
                                    Logs.INVOCATION.debugf("EJBClientChannel.handleResponse: updated weak affinity = %s", context.getWeakAffinity());
                                }
                            }
                            if (Bits.allAreSet((int)updateBits, (int)4)) {
                                b = new byte[PackedInteger.readPackedInteger(inputStream)];
                                inputStream.readFully(b);
                                context.setLocator(context.getLocator().withNewAffinity(new ClusterAffinity(new String(b, StandardCharsets.UTF_8))));
                                if (Logs.INVOCATION.isDebugEnabled()) {
                                    Logs.INVOCATION.debugf("EJBClientChannel.handleResponse: updated strong affinity = %s", context.getLocator().getAffinity());
                                }
                            }
                        }
                        catch (RollbackException | SystemException | IOException | RuntimeException e) {
                            this.receiverInvocationContext.requestFailed((Exception)new EJBException((Exception)e), EJBClientChannel.this.getRetryExecutor(this.receiverInvocationContext));
                            IoUtils.safeClose((Closeable)inputStream);
                            return;
                        }
                    }
                    NamingProvider provider = context.getProxyAttachment(Keys.NAMING_PROVIDER_ATTACHMENT_KEY);
                    this.receiverInvocationContext.resultReady(new MethodCallResultProducer(provider, inputStream, id));
                    return;
                }
                case 7: {
                    XAOutflowHandle outflowHandle;
                    this.free();
                    if (EJBClientChannel.this.version >= 3 && (outflowHandle = this.getOutflowHandle()) != null) {
                        outflowHandle.forgetEnlistment();
                    }
                    this.receiverInvocationContext.requestCancelled();
                    return;
                }
                case 6: {
                    this.free();
                    this.receiverInvocationContext.resultReady(new ExceptionResultProducer(inputStream, id));
                    return;
                }
                case 10: {
                    this.free();
                    try {
                        XAOutflowHandle outflowHandle;
                        if (EJBClientChannel.this.version >= 3 && (outflowHandle = this.getOutflowHandle()) != null) {
                            outflowHandle.forgetEnlistment();
                        }
                        EJBClientChannel.disassociateRemoteTxIfPossible(this.receiverInvocationContext.getClientInvocationContext());
                        String message = inputStream.readUTF();
                        EJBModuleIdentifier moduleIdentifier = this.receiverInvocationContext.getClientInvocationContext().getLocator().getIdentifier().getModuleIdentifier();
                        NodeInformation nodeInformation = EJBClientChannel.this.discoveredNodeRegistry.getNodeInformation(EJBClientChannel.this.getChannel().getConnection().getRemoteEndpointName());
                        nodeInformation.removeModule(EJBClientChannel.this, moduleIdentifier);
                        this.receiverInvocationContext.requestFailed((Exception)((Object)new NoSuchEJBException(message + " @ " + EJBClientChannel.this.getChannel().getConnection().getPeerURI())), EJBClientChannel.this.getRetryExecutor(this.receiverInvocationContext));
                        return;
                    }
                    catch (IOException e) {
                        this.receiverInvocationContext.requestFailed((Exception)new EJBException("Failed to read 'No such EJB' response", (Exception)e), EJBClientChannel.this.getRetryExecutor(this.receiverInvocationContext));
                        return;
                    }
                    finally {
                        IoUtils.safeClose((Closeable)inputStream);
                    }
                }
                case 28: {
                    this.free();
                    try {
                        XAOutflowHandle outflowHandle;
                        if (EJBClientChannel.this.version >= 3 && (outflowHandle = this.getOutflowHandle()) != null) {
                            outflowHandle.forgetEnlistment();
                        }
                        EJBClientChannel.disassociateRemoteTxIfPossible(this.receiverInvocationContext.getClientInvocationContext());
                        String message = inputStream.readUTF();
                        this.receiverInvocationContext.requestFailed((Exception)Logs.REMOTING.invalidViewTypeForInvocation(message), EJBClientChannel.this.getRetryExecutor(this.receiverInvocationContext));
                        return;
                    }
                    catch (IOException e) {
                        this.receiverInvocationContext.requestFailed((Exception)new EJBException("Failed to read 'Bad EJB view type' response", (Exception)e), EJBClientChannel.this.getRetryExecutor(this.receiverInvocationContext));
                        return;
                    }
                    finally {
                        IoUtils.safeClose((Closeable)inputStream);
                    }
                }
                case 11: {
                    this.free();
                    try {
                        XAOutflowHandle outflowHandle;
                        if (EJBClientChannel.this.version >= 3 && (outflowHandle = this.getOutflowHandle()) != null) {
                            outflowHandle.forgetEnlistment();
                        }
                        EJBClientChannel.disassociateRemoteTxIfPossible(this.receiverInvocationContext.getClientInvocationContext());
                        String message = inputStream.readUTF();
                        this.receiverInvocationContext.requestFailed(new IllegalArgumentException(message), EJBClientChannel.this.getRetryExecutor(this.receiverInvocationContext));
                        return;
                    }
                    catch (IOException e) {
                        this.receiverInvocationContext.requestFailed((Exception)new EJBException("Failed to read 'No such EJB method' response", (Exception)e), EJBClientChannel.this.getRetryExecutor(this.receiverInvocationContext));
                        return;
                    }
                    finally {
                        IoUtils.safeClose((Closeable)inputStream);
                    }
                }
                case 12: {
                    this.free();
                    try {
                        XAOutflowHandle outflowHandle;
                        if (EJBClientChannel.this.version >= 3 && (outflowHandle = this.getOutflowHandle()) != null) {
                            outflowHandle.forgetEnlistment();
                        }
                        EJBClientChannel.disassociateRemoteTxIfPossible(this.receiverInvocationContext.getClientInvocationContext());
                        String message = inputStream.readUTF();
                        this.receiverInvocationContext.requestFailed((Exception)new EJBException(message), EJBClientChannel.this.getRetryExecutor(this.receiverInvocationContext));
                        return;
                    }
                    catch (IOException e) {
                        this.receiverInvocationContext.requestFailed((Exception)new EJBException("Failed to read 'Session not active' response", (Exception)e), EJBClientChannel.this.getRetryExecutor(this.receiverInvocationContext));
                        return;
                    }
                    finally {
                        IoUtils.safeClose((Closeable)inputStream);
                    }
                }
                case 13: {
                    this.free();
                    try {
                        XAOutflowHandle outflowHandle;
                        if (EJBClientChannel.this.version >= 3 && (outflowHandle = this.getOutflowHandle()) != null) {
                            outflowHandle.forgetEnlistment();
                        }
                        EJBClientChannel.disassociateRemoteTxIfPossible(this.receiverInvocationContext.getClientInvocationContext());
                        String message = inputStream.readUTF();
                        this.receiverInvocationContext.requestFailed((Exception)new EJBException(message), EJBClientChannel.this.getRetryExecutor(this.receiverInvocationContext));
                        return;
                    }
                    catch (IOException e) {
                        this.receiverInvocationContext.requestFailed((Exception)new EJBException("Failed to read 'EJB not stateful' response"), EJBClientChannel.this.getRetryExecutor(this.receiverInvocationContext));
                        return;
                    }
                    finally {
                        IoUtils.safeClose((Closeable)inputStream);
                    }
                }
                case 14: {
                    IoUtils.safeClose((Closeable)inputStream);
                    this.receiverInvocationContext.proceedAsynchronously();
                    return;
                }
                default: {
                    this.free();
                    IoUtils.safeClose((Closeable)inputStream);
                    this.receiverInvocationContext.requestFailed((Exception)new EJBException("Unknown protocol response"), EJBClientChannel.this.getRetryExecutor(this.receiverInvocationContext));
                }
            }
        }

        public void handleClosed() {
            this.receiverInvocationContext.requestFailed((Exception)Logs.REMOTING.channelTimeoutOrClosed(new ClosedChannelException()), EJBClientChannel.this.getRetryExecutor(this.receiverInvocationContext));
        }

        public void handleException(IOException cause) {
            this.receiverInvocationContext.requestFailed((Exception)new EJBException((Exception)cause), EJBClientChannel.this.getRetryExecutor(this.receiverInvocationContext));
        }

        XAOutflowHandle getOutflowHandle() {
            return this.outflowHandle;
        }

        void setOutflowHandle(XAOutflowHandle outflowHandle) {
            this.outflowHandle = outflowHandle;
        }

        class MethodCallResultProducer
        implements EJBReceiverInvocationContext.ResultProducer,
        ExceptionBiFunction<Void, Void, Object, Exception> {
            private final NamingProvider namingProvider;
            private final InputStream inputStream;
            private final int id;

            MethodCallResultProducer(NamingProvider provider, InputStream inputStream, int id) {
                this.namingProvider = provider;
                this.inputStream = inputStream;
                this.id = id;
            }

            private void cleanContextDataBeforeUnmarshalling(EJBClientInvocationContext clientInvocationContext) {
                Map<String, Object> contextData = clientInvocationContext.getContextData();
                Set returnedContextDataKeys = (Set)contextData.get("jboss.returned.keys");
                if (returnedContextDataKeys != null) {
                    contextData.keySet().removeAll(returnedContextDataKeys);
                }
            }

            public Object apply(Void ignored0, Void ignored1) throws Exception {
                Object result;
                ResponseMessageInputStream response = this.inputStream instanceof ResponseMessageInputStream ? (ResponseMessageInputStream)((Object)this.inputStream) : new ResponseMessageInputStream(this.inputStream, this.id);
                try (Unmarshaller unmarshaller = EJBClientChannel.this.createUnmarshaller();){
                    unmarshaller.start((ByteInput)response);
                    result = unmarshaller.readObject();
                    int attachments = unmarshaller.readUnsignedByte();
                    EJBClientInvocationContext clientInvocationContext = MethodInvocation.this.receiverInvocationContext.getClientInvocationContext();
                    this.cleanContextDataBeforeUnmarshalling(clientInvocationContext);
                    for (int i = 0; i < attachments; ++i) {
                        String key = (String)unmarshaller.readObject(String.class);
                        if (EJBClientChannel.this.version < 3 && key.equals("jboss.ejb.weak.affinity")) {
                            Affinity affinity = (Affinity)unmarshaller.readObject(Affinity.class);
                            clientInvocationContext.putAttachment(AttachmentKeys.WEAK_AFFINITY, affinity);
                            clientInvocationContext.setWeakAffinity(affinity);
                            if (!Logs.INVOCATION.isDebugEnabled()) continue;
                            Logs.INVOCATION.debugf("EJBClientChannel.MethodCallResultProducer: updated weak affinity (version < 3) = %s", affinity);
                            continue;
                        }
                        if (key.equals("org.jboss.ejb.client.invocation.attachments")) {
                            unmarshaller.readObject();
                            continue;
                        }
                        Object value = unmarshaller.readObject();
                        if (value == null) continue;
                        clientInvocationContext.getContextData().put(key, value);
                    }
                    unmarshaller.finish();
                }
                catch (IOException | ClassNotFoundException ex) {
                    this.discardResult();
                    throw new EJBException("Failed to read response", ex);
                }
                return result;
            }

            @Override
            public Object getResult() throws Exception {
                if (this.namingProvider != null) {
                    return this.namingProvider.performExceptionAction((ExceptionBiFunction)this, null, null);
                }
                return this.apply(null, null);
            }

            @Override
            public void discardResult() {
                IoUtils.safeClose((Closeable)this.inputStream);
            }
        }

        class ExceptionResultProducer
        implements EJBReceiverInvocationContext.ResultProducer {
            private final InputStream inputStream;
            private final int id;

            ExceptionResultProducer(InputStream inputStream, int id) {
                this.inputStream = inputStream;
                this.id = id;
            }

            @Override
            public Object getResult() throws Exception {
                Exception e;
                try (ResponseMessageInputStream response = new ResponseMessageInputStream(this.inputStream, this.id);){
                    if (EJBClientChannel.this.version >= 3) {
                        int cmd = response.readUnsignedByte();
                        XAOutflowHandle outflowHandle = MethodInvocation.this.getOutflowHandle();
                        if (outflowHandle != null) {
                            if (cmd == 0) {
                                outflowHandle.forgetEnlistment();
                            } else if (cmd == 1) {
                                try {
                                    outflowHandle.verifyEnlistment();
                                }
                                catch (RollbackException | SystemException e1) {
                                    throw new EJBException((Exception)e1);
                                }
                            } else if (cmd == 2) {
                                outflowHandle.nonMasterEnlistment();
                            }
                        }
                    }
                    try (Unmarshaller unmarshaller = EJBClientChannel.this.createUnmarshaller();){
                        unmarshaller.start((ByteInput)response);
                        e = (Exception)unmarshaller.readObject(Exception.class);
                        if (EJBClientChannel.this.version < 3) {
                            int attachments = unmarshaller.readUnsignedByte();
                            for (int i = 0; i < attachments; ++i) {
                                unmarshaller.readObject();
                                unmarshaller.readObject();
                            }
                        }
                        unmarshaller.finish();
                    }
                }
                catch (IOException | ClassNotFoundException ex) {
                    this.discardResult();
                    throw new EJBException("Failed to read response", ex);
                }
                if (e == null) {
                    throw new EJBException("Null exception response");
                }
                EJBClientChannel.glueStackTraces(e, Thread.currentThread().getStackTrace(), 1, "asynchronous invocation");
                throw e;
            }

            @Override
            public void discardResult() {
                IoUtils.safeClose((Closeable)this.inputStream);
            }
        }
    }

    final class SessionOpenInvocation<T>
    extends Invocation {
        private final StatelessEJBLocator<T> statelessLocator;
        private final EJBSessionCreationInvocationContext clientInvocationContext;
        private int id;
        private MessageInputStream inputStream;
        private XAOutflowHandle outflowHandle;
        private IOException ex;

        protected SessionOpenInvocation(int index, StatelessEJBLocator<T> statelessLocator, EJBSessionCreationInvocationContext clientInvocationContext) {
            super(index);
            this.statelessLocator = statelessLocator;
            this.clientInvocationContext = clientInvocationContext;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void handleResponse(int id, MessageInputStream inputStream) {
            SessionOpenInvocation sessionOpenInvocation = this;
            synchronized (sessionOpenInvocation) {
                this.id = id;
                this.inputStream = inputStream;
                ((Object)((Object)this)).notifyAll();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void handleClosed() {
            SessionOpenInvocation sessionOpenInvocation = this;
            synchronized (sessionOpenInvocation) {
                ((Object)((Object)this)).notifyAll();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void handleException(IOException cause) {
            SessionOpenInvocation sessionOpenInvocation = this;
            synchronized (sessionOpenInvocation) {
                this.ex = cause;
                ((Object)((Object)this)).notifyAll();
            }
        }

        void setOutflowHandle(XAOutflowHandle outflowHandle) {
            this.outflowHandle = outflowHandle;
        }

        XAOutflowHandle getOutflowHandle() {
            return this.outflowHandle;
        }

        /*
         * Unable to fully structure code
         */
        StatefulEJBLocator<T> getResult() throws Exception {
            try {
                response = this.removeInvocationResult();
                try {
                    switch (this.id) {
                        case 2: {
                            size = PackedInteger.readPackedInteger((DataInput)response);
                            bytes = new byte[size];
                            response.readFully(bytes);
                            if (1 <= EJBClientChannel.access$200(EJBClientChannel.this) && EJBClientChannel.access$200(EJBClientChannel.this) <= 2) {
                                unmarshaller = EJBClientChannel.this.createUnmarshaller();
                                try {
                                    unmarshaller.start((ByteInput)response);
                                    affinity = (Affinity)unmarshaller.readObject(Affinity.class);
                                    unmarshaller.finish();
                                }
                                finally {
                                    if (unmarshaller != null) {
                                        unmarshaller.close();
                                    }
                                }
                            } else {
                                affinity = this.statelessLocator.getAffinity();
                                cmd = response.readUnsignedByte();
                                outflowHandle = this.getOutflowHandle();
                                if (outflowHandle != null) {
                                    if (cmd == 0) {
                                        outflowHandle.forgetEnlistment();
                                    } else if (cmd == 1) {
                                        try {
                                            outflowHandle.verifyEnlistment();
                                        }
                                        catch (RollbackException | SystemException e1) {
                                            throw new EJBException((Exception)e1);
                                        }
                                    } else if (cmd == 2) {
                                        outflowHandle.nonMasterEnlistment();
                                    }
                                }
                                if (Bits.allAreSet((int)(updateBits = response.readUnsignedByte()), (int)2)) {
                                    b = new byte[PackedInteger.readPackedInteger((DataInput)response)];
                                    response.readFully(b);
                                    this.clientInvocationContext.setWeakAffinity(new NodeAffinity(new String(b, StandardCharsets.UTF_8)));
                                }
                                if (Bits.allAreSet((int)updateBits, (int)4)) {
                                    b = new byte[PackedInteger.readPackedInteger((DataInput)response)];
                                    response.readFully(b);
                                    clusterName = new String(b, StandardCharsets.UTF_8);
                                    affinity = new ClusterAffinity(clusterName);
                                }
                            }
                            locator = this.statelessLocator.withSessionAndAffinity(SessionID.createSessionID(bytes), affinity);
                            if (Logs.INVOCATION.isDebugEnabled()) {
                                Logs.INVOCATION.debugf("EJBClientChannel.SessionOpenInvocation.getResult(): updating Locator (sessionID), new = %s; weakAffinity = %s", locator, this.clientInvocationContext.getWeakAffinity());
                            }
                            this.clientInvocationContext.setLocator(locator);
                            var7_22 = locator;
                            return var7_22;
                        }
                        case 6: {
                            if (EJBClientChannel.access$200(EJBClientChannel.this) >= 3) {
                                cmd = response.readUnsignedByte();
                                outflowHandle = this.getOutflowHandle();
                                if (outflowHandle != null) {
                                    if (cmd == 0) {
                                        outflowHandle.forgetEnlistment();
                                    } else if (cmd == 1) {
                                        try {
                                            outflowHandle.verifyEnlistment();
                                        }
                                        catch (RollbackException | SystemException e1) {
                                            throw new EJBException((Exception)e1);
                                        }
                                    } else if (cmd == 2) {
                                        outflowHandle.nonMasterEnlistment();
                                    }
                                }
                            }
                            unmarshaller = EJBClientChannel.this.createUnmarshaller();
                            try {
                                unmarshaller.start((ByteInput)response);
                                e = (Exception)unmarshaller.readObject(Exception.class);
                                unmarshaller.finish();
                                if (EJBClientChannel.access$200(EJBClientChannel.this) < 3) {
                                    while (response.read() != -1) {
                                        response.skip(0x7FFFFFFFFFFFFFFFL);
                                    }
                                }
                            }
                            finally {
                                if (unmarshaller != null) {
                                    unmarshaller.close();
                                }
                            }
                            EJBClientChannel.access$300(e, Thread.currentThread().getStackTrace(), 1, "asynchronous invocation");
                            ** break;
lbl83:
                            // 1 sources

                            break;
                        }
                        case 7: {
                            if (EJBClientChannel.access$200(EJBClientChannel.this) >= 3 && (outflowHandle = this.getOutflowHandle()) != null) {
                                outflowHandle.forgetEnlistment();
                            }
                            EJBClientChannel.access$400(this.clientInvocationContext);
                            throw Logs.REMOTING.requestCancelled();
                        }
                        case 10: {
                            if (EJBClientChannel.access$200(EJBClientChannel.this) >= 3 && (outflowHandle = this.getOutflowHandle()) != null) {
                                outflowHandle.forgetEnlistment();
                            }
                            EJBClientChannel.access$400(this.clientInvocationContext);
                            message = response.readUTF();
                            throw new NoSuchEJBException(message + " @ " + EJBClientChannel.this.getChannel().getConnection().getPeerURI());
                        }
                        case 28: {
                            if (EJBClientChannel.access$200(EJBClientChannel.this) >= 3 && (outflowHandle = this.getOutflowHandle()) != null) {
                                outflowHandle.forgetEnlistment();
                            }
                            EJBClientChannel.access$400(this.clientInvocationContext);
                            message = response.readUTF();
                            throw Logs.REMOTING.invalidViewTypeForInvocation(message);
                        }
                        case 13: {
                            if (EJBClientChannel.access$200(EJBClientChannel.this) >= 3 && (outflowHandle = this.getOutflowHandle()) != null) {
                                outflowHandle.forgetEnlistment();
                            }
                            EJBClientChannel.access$400(this.clientInvocationContext);
                            message = response.readUTF();
                            throw Logs.REMOTING.ejbNotStateful(message);
                        }
                        default: {
                            throw new EJBException("Invalid EJB creation response (id " + this.id + ")");
                        }
                    }
                }
                finally {
                    if (response != null) {
                        response.close();
                    }
                }
            }
            catch (IOException | ClassNotFoundException ex) {
                throw new EJBException("Failed to read session create response", ex);
            }
            finally {
                EJBClientChannel.access$500(EJBClientChannel.this).remove((Invocation)this);
            }
            if (e == null) {
                throw new EJBException("Null exception response");
            }
            throw e;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private ResponseMessageInputStream removeInvocationResult() {
            MessageInputStream mis;
            int id;
            try {
                SessionOpenInvocation sessionOpenInvocation = this;
                synchronized (sessionOpenInvocation) {
                    while (true) {
                        id = this.getIndex();
                        if (this.inputStream != null) break;
                        if (this.ex != null) {
                            throw new EJBException((Exception)this.ex);
                        }
                        if (id == -1) {
                            throw new EJBException("Connection closed");
                        }
                        ((Object)((Object)this)).wait();
                    }
                    mis = this.inputStream;
                    this.inputStream = null;
                }
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new EJBException("Session creation interrupted");
            }
            return new ResponseMessageInputStream((InputStream)mis, id);
        }
    }
}

