/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.mapper.pojo.work.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.concurrent.CompletableFuture;
import org.hibernate.search.engine.backend.common.spi.EntityReferenceFactory;
import org.hibernate.search.engine.backend.common.spi.MultiEntityOperationExecutionReport;
import org.hibernate.search.engine.backend.work.execution.DocumentCommitStrategy;
import org.hibernate.search.engine.backend.work.execution.DocumentRefreshStrategy;
import org.hibernate.search.engine.backend.work.execution.spi.IndexIndexingPlan;
import org.hibernate.search.mapper.pojo.processing.spi.PojoIndexingProcessorRootContext;
import org.hibernate.search.mapper.pojo.work.impl.PojoContainedTypeIndexingPlan;
import org.hibernate.search.mapper.pojo.work.impl.PojoIndexedTypeIndexingPlan;
import org.hibernate.search.mapper.pojo.work.impl.PojoIndexingPlanStrategy;
import org.hibernate.search.mapper.pojo.work.impl.PojoLoadingPlanProvider;
import org.hibernate.search.mapper.pojo.work.impl.PojoTypeIndexingPlanIndexOrEventQueueDelegate;
import org.hibernate.search.mapper.pojo.work.impl.PojoWorkContainedTypeContext;
import org.hibernate.search.mapper.pojo.work.impl.PojoWorkIndexedTypeContext;
import org.hibernate.search.mapper.pojo.work.spi.PojoIndexingQueueEventSendingPlan;
import org.hibernate.search.mapper.pojo.work.spi.PojoWorkSessionContext;

public class PojoIndexingPlanEventProcessingStrategy
implements PojoIndexingPlanStrategy {
    final DocumentCommitStrategy commitStrategy;
    final DocumentRefreshStrategy refreshStrategy;
    private final PojoIndexingQueueEventSendingPlan sendingPlan;

    public PojoIndexingPlanEventProcessingStrategy(DocumentCommitStrategy commitStrategy, DocumentRefreshStrategy refreshStrategy, PojoIndexingQueueEventSendingPlan sendingPlan) {
        this.commitStrategy = commitStrategy;
        this.refreshStrategy = refreshStrategy;
        this.sendingPlan = sendingPlan;
    }

    @Override
    public boolean shouldResolveDirtyForDeleteOnly() {
        return false;
    }

    @Override
    public <R> CompletableFuture<MultiEntityOperationExecutionReport<R>> doExecuteAndReport(Collection<PojoIndexedTypeIndexingPlan<?, ?>> indexedTypeDelegates, PojoLoadingPlanProvider loadingPlanProvider, EntityReferenceFactory<R> entityReferenceFactory) {
        ArrayList<CompletableFuture<MultiEntityOperationExecutionReport<R>>> futures = new ArrayList<CompletableFuture<MultiEntityOperationExecutionReport<R>>>();
        for (PojoIndexedTypeIndexingPlan<?, ?> delegate : indexedTypeDelegates) {
            futures.add(delegate.executeAndReport(entityReferenceFactory));
        }
        futures.add(this.sendingPlan.sendAndReport(entityReferenceFactory));
        return MultiEntityOperationExecutionReport.allOf(futures);
    }

    @Override
    public void doDiscard(Collection<PojoIndexedTypeIndexingPlan<?, ?>> indexedTypeDelegates) {
        for (PojoIndexedTypeIndexingPlan<?, ?> delegate : indexedTypeDelegates) {
            delegate.discard();
        }
        this.sendingPlan.discard();
    }

    @Override
    public <I, E> PojoIndexedTypeIndexingPlan<I, E> createDelegate(PojoWorkIndexedTypeContext<I, E> typeContext, PojoWorkSessionContext sessionContext, PojoIndexingProcessorRootContext processorContext) {
        IndexIndexingPlan indexIndexingPlan = typeContext.createIndexingPlan(sessionContext, this.commitStrategy, this.refreshStrategy);
        return new PojoIndexedTypeIndexingPlan<I, E>(typeContext, sessionContext, new PojoTypeIndexingPlanIndexOrEventQueueDelegate<I, E>(typeContext, sessionContext, processorContext, indexIndexingPlan, this.sendingPlan));
    }

    @Override
    public <I, E> PojoContainedTypeIndexingPlan<I, E> createDelegate(PojoWorkContainedTypeContext<I, E> typeContext, PojoWorkSessionContext sessionContext) {
        return new PojoContainedTypeIndexingPlan<I, E>(typeContext, sessionContext, null);
    }
}

