/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.backend;

import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import org.infinispan.query.logging.Log;

public final class TransactionHelper {
    private final TransactionManager transactionManager;

    public TransactionHelper(TransactionManager transactionManager) {
        this.transactionManager = transactionManager;
    }

    public void resume(Transaction transaction) {
        if (transaction != null) {
            try {
                this.transactionManager.resume(transaction);
            }
            catch (Exception e) {
                throw Log.CONTAINER.unableToResumeSuspendedTx(transaction, e);
            }
        }
    }

    public Transaction suspendTxIfExists() {
        if (this.transactionManager == null) {
            return null;
        }
        try {
            return this.transactionManager.suspend();
        }
        catch (Exception e) {
            throw Log.CONTAINER.unableToSuspendTx(e);
        }
    }
}

