/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.undertow.session;

import io.undertow.servlet.api.SessionManagerFactory;
import java.util.List;
import java.util.function.Function;
import org.jboss.as.clustering.controller.CapabilityServiceConfigurator;
import org.jboss.as.web.session.AffinityLocator;
import org.jboss.as.web.session.SessionIdentifierCodec;
import org.jboss.msc.service.ServiceName;
import org.wildfly.clustering.service.ServiceNameProvider;
import org.wildfly.clustering.service.ServiceSupplierDependency;
import org.wildfly.clustering.service.SupplierDependency;
import org.wildfly.clustering.web.container.SessionManagementProvider;
import org.wildfly.clustering.web.container.SessionManagerFactoryConfiguration;
import org.wildfly.clustering.web.container.WebDeploymentConfiguration;
import org.wildfly.extension.undertow.session.SessionConfigWrapperFactoryServiceConfigurator;
import org.wildfly.extension.undertow.session.SessionManagerFactoryServiceConfigurator;
import org.wildfly.extension.undertow.session.SimpleAffinityLocatorServiceConfigurator;
import org.wildfly.extension.undertow.session.SimpleSessionIdentifierCodecServiceConfigurator;

public class NonDistributableSessionManagementProvider
implements SessionManagementProvider {
    private final Function<SessionManagerFactoryConfiguration, SessionManagerFactory> factory;

    public NonDistributableSessionManagementProvider(Function<SessionManagerFactoryConfiguration, SessionManagerFactory> factory) {
        this.factory = factory;
    }

    public Iterable<CapabilityServiceConfigurator> getSessionManagerFactoryServiceConfigurators(ServiceName name, SessionManagerFactoryConfiguration configuration) {
        return List.of(new SessionManagerFactoryServiceConfigurator(name, () -> this.factory.apply(configuration)));
    }

    public Iterable<CapabilityServiceConfigurator> getSessionAffinityServiceConfigurators(ServiceName name, WebDeploymentConfiguration configuration) {
        SimpleSessionIdentifierCodecServiceConfigurator codecConfigurator = new SimpleSessionIdentifierCodecServiceConfigurator(name.append(new String[]{"codec"}), configuration.getServerName());
        SimpleAffinityLocatorServiceConfigurator locatorConfigurator = new SimpleAffinityLocatorServiceConfigurator(name.append(new String[]{"locator"}), configuration.getServerName());
        SessionConfigWrapperFactoryServiceConfigurator wrapperFactoryConfigurator = new SessionConfigWrapperFactoryServiceConfigurator(name, (SupplierDependency<SessionIdentifierCodec>)new ServiceSupplierDependency((ServiceNameProvider)codecConfigurator), (SupplierDependency<AffinityLocator>)new ServiceSupplierDependency((ServiceNameProvider)locatorConfigurator));
        return List.of(codecConfigurator, locatorConfigurator, wrapperFactoryConfigurator);
    }
}

