/*
 * Decompiled with CFR 0.152.
 */
package com.arjuna.ats.internal.arjuna.objectstore;

import com.arjuna.ats.arjuna.common.ObjectStoreEnvironmentBean;
import com.arjuna.ats.arjuna.common.Uid;
import com.arjuna.ats.arjuna.common.arjPropertyManager;
import com.arjuna.ats.arjuna.exceptions.ObjectStoreException;
import com.arjuna.ats.arjuna.logging.tsLogger;
import com.arjuna.ats.arjuna.objectstore.ObjectStore;
import com.arjuna.ats.arjuna.state.InputObjectState;
import com.arjuna.ats.arjuna.state.OutputObjectState;
import com.arjuna.ats.arjuna.utils.FileLock;
import com.arjuna.ats.arjuna.utils.Utility;
import com.arjuna.ats.internal.arjuna.common.UidHelper;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Hashtable;

public abstract class FileSystemStore
extends ObjectStore {
    static final char unixSeparator = '/';
    static final boolean rewriteSeparator = File.separatorChar != '/';
    protected boolean syncWrites = true;
    private final String fullStoreName = this.locateStore(this._objectStoreRoot);
    protected volatile boolean doSync = true;
    private static final Hashtable fileCache = new Hashtable();
    private static final int createRetry = arjPropertyManager.getObjectStoreEnvironmentBean().getHierarchyRetry();
    private static final int createTimeout = arjPropertyManager.getObjectStoreEnvironmentBean().getHierarchyTimeout();
    protected boolean scanZeroLengthFiles = false;
    private static final boolean isWindows = Utility.isWindows();

    @Override
    public String getStoreName() {
        return this._objectStoreRoot;
    }

    @Override
    public InputObjectState read_committed(Uid storeUid, String tName) throws ObjectStoreException {
        if (tsLogger.logger.isTraceEnabled()) {
            tsLogger.logger.trace((Object)("FileSystemStore.read_committed(" + storeUid + ", " + tName + ")"));
        }
        return this.read_state_internal(storeUid, tName, 11);
    }

    @Override
    public InputObjectState read_uncommitted(Uid storeUid, String tName) throws ObjectStoreException {
        if (tsLogger.logger.isTraceEnabled()) {
            tsLogger.logger.trace((Object)("FileSystemStore.read_uncommitted(" + storeUid + ", " + tName + ")"));
        }
        return this.read_state_internal(storeUid, tName, 10);
    }

    @Override
    public boolean remove_committed(Uid storeUid, String tName) throws ObjectStoreException {
        if (tsLogger.logger.isTraceEnabled()) {
            tsLogger.logger.trace((Object)("FileSystemStore.remove_committed(" + storeUid + ", " + tName + ")"));
        }
        return this.remove_state_internal(storeUid, tName, 11);
    }

    @Override
    public boolean remove_uncommitted(Uid storeUid, String tName) throws ObjectStoreException {
        if (tsLogger.logger.isTraceEnabled()) {
            tsLogger.logger.trace((Object)("FileSystemStore.remove_uncommitted(" + storeUid + ", " + tName + ")"));
        }
        return this.remove_state_internal(storeUid, tName, 10);
    }

    @Override
    public boolean write_committed(Uid storeUid, String tName, OutputObjectState state) throws ObjectStoreException {
        if (tsLogger.logger.isTraceEnabled()) {
            tsLogger.logger.trace((Object)("FileSystemStore.write_committed(" + storeUid + ", " + tName + ")"));
        }
        return this.write_state_internal(storeUid, tName, state, 11);
    }

    @Override
    public boolean write_uncommitted(Uid storeUid, String tName, OutputObjectState state) throws ObjectStoreException {
        if (tsLogger.logger.isTraceEnabled()) {
            tsLogger.logger.trace((Object)("FileSystemStore.write_uncommitted(" + storeUid + ", " + tName + ", " + state + ")"));
        }
        return this.write_state_internal(storeUid, tName, state, 10);
    }

    @Override
    public boolean allObjUids(final String tName, final InputObjectState state, final int match) throws ObjectStoreException {
        if (System.getSecurityManager() == null) {
            return this.allObjUidsInternal(tName, state, match);
        }
        try {
            return AccessController.doPrivileged(new PrivilegedExceptionAction<Boolean>(){

                @Override
                public Boolean run() throws Exception {
                    return FileSystemStore.this.allObjUidsInternal(tName, state, match);
                }
            });
        }
        catch (PrivilegedActionException e) {
            throw this.unwrapException(e);
        }
    }

    private RuntimeException unwrapException(PrivilegedActionException e) throws ObjectStoreException {
        Throwable c = e.getCause();
        if (c instanceof ObjectStoreException) {
            throw (ObjectStoreException)c;
        }
        if (c instanceof RuntimeException) {
            throw (RuntimeException)c;
        }
        if (c instanceof Error) {
            throw (Error)c;
        }
        throw new RuntimeException(c);
    }

    private boolean allObjUidsInternal(String tName, InputObjectState state, int match) throws ObjectStoreException {
        if (tsLogger.logger.isTraceEnabled()) {
            tsLogger.logger.trace((Object)("FileSystemStore.allObjUids(" + tName + ", " + state + ", " + match + ")"));
        }
        String directory = null;
        OutputObjectState store = new OutputObjectState();
        if (tName != null && tName.length() > 0 && tName.charAt(0) == File.separatorChar) {
            String s = tName.substring(1, tName.length());
            directory = new String(this.fullStoreName + s);
        } else {
            directory = new String(this.fullStoreName + tName);
        }
        File f = new File(directory);
        String[] entry = f.list(new FileFilter());
        if (entry != null && entry.length > 0) {
            for (int i = 0; i < entry.length; ++i) {
                try {
                    Uid aUid = new Uid(entry[i], true);
                    if (!aUid.valid() || aUid.equals(Uid.nullUid())) {
                        String revealed = this.revealedId(entry[i]);
                        aUid = this.present(revealed, entry) ? null : new Uid(revealed);
                    }
                    if (aUid == null || !aUid.valid() || !aUid.notEquals(Uid.nullUid()) || match != -1 && !this.isType(aUid, tName, match) || !this.scanZeroLengthFiles && new File(f, entry[i]).length() <= 0L) continue;
                    UidHelper.packInto(aUid, store);
                    continue;
                }
                catch (NumberFormatException aUid) {
                    continue;
                }
                catch (IOException e) {
                    throw new ObjectStoreException(tsLogger.i18NLogger.get_objectstore_FileSystemStore_2a(), e);
                }
            }
        }
        try {
            UidHelper.packInto(Uid.nullUid(), store);
        }
        catch (IOException e) {
            throw new ObjectStoreException(tsLogger.i18NLogger.get_objectstore_FileSystemStore_3(), e);
        }
        state.setBuffer(store.buffer());
        store = null;
        return true;
    }

    @Override
    public boolean allTypes(InputObjectState foundTypes) throws ObjectStoreException {
        if (tsLogger.logger.isTraceEnabled()) {
            tsLogger.logger.trace((Object)("FileSystemStore.allTypes(" + foundTypes + ")"));
        }
        boolean result = true;
        String directory = new String(this.fullStoreName);
        File f = new File(directory);
        String[] entry = f.list();
        if (entry == null) {
            return true;
        }
        OutputObjectState store = new OutputObjectState();
        for (int i = 0; i < entry.length; ++i) {
            if (this.supressEntry(entry[i])) continue;
            File tmpFile = new File(directory + File.separator + entry[i]);
            if (tmpFile.isDirectory()) {
                try {
                    store.packString(entry[i]);
                    result = this.allTypes(store, entry[i]);
                }
                catch (IOException e) {
                    throw new ObjectStoreException(tsLogger.i18NLogger.get_objectstore_FileSystemStore_4(), e);
                }
            }
            tmpFile = null;
        }
        try {
            store.packString("");
        }
        catch (IOException e) {
            throw new ObjectStoreException(tsLogger.i18NLogger.get_objectstore_FileSystemStore_5(), e);
        }
        foundTypes.setBuffer(store.buffer());
        return result;
    }

    private InputObjectState read_state_internal(final Uid u, final String tn, final int s) throws ObjectStoreException {
        if (System.getSecurityManager() == null) {
            return this.read_state(u, tn, s);
        }
        try {
            return AccessController.doPrivileged(new PrivilegedExceptionAction<InputObjectState>(){

                @Override
                public InputObjectState run() throws Exception {
                    return FileSystemStore.this.read_state(u, tn, s);
                }
            });
        }
        catch (PrivilegedActionException e) {
            throw this.unwrapException(e);
        }
    }

    private boolean remove_state_internal(final Uid u, final String tn, final int s) throws ObjectStoreException {
        if (System.getSecurityManager() == null) {
            return this.remove_state(u, tn, s);
        }
        try {
            return AccessController.doPrivileged(new PrivilegedExceptionAction<Boolean>(){

                @Override
                public Boolean run() throws Exception {
                    return FileSystemStore.this.remove_state(u, tn, s);
                }
            });
        }
        catch (PrivilegedActionException e) {
            throw this.unwrapException(e);
        }
    }

    private boolean write_state_internal(final Uid u, final String tn, final OutputObjectState buff, final int s) throws ObjectStoreException {
        if (System.getSecurityManager() == null) {
            return this.write_state(u, tn, buff, s);
        }
        try {
            return AccessController.doPrivileged(new PrivilegedExceptionAction<Boolean>(){

                @Override
                public Boolean run() throws Exception {
                    return FileSystemStore.this.write_state(u, tn, buff, s);
                }
            });
        }
        catch (PrivilegedActionException e) {
            throw this.unwrapException(e);
        }
    }

    protected abstract InputObjectState read_state(Uid var1, String var2, int var3) throws ObjectStoreException;

    protected abstract boolean remove_state(Uid var1, String var2, int var3) throws ObjectStoreException;

    protected abstract boolean write_state(Uid var1, String var2, OutputObjectState var3, int var4) throws ObjectStoreException;

    protected final synchronized boolean synchronousWrites() {
        return this.doSync && this.syncWrites;
    }

    protected synchronized boolean lock(final File fd, final int lmode, final boolean create) {
        if (System.getSecurityManager() == null) {
            FileLock fileLock = new FileLock(fd);
            return fileLock.lock(lmode, create);
        }
        return AccessController.doPrivileged(new PrivilegedAction<Boolean>(){

            @Override
            public Boolean run() {
                FileLock fileLock = new FileLock(fd);
                return fileLock.lock(lmode, create);
            }
        });
    }

    protected synchronized boolean unlock(final File fd) {
        if (System.getSecurityManager() == null) {
            FileLock fileLock = new FileLock(fd);
            return fileLock.unlock();
        }
        return AccessController.doPrivileged(new PrivilegedAction<Boolean>(){

            @Override
            public Boolean run() {
                FileLock fileLock = new FileLock(fd);
                return fileLock.unlock();
            }
        });
    }

    protected boolean closeAndUnlock(File fd, FileInputStream ifile, FileOutputStream ofile) {
        if (tsLogger.logger.isTraceEnabled()) {
            tsLogger.logger.trace((Object)("FileSystemStore.closeAndUnlock(" + fd + ", " + ifile + ", " + ofile + ")"));
        }
        boolean closedOk = this.unlock(fd);
        try {
            if (ifile != null) {
                ifile.close();
            }
        }
        catch (Exception e) {
            closedOk = false;
        }
        try {
            if (ofile != null) {
                ofile.close();
            }
        }
        catch (Exception e) {
            closedOk = false;
        }
        return closedOk;
    }

    protected File openAndLock(final String fname, final int lmode, final boolean create) throws ObjectStoreException {
        if (System.getSecurityManager() == null) {
            return this.openAndLockInternal(fname, lmode, create);
        }
        try {
            return AccessController.doPrivileged(new PrivilegedExceptionAction<File>(){

                @Override
                public File run() throws Exception {
                    return FileSystemStore.this.openAndLockInternal(fname, lmode, create);
                }
            });
        }
        catch (PrivilegedActionException e) {
            throw this.unwrapException(e);
        }
    }

    private File openAndLockInternal(String fname, int lmode, boolean create) throws ObjectStoreException {
        File fd;
        if (tsLogger.logger.isTraceEnabled()) {
            tsLogger.logger.trace((Object)("FileSystemStore.openAndLock(" + fname + ", " + FileLock.modeString(lmode) + ", " + create + ")"));
        }
        if ((fd = null) == null) {
            fd = new File(fname);
            if (!fd.getParentFile().exists()) {
                if (this.createHierarchy(fname)) {
                    if (!this.lock(fd, lmode, create)) {
                        return null;
                    }
                    return fd;
                }
                throw new ObjectStoreException("FileSystemStore.openAndLock failed to create hierarchy " + fname);
            }
            if (!this.lock(fd, lmode, create)) {
                fd = null;
            }
        }
        return fd;
    }

    protected final synchronized boolean renameFromTo(final File from, final File to) {
        if (System.getSecurityManager() == null) {
            return this.renameFromToInternal(from, to);
        }
        return AccessController.doPrivileged(new PrivilegedAction<Boolean>(){

            @Override
            public Boolean run() {
                return FileSystemStore.this.renameFromToInternal(from, to);
            }
        });
    }

    protected final boolean renameFromToInternal(File from, File to) {
        if (!isWindows) {
            return from.renameTo(to);
        }
        if (!from.exists()) {
            this.removeFromCache(from.toString());
            tsLogger.i18NLogger.warn_objectstore_FileSystemStore_20(from.getName());
            return true;
        }
        to.delete();
        boolean res = from.renameTo(to);
        return true;
    }

    public FileSystemStore(ObjectStoreEnvironmentBean objectStoreEnvironmentBean) throws ObjectStoreException {
        super(objectStoreEnvironmentBean);
        this.doSync = objectStoreEnvironmentBean.isObjectStoreSync();
        this.scanZeroLengthFiles = objectStoreEnvironmentBean.isScanZeroLengthFiles();
        if (this.fullStoreName == null || !this.createHierarchy(this.fullStoreName)) {
            throw new ObjectStoreException(tsLogger.i18NLogger.get_objectstore_FileSystemStore_1(this.fullStoreName));
        }
    }

    protected boolean allTypes(final OutputObjectState foundTypes, final String root) throws ObjectStoreException {
        if (System.getSecurityManager() == null) {
            return this.allTypesInternal(foundTypes, root);
        }
        try {
            return AccessController.doPrivileged(new PrivilegedExceptionAction<Boolean>(){

                @Override
                public Boolean run() throws Exception {
                    return FileSystemStore.this.allTypesInternal(foundTypes, root);
                }
            });
        }
        catch (PrivilegedActionException e) {
            throw this.unwrapException(e);
        }
    }

    private boolean allTypesInternal(OutputObjectState foundTypes, String root) throws ObjectStoreException {
        if (tsLogger.logger.isTraceEnabled()) {
            tsLogger.logger.trace((Object)("FileSystemStore.allTypes(" + foundTypes + ", " + root + ")"));
        }
        boolean result = true;
        String directory = new String(this.fullStoreName + File.separator + root);
        File f = new File(directory);
        String[] entry = f.list();
        if (entry != null && entry.length > 0) {
            for (int i = 0; i < entry.length; ++i) {
                if (this.supressEntry(entry[i])) continue;
                try {
                    String pack;
                    File tmpFile = new File(directory + File.separator + entry[i]);
                    if (tmpFile.isDirectory() && (pack = this.truncate(entry[i])).length() > 0) {
                        foundTypes.packString(root + File.separator + pack);
                        result = this.allTypes(foundTypes, root + File.separator + pack);
                    }
                    tmpFile = null;
                    continue;
                }
                catch (IOException e) {
                    throw new ObjectStoreException(tsLogger.i18NLogger.get_objectstore_FileSystemStore_7(), e);
                }
            }
        }
        return result;
    }

    protected String genPathName(Uid objUid, String tName, int ostype) throws ObjectStoreException {
        if (tsLogger.logger.isTraceEnabled()) {
            tsLogger.logger.trace((Object)("FileSystemStore.genPathName(" + objUid + ", " + tName + ", " + ostype + ")"));
        }
        String storeName = this.locateStore(this.getStoreName());
        String cPtr = null;
        Object fname = null;
        String os = objUid.fileStringForm();
        if (tName == null || tName.length() == 0) {
            cPtr = "";
        } else {
            cPtr = tName;
            if (rewriteSeparator && cPtr.indexOf(47) != -1) {
                cPtr = cPtr.replace('/', File.separatorChar);
            }
        }
        if (cPtr.charAt(0) == File.separatorChar) {
            cPtr = cPtr.substring(1, cPtr.length());
        }
        if (((String)(fname = cPtr.charAt(cPtr.length() - 1) != File.separatorChar ? storeName + cPtr + File.separator + os : storeName + cPtr + os)).charAt(((String)fname).length() - 1) == File.separatorChar) {
            fname = ((String)fname).substring(0, ((String)fname).length() - 2);
        }
        return fname;
    }

    @Override
    protected boolean supressEntry(String name) {
        return name.compareTo(".") == 0 || name.compareTo("..") == 0;
    }

    protected String truncate(String value) {
        return value;
    }

    protected final synchronized boolean createHierarchy(String path) throws ObjectStoreException {
        if (tsLogger.logger.isTraceEnabled()) {
            tsLogger.logger.trace((Object)("FileSystemStore.createHierarchy(" + path + ")"));
        }
        if (path != null && path.length() > 0) {
            File f = null;
            if (path.charAt(path.length() - 1) != File.separatorChar) {
                int index = path.lastIndexOf(File.separator);
                if (index <= 0) {
                    return true;
                }
                f = new File(path.substring(0, index));
            } else {
                f = new File(path);
            }
            int retryLimit = createRetry;
            do {
                if (f.exists()) {
                    return true;
                }
                if (!f.mkdirs()) {
                    if (--retryLimit == 0) {
                        return false;
                    }
                    try {
                        Thread.currentThread();
                        Thread.sleep(createTimeout);
                    }
                    catch (Exception exception) {}
                    continue;
                }
                return true;
            } while (!f.exists() && retryLimit > 0);
            return f.exists();
        }
        throw new ObjectStoreException(tsLogger.i18NLogger.get_objectstore_FileSystemStore_8());
    }

    protected final boolean exists(String path) {
        boolean doesExist;
        if (this.shareStatus == 14 && fileCache.get(path) != null) {
            return true;
        }
        File f = new File(path);
        boolean bl = doesExist = f.exists() && (this.scanZeroLengthFiles || f.length() > 0L);
        if (doesExist) {
            this.addToCache(path);
        }
        return doesExist;
    }

    protected final void addToCache(String fname) {
        if (this.shareStatus == 14) {
            fileCache.put(fname, fname);
        }
    }

    protected final void removeFromCache(String fname) {
        this.removeFromCache(fname, true);
    }

    protected final void removeFromCache(String fname, boolean warn) {
        if (this.shareStatus == 14 && fileCache.remove(fname) == null && warn) {
            tsLogger.i18NLogger.warn_objectstore_FileSystemStore_2(fname);
        }
    }

    private final boolean present(String id, String[] list2) {
        for (int i = 0; i < list2.length; ++i) {
            if (!list2[i].equals(id)) continue;
            return true;
        }
        return false;
    }

    class FileFilter
    implements FilenameFilter {
        FileFilter() {
        }

        @Override
        public boolean accept(File dir, String name) {
            File f = new File(name);
            return !f.isDirectory();
        }
    }
}

