/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.elasticsearch.work.impl;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import org.hibernate.search.backend.elasticsearch.util.spi.URLEncodedString;
import org.hibernate.search.backend.elasticsearch.work.impl.AbstractSingleDocumentIndexingWork;
import org.hibernate.search.backend.elasticsearch.work.impl.ElasticsearchRequestSuccessAssessor;

public class DeleteWork
extends AbstractSingleDocumentIndexingWork {
    private static final ElasticsearchRequestSuccessAssessor SUCCESS_ASSESSOR = ElasticsearchRequestSuccessAssessor.builder().ignoreErrorStatuses(404).build();

    private DeleteWork(Builder builder) {
        super(builder);
    }

    public static class Builder
    extends AbstractSingleDocumentIndexingWork.AbstractBuilder<Builder> {
        private final URLEncodedString indexName;
        private final URLEncodedString typeName;
        private final String routingKey;

        public static Builder forElasticsearch67AndBelow(String entityTypeName, Object entityIdentifier, URLEncodedString elasticsearchIndexName, URLEncodedString typeName, String documentIdentifier, String routingKey) {
            return new Builder(entityTypeName, entityIdentifier, elasticsearchIndexName, typeName, documentIdentifier, routingKey);
        }

        public static Builder forElasticsearch7AndAbove(String entityTypeName, Object entityIdentifier, URLEncodedString elasticsearchIndexName, String documentIdentifier, String routingKey) {
            return new Builder(entityTypeName, entityIdentifier, elasticsearchIndexName, null, documentIdentifier, routingKey);
        }

        private Builder(String entityTypeName, Object entityIdentifier, URLEncodedString elasticsearchIndexName, URLEncodedString typeName, String documentIdentifier, String routingKey) {
            super(SUCCESS_ASSESSOR, entityTypeName, entityIdentifier, documentIdentifier);
            this.indexName = elasticsearchIndexName;
            this.typeName = typeName;
            this.routingKey = routingKey;
        }

        @Override
        protected JsonObject buildBulkableActionMetadata() {
            JsonObject delete = new JsonObject();
            delete.addProperty("_index", this.indexName.original);
            if (this.typeName != null) {
                delete.addProperty("_type", this.typeName.original);
            }
            delete.addProperty("_id", this.documentIdentifier);
            if (this.routingKey != null) {
                delete.addProperty("routing", this.routingKey);
            }
            JsonObject result = new JsonObject();
            result.add("delete", (JsonElement)delete);
            return result;
        }

        @Override
        protected JsonObject buildBulkableActionBody() {
            return null;
        }

        @Override
        public DeleteWork build() {
            return new DeleteWork(this);
        }
    }
}

