/*
 * Decompiled with CFR 0.152.
 */
package org.hornetq.utils;

import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicInteger;
import org.hornetq.utils.ReferenceCounter;

public class ReferenceCounterUtil
implements ReferenceCounter {
    private final Runnable runnable;
    private final Executor executor;
    private final AtomicInteger uses = new AtomicInteger(0);

    public ReferenceCounterUtil(Runnable runnable) {
        this(runnable, null);
    }

    public ReferenceCounterUtil(Runnable runnable, Executor executor) {
        this.runnable = runnable;
        this.executor = executor;
    }

    @Override
    public int increment() {
        return this.uses.incrementAndGet();
    }

    @Override
    public int decrement() {
        int value = this.uses.decrementAndGet();
        if (value == 0) {
            if (this.executor != null) {
                this.executor.execute(this.runnable);
            } else {
                this.runnable.run();
            }
        }
        return value;
    }
}

