/*
 * Decompiled with CFR 0.152.
 */
package com.arjuna.webservices11.wsaddr;

import com.arjuna.webservices11.wsaddr.NativeEndpointReference;
import jakarta.xml.ws.EndpointReference;
import jakarta.xml.ws.WebServiceException;
import jakarta.xml.ws.wsaddressing.W3CEndpointReference;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;

public class EndpointHelper {
    public static <T extends EndpointReference> T transform(Class<T> clazz, EndpointReference epr) {
        assert (epr != null);
        if (clazz.isAssignableFrom(W3CEndpointReference.class)) {
            if (epr instanceof W3CEndpointReference) {
                return (T)epr;
            }
            if (epr instanceof NativeEndpointReference) {
                return (T)W3CEndpointReference.readFrom((Source)EndpointHelper.getSourceFromEndpointReference(epr));
            }
            throw new WebServiceException("Unsupported EndpointReference: " + epr);
        }
        if (clazz.isAssignableFrom(NativeEndpointReference.class)) {
            return (T)NativeEndpointReference.readFrom(EndpointHelper.getSourceFromEndpointReference(epr));
        }
        throw new WebServiceException("EndpointReference of type " + clazz + " not supported.");
    }

    private static Source getSourceFromEndpointReference(EndpointReference epr) {
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        StreamResult result = new StreamResult(outputStream);
        epr.writeTo((Result)result);
        return new StreamSource(new ByteArrayInputStream(outputStream.toByteArray()));
    }
}

