/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ejb3.subsystem;

import jakarta.transaction.TransactionSynchronizationRegistry;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.jboss.as.controller.AbstractAddStepHandler;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.CapabilityServiceBuilder;
import org.jboss.as.controller.CapabilityServiceTarget;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.capability.RuntimeCapability;
import org.jboss.as.controller.services.path.PathManager;
import org.jboss.as.ejb3.subsystem.FileDataStoreResourceDefinition;
import org.jboss.as.ejb3.subsystem.TimerServiceResourceDefinition;
import org.jboss.as.ejb3.timerservice.persistence.filestore.FileTimerPersistence;
import org.jboss.as.server.Services;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.Service;

public class FileDataStoreAdd
extends AbstractAddStepHandler {
    private static final String TRANSACTION_SYNCHRONIZATION_REGISTRY_CAPABILITY_NAME = "org.wildfly.transactions.transaction-synchronization-registry";
    private static final String TRANSACTION_GLOBAL_DEFAULT_LOCAL_PROVIDER_CAPABILITY_NAME = "org.wildfly.transactions.global-default-local-provider";
    private static final String PATH_MANAGER_CAPABILITY_NAME = "org.wildfly.management.path-manager";

    FileDataStoreAdd(AttributeDefinition ... attributes) {
        super(attributes);
    }

    protected void performRuntime(OperationContext context, ModelNode operation, ModelNode model) throws OperationFailedException {
        ModelNode pathNode = FileDataStoreResourceDefinition.PATH.resolveModelAttribute(context, model);
        String path = pathNode.isDefined() ? pathNode.asString() : null;
        ModelNode relativeToNode = FileDataStoreResourceDefinition.RELATIVE_TO.resolveModelAttribute(context, model);
        String relativeTo = relativeToNode.isDefined() ? relativeToNode.asString() : null;
        CapabilityServiceTarget serviceTarget = context.getCapabilityServiceTarget();
        CapabilityServiceBuilder builder = serviceTarget.addCapability(TimerServiceResourceDefinition.TIMER_PERSISTENCE_CAPABILITY);
        Consumer consumer = builder.provides(new RuntimeCapability[]{TimerServiceResourceDefinition.TIMER_PERSISTENCE_CAPABILITY});
        builder.requiresCapability(TRANSACTION_GLOBAL_DEFAULT_LOCAL_PROVIDER_CAPABILITY_NAME, Void.class, new String[0]);
        Supplier txnRegistrySupplier = builder.requiresCapability(TRANSACTION_SYNCHRONIZATION_REGISTRY_CAPABILITY_NAME, TransactionSynchronizationRegistry.class, new String[0]);
        Supplier moduleLoaderSupplier = builder.requires(Services.JBOSS_SERVICE_MODULE_LOADER);
        Supplier pathManagerSupplier = builder.requiresCapability(PATH_MANAGER_CAPABILITY_NAME, PathManager.class, new String[0]);
        FileTimerPersistence fileTimerPersistence = new FileTimerPersistence(consumer, txnRegistrySupplier, moduleLoaderSupplier, pathManagerSupplier, true, path, relativeTo);
        builder.setInstance((Service)fileTimerPersistence);
        builder.install();
    }
}

