/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.cli;

import java.io.BufferedReader;
import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import org.apache.activemq.artemis.cli.CLIException;
import org.apache.activemq.artemis.cli.ConfigurationException;
import org.apache.activemq.artemis.cli.Shell;
import org.apache.activemq.artemis.cli.commands.Action;
import org.apache.activemq.artemis.cli.commands.ActionContext;
import org.apache.activemq.artemis.cli.commands.AutoCompletion;
import org.apache.activemq.artemis.cli.commands.Connect;
import org.apache.activemq.artemis.cli.commands.Create;
import org.apache.activemq.artemis.cli.commands.Disconnect;
import org.apache.activemq.artemis.cli.commands.HelpAction;
import org.apache.activemq.artemis.cli.commands.InputAbstract;
import org.apache.activemq.artemis.cli.commands.InvalidOptionsError;
import org.apache.activemq.artemis.cli.commands.Kill;
import org.apache.activemq.artemis.cli.commands.Mask;
import org.apache.activemq.artemis.cli.commands.PrintVersion;
import org.apache.activemq.artemis.cli.commands.Run;
import org.apache.activemq.artemis.cli.commands.Stop;
import org.apache.activemq.artemis.cli.commands.Upgrade;
import org.apache.activemq.artemis.cli.commands.activation.ActivationGroup;
import org.apache.activemq.artemis.cli.commands.address.AddressGroup;
import org.apache.activemq.artemis.cli.commands.check.CheckGroup;
import org.apache.activemq.artemis.cli.commands.messages.Browse;
import org.apache.activemq.artemis.cli.commands.messages.Consumer;
import org.apache.activemq.artemis.cli.commands.messages.Producer;
import org.apache.activemq.artemis.cli.commands.messages.Transfer;
import org.apache.activemq.artemis.cli.commands.messages.perf.PerfGroup;
import org.apache.activemq.artemis.cli.commands.queue.QueueGroup;
import org.apache.activemq.artemis.cli.commands.tools.DataGroup;
import org.apache.activemq.artemis.cli.commands.tools.journal.PerfJournal;
import org.apache.activemq.artemis.cli.commands.user.UserGroup;
import org.apache.activemq.artemis.dto.ManagementContextDTO;
import org.apache.activemq.artemis.dto.XmlUtil;
import picocli.CommandLine;

@CommandLine.Command(name="artemis", description={"ActiveMQ Artemis Command Line"})
public class Artemis
implements Runnable {
    CommandLine commandLine;

    public CommandLine getCommandLine() {
        return this.commandLine;
    }

    public Artemis setCommandLine(CommandLine commandLine) {
        this.commandLine = commandLine;
        return this;
    }

    @Override
    public void run() {
        Shell.runShell(true);
    }

    public static void main(String ... args) throws Exception {
        String home = System.getProperty("artemis.home");
        File fileHome = home != null ? new File(home) : null;
        String instance = System.getProperty("artemis.instance");
        File fileInstance = instance != null ? new File(instance) : null;
        Object brokerEtc = System.getProperty("artemis.instance.etc");
        brokerEtc = brokerEtc != null ? ((String)brokerEtc).replace("\\", "/") : instance + "/etc";
        File fileBrokerETC = new File((String)brokerEtc);
        Artemis.verifyManagementDTO(fileBrokerETC);
        Artemis.execute(true, true, fileHome, fileInstance, fileBrokerETC, args);
    }

    public static void verifyManagementDTO(File etc) {
        File management;
        if (etc != null && (management = new File(etc, "management.xml")).exists()) {
            try {
                ManagementContextDTO managementContextDTO = (ManagementContextDTO)XmlUtil.decode(ManagementContextDTO.class, (File)management);
                if (managementContextDTO != null && managementContextDTO.getAuthorisation() != null) {
                    System.setProperty("javax.management.builder.initial", "org.apache.activemq.artemis.core.server.management.ArtemisMBeanServerBuilder");
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public static Object internalExecute(String ... args) throws Exception {
        return Artemis.internalExecute(null, null, null, args);
    }

    public static Object execute(File artemisHome, File artemisInstance, File etcFolder, List<String> args) throws Exception {
        return Artemis.execute(false, false, artemisHome, artemisInstance, etcFolder, args.toArray(new String[args.size()]));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object execute(boolean inputEnabled, boolean useSystemOut, File artemisHome, File artemisInstance, File etcFolder, String ... args) throws Exception {
        if (etcFolder == null && artemisInstance != null) {
            etcFolder = new File(artemisInstance, "etc");
        }
        Artemis.verifyManagementDTO(etcFolder);
        if (inputEnabled) {
            InputAbstract.enableInput();
        }
        ActionContext context = useSystemOut ? new ActionContext() : new ActionContext(InputStream.nullInputStream(), new PrintStream(OutputStream.nullOutputStream()), System.err);
        ActionContext.setSystem(context);
        try {
            Object object = Artemis.internalExecute(artemisHome, artemisInstance, etcFolder, args, context);
            return object;
        }
        catch (ConfigurationException configException) {
            context.err.println(configException.getMessage());
            context.out.println();
            context.out.println("Configuration should be specified as 'scheme:location'. Default configuration is 'xml:${ARTEMIS_INSTANCE}/etc/bootstrap.xml'");
            ConfigurationException configurationException = configException;
            return configurationException;
        }
        catch (CLIException cliException) {
            context.err.println(cliException.getMessage());
            CLIException cLIException = cliException;
            return cLIException;
        }
        catch (NullPointerException e) {
            e.printStackTrace();
            NullPointerException nullPointerException = e;
            return nullPointerException;
        }
        catch (RuntimeException | InvalidOptionsError re) {
            context.err.println(re.getMessage());
            context.out.println();
            HelpAction.help(Artemis.buildCommand(true, true), "help");
            Exception exception = re;
            return exception;
        }
        finally {
            ActionContext.setSystem(new ActionContext());
        }
    }

    private static Object internalExecute(File artemisHome, File artemisInstance, File etcFolder, String[] args) throws Exception {
        return Artemis.internalExecute(artemisHome, artemisInstance, etcFolder, args, new ActionContext());
    }

    public static Object internalExecute(File artemisHome, File artemisInstance, File etcFolder, String[] args, ActionContext context) throws Exception {
        boolean isInstance = artemisInstance != null || System.getProperty("artemis.instance") != null;
        CommandLine commandLine = Artemis.buildCommand(isInstance, !isInstance);
        Object userObject = Artemis.parseAction(commandLine, args);
        Objects.requireNonNull(userObject, "Picocli action command should never be null");
        assert (userObject != null);
        if (userObject instanceof Action) {
            Action action = (Action)userObject;
            action.setHomeValues(artemisHome, artemisInstance, etcFolder);
            if (action.isVerbose()) {
                context.out.print("Executing " + action.getClass().getName() + " ");
                for (String arg : args) {
                    context.out.print(arg + " ");
                }
                context.out.println();
                context.out.println("Home::" + action.getBrokerHome() + ", Instance::" + action.getBrokerInstance());
            }
            return action.execute(context);
        }
        if (!(userObject instanceof Runnable)) {
            throw new IllegalArgumentException(userObject.getClass() + " should implement either " + Action.class.getName() + " or " + Runnable.class.getName());
        }
        ((Runnable)userObject).run();
        return null;
    }

    private static Object parseAction(CommandLine line, String[] args) {
        CommandLine.ParseResult parseResult = line.parseArgs(args);
        if (parseResult != null) {
            while (parseResult.hasSubcommand()) {
                parseResult = parseResult.subcommand();
            }
        }
        if (parseResult == null) {
            throw new RuntimeException("Cannot match arg::" + Arrays.toString(args));
        }
        return parseResult.commandSpec().userObject();
    }

    public static CommandLine buildCommand(boolean includeInstanceCommands, boolean includeHomeCommands) {
        return Artemis.buildCommand(includeInstanceCommands, includeHomeCommands, false);
    }

    public static CommandLine buildCommand(boolean includeInstanceCommands, boolean includeHomeCommands, boolean fromShell) {
        Artemis artemis = new Artemis();
        CommandLine commandLine = new CommandLine((Object)artemis);
        artemis.setCommandLine(commandLine);
        HelpAction help = new HelpAction();
        help.setCommandLine(commandLine);
        commandLine.addSubcommand((Object)help);
        commandLine.addSubcommand((Object)new AutoCompletion());
        if (!fromShell) {
            commandLine.addSubcommand((Object)new Shell(commandLine));
        }
        commandLine.addSubcommand((Object)new Producer()).addSubcommand((Object)new Transfer()).addSubcommand((Object)new Consumer()).addSubcommand((Object)new Browse()).addSubcommand((Object)new Mask()).addSubcommand((Object)new PrintVersion());
        commandLine.addSubcommand((Object)new PerfGroup(commandLine));
        commandLine.addSubcommand((Object)new CheckGroup(commandLine));
        commandLine.addSubcommand((Object)new QueueGroup(commandLine));
        commandLine.addSubcommand((Object)new AddressGroup(commandLine));
        if (fromShell) {
            commandLine.addSubcommand((Object)new Connect());
            commandLine.addSubcommand((Object)new Disconnect());
        }
        if (includeInstanceCommands) {
            commandLine.addSubcommand((Object)new ActivationGroup(commandLine));
            commandLine.addSubcommand((Object)new DataGroup(commandLine));
            commandLine.addSubcommand((Object)new UserGroup(commandLine));
            commandLine.addSubcommand((Object)new Run());
            commandLine.addSubcommand((Object)new Stop());
            commandLine.addSubcommand((Object)new Kill());
            commandLine.addSubcommand((Object)new PerfJournal());
        }
        if (includeHomeCommands) {
            if (!includeInstanceCommands) {
                commandLine.addSubcommand((Object)new DataGroup(commandLine));
            }
            commandLine.addSubcommand((Object)new Create());
            commandLine.addSubcommand((Object)new Upgrade());
        }
        return commandLine;
    }

    public static void printBanner(PrintStream out) throws Exception {
        Artemis.copy(Artemis.class.getResourceAsStream("banner.txt"), out);
    }

    public static String getNameFromBanner() throws Exception {
        InputStream inputStream = Artemis.class.getResourceAsStream("banner.txt");
        BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream));
        String lastLine = "";
        while (reader.ready()) {
            String line = reader.readLine();
            if (line.trim().isEmpty()) continue;
            lastLine = line;
        }
        return lastLine.trim();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static long copy(InputStream in, OutputStream out) throws Exception {
        try {
            byte[] buffer = new byte[1024];
            int len = in.read(buffer);
            while (len != -1) {
                out.write(buffer, 0, len);
                len = in.read(buffer);
            }
            long l = len;
            return l;
        }
        finally {
            in.close();
        }
    }
}

