/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.eesecurity;

import java.util.EnumSet;
import org.jboss.as.controller.Extension;
import org.jboss.as.controller.ExtensionContext;
import org.jboss.as.controller.ModelVersion;
import org.jboss.as.controller.OperationDefinition;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.PersistentResourceXMLDescription;
import org.jboss.as.controller.PersistentResourceXMLDescriptionReader;
import org.jboss.as.controller.PersistentResourceXMLDescriptionWriter;
import org.jboss.as.controller.ResourceDefinition;
import org.jboss.as.controller.SubsystemRegistration;
import org.jboss.as.controller.descriptions.ParentResourceDescriptionResolver;
import org.jboss.as.controller.descriptions.SubsystemResourceDescriptionResolver;
import org.jboss.as.controller.operations.common.GenericSubsystemDescribeHandler;
import org.jboss.as.controller.parsing.ExtensionParsingContext;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.staxmapper.XMLElementReader;
import org.jboss.staxmapper.XMLElementWriter;
import org.wildfly.extension.eesecurity.EESecuritySubsystemDefinition;
import org.wildfly.extension.eesecurity.EESecuritySubsystemSchema;

public class EESecurityExtension
implements Extension {
    public static final String SUBSYSTEM_NAME = "ee-security";
    public static final ModelVersion MODEL_VERSION_1_0_0;
    private static final ModelVersion CURRENT_MODEL_VERSION;
    static final PathElement SUBSYSTEM_PATH;
    static final ParentResourceDescriptionResolver SUBSYSTEM_RESOLVER;
    private final PersistentResourceXMLDescription currentDescription = EESecuritySubsystemSchema.CURRENT.getXMLDescription();

    public void initialize(ExtensionContext context) {
        SubsystemRegistration subsystem = context.registerSubsystem(SUBSYSTEM_NAME, CURRENT_MODEL_VERSION);
        ManagementResourceRegistration registration = subsystem.registerSubsystemModel((ResourceDefinition)new EESecuritySubsystemDefinition());
        registration.registerOperationHandler((OperationDefinition)GenericSubsystemDescribeHandler.DEFINITION, (OperationStepHandler)GenericSubsystemDescribeHandler.INSTANCE);
        subsystem.registerXMLElementWriter((XMLElementWriter)new PersistentResourceXMLDescriptionWriter(this.currentDescription));
    }

    public void initializeParsers(ExtensionParsingContext context) {
        for (EESecuritySubsystemSchema schema : EnumSet.allOf(EESecuritySubsystemSchema.class)) {
            EESecuritySubsystemSchema reader = schema == EESecuritySubsystemSchema.CURRENT ? new PersistentResourceXMLDescriptionReader(this.currentDescription) : schema;
            context.setSubsystemXmlMapping(SUBSYSTEM_NAME, schema.getNamespace().getUri(), (XMLElementReader)reader);
        }
    }

    static {
        CURRENT_MODEL_VERSION = MODEL_VERSION_1_0_0 = ModelVersion.create((int)1, (int)0, (int)0);
        SUBSYSTEM_PATH = PathElement.pathElement((String)"subsystem", (String)SUBSYSTEM_NAME);
        SUBSYSTEM_RESOLVER = new SubsystemResourceDescriptionResolver(SUBSYSTEM_NAME, EESecurityExtension.class);
    }
}

