/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ejb3.deployment;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.jboss.as.ee.component.ComponentView;
import org.jboss.as.ejb3.component.EJBComponent;
import org.jboss.as.ejb3.iiop.EjbIIOPService;
import org.jboss.msc.value.InjectedValue;
import org.wildfly.common.Assert;

public class EjbDeploymentInformation {
    private final String ejbName;
    private final ClassLoader deploymentClassLoader;
    private final InjectedValue<EJBComponent> ejbComponent;
    private final Map<String, InjectedValue<ComponentView>> componentViews;
    private final InjectedValue<EjbIIOPService> iorFactory;
    private final Set<String> remoteViewClassNames = new HashSet<String>();

    @Deprecated
    public EjbDeploymentInformation(String ejbName, InjectedValue<EJBComponent> ejbComponent, Map<String, InjectedValue<ComponentView>> componentViews, ClassLoader deploymentClassLoader, InjectedValue<EjbIIOPService> iorFactory) {
        this.ejbName = ejbName;
        this.ejbComponent = ejbComponent;
        this.componentViews = componentViews;
        this.deploymentClassLoader = deploymentClassLoader;
        this.iorFactory = iorFactory;
    }

    public EjbDeploymentInformation(String ejbName, InjectedValue<EJBComponent> ejbComponent, Map<String, InjectedValue<ComponentView>> remoteViews, Map<String, InjectedValue<ComponentView>> localViews, ClassLoader deploymentClassLoader, InjectedValue<EjbIIOPService> iorFactory) {
        this.ejbName = ejbName;
        this.ejbComponent = ejbComponent;
        this.componentViews = new HashMap<String, InjectedValue<ComponentView>>();
        if (remoteViews != null) {
            this.componentViews.putAll(remoteViews);
            this.remoteViewClassNames.addAll(remoteViews.keySet());
        }
        if (localViews != null) {
            this.componentViews.putAll(localViews);
        }
        this.deploymentClassLoader = deploymentClassLoader;
        this.iorFactory = iorFactory;
    }

    public String getEjbName() {
        return this.ejbName;
    }

    public EJBComponent getEjbComponent() {
        return (EJBComponent)((Object)this.ejbComponent.getValue());
    }

    public Collection<String> getViewNames() {
        return this.componentViews.keySet();
    }

    public ComponentView getView(String name) {
        InjectedValue value = (InjectedValue)Assert.checkNotNullParam((String)String.valueOf(name), this.componentViews.get(name));
        return (ComponentView)value.getValue();
    }

    public ClassLoader getDeploymentClassLoader() {
        return this.deploymentClassLoader;
    }

    public EjbIIOPService getIorFactory() {
        return (EjbIIOPService)this.iorFactory.getOptionalValue();
    }

    public boolean isRemoteView(String viewClassName) {
        return this.remoteViewClassNames.contains(viewClassName);
    }
}

