/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.discovery;

import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import org.jboss.as.controller.AbstractAddStepHandler;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.CapabilityServiceBuilder;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.registry.Resource;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.Service;
import org.jboss.msc.service.ServiceController;
import org.wildfly.discovery.AttributeValue;
import org.wildfly.discovery.ServiceURL;
import org.wildfly.discovery.impl.StaticDiscoveryProvider;
import org.wildfly.extension.discovery.DiscoveryExtension;
import org.wildfly.extension.discovery.Messages;
import org.wildfly.extension.discovery.StaticDiscoveryProviderDefinition;

class StaticDiscoveryProviderAddHandler
extends AbstractAddStepHandler {
    StaticDiscoveryProviderAddHandler() {
        super(new AbstractAddStepHandler.Parameters().addAttribute(new AttributeDefinition[]{StaticDiscoveryProviderDefinition.SERVICES}));
    }

    protected void performRuntime(OperationContext context, ModelNode operation, Resource resource) throws OperationFailedException {
        List services = StaticDiscoveryProviderDefinition.SERVICES.resolveModelAttribute(context, resource.getModel()).asListOrEmpty();
        ArrayList<ServiceURL> serviceURLs = new ArrayList<ServiceURL>(services.size());
        for (ModelNode service : services) {
            String uriSchemeAuthority;
            String abstractTypeAuthority;
            ServiceURL.Builder builder = new ServiceURL.Builder();
            builder.setUri(URI.create(StaticDiscoveryProviderDefinition.URI.resolveModelAttribute(context, service).asString()));
            String abstractType = StaticDiscoveryProviderDefinition.ABSTRACT_TYPE.resolveModelAttribute(context, service).asStringOrNull();
            if (abstractType != null) {
                builder.setAbstractType(abstractType);
            }
            if ((abstractTypeAuthority = StaticDiscoveryProviderDefinition.ABSTRACT_TYPE_AUTHORITY.resolveModelAttribute(context, service).asStringOrNull()) != null) {
                builder.setAbstractTypeAuthority(abstractTypeAuthority);
            }
            if ((uriSchemeAuthority = StaticDiscoveryProviderDefinition.URI_SCHEME_AUTHORITY.resolveModelAttribute(context, service).asStringOrNull()) != null) {
                builder.setUriSchemeAuthority(uriSchemeAuthority);
            }
            List attributes = StaticDiscoveryProviderDefinition.ATTRIBUTES.resolveModelAttribute(context, service).asListOrEmpty();
            for (ModelNode attribute : attributes) {
                String name = StaticDiscoveryProviderDefinition.NAME.resolveModelAttribute(context, attribute).asString();
                String value = StaticDiscoveryProviderDefinition.VALUE.resolveModelAttribute(context, attribute).asStringOrNull();
                if (value != null) {
                    builder.addAttribute(name, AttributeValue.fromString((String)value));
                    continue;
                }
                builder.addAttribute(name);
            }
            ServiceURL serviceURL = builder.create();
            Messages.log.tracef("Adding service URL %s", serviceURL);
            serviceURLs.add(serviceURL);
        }
        CapabilityServiceBuilder builder = context.getCapabilityServiceTarget().addService();
        Consumer provider = builder.provides(DiscoveryExtension.DISCOVERY_PROVIDER_CAPABILITY);
        builder.setInstance(Service.newInstance((Consumer)provider, (Object)new StaticDiscoveryProvider(serviceURLs))).setInitialMode(ServiceController.Mode.ON_DEMAND).install();
    }

    protected void rollbackRuntime(OperationContext context, ModelNode operation, Resource resource) {
        context.removeService(DiscoveryExtension.DISCOVERY_PROVIDER_CAPABILITY.getCapabilityServiceName(context.getCurrentAddress()));
    }
}

