/*
 * Decompiled with CFR 0.152.
 */
package org.jberet.job.model;

import jakarta.batch.operations.BatchRuntimeException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jberet._private.BatchMessages;
import org.jberet.job.model.AbstractPropertiesBuilder;
import org.jberet.job.model.Decision;
import org.jberet.job.model.Flow;
import org.jberet.job.model.Job;
import org.jberet.job.model.JobElement;
import org.jberet.job.model.Listeners;
import org.jberet.job.model.Properties;
import org.jberet.job.model.RefArtifact;
import org.jberet.job.model.Split;
import org.jberet.job.model.Step;

public final class JobBuilder
extends AbstractPropertiesBuilder<JobBuilder> {
    private final String id;
    private String restartable;
    private Listeners listeners;
    private final List<JobElement> jobElements = new ArrayList<JobElement>();
    final Set<String> ids = new HashSet<String>();

    public JobBuilder(String id) {
        this.id = id;
    }

    public JobBuilder restartable(boolean ... b) {
        this.restartable = b.length == 0 ? String.valueOf(true) : String.valueOf(b[0]);
        return this;
    }

    public JobBuilder listener(String listenerRef, String[] ... pairsOfKeyValue) {
        if (this.listeners == null) {
            this.listeners = new Listeners();
        }
        this.listeners.getListeners().add(JobBuilder.createRefArtifactWithProperties(listenerRef, null, pairsOfKeyValue));
        return this;
    }

    public JobBuilder listener(String listenerRef, java.util.Properties props) {
        if (this.listeners == null) {
            this.listeners = new Listeners();
        }
        this.listeners.getListeners().add(JobBuilder.createRefArtifactWithProperties(listenerRef, props, new String[0][]));
        return this;
    }

    public JobBuilder step(Step step) {
        this.jobElements.add(step);
        return this;
    }

    public JobBuilder decision(Decision decision) {
        this.jobElements.add(decision);
        return this;
    }

    public JobBuilder flow(Flow flow) {
        this.jobElements.add(flow);
        return this;
    }

    public JobBuilder split(Split split) {
        this.jobElements.add(split);
        return this;
    }

    public Job build() {
        Job job = new Job(this.id);
        if (this.restartable != null) {
            job.setRestartable(this.restartable);
        }
        if (this.nameValues.size() > 0) {
            job.setProperties(this.nameValuesToProperties());
        }
        job.setListeners(this.listeners);
        this.ids.add(this.id);
        for (JobElement jobElement : this.jobElements) {
            this.assertUniqueId(jobElement);
            job.addJobElement(jobElement);
        }
        this.jobElements.clear();
        this.ids.clear();
        return job;
    }

    static RefArtifact createRefArtifactWithProperties(String ref, java.util.Properties props, String[] ... propKeysValues) {
        RefArtifact refArtifact = new RefArtifact(ref);
        Properties properties = new Properties();
        if (props != null) {
            for (String k : props.stringPropertyNames()) {
                properties.add(k, props.getProperty(k));
            }
        } else if (propKeysValues.length > 0) {
            for (String[] pair : propKeysValues) {
                properties.add(pair[0], pair.length > 1 ? pair[1] : null);
            }
        }
        refArtifact.setProperties(properties);
        return refArtifact;
    }

    private void assertUniqueId(JobElement jobElement) throws BatchRuntimeException {
        block4: {
            block3: {
                String jobElementId = jobElement.getId();
                if (!this.ids.add(jobElementId)) {
                    throw BatchMessages.MESSAGES.idAlreadyExists(jobElement.getClass().getSimpleName(), jobElementId);
                }
                if (!(jobElement instanceof Split)) break block3;
                for (Flow f : ((Split)jobElement).flows) {
                    this.assertUniqueId(f);
                }
                break block4;
            }
            if (!(jobElement instanceof Flow)) break block4;
            for (JobElement e : ((Flow)jobElement).jobElements) {
                this.assertUniqueId(e);
            }
        }
    }
}

