/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.messaging.activemq;

import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.core.settings.impl.AddressSettings;
import org.jboss.as.controller.AbstractRuntimeOnlyHandler;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationDefinition;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.SimpleOperationDefinition;
import org.jboss.as.controller.SimpleOperationDefinitionBuilder;
import org.jboss.as.controller.descriptions.ResourceDescriptionResolver;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.wildfly.extension.messaging.activemq.ActiveMQActivationService;
import org.wildfly.extension.messaging.activemq.AddressSettingDefinition;
import org.wildfly.extension.messaging.activemq.CommonAttributes;
import org.wildfly.extension.messaging.activemq.MessagingServices;
import org.wildfly.extension.messaging.activemq.OperationDefinitionHelper;

public class AddressSettingsResolveHandler
extends AbstractRuntimeOnlyHandler {
    static final AddressSettingsResolveHandler INSTANCE = new AddressSettingsResolveHandler();
    private static final AttributeDefinition ACTIVEMQ_ADDRESS = OperationDefinitionHelper.createNonEmptyStringAttribute("activemq-address");

    protected AddressSettingsResolveHandler() {
    }

    protected void executeRuntimeStep(OperationContext context, ModelNode operation) throws OperationFailedException {
        if (ActiveMQActivationService.ignoreOperationIfServerNotActive(context, operation)) {
            return;
        }
        PathAddress address = PathAddress.pathAddress((ModelNode)operation.get("address"));
        ServiceName serviceName = MessagingServices.getActiveMQServiceName(address);
        ServiceController service = context.getServiceRegistry(false).getService(serviceName);
        ActiveMQServer server = (ActiveMQServer)ActiveMQServer.class.cast(service.getValue());
        String activeMQAddress = ACTIVEMQ_ADDRESS.resolveModelAttribute(context, operation).asString();
        AddressSettings settings = (AddressSettings)server.getAddressSettingsRepository().getMatch(activeMQAddress);
        ModelNode result = context.getResult();
        result.get(AddressSettingDefinition.ADDRESS_FULL_MESSAGE_POLICY.getName()).set(settings.getAddressFullMessagePolicy().toString());
        ModelNode deadLetterAddress = result.get(CommonAttributes.DEAD_LETTER_ADDRESS.getName());
        if (settings.getDeadLetterAddress() != null) {
            deadLetterAddress.set(settings.getDeadLetterAddress().toString());
        }
        ModelNode expiryAddress = result.get(CommonAttributes.EXPIRY_ADDRESS.getName());
        if (settings.getExpiryAddress() != null) {
            expiryAddress.set(settings.getExpiryAddress().toString());
        }
        result.get(AddressSettingDefinition.EXPIRY_DELAY.getName()).set(settings.getExpiryDelay().longValue());
        result.get(AddressSettingDefinition.LAST_VALUE_QUEUE.getName()).set(settings.isDefaultLastValueQueue());
        result.get(AddressSettingDefinition.MAX_DELIVERY_ATTEMPTS.getName()).set(settings.getMaxDeliveryAttempts());
        result.get(AddressSettingDefinition.MAX_READ_PAGE_BYTES.getName()).set(settings.getMaxReadPageBytes());
        result.get(AddressSettingDefinition.MAX_REDELIVERY_DELAY.getName()).set(settings.getMaxRedeliveryDelay());
        result.get(AddressSettingDefinition.MAX_SIZE_BYTES.getName()).set(settings.getMaxSizeBytes());
        result.get(AddressSettingDefinition.MESSAGE_COUNTER_HISTORY_DAY_LIMIT.getName()).set(settings.getMessageCounterHistoryDayLimit());
        result.get(AddressSettingDefinition.PAGE_MAX_CACHE_SIZE.getName()).set(settings.getPageCacheMaxSize());
        result.get(AddressSettingDefinition.PAGE_SIZE_BYTES.getName()).set(settings.getPageSizeBytes());
        result.get(AddressSettingDefinition.REDELIVERY_DELAY.getName()).set(settings.getRedeliveryDelay());
        result.get(AddressSettingDefinition.REDELIVERY_MULTIPLIER.getName()).set(settings.getRedeliveryMultiplier());
        result.get(AddressSettingDefinition.REDISTRIBUTION_DELAY.getName()).set(settings.getRedistributionDelay());
        result.get(AddressSettingDefinition.SEND_TO_DLA_ON_NO_ROUTE.getName()).set(settings.isSendToDLAOnNoRoute());
        result.get(AddressSettingDefinition.SLOW_CONSUMER_CHECK_PERIOD.getName()).set(settings.getSlowConsumerCheckPeriod());
        result.get(AddressSettingDefinition.SLOW_CONSUMER_POLICY.getName()).set(settings.getSlowConsumerPolicy().toString());
        result.get(AddressSettingDefinition.SLOW_CONSUMER_THRESHOLD.getName()).set(settings.getSlowConsumerThreshold());
        result.get(AddressSettingDefinition.AUTO_CREATE_JMS_QUEUES.getName()).set(settings.isAutoCreateJmsQueues());
        result.get(AddressSettingDefinition.AUTO_DELETE_JMS_QUEUES.getName()).set(settings.isAutoDeleteJmsQueues());
        result.get(AddressSettingDefinition.AUTO_CREATE_ADDRESSES.getName()).set(settings.isAutoCreateAddresses().booleanValue());
        result.get(AddressSettingDefinition.AUTO_DELETE_ADDRESSES.getName()).set(settings.isAutoDeleteAddresses().booleanValue());
        result.get(AddressSettingDefinition.AUTO_CREATE_QUEUES.getName()).set(settings.isAutoCreateQueues().booleanValue());
        result.get(AddressSettingDefinition.AUTO_DELETE_QUEUES.getName()).set(settings.isAutoDeleteQueues().booleanValue());
        result.get(AddressSettingDefinition.AUTO_DELETE_CREATED_QUEUES.getName()).set(settings.isAutoDeleteCreatedQueues().booleanValue());
    }

    public static void registerOperationHandler(ManagementResourceRegistration registry, ResourceDescriptionResolver resolver) {
        SimpleOperationDefinition op = new SimpleOperationDefinitionBuilder("resolve-address-setting", resolver).setReadOnly().setRuntimeOnly().addParameter(ACTIVEMQ_ADDRESS).setReplyType(ModelType.LIST).setReplyParameters(AddressSettingDefinition.ATTRIBUTES).build();
        registry.registerOperationHandler((OperationDefinition)op, (OperationStepHandler)INSTANCE);
    }
}

