/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.messaging.activemq;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.AttributeMarshaller;
import org.jboss.as.controller.AttributeParser;
import org.jboss.as.controller.DeprecationData;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationDefinition;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PrimitiveListAttributeDefinition;
import org.jboss.as.controller.SimpleAttributeDefinition;
import org.jboss.as.controller.SimpleAttributeDefinitionBuilder;
import org.jboss.as.controller.SimpleOperationDefinition;
import org.jboss.as.controller.SimpleOperationDefinitionBuilder;
import org.jboss.as.controller.SimpleResourceDefinition;
import org.jboss.as.controller.StringListAttributeDefinition;
import org.jboss.as.controller.client.helpers.MeasurementUnit;
import org.jboss.as.controller.operations.validation.ParameterValidator;
import org.jboss.as.controller.operations.validation.StringLengthValidator;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.controller.registry.Resource;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.wildfly.extension.messaging.activemq.BroadcastGroupAdd;
import org.wildfly.extension.messaging.activemq.BroadcastGroupControlHandler;
import org.wildfly.extension.messaging.activemq.BroadcastGroupRemove;
import org.wildfly.extension.messaging.activemq.CommonAttributes;
import org.wildfly.extension.messaging.activemq.MessagingExtension;
import org.wildfly.extension.messaging.activemq.MessagingServices;
import org.wildfly.extension.messaging.activemq.logging.MessagingLogger;
import org.wildfly.extension.messaging.activemq.shallow.ShallowResourceDefinition;

public class BroadcastGroupDefinition
extends ShallowResourceDefinition {
    public static final PrimitiveListAttributeDefinition CONNECTOR_REFS = ((StringListAttributeDefinition.Builder)((StringListAttributeDefinition.Builder)((StringListAttributeDefinition.Builder)((StringListAttributeDefinition.Builder)((StringListAttributeDefinition.Builder)((StringListAttributeDefinition.Builder)new StringListAttributeDefinition.Builder("connectors").setRequired(true)).setElementValidator((ParameterValidator)new StringLengthValidator(1))).setAttributeParser(AttributeParser.STRING_LIST)).setAttributeMarshaller(AttributeMarshaller.STRING_LIST)).setAllowExpression(false)).setRestartAllServices()).build();
    public static final SimpleAttributeDefinition BROADCAST_PERIOD = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"broadcast-period", (ModelType)ModelType.LONG).setDefaultValue(new ModelNode(2000L))).setMeasurementUnit(MeasurementUnit.MILLISECONDS)).setRequired(false)).setAllowExpression(true)).setRestartAllServices()).build();
    @Deprecated
    public static final SimpleAttributeDefinition JGROUPS_CHANNEL_FACTORY = SimpleAttributeDefinitionBuilder.create((SimpleAttributeDefinition)CommonAttributes.JGROUPS_CHANNEL_FACTORY).build();
    public static final SimpleAttributeDefinition JGROUPS_CHANNEL = SimpleAttributeDefinitionBuilder.create((SimpleAttributeDefinition)CommonAttributes.JGROUPS_CHANNEL).build();
    public static final AttributeDefinition[] ATTRIBUTES = new AttributeDefinition[]{JGROUPS_CHANNEL_FACTORY, JGROUPS_CHANNEL, CommonAttributes.JGROUPS_CLUSTER, CommonAttributes.SOCKET_BINDING, BROADCAST_PERIOD, CONNECTOR_REFS};
    public static final String GET_CONNECTOR_PAIRS_AS_JSON = "get-connector-pairs-as-json";

    BroadcastGroupDefinition(boolean registerRuntimeOnly) {
        super(new SimpleResourceDefinition.Parameters(MessagingExtension.BROADCAST_GROUP_PATH, MessagingExtension.getResourceDescriptionResolver("broadcast-group")).setAddHandler((OperationStepHandler)BroadcastGroupAdd.INSTANCE).setRemoveHandler((OperationStepHandler)BroadcastGroupRemove.INSTANCE).setFeature(false).setDeprecationData(new DeprecationData(MessagingExtension.VERSION_9_0_0, true)), registerRuntimeOnly);
    }

    public Collection<AttributeDefinition> getAttributes() {
        return Arrays.asList(ATTRIBUTES);
    }

    @Override
    public void registerOperations(ManagementResourceRegistration registry) {
        super.registerOperations(registry);
        if (this.registerRuntimeOnly) {
            BroadcastGroupControlHandler.INSTANCE.registerOperations(registry, this.getResourceDescriptionResolver());
            SimpleOperationDefinition op = new SimpleOperationDefinitionBuilder(GET_CONNECTOR_PAIRS_AS_JSON, this.getResourceDescriptionResolver()).setReadOnly().setRuntimeOnly().setReplyType(ModelType.STRING).build();
            registry.registerOperationHandler((OperationDefinition)op, (OperationStepHandler)BroadcastGroupControlHandler.INSTANCE);
        }
    }

    static void validateConnectors(OperationContext context, ModelNode operation, ModelNode connectorRefs) throws OperationFailedException {
        Set<String> availableConnectors = BroadcastGroupDefinition.getAvailableConnectors(context, operation);
        List operationAddress = operation.get("address").asList();
        if (connectorRefs.isDefined()) {
            for (ModelNode connectorRef : connectorRefs.asList()) {
                String connectorName = connectorRef.asString();
                if (availableConnectors.contains(connectorName)) continue;
                throw MessagingLogger.ROOT_LOGGER.wrongConnectorRefInBroadCastGroup(BroadcastGroupDefinition.getBroadCastGroupName((ModelNode)operationAddress.get(operationAddress.size() - 1)), connectorName, availableConnectors);
            }
        }
    }

    private static String getBroadCastGroupName(ModelNode node) {
        if (node.hasDefined("broadcast-group")) {
            return node.get("broadcast-group").asString();
        }
        if (node.hasDefined("socket-broadcast-group")) {
            return node.get("socket-broadcast-group").asString();
        }
        if (node.hasDefined("jgroups-broadcast-group")) {
            return node.get("jgroups-broadcast-group").asString();
        }
        return ModelType.UNDEFINED.name();
    }

    private static Set<String> getAvailableConnectors(OperationContext context, ModelNode operation) throws OperationFailedException {
        PathAddress address = PathAddress.pathAddress((ModelNode)operation.get("address"));
        PathAddress active = MessagingServices.getActiveMQServerPathAddress(address);
        HashSet<String> availableConnectors = new HashSet<String>();
        Resource subsystemResource = context.readResourceFromRoot(active.getParent(), false);
        availableConnectors.addAll(subsystemResource.getChildrenNames("remote-connector"));
        Resource activeMQServerResource = context.readResourceFromRoot(active, false);
        availableConnectors.addAll(activeMQServerResource.getChildrenNames("http-connector"));
        availableConnectors.addAll(activeMQServerResource.getChildrenNames("in-vm-connector"));
        availableConnectors.addAll(activeMQServerResource.getChildrenNames("remote-connector"));
        availableConnectors.addAll(activeMQServerResource.getChildrenNames("connector"));
        return availableConnectors;
    }

    @Override
    public PathAddress convert(OperationContext context, ModelNode operation) {
        PathAddress parent = context.getCurrentAddress().getParent();
        PathAddress targetAddress = parent.append("jgroups-broadcast-group", context.getCurrentAddressValue());
        try {
            context.readResourceFromRoot(targetAddress, false);
            return targetAddress;
        }
        catch (Resource.NoSuchResourceException ex) {
            return parent.append("socket-broadcast-group", context.getCurrentAddressValue());
        }
    }

    @Override
    public Set<String> getIgnoredAttributes(OperationContext context, ModelNode operation) {
        PathAddress targetAddress = context.getCurrentAddress().getParent().append("jgroups-broadcast-group", context.getCurrentAddressValue());
        HashSet<String> ignoredAttributes = new HashSet<String>();
        try {
            context.readResourceFromRoot(targetAddress, false);
            ignoredAttributes.add(CommonAttributes.SOCKET_BINDING.getName());
        }
        catch (Resource.NoSuchResourceException ex) {
            ignoredAttributes.add(JGROUPS_CHANNEL_FACTORY.getName());
            ignoredAttributes.add(JGROUPS_CHANNEL.getName());
            ignoredAttributes.add(CommonAttributes.JGROUPS_CLUSTER.getName());
        }
        return ignoredAttributes;
    }

    @Override
    protected boolean isUsingSocketBinding(PathAddress targetAddress) {
        return "socket-broadcast-group".equals(targetAddress.getLastElement().getKey());
    }
}

