/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.ejb.cache.bean;

import java.util.function.Consumer;
import org.wildfly.clustering.ejb.bean.Bean;
import org.wildfly.clustering.ejb.bean.BeanInstance;
import org.wildfly.clustering.ejb.bean.BeanMetaData;

public class OnCloseBean<K, V extends BeanInstance<K>>
implements Bean<K, V> {
    private final Bean<K, V> bean;
    private final Consumer<Bean<K, V>> task;

    public OnCloseBean(Bean<K, V> bean, Consumer<Bean<K, V>> task) {
        this.bean = bean;
        this.task = task;
    }

    public K getId() {
        return (K)this.bean.getId();
    }

    public V getInstance() {
        return (V)this.bean.getInstance();
    }

    public BeanMetaData<K> getMetaData() {
        return this.bean.getMetaData();
    }

    public boolean isValid() {
        return this.bean.isValid();
    }

    public void remove(Consumer<V> removeTask) {
        this.bean.remove(removeTask);
    }

    public void close() {
        try {
            this.task.accept(this.bean);
        }
        finally {
            this.bean.close();
        }
    }
}

