/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.lock.impl.lock;

import java.util.Collections;
import java.util.List;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.infinispan.AdvancedCache;
import org.infinispan.commons.logging.LogFactory;
import org.infinispan.commons.util.Util;
import org.infinispan.functional.FunctionalMap;
import org.infinispan.functional.impl.FunctionalMapImpl;
import org.infinispan.functional.impl.ReadWriteMapImpl;
import org.infinispan.lock.api.ClusteredLock;
import org.infinispan.lock.exception.ClusteredLockException;
import org.infinispan.lock.impl.entries.ClusteredLockKey;
import org.infinispan.lock.impl.entries.ClusteredLockState;
import org.infinispan.lock.impl.entries.ClusteredLockValue;
import org.infinispan.lock.impl.functions.IsLocked;
import org.infinispan.lock.impl.functions.LockFunction;
import org.infinispan.lock.impl.functions.UnlockFunction;
import org.infinispan.lock.impl.lock.ClusteredLockFilter;
import org.infinispan.lock.impl.lock.RequestExpirationScheduler;
import org.infinispan.lock.impl.manager.EmbeddedClusteredLockManager;
import org.infinispan.lock.logging.Log;
import org.infinispan.notifications.Listener;
import org.infinispan.notifications.cachelistener.annotation.CacheEntryModified;
import org.infinispan.notifications.cachelistener.annotation.CacheEntryRemoved;
import org.infinispan.notifications.cachelistener.event.CacheEntryModifiedEvent;
import org.infinispan.notifications.cachelistener.event.CacheEntryRemovedEvent;
import org.infinispan.notifications.cachelistener.filter.CacheEventFilter;
import org.infinispan.notifications.cachemanagerlistener.annotation.ViewChanged;
import org.infinispan.notifications.cachemanagerlistener.event.ViewChangedEvent;
import org.infinispan.remoting.RemoteException;

public class ClusteredLockImpl
implements ClusteredLock {
    private static final Log log = (Log)LogFactory.getLog(ClusteredLockImpl.class, Log.class);
    private final String name;
    private final ClusteredLockKey lockKey;
    private final AdvancedCache<ClusteredLockKey, ClusteredLockValue> clusteredLockCache;
    private final EmbeddedClusteredLockManager clusteredLockManager;
    private final FunctionalMap.ReadWriteMap<ClusteredLockKey, ClusteredLockValue> readWriteMap;
    private final Queue<RequestHolder> pendingRequests;
    private final Object originator;
    private final AtomicInteger viewChangeUnlockHappening = new AtomicInteger(0);
    private final RequestExpirationScheduler requestExpirationScheduler;
    private final ClusterChangeListener clusterChangeListener;
    private final LockReleasedListener lockReleasedListener;

    public ClusteredLockImpl(String name, ClusteredLockKey lockKey, AdvancedCache<ClusteredLockKey, ClusteredLockValue> clusteredLockCache, EmbeddedClusteredLockManager clusteredLockManager) {
        this.name = name;
        this.lockKey = lockKey;
        this.clusteredLockCache = clusteredLockCache;
        this.clusteredLockManager = clusteredLockManager;
        this.pendingRequests = new ConcurrentLinkedQueue<RequestHolder>();
        this.readWriteMap = ReadWriteMapImpl.create((FunctionalMapImpl)FunctionalMapImpl.create(clusteredLockCache));
        this.originator = clusteredLockCache.getCacheManager().getAddress();
        this.requestExpirationScheduler = new RequestExpirationScheduler(clusteredLockManager.getScheduledExecutorService());
        this.clusterChangeListener = new ClusterChangeListener();
        this.lockReleasedListener = new LockReleasedListener();
        this.clusteredLockCache.getCacheManager().addListener((Object)this.clusterChangeListener);
        this.clusteredLockCache.addFilteredListener((Object)this.lockReleasedListener, (CacheEventFilter)new ClusteredLockFilter(lockKey), null, Util.asSet((Object[])new Class[]{CacheEntryModified.class, CacheEntryRemoved.class}));
    }

    public void stop() {
        this.clusteredLockCache.removeListener((Object)this.clusterChangeListener);
        this.clusteredLockCache.removeListener((Object)this.lockReleasedListener);
        this.requestExpirationScheduler.clear();
    }

    private void retryPendingRequests(ClusteredLockValue value) {
        if (this.isChangeViewUnlockInProgress()) {
            if (log.isTraceEnabled()) {
                log.tracef("LOCK[%s] Hold pending requests while view change unlock is happening in %s", this.getName(), this.originator);
            }
        } else {
            RequestHolder nextRequestor = null;
            if (log.isTraceEnabled()) {
                log.tracef("LOCK[%s] Pending requests size[%d] in %s", this.getName(), this.pendingRequests.size(), this.originator);
            }
            while (!this.pendingRequests.isEmpty() && (nextRequestor == null || nextRequestor.isDone() || this.isSameRequest(nextRequestor, value))) {
                nextRequestor = this.pendingRequests.poll();
            }
            if (nextRequestor != null) {
                if (log.isTraceEnabled()) {
                    log.tracef("LOCK[%s] About to retry lock for %s", this.getName(), nextRequestor);
                }
                RequestHolder requestor = nextRequestor;
                this.lock(requestor);
            }
        }
    }

    private void retryPendingRequests() {
        this.retryPendingRequests(null);
    }

    private boolean isSameRequest(RequestHolder nextRequestor, ClusteredLockValue value) {
        if (value == null) {
            return false;
        }
        return nextRequestor.requestId.equals(value.getRequestId()) && nextRequestor.requestor.equals(value.getOwner());
    }

    public CompletableFuture<Void> lock() {
        if (log.isTraceEnabled()) {
            log.tracef("LOCK[%s] lock called from %s", this.getName(), this.originator);
        }
        CompletableFuture<Void> lockRequest = new CompletableFuture<Void>();
        this.lock(new LockRequestHolder(this.originator, lockRequest));
        return lockRequest;
    }

    private void lock(RequestHolder<Void> requestHolder) {
        if (requestHolder == null || requestHolder.isDone()) {
            return;
        }
        this.pendingRequests.offer(requestHolder);
        if (this.isChangeViewUnlockInProgress()) {
            if (log.isTraceEnabled()) {
                log.tracef("LOCK[%s] View change unlock is happening in %s. Do not try to lock", this.getName(), this.originator);
            }
        } else {
            this.readWriteMap.eval((Object)this.lockKey, (Function)new LockFunction(requestHolder.requestId, requestHolder.requestor)).whenComplete((lockResult, ex) -> requestHolder.handleLockResult((Boolean)lockResult, (Throwable)ex));
        }
    }

    public CompletableFuture<Boolean> tryLock() {
        if (log.isTraceEnabled()) {
            log.tracef("LOCK[%s] tryLock called from %s", this.getName(), this.originator);
        }
        CompletableFuture<Boolean> tryLockRequest = new CompletableFuture<Boolean>();
        this.tryLock(new TryLockRequestHolder(this.originator, tryLockRequest));
        return tryLockRequest;
    }

    public CompletableFuture<Boolean> tryLock(long time, TimeUnit unit) {
        if (log.isTraceEnabled()) {
            log.tracef("LOCK[%s] tryLock with timeout (%d, %s) called from %s", new Object[]{this.getName(), time, unit, this.originator});
        }
        CompletableFuture<Boolean> tryLockRequest = new CompletableFuture<Boolean>();
        this.tryLock(new TryLockRequestHolder(this.originator, tryLockRequest, time, unit));
        return tryLockRequest;
    }

    private void tryLock(TryLockRequestHolder requestHolder) {
        if (requestHolder == null || requestHolder.isDone()) {
            return;
        }
        if (requestHolder.hasTimeout()) {
            this.pendingRequests.offer(requestHolder);
        }
        if (this.isChangeViewUnlockInProgress()) {
            requestHolder.handleLockResult(false, null);
        } else {
            this.readWriteMap.eval((Object)this.lockKey, (Function)new LockFunction(requestHolder.requestId, requestHolder.requestor)).whenComplete((lockResult, ex) -> requestHolder.handleLockResult((Boolean)lockResult, (Throwable)ex));
        }
    }

    public CompletableFuture<Void> unlock() {
        if (log.isTraceEnabled()) {
            log.tracef("LOCK[%s] unlock called from %s", this.getName(), this.originator);
        }
        CompletableFuture<Void> unlockRequest = new CompletableFuture<Void>();
        this.readWriteMap.eval((Object)this.lockKey, (Function)new UnlockFunction(this.originator)).whenComplete((unlockResult, ex) -> {
            if (ex == null) {
                if (log.isTraceEnabled()) {
                    log.tracef("LOCK[%s] Unlock result for %s is %b", this.getName(), this.originator, unlockResult);
                }
                unlockRequest.complete(null);
            } else {
                unlockRequest.completeExceptionally(this.handleException((Throwable)ex));
            }
        });
        return unlockRequest;
    }

    public CompletableFuture<Boolean> isLocked() {
        if (log.isTraceEnabled()) {
            log.tracef("LOCK[%s] isLocked called from %s", this.getName(), this.originator);
        }
        CompletableFuture<Boolean> isLockedRequest = new CompletableFuture<Boolean>();
        this.readWriteMap.eval((Object)this.lockKey, (Function)new IsLocked()).whenComplete((isLocked, ex) -> {
            if (ex == null) {
                isLockedRequest.complete((Boolean)isLocked);
            } else {
                isLockedRequest.completeExceptionally(this.handleException((Throwable)ex));
            }
        });
        return isLockedRequest;
    }

    public CompletableFuture<Boolean> isLockedByMe() {
        if (log.isTraceEnabled()) {
            log.tracef("LOCK[%s] isLockedByMe called from %s", this.getName(), this.originator);
        }
        CompletableFuture<Boolean> isLockedByMeRequest = new CompletableFuture<Boolean>();
        this.readWriteMap.eval((Object)this.lockKey, (Function)new IsLocked(this.originator)).whenComplete((isLockedByMe, ex) -> {
            if (ex == null) {
                isLockedByMeRequest.complete((Boolean)isLockedByMe);
            } else {
                isLockedByMeRequest.completeExceptionally(this.handleException((Throwable)ex));
            }
        });
        return isLockedByMeRequest;
    }

    private CompletableFuture<Boolean> unlock(String requestId, Set<Object> possibleOwners) {
        if (log.isTraceEnabled()) {
            log.tracef("LOCK[%s] unlock called for %s %s", this.getName(), requestId, possibleOwners);
        }
        CompletableFuture<Boolean> unlockRequest = new CompletableFuture<Boolean>();
        this.readWriteMap.eval((Object)this.lockKey, (Function)new UnlockFunction(requestId, possibleOwners)).whenComplete((unlockResult, ex) -> {
            if (ex == null) {
                unlockRequest.complete((Boolean)unlockResult);
            } else {
                unlockRequest.completeExceptionally(this.handleException((Throwable)ex));
            }
        });
        return unlockRequest;
    }

    private String createRequestId() {
        return Util.threadLocalRandomUUID().toString();
    }

    private boolean isChangeViewUnlockInProgress() {
        return this.viewChangeUnlockHappening.get() > 0;
    }

    private Throwable handleException(Throwable ex) {
        Throwable lockException = ex;
        if (ex instanceof RemoteException) {
            lockException = ex.getCause();
        }
        if (!(lockException instanceof ClusteredLockException)) {
            lockException = new ClusteredLockException(ex);
        }
        return lockException;
    }

    public String getName() {
        return this.name;
    }

    public Object getOriginator() {
        return this.originator;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("ClusteredLockImpl{");
        sb.append("lock=").append(this.getName());
        sb.append(", originator=").append(this.originator);
        sb.append('}');
        return sb.toString();
    }

    @Listener
    class ClusterChangeListener {
        ClusterChangeListener() {
        }

        @ViewChanged
        public void viewChange(ViewChangedEvent event) {
            if (log.isTraceEnabled()) {
                log.tracef("LOCK[%s] ViewChange event has been fired %s", ClusteredLockImpl.this.getName(), ClusteredLockImpl.this.originator);
            }
            List newMembers = event.getNewMembers();
            List oldMembers = event.getOldMembers();
            if (newMembers.size() <= 1 && oldMembers.size() > 2) {
                if (log.isTraceEnabled()) {
                    log.tracef("LOCK[%s] A single new node %s is this notification. Do nothing", ClusteredLockImpl.this.getName(), ClusteredLockImpl.this.originator);
                }
                return;
            }
            Set<Object> leavingNodes = oldMembers.stream().filter(a -> !newMembers.contains(a)).collect(Collectors.toSet());
            if (leavingNodes.isEmpty()) {
                if (log.isTraceEnabled()) {
                    log.tracef("LOCK[%s] Nothing to do, all nodes are present %s", ClusteredLockImpl.this.getName(), ClusteredLockImpl.this.originator);
                }
                return;
            }
            if (leavingNodes.size() >= newMembers.size() && oldMembers.size() > 2) {
                if (log.isTraceEnabled()) {
                    log.tracef("LOCK[%s] Nothing to do, we are on a minority partition notification on %s", ClusteredLockImpl.this.getName(), ClusteredLockImpl.this.originator);
                }
                return;
            }
            if (ClusteredLockImpl.this.clusteredLockManager.isDefined(ClusteredLockImpl.this.name)) {
                if (log.isTraceEnabled()) {
                    log.tracef("LOCK[%s] %s launches unlock for each leaving node", ClusteredLockImpl.this.getName(), ClusteredLockImpl.this.originator);
                }
                this.forceUnlockForLeavingMembers(leavingNodes);
            }
        }

        private void forceUnlockForLeavingMembers(Set<Object> possibleOwners) {
            if (log.isTraceEnabled()) {
                log.tracef("LOCK[%s] Call force unlock for %s from %s ", ClusteredLockImpl.this.getName(), possibleOwners, ClusteredLockImpl.this.originator);
            }
            int viewChangeUnlockValue = ClusteredLockImpl.this.viewChangeUnlockHappening.incrementAndGet();
            if (log.isTraceEnabled()) {
                log.tracef("LOCK[%s] viewChangeUnlockHappening value in %s ", ClusteredLockImpl.this.getName(), viewChangeUnlockValue, ClusteredLockImpl.this.originator);
            }
            ClusteredLockImpl.this.unlock(null, possibleOwners).whenComplete((unlockResult, ex) -> {
                if (log.isTraceEnabled()) {
                    log.tracef("LOCK[%s] Force unlock call completed for %s from %s ", ClusteredLockImpl.this.getName(), possibleOwners, ClusteredLockImpl.this.originator);
                }
                int viewChangeUnlockValueAfterUnlock = ClusteredLockImpl.this.viewChangeUnlockHappening.decrementAndGet();
                if (log.isTraceEnabled()) {
                    log.tracef("LOCK[%s] viewChangeUnlockHappening value in %s ", ClusteredLockImpl.this.getName(), viewChangeUnlockValueAfterUnlock, ClusteredLockImpl.this.originator);
                }
                if (ex == null) {
                    if (log.isTraceEnabled()) {
                        log.tracef("LOCK[%s] Force unlock result %b for %s from %s ", new Object[]{ClusteredLockImpl.this.getName(), unlockResult, possibleOwners, ClusteredLockImpl.this.originator});
                    }
                } else {
                    log.error(ex, (Throwable)log.unlockFailed(ClusteredLockImpl.this.getName(), ClusteredLockImpl.this.getOriginator()));
                }
                ClusteredLockImpl.this.retryPendingRequests();
            });
        }
    }

    @Listener(clustered=true)
    class LockReleasedListener {
        LockReleasedListener() {
        }

        @CacheEntryModified
        public void entryModified(CacheEntryModifiedEvent event) {
            ClusteredLockValue value = (ClusteredLockValue)event.getValue();
            if (value.getState() == ClusteredLockState.RELEASED) {
                if (log.isTraceEnabled()) {
                    log.tracef("LOCK[%s] Lock has been released, %s notified", ClusteredLockImpl.this.getName(), ClusteredLockImpl.this.originator);
                }
                ClusteredLockImpl.this.retryPendingRequests(value);
            }
        }

        @CacheEntryRemoved
        public void entryRemoved(CacheEntryRemovedEvent event) {
            while (!ClusteredLockImpl.this.pendingRequests.isEmpty()) {
                RequestHolder requestHolder = ClusteredLockImpl.this.pendingRequests.poll();
                requestHolder.handleLockResult(null, (Throwable)log.lockDeleted());
                ClusteredLockImpl.this.requestExpirationScheduler.abortScheduling(requestHolder.requestId);
            }
        }
    }

    public abstract class RequestHolder<E> {
        protected final CompletableFuture<E> request;
        protected final String requestId;
        protected final Object requestor;

        public RequestHolder(Object requestor, CompletableFuture<E> request) {
            this.requestId = ClusteredLockImpl.this.createRequestId();
            this.requestor = requestor;
            this.request = request;
        }

        public boolean isDone() {
            return this.request.isDone();
        }

        public void handleLockResult(Boolean result, Throwable ex) {
            if (ex != null) {
                log.errorf(ex, "LOCK[%s] Exception on lock request %s", ClusteredLockImpl.this.getName(), this.toString());
                this.request.completeExceptionally(ClusteredLockImpl.this.handleException(ex));
                return;
            }
            if (result == null) {
                if (log.isTraceEnabled()) {
                    log.tracef("LOCK[%s] Result is null on request %s", ClusteredLockImpl.this.getName(), this.toString());
                }
                this.request.completeExceptionally((Throwable)new ClusteredLockException("Lock result is null, something is wrong"));
                return;
            }
            this.handle(result);
        }

        protected abstract void handle(Boolean var1);

        protected abstract void forceFailed();
    }

    public class LockRequestHolder
    extends RequestHolder<Void> {
        public LockRequestHolder(Object requestor, CompletableFuture<Void> request) {
            super(requestor, request);
        }

        @Override
        protected void handle(Boolean result) {
            if (result.booleanValue()) {
                this.request.complete(null);
            }
        }

        @Override
        protected void forceFailed() {
            this.request.complete(null);
        }

        public String toString() {
            StringBuilder sb = new StringBuilder("LockRequestHolder{");
            sb.append("name=").append(ClusteredLockImpl.this.getName());
            sb.append(", requestId=").append(this.requestId);
            sb.append(", requestor=").append(this.requestor);
            sb.append(", completed=").append(this.request.isDone());
            sb.append(", completedExceptionally=").append(this.request.isCompletedExceptionally());
            sb.append('}');
            return sb.toString();
        }
    }

    public class TryLockRequestHolder
    extends RequestHolder<Boolean> {
        private final long time;
        private final TimeUnit unit;
        private boolean isScheduled;

        public TryLockRequestHolder(Object requestor, CompletableFuture<Boolean> request) {
            super(requestor, request);
            this.time = 0L;
            this.unit = null;
        }

        public TryLockRequestHolder(Object requestor, CompletableFuture<Boolean> request, long time, TimeUnit unit) {
            super(requestor, request);
            this.time = time;
            this.unit = unit;
        }

        @Override
        protected void handle(Boolean result) {
            if (this.time <= 0L) {
                if (log.isTraceEnabled()) {
                    log.tracef("LOCK[%s] Result[%b] for request %s", ClusteredLockImpl.this.getName(), result, this);
                }
                this.request.complete(result);
            } else if (result.booleanValue()) {
                if (log.isTraceEnabled()) {
                    log.tracef("LOCK[%s] LockResult[%b] for %s", ClusteredLockImpl.this.getName(), result, this);
                }
                this.request.complete(true);
                ClusteredLockImpl.this.requestExpirationScheduler.abortScheduling(this.requestId);
                Boolean tryLockRealResult = (Boolean)this.request.join();
                if (!tryLockRealResult.booleanValue()) {
                    ClusteredLockImpl.this.unlock(this.requestId, Collections.singleton(this.requestor));
                }
            } else if (!this.isScheduled) {
                if (log.isTraceEnabled()) {
                    log.tracef("LOCK[%s] Schedule for expiration %s", ClusteredLockImpl.this.getName(), this);
                }
                this.isScheduled = true;
                ClusteredLockImpl.this.requestExpirationScheduler.scheduleForCompletion(this.requestId, this.request, this.time, this.unit);
            }
        }

        @Override
        protected void forceFailed() {
            this.request.complete(false);
        }

        public String toString() {
            StringBuilder sb = new StringBuilder("TryLockRequestHolder{");
            sb.append("name=").append(ClusteredLockImpl.this.getName());
            sb.append(", requestId=").append(this.requestId);
            sb.append(", requestor=").append(this.requestor);
            sb.append(", time=").append(this.time);
            sb.append(", unit=").append((Object)this.unit);
            sb.append(", completed=").append(this.request.isDone());
            sb.append(", completedExceptionally=").append(this.request.isCompletedExceptionally());
            sb.append('}');
            return sb.toString();
        }

        public boolean hasTimeout() {
            return this.time > 0L;
        }
    }
}

